/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.util.AbstractArrayMapOwner;
import kotlin.reflect.jvm.internal.impl.util.ArrayMap;
import kotlin.reflect.jvm.internal.impl.util.ArrayMapImpl;
import kotlin.reflect.jvm.internal.impl.util.EmptyArrayMap;
import kotlin.reflect.jvm.internal.impl.util.OneElementArrayMap;
import ru.astrainteractive.astramarket.org.jetbrains.annotations.NotNull;

public abstract class AttributeArrayOwner<K, T>
extends AbstractArrayMapOwner<K, T> {
    @NotNull
    private ArrayMap<T> arrayMap;

    protected AttributeArrayOwner(@NotNull ArrayMap<T> arrayMap) {
        Intrinsics.checkNotNullParameter(arrayMap, "arrayMap");
        this.arrayMap = arrayMap;
    }

    @Override
    @NotNull
    protected final ArrayMap<T> getArrayMap() {
        return this.arrayMap;
    }

    public AttributeArrayOwner() {
        EmptyArrayMap emptyArrayMap = EmptyArrayMap.INSTANCE;
        Intrinsics.checkNotNull(emptyArrayMap, "null cannot be cast to non-null type org.jetbrains.kotlin.util.ArrayMap<T of org.jetbrains.kotlin.util.AttributeArrayOwner>");
        this(emptyArrayMap);
    }

    @Override
    protected final void registerComponent(@NotNull String keyQualifiedName, @NotNull T value) {
        Intrinsics.checkNotNullParameter(keyQualifiedName, "keyQualifiedName");
        Intrinsics.checkNotNullParameter(value, "value");
        int id = this.getTypeRegistry().getId(keyQualifiedName);
        switch (this.arrayMap.getSize()) {
            case 0: {
                this.arrayMap = new OneElementArrayMap<T>(value, id);
                return;
            }
            case 1: {
                ArrayMap<T> arrayMap = this.arrayMap;
                Intrinsics.checkNotNull(arrayMap, "null cannot be cast to non-null type org.jetbrains.kotlin.util.OneElementArrayMap<T of org.jetbrains.kotlin.util.AttributeArrayOwner>");
                OneElementArrayMap map2 = (OneElementArrayMap)arrayMap;
                if (map2.getIndex() == id) {
                    this.arrayMap = new OneElementArrayMap<T>(value, id);
                    return;
                }
                this.arrayMap = new ArrayMapImpl();
                this.arrayMap.set(map2.getIndex(), map2.getValue());
            }
        }
        this.arrayMap.set(id, value);
    }
}

