/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astramarket.org.jetbrains.exposed.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import ru.astrainteractive.astramarket.org.jetbrains.annotations.NotNull;
import ru.astrainteractive.astramarket.org.jetbrains.annotations.Nullable;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.exceptions.ExceptionsKt;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.ColumnDiff;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.ColumnKt;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.ColumnType;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.ColumnTypeKt;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.DdlAware;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.Expression;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.ExpressionWithColumnType;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.ForeignKeyConstraint;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.IColumnType;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.QueryBuilder;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.SQLLogKt;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.Table;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.Transaction;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.transactions.TransactionManager;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.vendors.H2Dialect;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.vendors.MysqlDialect;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.vendors.OracleDialect;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.vendors.SQLServerDialect;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u00032\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000\u0004B*\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\b\u00028\u00000\n\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u0019\u001a\n\u0012\u0004\u0012\u0002H\u001c\u0018\u00010\u0000\"\b\b\u0001\u0010\u001c*\u00028\u0000J\u000e\u0010)\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010$J\u0006\u0010*\u001a\u00020+J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016J\u0006\u0010;\u001a\u00020\bJ\u0006\u0010<\u001a\u00020\bJ\u000e\u0010@\u001a\b\u0012\u0004\u0012\u00020\b0AH\u0016J\u0014\u0010B\u001a\b\u0012\u0004\u0012\u00020\b0A2\u0006\u0010C\u001a\u00020DJ\u000e\u0010E\u001a\b\u0012\u0004\u0012\u00020\b0AH\u0016J\u000e\u0010F\u001a\b\u0012\u0004\u0012\u00020\b0AH\u0016J\r\u0010G\u001a\u00020+H\u0000\u00a2\u0006\u0002\bHJ\u0010\u0010I\u001a\u00020\b2\b\b\u0002\u0010J\u001a\u00020+JO\u0010K\u001a\b\u0012\u0004\u0012\u0002HL0\u0000\"\u0004\b\u0001\u0010L2\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\b\u0002HL0M2!\b\u0002\u0010N\u001a\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u0002HL0\u0000\u0012\u0004\u0012\u000208\u0018\u00010O\u00a2\u0006\u0002\bPH\u0000\u00f8\u0001\u0000\u00a2\u0006\u0002\bQJ\u001f\u0010R\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\b\u00028\u00000\n\u00f8\u0001\u0000J\u0015\u0010S\u001a\u00020T2\n\u0010U\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0096\u0002J\u0013\u0010V\u001a\u00020+2\b\u0010U\u001a\u0004\u0018\u000102H\u0096\u0002J\b\u0010W\u001a\u00020TH\u0016J\b\u0010X\u001a\u00020\bH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001f\u0010\t\u001a\n\u0012\u0006\u0012\u0004\b\u00028\u00000\nX\u0096\u0004\u00f8\u0001\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\"\u0010\u001d\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\"\u0010#\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010$X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010*\u001a\u00020+X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R \u00100\u001a\b\u0012\u0004\u0012\u00020201X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u0014\u0010=\u001a\u00020+8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010-R\u0014\u0010>\u001a\u00020+8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010-\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006Y"}, d2={"Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/Column;", "T", "Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/ExpressionWithColumnType;", "Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/DdlAware;", "", "table", "Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/Table;", "name", "", "columnType", "Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/IColumnType;", "<init>", "(Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/Table;Ljava/lang/String;Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/IColumnType;)V", "getTable", "()Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/Table;", "getName", "()Ljava/lang/String;", "getColumnType", "()Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/IColumnType;", "foreignKey", "Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/ForeignKeyConstraint;", "getForeignKey", "()Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/ForeignKeyConstraint;", "setForeignKey", "(Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/ForeignKeyConstraint;)V", "referee", "getReferee", "()Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/Column;", "S", "defaultValueFun", "Lkotlin/Function0;", "getDefaultValueFun", "()Lkotlin/jvm/functions/Function0;", "setDefaultValueFun", "(Lkotlin/jvm/functions/Function0;)V", "dbDefaultValue", "Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/Expression;", "getDbDefaultValue$exposed_core", "()Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/Expression;", "setDbDefaultValue$exposed_core", "(Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/Expression;)V", "defaultValueInDb", "isDatabaseGenerated", "", "isDatabaseGenerated$exposed_core", "()Z", "setDatabaseGenerated$exposed_core", "(Z)V", "extraDefinitions", "", "", "getExtraDefinitions$exposed_core", "()Ljava/util/List;", "setExtraDefinitions$exposed_core", "(Ljava/util/List;)V", "toQueryBuilder", "", "queryBuilder", "Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/QueryBuilder;", "nameInDatabaseCase", "nameUnquoted", "isLastColumnInPK", "isPrimaryConstraintWillBeDefined", "isPrimaryConstraintWillBeDefined$exposed_core", "createStatement", "", "modifyStatements", "columnDiff", "Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/ColumnDiff;", "modifyStatement", "dropStatement", "isOneColumnPK", "isOneColumnPK$exposed_core", "descriptionDdl", "modify", "copyWithAnotherColumnType", "R", "Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/ColumnType;", "body", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "copyWithAnotherColumnType$exposed_core", "withColumnType", "compareTo", "", "other", "equals", "hashCode", "toString", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nColumn.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Column.kt\norg/jetbrains/exposed/sql/Column\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,208:1\n1#2:209\n*E\n"})
public final class Column<T>
extends ExpressionWithColumnType<T>
implements DdlAware,
Comparable<Column<?>> {
    @NotNull
    private final Table table;
    @NotNull
    private final String name;
    @NotNull
    private final IColumnType<T> columnType;
    @Nullable
    private ForeignKeyConstraint foreignKey;
    @Nullable
    private Function0<? extends T> defaultValueFun;
    @Nullable
    private Expression<T> dbDefaultValue;
    private boolean isDatabaseGenerated;
    @NotNull
    private List<Object> extraDefinitions;

    public Column(@NotNull Table table, @NotNull String name, @NotNull IColumnType<T> columnType) {
        Intrinsics.checkNotNullParameter(table, "table");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(columnType, "columnType");
        this.table = table;
        this.name = name;
        this.columnType = columnType;
        this.extraDefinitions = new ArrayList();
    }

    @NotNull
    public final Table getTable() {
        return this.table;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public IColumnType<T> getColumnType() {
        return this.columnType;
    }

    @Nullable
    public final ForeignKeyConstraint getForeignKey() {
        return this.foreignKey;
    }

    public final void setForeignKey(@Nullable ForeignKeyConstraint foreignKeyConstraint) {
        this.foreignKey = foreignKeyConstraint;
    }

    @Nullable
    public final Column<?> getReferee() {
        ForeignKeyConstraint foreignKeyConstraint = this.foreignKey;
        return foreignKeyConstraint != null ? foreignKeyConstraint.targetOf(this) : null;
    }

    @Nullable
    public final <S extends T> Column<S> referee() {
        Column<?> column = this.getReferee();
        return column instanceof Column ? column : null;
    }

    @Nullable
    public final Function0<T> getDefaultValueFun() {
        return this.defaultValueFun;
    }

    public final void setDefaultValueFun(@Nullable Function0<? extends T> function0) {
        this.defaultValueFun = function0;
    }

    @Nullable
    public final Expression<T> getDbDefaultValue$exposed_core() {
        return this.dbDefaultValue;
    }

    public final void setDbDefaultValue$exposed_core(@Nullable Expression<T> expression) {
        this.dbDefaultValue = expression;
    }

    @Nullable
    public final Expression<T> defaultValueInDb() {
        return this.dbDefaultValue;
    }

    public final boolean isDatabaseGenerated$exposed_core() {
        return this.isDatabaseGenerated;
    }

    public final void setDatabaseGenerated$exposed_core(boolean bl) {
        this.isDatabaseGenerated = bl;
    }

    public final boolean isDatabaseGenerated() {
        return this.isDatabaseGenerated;
    }

    @NotNull
    public final List<Object> getExtraDefinitions$exposed_core() {
        return this.extraDefinitions;
    }

    public final void setExtraDefinitions$exposed_core(@NotNull List<Object> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.extraDefinitions = list;
    }

    @Override
    public void toQueryBuilder(@NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        TransactionManager.Companion.current().fullIdentity$exposed_core(this, queryBuilder);
    }

    @NotNull
    public final String nameInDatabaseCase() {
        return DatabaseDialectKt.inProperCase(this.name);
    }

    @NotNull
    public final String nameUnquoted() {
        String string;
        if (DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect) {
            string = this.name;
        } else {
            char[] cArray = new char[]{'\"'};
            string = StringsKt.trim(this.name, cArray);
        }
        return string;
    }

    private final boolean isLastColumnInPK() {
        Column<?>[] columnArray = this.table.getPrimaryKey();
        return Intrinsics.areEqual(this, columnArray != null && (columnArray = columnArray.getColumns()) != null ? ArraysKt.last(columnArray) : null);
    }

    public final boolean isPrimaryConstraintWillBeDefined$exposed_core() {
        return DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect && ColumnTypeKt.isAutoInc(this.getColumnType()) ? false : (this.table.isCustomPKNameDefined$exposed_core() ? this.isLastColumnInPK() : (this.isOneColumnPK$exposed_core() ? false : this.isLastColumnInPK()));
    }

    @Override
    @NotNull
    public List<String> createStatement() {
        String alterTablePrefix = "ALTER TABLE " + TransactionManager.Companion.current().identity(this.table) + " ADD";
        boolean isH2withCustomPKConstraint = DatabaseDialectKt.getCurrentDialect() instanceof H2Dialect && this.isLastColumnInPK();
        boolean isOracle = DatabaseDialectKt.getCurrentDialect() instanceof OracleDialect;
        String columnDefinition = this.isPrimaryConstraintWillBeDefined$exposed_core() && this.isLastColumnInPK() && !isH2withCustomPKConstraint && !isOracle ? this.descriptionDdl(false) + ", ADD " + this.table.primaryKeyConstraint$exposed_core() : (isH2withCustomPKConstraint ? this.descriptionDdl(true) : this.descriptionDdl(false));
        String addConstr = isH2withCustomPKConstraint || isOracle && this.isPrimaryConstraintWillBeDefined$exposed_core() ? alterTablePrefix + ' ' + this.table.primaryKeyConstraint$exposed_core() : null;
        String[] stringArray = new String[]{alterTablePrefix + ' ' + columnDefinition, addConstr};
        return CollectionsKt.listOfNotNull(stringArray);
    }

    @NotNull
    public final List<String> modifyStatements(@NotNull ColumnDiff columnDiff) {
        Intrinsics.checkNotNullParameter(columnDiff, "columnDiff");
        return DatabaseDialectKt.getCurrentDialect().modifyColumn(this, columnDiff);
    }

    @Override
    @NotNull
    public List<String> modifyStatement() {
        return DatabaseDialectKt.getCurrentDialect().modifyColumn(this, ColumnDiff.Companion.getAllChanged());
    }

    @Override
    @NotNull
    public List<String> dropStatement() {
        Transaction tr = TransactionManager.Companion.current();
        return CollectionsKt.listOf("ALTER TABLE " + tr.identity(this.table) + " DROP COLUMN " + tr.identity(this));
    }

    public final boolean isOneColumnPK$exposed_core() {
        Column<?>[] columnArray = this.table.getPrimaryKey();
        return Intrinsics.areEqual(this, columnArray != null && (columnArray = columnArray.getColumns()) != null ? ArraysKt.singleOrNull(columnArray) : null);
    }

    @NotNull
    public final String descriptionDdl(boolean modify) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder $this$descriptionDdl_u24lambda_u241 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        Transaction tr = TransactionManager.Companion.current();
        Column column = this;
        $this$descriptionDdl_u24lambda_u241.append(tr.identity(column));
        $this$descriptionDdl_u24lambda_u241.append(" ");
        Column<?>[] columnArray = this.table.getPrimaryKey();
        boolean isPKColumn = columnArray != null && (columnArray = columnArray.getColumns()) != null ? ArraysKt.contains(columnArray, column) : false;
        boolean isSQLiteAutoIncColumn = DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect && ColumnTypeKt.isAutoInc(this.getColumnType());
        if (!isPKColumn && isSQLiteAutoIncColumn) {
            ExceptionsKt.throwUnsupportedException(tr, "Auto-increment could be applied only to primary key column");
            throw new KotlinNothingValueException();
        }
        if (isSQLiteAutoIncColumn && !this.isOneColumnPK$exposed_core()) {
            ExceptionsKt.throwUnsupportedException(tr, "Auto-increment could be applied only to a single column primary key");
            throw new KotlinNothingValueException();
        }
        if (isSQLiteAutoIncColumn && this.table.isCustomPKNameDefined$exposed_core()) {
            String rawType = StringsKt.substringBefore$default(this.getColumnType().sqlType(), "PRIMARY KEY", null, 2, null);
            String string = this.table.primaryKeyConstraint$exposed_core();
            Intrinsics.checkNotNull(string);
            String constraintPart = StringsKt.substringBefore$default(string, "(", null, 2, null);
            stringBuilder = $this$descriptionDdl_u24lambda_u241.append(rawType + ' ' + constraintPart + " AUTOINCREMENT");
        } else {
            stringBuilder = $this$descriptionDdl_u24lambda_u241.append(this.getColumnType().sqlType());
        }
        Expression<T> defaultValue = this.dbDefaultValue;
        if (defaultValue != null) {
            Object object;
            String expressionSQL = DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().processForDefaultValue(defaultValue);
            if (!DatabaseDialectKt.getCurrentDialect().isAllowedAsColumnDefault(defaultValue)) {
                String clientDefault = this.defaultValueFun != null && this.dbDefaultValue == null ? " Expression will be evaluated on the client." : (!this.getColumnType().getNullable() ? " Column will be created with NULL marker." : "");
                SQLLogKt.getExposedLogger().error(DatabaseDialectKt.getCurrentDialect().getName() + ' ' + tr.getDb().getVersion() + " doesn't support expression '" + expressionSQL + "' as default value." + clientDefault);
                object = Unit.INSTANCE;
            } else if (DatabaseDialectKt.getCurrentDialect() instanceof SQLServerDialect) {
                String tableName = column.table.getTableNameWithoutScheme$exposed_core();
                String columnName = column.name;
                String constraintName = "DF_" + tableName + '_' + columnName;
                object = $this$descriptionDdl_u24lambda_u241.append(" CONSTRAINT " + constraintName + " DEFAULT " + expressionSQL);
            } else {
                object = $this$descriptionDdl_u24lambda_u241.append(" DEFAULT " + expressionSQL);
            }
        }
        if (!((Collection)this.extraDefinitions).isEmpty()) {
            $this$descriptionDdl_u24lambda_u241.append(CollectionsKt.joinToString$default(this.extraDefinitions, " ", " ", null, 0, null, Column::descriptionDdl$lambda$1$lambda$0, 28, null));
        }
        if (this.getColumnType().getNullable() || defaultValue != null && this.defaultValueFun == null && !DatabaseDialectKt.getCurrentDialect().isAllowedAsColumnDefault(defaultValue)) {
            $this$descriptionDdl_u24lambda_u241.append(" NULL");
        } else if (!isPKColumn || DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect && !isSQLiteAutoIncColumn) {
            $this$descriptionDdl_u24lambda_u241.append(" NOT NULL");
        }
        if (!modify && this.isOneColumnPK$exposed_core() && !this.isPrimaryConstraintWillBeDefined$exposed_core() && !isSQLiteAutoIncColumn) {
            $this$descriptionDdl_u24lambda_u241.append(" PRIMARY KEY");
        }
        return stringBuilder2.toString();
    }

    public static /* synthetic */ String descriptionDdl$default(Column column, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return column.descriptionDdl(bl);
    }

    @NotNull
    public final <R> Column<R> copyWithAnotherColumnType$exposed_core(@NotNull ColumnType<R> columnType, @Nullable Function1<? super Column<R>, Unit> body) {
        Intrinsics.checkNotNullParameter(columnType, "columnType");
        Column<T> newColumn = new Column<T>(this.table, this.name, columnType);
        newColumn.foreignKey = this.foreignKey;
        newColumn.dbDefaultValue = this.dbDefaultValue;
        newColumn.isDatabaseGenerated = this.isDatabaseGenerated;
        newColumn.extraDefinitions = this.extraDefinitions;
        Function1<Column<R>, Unit> function1 = body;
        if (function1 != null) {
            Function1<Column<R>, Unit> it = function1;
            boolean bl = false;
            it.invoke(newColumn);
        }
        if (this.defaultValueFun != null && !(newColumn.defaultValueFun != null)) {
            boolean bl = false;
            String string = "defaultValueFun was lost on cloning the column";
            throw new IllegalArgumentException(string.toString());
        }
        return newColumn;
    }

    public static /* synthetic */ Column copyWithAnotherColumnType$exposed_core$default(Column column, ColumnType columnType, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        return column.copyWithAnotherColumnType$exposed_core(columnType, function1);
    }

    @NotNull
    public final Column<T> withColumnType(@NotNull IColumnType<T> columnType) {
        Column<T> column;
        Intrinsics.checkNotNullParameter(columnType, "columnType");
        Column<T> it = column = new Column<T>(this.table, this.name, columnType);
        boolean bl = false;
        it.foreignKey = this.foreignKey;
        it.defaultValueFun = this.defaultValueFun;
        it.dbDefaultValue = this.dbDefaultValue;
        it.isDatabaseGenerated = this.isDatabaseGenerated;
        it.extraDefinitions = this.extraDefinitions;
        return column;
    }

    @Override
    public int compareTo(@NotNull Column<?> other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ColumnKt.access$getComparator$p().compare(this, other);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Column)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.table, ((Column)other).table)) {
            return false;
        }
        return Intrinsics.areEqual(this.name, ((Column)other).name);
    }

    @Override
    public int hashCode() {
        return this.table.hashCode() * 31 + this.name.hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        return this.table.getClass().getName() + '.' + this.name;
    }

    @Override
    @NotNull
    public List<String> getDdl() {
        return DdlAware.DefaultImpls.getDdl(this);
    }

    private static final CharSequence descriptionDdl$lambda$1$lambda$0(Object it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return String.valueOf(it);
    }
}

