/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.statements.jdbc;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import ru.astrainteractive.astramarket.org.jetbrains.annotations.NotNull;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.ColumnType;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.IColumnType;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.Transaction;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.statements.Statement;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.statements.StatementResult;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.statements.StatementType;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.statements.api.ExposedConnection;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.statements.api.ExposedDatabaseMetadata;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.statements.api.ExposedSavepoint;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.statements.jdbc.JdbcDatabaseMetadataImpl;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.statements.jdbc.JdbcPreparedStatementImpl;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.statements.jdbc.JdbcSavepoint;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u0013H\u0016J,\u0010&\u001a\u0002H,\"\u0004\b\u0000\u0010,2\u0017\u0010-\u001a\u0013\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002H,0.\u00a2\u0006\u0002\b0H\u0016\u00a2\u0006\u0002\u00101J\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\t2\u0006\u00105\u001a\u00020\u0016H\u0016J#\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\t2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\t07H\u0016\u00a2\u0006\u0002\u00108J\u0016\u00109\u001a\u00020\u00132\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\t0;H\u0016J\u0010\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\tH\u0016J\u0010\u0010?\u001a\u00020\u00132\u0006\u0010@\u001a\u00020=H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010@\u001a\u00020=H\u0016R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR$\u0010\u000f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R$\u0010\u0019\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\u00168V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u0017\"\u0004\b\u001b\u0010\u001cR$\u0010\u001d\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\u00168V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u001cR&\u0010!\u001a\u00020 2\u0006\u0010\b\u001a\u00020 8V@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001b\u0010&\u001a\u00020'8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b(\u0010)\u00a8\u0006A"}, d2={"Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/statements/jdbc/JdbcConnectionImpl;", "Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/statements/api/ExposedConnection;", "Ljava/sql/Connection;", "connection", "<init>", "(Ljava/sql/Connection;)V", "getConnection", "()Ljava/sql/Connection;", "value", "", "catalog", "getCatalog", "()Ljava/lang/String;", "setCatalog", "(Ljava/lang/String;)V", "schema", "getSchema", "setSchema", "commit", "", "rollback", "isClosed", "", "()Z", "close", "autoCommit", "getAutoCommit", "setAutoCommit", "(Z)V", "readOnly", "getReadOnly", "setReadOnly", "", "transactionIsolation", "getTransactionIsolation", "()I", "setTransactionIsolation", "(I)V", "metadata", "Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl;", "getMetadata", "()Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl;", "metadata$delegate", "Lkotlin/Lazy;", "T", "body", "Lkotlin/Function1;", "Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/statements/api/ExposedDatabaseMetadata;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "prepareStatement", "Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "sql", "returnKeys", "columns", "", "(Ljava/lang/String;[Ljava/lang/String;)Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "executeInBatch", "sqls", "", "setSavepoint", "Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/statements/api/ExposedSavepoint;", "name", "releaseSavepoint", "savepoint", "exposed-jdbc"})
@SourceDebugExtension(value={"SMAP\nJdbcConnectionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdbcConnectionImpl.kt\norg/jetbrains/exposed/sql/statements/jdbc/JdbcConnectionImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n1557#2:146\n1628#2,3:147\n2632#2,3:150\n*S KotlinDebug\n*F\n+ 1 JdbcConnectionImpl.kt\norg/jetbrains/exposed/sql/statements/jdbc/JdbcConnectionImpl\n*L\n88#1:146\n88#1:147,3\n94#1:150,3\n*E\n"})
public final class JdbcConnectionImpl
implements ExposedConnection<Connection> {
    @NotNull
    private final Connection connection;
    private int transactionIsolation;
    @NotNull
    private final Lazy metadata$delegate;

    public JdbcConnectionImpl(@NotNull Connection connection) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        this.connection = connection;
        this.transactionIsolation = -1;
        this.metadata$delegate = LazyKt.lazy(() -> JdbcConnectionImpl.metadata_delegate$lambda$1(this));
    }

    @Override
    @NotNull
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    @NotNull
    public String getCatalog() {
        String string;
        String string2;
        try {
            string2 = this.getConnection().getCatalog();
        }
        catch (Exception exception) {
            string2 = null;
        }
        if ((string = string2) == null && (string = this.getConnection().getMetaData().getUserName()) == null) {
            string = "";
        }
        return string;
    }

    @Override
    public void setCatalog(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        try {
            this.getConnection().setCatalog(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    @NotNull
    public String getSchema() {
        String string;
        try {
            string = this.getConnection().getSchema();
        }
        catch (Exception exception) {
            string = "";
        }
        return string;
    }

    @Override
    public void setSchema(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        try {
            this.getConnection().setSchema(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void commit() {
        this.getConnection().commit();
    }

    @Override
    public void rollback() {
        this.getConnection().rollback();
    }

    @Override
    public boolean isClosed() {
        return this.getConnection().isClosed();
    }

    @Override
    public void close() {
        this.getConnection().close();
    }

    @Override
    public boolean getAutoCommit() {
        return this.getConnection().getAutoCommit();
    }

    @Override
    public void setAutoCommit(boolean value) {
        this.getConnection().setAutoCommit(value);
    }

    @Override
    public boolean getReadOnly() {
        return this.getConnection().isReadOnly();
    }

    @Override
    public void setReadOnly(boolean value) {
        this.getConnection().setReadOnly(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTransactionIsolation() {
        if (this.transactionIsolation == -1) {
            JdbcConnectionImpl jdbcConnectionImpl = this;
            synchronized (jdbcConnectionImpl) {
                boolean bl = false;
                this.transactionIsolation = this.getConnection().getTransactionIsolation();
                Unit unit = Unit.INSTANCE;
            }
        }
        return this.transactionIsolation;
    }

    @Override
    public void setTransactionIsolation(int value) {
        if (this.transactionIsolation != value) {
            this.getConnection().setTransactionIsolation(value);
            this.transactionIsolation = value;
        }
    }

    private final JdbcDatabaseMetadataImpl getMetadata() {
        Lazy lazy = this.metadata$delegate;
        return (JdbcDatabaseMetadataImpl)lazy.getValue();
    }

    @Override
    public <T> T metadata(@NotNull Function1<? super ExposedDatabaseMetadata, ? extends T> body) {
        Intrinsics.checkNotNullParameter(body, "body");
        return body.invoke(this.getMetadata());
    }

    @Override
    @NotNull
    public PreparedStatementApi prepareStatement(@NotNull String sql, boolean returnKeys) {
        Intrinsics.checkNotNullParameter(sql, "sql");
        int generated = returnKeys ? 1 : 2;
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(sql, generated);
        Intrinsics.checkNotNullExpressionValue(preparedStatement, "prepareStatement(...)");
        return new JdbcPreparedStatementImpl(preparedStatement, returnKeys);
    }

    @Override
    @NotNull
    public PreparedStatementApi prepareStatement(@NotNull String sql, @NotNull String[] columns) {
        Intrinsics.checkNotNullParameter(sql, "sql");
        Intrinsics.checkNotNullParameter(columns, "columns");
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(sql, columns);
        Intrinsics.checkNotNullExpressionValue(preparedStatement, "prepareStatement(...)");
        return new JdbcPreparedStatementImpl(preparedStatement, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void executeInBatch(@NotNull List<String> sqls) {
        boolean bl;
        List types;
        List list;
        block9: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(sqls, "sqls");
            Iterable $this$map$iv = sqls;
            boolean $i$f$map = false;
            list = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                StatementType statementType;
                Object v0;
                Collection collection;
                block8: {
                    String string = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    Iterable iterable = StatementType.getEntries();
                    for (Object t : iterable) {
                        void stmt;
                        StatementType it = (StatementType)((Object)t);
                        boolean bl3 = false;
                        if (!StringsKt.startsWith((String)stmt, it.name(), true)) continue;
                        v0 = t;
                        break block8;
                    }
                    v0 = null;
                }
                if ((statementType = (StatementType)v0) == null) {
                    statementType = StatementType.OTHER;
                }
                collection.add(statementType);
            }
            types = (List)destination$iv$iv;
            Iterable $this$none$iv = types;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    StatementType it = (StatementType)((Object)element$iv);
                    boolean bl4 = false;
                    if (!(it == StatementType.SELECT)) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean $i$a$-check-JdbcConnectionImpl$executeInBatch$32 = false;
            String $i$a$-check-JdbcConnectionImpl$executeInBatch$32 = "SELECT statements are unsupported in batch execution";
            throw new IllegalStateException($i$a$-check-JdbcConnectionImpl$executeInBatch$32.toString());
        }
        StatementType statementType = (StatementType)((Object)CollectionsKt.singleOrNull(CollectionsKt.distinct(types)));
        if (statementType == null) {
            statementType = StatementType.OTHER;
        }
        StatementType type = statementType;
        list = CollectionsKt.emptyList();
        Statement<Unit> prepStatement2 = new Statement<Unit>(type, this, sqls, list){
            final /* synthetic */ JdbcConnectionImpl this$0;
            final /* synthetic */ List<String> $sqls;
            {
                this.this$0 = $receiver;
                this.$sqls = $sqls;
                super($type, $super_call_param$1);
            }

            public PreparedStatementApi prepared(Transaction transaction, String sql) {
                Intrinsics.checkNotNullParameter(transaction, "transaction");
                Intrinsics.checkNotNullParameter(sql, "sql");
                PreparedStatementApi originalStatement = super.prepared(transaction, StringsKt.substringBefore$default(sql, '\n', null, 2, null));
                java.sql.Statement statement = this.this$0.getConnection().createStatement();
                List<String> list = this.$sqls;
                java.sql.Statement $this$prepared_u24lambda_u241 = statement;
                boolean bl = false;
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    $this$prepared_u24lambda_u241.addBatch(it);
                }
                java.sql.Statement batchStatement = statement;
                return new PreparedStatementApi(originalStatement, batchStatement){
                    private final /* synthetic */ PreparedStatementApi $$delegate_0;
                    final /* synthetic */ PreparedStatementApi $originalStatement;
                    final /* synthetic */ java.sql.Statement $batchStatement;
                    {
                        this.$originalStatement = $originalStatement;
                        this.$batchStatement = $batchStatement;
                        this.$$delegate_0 = $originalStatement;
                    }

                    public int fillParameters(Iterable<? extends Pair<? extends IColumnType<?>, ? extends Object>> args) {
                        Intrinsics.checkNotNullParameter(args, "args");
                        return this.$$delegate_0.fillParameters(args);
                    }

                    public void addBatch() {
                        this.$$delegate_0.addBatch();
                    }

                    public ResultSet executeQuery() {
                        return this.$$delegate_0.executeQuery();
                    }

                    public List<StatementResult> executeMultiple() {
                        return this.$$delegate_0.executeMultiple();
                    }

                    public void set(int index, Object value) {
                        Intrinsics.checkNotNullParameter(value, "value");
                        this.$$delegate_0.set(index, value);
                    }

                    public void setNull(int index, IColumnType<?> columnType) {
                        Intrinsics.checkNotNullParameter(columnType, "columnType");
                        this.$$delegate_0.setNull(index, columnType);
                    }

                    public void setInputStream(int index, InputStream inputStream2, boolean setAsBlobObject) {
                        Intrinsics.checkNotNullParameter(inputStream2, "inputStream");
                        this.$$delegate_0.setInputStream(index, inputStream2, setAsBlobObject);
                    }

                    public void setArray(int index, String type, Object[] array) {
                        Intrinsics.checkNotNullParameter(type, "type");
                        Intrinsics.checkNotNullParameter(array, "array");
                        this.$$delegate_0.setArray(index, type, array);
                    }

                    public List<Integer> executeBatch() {
                        return this.$$delegate_0.executeBatch();
                    }

                    public void cancel() {
                        this.$$delegate_0.cancel();
                    }

                    public Integer getFetchSize() {
                        return this.$$delegate_0.getFetchSize();
                    }

                    public void setFetchSize(Integer n) {
                        this.$$delegate_0.setFetchSize(n);
                    }

                    public Integer getTimeout() {
                        return this.$$delegate_0.getTimeout();
                    }

                    public void setTimeout(Integer n) {
                        this.$$delegate_0.setTimeout(n);
                    }

                    public ResultSet getResultSet() {
                        return this.$$delegate_0.getResultSet();
                    }

                    public void closeIfPossible() {
                        this.$batchStatement.close();
                        this.$originalStatement.closeIfPossible();
                    }

                    public int executeUpdate() {
                        this.$batchStatement.executeBatch();
                        return 0;
                    }
                };
            }

            public void executeInternal(PreparedStatementApi $this$executeInternal, Transaction transaction) {
                Intrinsics.checkNotNullParameter($this$executeInternal, "<this>");
                Intrinsics.checkNotNullParameter(transaction, "transaction");
                $this$executeInternal.executeUpdate();
            }

            public String prepareSQL(Transaction transaction, boolean prepared2) {
                Intrinsics.checkNotNullParameter(transaction, "transaction");
                return CollectionsKt.joinToString$default(this.$sqls, "\n", null, null, 0, null, null, 62, null);
            }

            public Iterable<Iterable<Pair<ColumnType<?>, Object>>> arguments() {
                return CollectionsKt.emptyList();
            }
        };
        prepStatement2.execute(TransactionManager.Companion.current());
    }

    @Override
    @NotNull
    public ExposedSavepoint setSavepoint(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Savepoint savepoint = this.getConnection().setSavepoint(name);
        Intrinsics.checkNotNullExpressionValue(savepoint, "setSavepoint(...)");
        return new JdbcSavepoint(name, savepoint);
    }

    @Override
    public void releaseSavepoint(@NotNull ExposedSavepoint savepoint) {
        Intrinsics.checkNotNullParameter(savepoint, "savepoint");
        this.getConnection().releaseSavepoint(((JdbcSavepoint)savepoint).getSavepoint$exposed_jdbc());
    }

    @Override
    public void rollback(@NotNull ExposedSavepoint savepoint) {
        Intrinsics.checkNotNullParameter(savepoint, "savepoint");
        this.getConnection().rollback(((JdbcSavepoint)savepoint).getSavepoint$exposed_jdbc());
    }

    private static final JdbcDatabaseMetadataImpl metadata_delegate$lambda$1(JdbcConnectionImpl this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        String string = this$0.getCatalog();
        DatabaseMetaData databaseMetaData = this$0.getConnection().getMetaData();
        Intrinsics.checkNotNullExpressionValue(databaseMetaData, "getMetaData(...)");
        return new JdbcDatabaseMetadataImpl(string, databaseMetaData);
    }
}

