/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.vendors;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import ru.astrainteractive.astramarket.org.jetbrains.annotations.NotNull;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.AutoIncColumnType;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.Column;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.ColumnDiff;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.ColumnTypeKt;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.Expression;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.ExpressionWithColumnType;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.Index;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.ReferenceOption;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.SQLLogKt;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.Schema;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.SchemaKt;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.Transaction;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.transactions.TransactionManager;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.vendors.SQLServerDataTypeProvider;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.vendors.SQLServerFunctionProvider;
import ru.astrainteractive.astramarket.org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\b\u0004\b\u0016\u0018\u0000 =2\u00020\u0001:\u0001=B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0018\u001a\u00020\u00052\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0016J\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u0016H\u0016J\b\u0010#\u001a\u00020\u0016H\u0016J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u0016H\u0016J\u0010\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010)\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'2\u0006\u0010*\u001a\u00020\u0005H\u0016J\u0010\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020-H\u0016J0\u0010.\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\u00162\u0006\u00100\u001a\u00020\u00162\u0006\u00101\u001a\u00020\u00162\u0006\u00102\u001a\u00020\u0016H\u0014J(\u00103\u001a\u00020\u00162\u0006\u00104\u001a\u00020\u00162\u0006\u00105\u001a\u00020\u00162\u0006\u00106\u001a\u00020\u00052\u0006\u00107\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0014\u0010\u000e\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0014\u0010\u0010\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0014\u0010\u0012\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\"\u00108\u001a\u0010\u0012\u0004\u0012\u00020:\u0012\u0006\u0012\u0004\u0018\u00010:09X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<\u00a8\u0006>"}, d2={"Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/vendors/SQLServerDialect;", "Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/vendors/VendorDialect;", "<init>", "()V", "supportsIfNotExists", "", "getSupportsIfNotExists", "()Z", "defaultReferenceOption", "Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/ReferenceOption;", "getDefaultReferenceOption", "()Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/ReferenceOption;", "needsQuotesWhenSymbolsInNames", "getNeedsQuotesWhenSymbolsInNames", "supportsSequenceAsGeneratedKeys", "getSupportsSequenceAsGeneratedKeys", "supportsOnlyIdentifiersInGeneratedKeys", "getSupportsOnlyIdentifiersInGeneratedKeys", "supportsRestrictReferenceOption", "getSupportsRestrictReferenceOption", "nonAcceptableDefaults", "", "", "[Ljava/lang/String;", "isAllowedAsColumnDefault", "e", "Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/Expression;", "modifyColumn", "", "column", "Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/Column;", "columnDiff", "Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/ColumnDiff;", "createDatabase", "name", "listDatabases", "dropDatabase", "setSchema", "schema", "Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/Schema;", "createSchema", "dropSchema", "cascade", "createIndex", "index", "Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/Index;", "createIndexWithType", "table", "columns", "type", "filterCondition", "dropIndex", "tableName", "indexName", "isUnique", "isPartialOrFunctional", "likePatternSpecialChars", "", "", "getLikePatternSpecialChars", "()Ljava/util/Map;", "Companion", "exposed-core"})
public class SQLServerDialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean supportsIfNotExists;
    private final boolean needsQuotesWhenSymbolsInNames;
    private final boolean supportsSequenceAsGeneratedKeys;
    private final boolean supportsOnlyIdentifiersInGeneratedKeys;
    private final boolean supportsRestrictReferenceOption;
    @NotNull
    private final String[] nonAcceptableDefaults;
    @NotNull
    private final Map<Character, Character> likePatternSpecialChars;
    @NotNull
    private static final Map<Character, Character> sqlServerLikePatternSpecialChars;

    public SQLServerDialect() {
        super(Companion.getDialectName(), SQLServerDataTypeProvider.INSTANCE, SQLServerFunctionProvider.INSTANCE);
        this.supportsOnlyIdentifiersInGeneratedKeys = true;
        String[] stringArray = new String[]{"DEFAULT"};
        this.nonAcceptableDefaults = stringArray;
        this.likePatternSpecialChars = sqlServerLikePatternSpecialChars;
    }

    @Override
    public boolean getSupportsIfNotExists() {
        return this.supportsIfNotExists;
    }

    @Override
    @NotNull
    public ReferenceOption getDefaultReferenceOption() {
        return ReferenceOption.NO_ACTION;
    }

    @Override
    public boolean getNeedsQuotesWhenSymbolsInNames() {
        return this.needsQuotesWhenSymbolsInNames;
    }

    @Override
    public boolean getSupportsSequenceAsGeneratedKeys() {
        return this.supportsSequenceAsGeneratedKeys;
    }

    @Override
    public boolean getSupportsOnlyIdentifiersInGeneratedKeys() {
        return this.supportsOnlyIdentifiersInGeneratedKeys;
    }

    @Override
    public boolean getSupportsRestrictReferenceOption() {
        return this.supportsRestrictReferenceOption;
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, "e");
        String string = e.toString().toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
        String columnDefault = ((Object)StringsKt.trim((CharSequence)string)).toString();
        return !ArraysKt.contains(this.nonAcceptableDefaults, columnDefault);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> modifyColumn(@NotNull Column<?> column, @NotNull ColumnDiff columnDiff) {
        void $this$modifyColumn_u24lambda_u240;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(column, "column");
        Intrinsics.checkNotNullParameter(columnDiff, "columnDiff");
        Transaction transaction = TransactionManager.Companion.current();
        String alterTablePart = "ALTER TABLE " + transaction.identity(column.getTable()) + ' ';
        List statements = new ArrayList();
        AutoIncColumnType<?> autoIncColumnType = ColumnTypeKt.getAutoIncColumnType(column);
        boolean replaceWithNewColumn = columnDiff.getAutoInc() && autoIncColumnType != null && autoIncColumnType.getSequence() == null;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        List list = statements;
        boolean bl = false;
        StringBuilder stringBuilder3 = replaceWithNewColumn ? $this$modifyColumn_u24lambda_u240.append(alterTablePart + "ADD NEW_" + transaction.identity(column) + ' ' + column.getColumnType().sqlType()) : $this$modifyColumn_u24lambda_u240.append(alterTablePart + "ALTER COLUMN " + transaction.identity(column) + ' ' + column.getColumnType().sqlType());
        if (columnDiff.getNullability()) {
            boolean isPKColumn;
            Expression<?> defaultValue = column.getDbDefaultValue$exposed_core();
            Column<?>[] columnArray = column.getTable().getPrimaryKey();
            boolean bl2 = columnArray != null && (columnArray = columnArray.getColumns()) != null ? ArraysKt.contains(columnArray, column) : (isPKColumn = false);
            if (column.getColumnType().getNullable() || defaultValue != null && column.getDefaultValueFun() == null && !DatabaseDialectKt.getCurrentDialect().isAllowedAsColumnDefault(defaultValue)) {
                $this$modifyColumn_u24lambda_u240.append(" NULL");
            } else if (!isPKColumn) {
                $this$modifyColumn_u24lambda_u240.append(" NOT NULL");
            }
        }
        list.add(stringBuilder.toString());
        if (columnDiff.getDefaults()) {
            void $this$modifyColumn_u24lambda_u242;
            StringBuilder stringBuilder4;
            String tableName = column.getTable().getTableName();
            String columnName = column.getName();
            String constraintName = "DF_" + tableName + '_' + columnName;
            String dropConstraint = "DROP CONSTRAINT IF EXISTS " + constraintName;
            StringBuilder stringBuilder5 = stringBuilder4 = new StringBuilder();
            list = statements;
            boolean bl3 = false;
            Expression<?> expression = column.getDbDefaultValue$exposed_core();
            if (expression != null) {
                Expression<?> it = expression;
                boolean bl4 = false;
                $this$modifyColumn_u24lambda_u242.append(alterTablePart + dropConstraint);
                $this$modifyColumn_u24lambda_u242.append("; ");
                $this$modifyColumn_u24lambda_u242.append(alterTablePart + "ADD CONSTRAINT " + constraintName + " DEFAULT " + SQLServerDataTypeProvider.INSTANCE.processForDefaultValue(it) + " for " + transaction.identity(column));
            } else {
                $this$modifyColumn_u24lambda_u242.append(alterTablePart + dropConstraint);
            }
            list.add(stringBuilder4.toString());
        }
        if (replaceWithNewColumn) {
            List $this$modifyColumn_u24lambda_u243 = statements;
            boolean bl5 = false;
            $this$modifyColumn_u24lambda_u243.add(alterTablePart + "DROP COLUMN " + transaction.identity(column));
            $this$modifyColumn_u24lambda_u243.add("EXEC sp_rename '" + transaction.identity(column.getTable()) + ".NEW_" + transaction.identity(column) + "', '" + transaction.identity(column) + "', 'COLUMN'");
        }
        return statements;
    }

    @Override
    @NotNull
    public String createDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return "CREATE DATABASE " + DatabaseDialectKt.inProperCase(name);
    }

    @Override
    @NotNull
    public String listDatabases() {
        return "SELECT name FROM sys.databases";
    }

    @Override
    @NotNull
    public String dropDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return "DROP DATABASE " + DatabaseDialectKt.inProperCase(name);
    }

    @Override
    @NotNull
    public String setSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter(schema, "schema");
        return "ALTER USER " + schema.getAuthorization() + " WITH DEFAULT_SCHEMA = " + schema.getIdentifier();
    }

    @Override
    @NotNull
    public String createSchema(@NotNull Schema schema) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(schema, "schema");
        StringBuilder $this$createSchema_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String[] stringArray = new String[]{"CREATE SCHEMA ", schema.getIdentifier()};
        StringsKt.append($this$createSchema_u24lambda_u244, stringArray);
        SchemaKt.appendIfNotNull($this$createSchema_u24lambda_u244, " AUTHORIZATION ", schema.getAuthorization());
        return stringBuilder.toString();
    }

    @Override
    @NotNull
    public String dropSchema(@NotNull Schema schema, boolean cascade) {
        Intrinsics.checkNotNullParameter(schema, "schema");
        return "DROP SCHEMA " + schema.getIdentifier();
    }

    @Override
    @NotNull
    public String createIndex(@NotNull Index index) {
        Intrinsics.checkNotNullParameter(index, "index");
        if (index.getFunctions() != null) {
            SQLLogKt.getExposedLogger().warn("Functional index on " + index.getTable().getTableName() + " using " + CollectionsKt.joinToString$default(index.getFunctions(), null, null, null, 0, null, SQLServerDialect::createIndex$lambda$5, 31, null) + " can't be created in SQLServer");
            return "";
        }
        return super.createIndex(index);
    }

    @Override
    @NotNull
    protected String createIndexWithType(@NotNull String name, @NotNull String table, @NotNull String columns, @NotNull String type, @NotNull String filterCondition) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(table, "table");
        Intrinsics.checkNotNullParameter(columns, "columns");
        Intrinsics.checkNotNullParameter(type, "type");
        Intrinsics.checkNotNullParameter(filterCondition, "filterCondition");
        return "CREATE " + type + " INDEX " + name + " ON " + table + ' ' + columns + filterCondition;
    }

    @Override
    @NotNull
    public String dropIndex(@NotNull String tableName, @NotNull String indexName, boolean isUnique, boolean isPartialOrFunctional) {
        Intrinsics.checkNotNullParameter(tableName, "tableName");
        Intrinsics.checkNotNullParameter(indexName, "indexName");
        return isUnique && !isPartialOrFunctional ? "ALTER TABLE " + this.getIdentifierManager().quoteIfNecessary(tableName) + " DROP CONSTRAINT IF EXISTS " + this.getIdentifierManager().quoteIfNecessary(indexName) : "DROP INDEX IF EXISTS " + this.getIdentifierManager().quoteIfNecessary(indexName) + " ON " + this.getIdentifierManager().quoteIfNecessary(tableName);
    }

    @Override
    @NotNull
    public Map<Character, Character> getLikePatternSpecialChars() {
        return this.likePatternSpecialChars;
    }

    private static final CharSequence createIndex$lambda$5(ExpressionWithColumnType it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.toString();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Character.valueOf('%'), null), TuplesKt.to(Character.valueOf('_'), null), TuplesKt.to(Character.valueOf('['), Character.valueOf(']'))};
        sqlServerLikePatternSpecialChars = MapsKt.mapOf(pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/vendors/SQLServerDialect$Companion;", "Lru/astrainteractive/astramarket/org/jetbrains/exposed/sql/vendors/VendorDialect$DialectNameProvider;", "<init>", "()V", "sqlServerLikePatternSpecialChars", "", "", "exposed-core"})
    public static final class Companion
    extends VendorDialect.DialectNameProvider {
        private Companion() {
            super("SQLServer");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

