/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance;

import NC.noChance.alerts.StaffAlertManager;
import NC.noChance.bstats.bukkit.Metrics;
import NC.noChance.commands.NoChanceCommand;
import NC.noChance.core.ACConfig;
import NC.noChance.core.AdaptiveSamplingSystem;
import NC.noChance.core.AsyncCheckProcessor;
import NC.noChance.core.CheckRegistry;
import NC.noChance.core.DetectionEngine;
import NC.noChance.core.LayerFiltering;
import NC.noChance.core.MultiLayerValidator;
import NC.noChance.core.PlayerData;
import NC.noChance.core.ViolationScoring;
import NC.noChance.database.DatabaseManager;
import NC.noChance.gui.ACMenuGUI;
import NC.noChance.gui.GUIListener;
import NC.noChance.listeners.PlayerListener;
import NC.noChance.packetevents.api.PacketEvents;
import NC.noChance.packetevents.impl.factory.spigot.SpigotPacketEventsBuilder;
import NC.noChance.packets.PacketAnalyzer;
import NC.noChance.punishment.PunishmentManager;
import NC.noChance.replay.ReplayMgr;
import NC.noChance.utils.UpdateChecker;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class NoChance
extends JavaPlugin {
    private Map<UUID, PlayerData> playerDataMap;
    private ACConfig config;
    private DatabaseManager database;
    private PunishmentManager punishmentManager;
    private StaffAlertManager alertManager;
    private AsyncCheckProcessor asyncProcessor;
    private ViolationScoring violationScoring;
    private LayerFiltering layerFiltering;
    private MultiLayerValidator multiLayerValidator;
    private PacketAnalyzer packetAnalyzer;
    private DetectionEngine detectionEngine;
    private AdaptiveSamplingSystem samplingSystem;
    private UpdateChecker updateChecker;
    private CheckRegistry checkRegistry;
    private ReplayMgr replayMgr;

    public void onLoad() {
        PacketEvents.setAPI(SpigotPacketEventsBuilder.build((Plugin)this));
        PacketEvents.getAPI().getSettings().reEncodeByDefault(false).checkForUpdates(false).bStats(false);
        PacketEvents.getAPI().load();
    }

    public void onEnable() {
        PacketEvents.getAPI().init();
        new Metrics((Plugin)this, 27528);
        this.playerDataMap = new ConcurrentHashMap<UUID, PlayerData>();
        this.config = new ACConfig((Plugin)this);
        DatabaseManager.DatabaseType dbType = this.config.getDatabaseType().equalsIgnoreCase("MYSQL") ? DatabaseManager.DatabaseType.MYSQL : DatabaseManager.DatabaseType.SQLITE;
        this.database = new DatabaseManager((Plugin)this, this.config, dbType, this.config.getDatabaseHost(), this.config.getDatabasePort(), this.config.getDatabaseName(), this.config.getDatabaseUsername(), this.config.getDatabasePassword(), this.config.getDatabaseTablePrefix());
        this.asyncProcessor = new AsyncCheckProcessor((Plugin)this, this.config.getAsyncThreadPoolSize());
        this.alertManager = new StaffAlertManager((Plugin)this, this.config);
        this.punishmentManager = new PunishmentManager((Plugin)this, this.config, this.database);
        if (this.config.isDiscordEnabled() && !this.config.getDiscordWebhook().isEmpty()) {
            this.alertManager.setDiscordWebhook(this.config.getDiscordWebhook());
            this.getLogger().info("Discord webhook integration enabled!");
        }
        this.layerFiltering = new LayerFiltering(this.config);
        this.detectionEngine = new DetectionEngine(this.config);
        this.samplingSystem = new AdaptiveSamplingSystem(this.detectionEngine);
        this.violationScoring = new ViolationScoring(this.config, this.playerDataMap, this.database, this.punishmentManager, this.alertManager, this.detectionEngine, this.samplingSystem);
        this.multiLayerValidator = new MultiLayerValidator(this.config, this.playerDataMap, this.layerFiltering);
        this.checkRegistry = new CheckRegistry(this.config, this.playerDataMap, this.layerFiltering);
        this.packetAnalyzer = new PacketAnalyzer((Plugin)this, this.config, this.checkRegistry.getBlinkCheck());
        this.packetAnalyzer.setBadPacketsCheck(this.checkRegistry.getBadPacketsCheck());
        this.multiLayerValidator.setPacketAnalyzer(this.packetAnalyzer);
        PlayerListener playerListener = new PlayerListener(this, this.playerDataMap, this.violationScoring, this.multiLayerValidator, this.alertManager, this.config, this.checkRegistry);
        this.getServer().getPluginManager().registerEvents((Listener)playerListener, (Plugin)this);
        ACMenuGUI menuGUI = new ACMenuGUI((Plugin)this, this.config);
        GUIListener guiListener = new GUIListener(menuGUI, (Plugin)this, this.config);
        this.getServer().getPluginManager().registerEvents((Listener)guiListener, (Plugin)this);
        this.replayMgr = new ReplayMgr((Plugin)this, this.config.getReplayBufferSeconds(), this.config.getReplayRetentionDays(), this.config.isReplayEnabled());
        this.violationScoring.setReplayMgr(this.replayMgr);
        NoChanceCommand commandExecutor = new NoChanceCommand((Plugin)this, this.config, this.playerDataMap, this.violationScoring, menuGUI, this.alertManager, this.database);
        commandExecutor.setReplayMgr(this.replayMgr);
        this.getCommand("nochance").setExecutor((CommandExecutor)commandExecutor);
        this.getCommand("nochance").setTabCompleter((TabCompleter)commandExecutor);
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
            long timeWindow = (long)this.config.getTimeWindow() * 1000L;
            ArrayList<PlayerData> dataSnapshot = new ArrayList<PlayerData>(this.playerDataMap.values());
            for (PlayerData data : dataSnapshot) {
                data.cleanOldViolations(timeWindow);
                data.calibrateSkillLevel();
                String playerName = Bukkit.getOfflinePlayer((UUID)data.getPlayerId()).getName();
                if (playerName == null) {
                    playerName = "Unknown";
                }
                this.database.updatePlayerData(data.getPlayerId(), playerName, data.getViolationRatio() > 0.0 ? (int)(data.getViolationRatio() * 100.0) : 0, data.getViolationRatio() > 0.0 ? 100 : 0, 1.0 - data.getViolationRatio(), data.getSkillLevel().name(), false);
            }
            this.multiLayerValidator.cleanupOldData();
            this.detectionEngine.cleanupOldData();
        }, 1200L, 1200L);
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> this.checkRegistry.cleanupStale(), 600L, 600L);
        this.updateChecker = new UpdateChecker((Plugin)this, 129357);
        this.updateChecker.performCheck();
        this.getLogger().info("NoChance Anti-Cheat has been enabled!");
        this.getLogger().info("Version: " + this.getDescription().getVersion());
        this.getLogger().info("Database: " + dbType.name());
        this.getLogger().info("Loaded " + this.checkRegistry.getCheckCount() + " detection modules with 4-layer validation cascade");
        this.getLogger().info("Packet detection: ENABLED");
        this.getLogger().info("Punishment system: ACTIVE (warn/kick/tempban/ban ladder)");
        this.getLogger().info("Async processing: ENABLED");
        this.getLogger().info("Replay system: " + (String)(this.config.isReplayEnabled() ? "ENABLED (" + this.config.getReplayBufferSeconds() + "s buffer)" : "DISABLED"));
    }

    public void onDisable() {
        PacketEvents.getAPI().terminate();
        if (this.replayMgr != null) {
            this.replayMgr.shutdown();
        }
        if (this.asyncProcessor != null) {
            this.asyncProcessor.shutdown();
        }
        if (this.database != null) {
            ArrayList<CompletableFuture<Void>> updates = new ArrayList<CompletableFuture<Void>>();
            for (Map.Entry<UUID, PlayerData> entry : this.playerDataMap.entrySet()) {
                UUID uuid = entry.getKey();
                PlayerData data = entry.getValue();
                String playerName = Bukkit.getOfflinePlayer((UUID)uuid).getName();
                if (playerName == null) {
                    playerName = "Unknown";
                }
                CompletableFuture<Void> future = this.database.updatePlayerData(uuid, playerName, data.getViolationRatio() > 0.0 ? (int)(data.getViolationRatio() * 100.0) : 0, data.getViolationRatio() > 0.0 ? 100 : 0, 1.0 - data.getViolationRatio(), data.getSkillLevel().name(), false);
                updates.add(future);
            }
            try {
                CompletableFuture.allOf(updates.toArray(new CompletableFuture[0])).get(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to wait for database updates on shutdown: " + e.getMessage());
            }
            this.database.close();
        }
        if (this.playerDataMap != null) {
            this.playerDataMap.clear();
        }
        this.getLogger().info("NoChance Anti-Cheat has been disabled!");
    }

    public DatabaseManager getDatabase() {
        return this.database;
    }

    public PunishmentManager getPunishmentManager() {
        return this.punishmentManager;
    }

    public StaffAlertManager getAlertManager() {
        return this.alertManager;
    }

    public AsyncCheckProcessor getAsyncProcessor() {
        return this.asyncProcessor;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public CheckRegistry getCheckRegistry() {
        return this.checkRegistry;
    }

    public ReplayMgr getReplayMgr() {
        return this.replayMgr;
    }
}

