/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.alerts;

import NC.noChance.core.ACConfig;
import NC.noChance.core.ViolationType;
import NC.noChance.json.JSONObject;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class StaffAlertManager {
    private final Plugin plugin;
    private final ACConfig config;
    private final Map<UUID, AlertThrottle> throttles;
    private final Set<UUID> alertsEnabled;
    private String discordWebhook;

    public StaffAlertManager(Plugin plugin, ACConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.throttles = new ConcurrentHashMap<UUID, AlertThrottle>();
        this.alertsEnabled = ConcurrentHashMap.newKeySet();
        this.discordWebhook = null;
    }

    public void setDiscordWebhook(String webhook) {
        this.discordWebhook = webhook;
    }

    public void sendAlert(Player player, ViolationType type, double severity, String details, String confidenceLevel, double score, String detectionMethod, String variant) {
        UUID uuid = player.getUniqueId();
        AlertThrottle throttle = this.throttles.computeIfAbsent(uuid, k -> new AlertThrottle());
        throttle.recordViolation(type);
        if (!throttle.shouldAlert(type)) {
            return;
        }
        int count = throttle.getViolationCount(type);
        String message = this.buildAlertMessage(player, type, severity, details, confidenceLevel, score, detectionMethod, count, variant);
        String hoverInfo = this.buildHoverInfo(player, type, severity, details, confidenceLevel, score, detectionMethod);
        for (Player staff : Bukkit.getOnlinePlayers()) {
            if (!staff.hasPermission("nochance.alerts") || !this.alertsEnabled.contains(staff.getUniqueId())) continue;
            staff.sendMessage(message);
        }
        if (this.discordWebhook != null && this.shouldSendToDiscord(confidenceLevel, severity)) {
            this.sendDiscordAlert(player.getName(), type, severity, details, confidenceLevel, score, detectionMethod, count, variant);
        }
    }

    private String buildAlertMessage(Player player, ViolationType type, double severity, String details, String confidenceLevel, double score, String detectionMethod, int count, String variant) {
        Object countSuffix = count > 1 ? " \u00a77x" + count : "";
        String variantTag = variant != null && !variant.isEmpty() ? " \u00a78[\u00a77" + variant + "\u00a78]" : "";
        return String.format("\u00a7c[\u00a77%s\u00a7c]%s \u00a77%s \u00a7c%.1f%% \u00a78| \u00a77%s%s", type.name(), variantTag, player.getName(), score * 100.0, confidenceLevel, countSuffix);
    }

    private String buildHoverInfo(Player player, ViolationType type, double severity, String details, String confidenceLevel, double score, String detectionMethod) {
        return String.format("\u00a77Player: \u00a7e%s\n\u00a77Type: \u00a7c%s\n\u00a77Severity: \u00a7f%.2f\n\u00a77Confidence: %s\n\u00a77Score: \u00a7f%.1f%%\n\u00a77Method: \u00a7e%s\n\u00a77Details: \u00a77%s\n\u00a77Ping: \u00a7f%dms\n\u00a77TPS: \u00a7f%.1f", player.getName(), type.name(), severity, confidenceLevel, score * 100.0, detectionMethod, details, this.getPing(player), this.getTPS());
    }

    private String getColorByConfidence(String confidence) {
        switch (confidence) {
            case "EXTREME": {
                return "\u00a74\u00a7l";
            }
            case "HIGH": {
                return "\u00a7c";
            }
            case "MEDIUM": {
                return "\u00a76";
            }
            case "LOW": {
                return "\u00a7e";
            }
        }
        return "\u00a77";
    }

    private String getIconByType(ViolationType type) {
        String name = type.name();
        if (name.contains("FLY") || name.contains("SPEED") || name.contains("NOCLIP") || name.contains("JESUS") || name.contains("NOSLOW")) {
            return "\u26a1";
        }
        if (name.contains("KILLAURA") || name.contains("REACH") || name.contains("AUTOCLICKER")) {
            return "\u2694";
        }
        if (name.contains("SCAFFOLD") || name.contains("FASTPLACE") || name.contains("NUKER")) {
            return "\u26cf";
        }
        if (name.contains("BADPACKETS") || name.contains("BLINK") || name.contains("TIMER")) {
            return "\ud83d\udce1";
        }
        return "\u26a0";
    }

    private boolean shouldSendToDiscord(String confidenceLevel, double severity) {
        if (confidenceLevel.equals("EXTREME")) {
            return true;
        }
        if (confidenceLevel.equals("HIGH")) {
            return true;
        }
        return confidenceLevel.equals("MEDIUM") && severity >= 0.8;
    }

    private void sendDiscordAlert(String playerName, ViolationType type, double severity, String details, String confidenceLevel, double score, String detectionMethod, int count, String variant) {
        CompletableFuture.runAsync(() -> {
            try {
                JSONObject embed = new JSONObject();
                String icon = this.getIconByType(type);
                Object countText = count > 1 ? " (x" + count + ")" : "";
                embed.put("title", icon + " **Anti-Cheat Detection**" + (String)countText);
                embed.put("description", String.format("**%s** has been flagged for suspicious activity", playerName));
                embed.put("color", this.getDiscordColor(confidenceLevel));
                JSONObject[] fields = new JSONObject[7];
                fields[0] = new JSONObject();
                fields[0].put("name", "\ud83c\udfaf Violation Type");
                String checkName = type.name() + (variant != null && !variant.isEmpty() ? variant : "");
                fields[0].put("value", "`" + checkName + "`");
                fields[0].put("inline", true);
                fields[1] = new JSONObject();
                fields[1].put("name", "\u26a1 Confidence Level");
                fields[1].put("value", "**" + confidenceLevel + "** (" + String.format("%.1f%%", score * 100.0) + ")");
                fields[1].put("inline", true);
                fields[2] = new JSONObject();
                fields[2].put("name", "\ud83d\udcca Severity Score");
                fields[2].put("value", "`" + String.format("%.2f", severity) + "`");
                fields[2].put("inline", true);
                fields[3] = new JSONObject();
                fields[3].put("name", "\ud83d\udd0d Detection Method");
                fields[3].put("value", "`" + detectionMethod + "`");
                fields[3].put("inline", true);
                fields[4] = new JSONObject();
                fields[4].put("name", "\ud83d\udd50 Detected");
                fields[4].put("value", "<t:" + System.currentTimeMillis() / 1000L + ":R>");
                fields[4].put("inline", true);
                fields[5] = new JSONObject();
                fields[5].put("name", "\ud83d\udccd Server");
                fields[5].put("value", "`" + Bukkit.getServer().getMotd() + "`");
                fields[5].put("inline", true);
                fields[6] = new JSONObject();
                fields[6].put("name", "\ud83d\udcdd Details");
                fields[6].put("value", "```" + details + "```");
                fields[6].put("inline", false);
                embed.put("fields", fields);
                JSONObject footer = new JSONObject();
                footer.put("text", "NoChance Anti-Cheat \u2022 TPS: " + String.format("%.1f", this.getTPS()));
                embed.put("footer", footer);
                JSONObject author = new JSONObject();
                author.put("name", playerName);
                author.put("icon_url", "https://minotar.net/avatar/" + playerName + "/64.png");
                embed.put("author", author);
                embed.put("timestamp", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").format(new Date()));
                JSONObject payload = new JSONObject();
                payload.put("embeds", new JSONObject[]{embed});
                URL url = new URL(this.discordWebhook);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setDoOutput(true);
                try (OutputStream os = conn.getOutputStream();){
                    byte[] input = payload.toString().getBytes(StandardCharsets.UTF_8);
                    os.write(input, 0, input.length);
                }
                int responseCode = conn.getResponseCode();
                if (responseCode != 204 && responseCode != 200) {
                    this.plugin.getLogger().warning("Discord webhook failed: " + responseCode);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to send Discord alert: " + e.getMessage());
            }
        });
    }

    private int getDiscordColor(String confidence) {
        switch (confidence) {
            case "EXTREME": {
                return 0xFF0000;
            }
            case "HIGH": {
                return 0xFF6600;
            }
            case "MEDIUM": {
                return 0xFFAA00;
            }
            case "LOW": {
                return 0xFFFF00;
            }
        }
        return 0x808080;
    }

    public void toggleAlerts(UUID uuid) {
        if (this.alertsEnabled.contains(uuid)) {
            this.alertsEnabled.remove(uuid);
        } else {
            this.alertsEnabled.add(uuid);
        }
    }

    public boolean hasAlertsEnabled(UUID uuid) {
        return this.alertsEnabled.contains(uuid);
    }

    public void enableAlerts(UUID uuid) {
        this.alertsEnabled.add(uuid);
    }

    public void cleanup(UUID uuid) {
        this.throttles.remove(uuid);
    }

    private int getPing(Player player) {
        try {
            Object entityPlayer = player.getClass().getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
            return (Integer)entityPlayer.getClass().getField("ping").get(entityPlayer);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private double getTPS() {
        try {
            Object server = Bukkit.getServer().getClass().getMethod("getServer", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
            double[] recentTps = (double[])server.getClass().getField("recentTps").get(server);
            return Math.min(20.0, recentTps[0]);
        }
        catch (Exception e) {
            return 20.0;
        }
    }

    private static class AlertThrottle {
        private final Map<ViolationType, Long> lastAlertTime = new HashMap<ViolationType, Long>();
        private final Map<ViolationType, Long> lastViolationTime = new HashMap<ViolationType, Long>();
        private final Map<ViolationType, Integer> violationCount = new HashMap<ViolationType, Integer>();
        private static final long THROTTLE_MS = 3000L;
        private static final long RESET_MS = 10000L;

        private AlertThrottle() {
        }

        void recordViolation(ViolationType type) {
            long now = System.currentTimeMillis();
            Long lastViolation = this.lastViolationTime.get((Object)type);
            if (lastViolation != null && now - lastViolation < 10000L) {
                this.violationCount.put(type, this.violationCount.getOrDefault((Object)type, 1) + 1);
            } else {
                this.violationCount.put(type, 1);
            }
            this.lastViolationTime.put(type, now);
        }

        int getViolationCount(ViolationType type) {
            return this.violationCount.getOrDefault((Object)type, 1);
        }

        boolean shouldAlert(ViolationType type) {
            long now = System.currentTimeMillis();
            Long last = this.lastAlertTime.get((Object)type);
            if (last == null || now - last >= 3000L) {
                this.lastAlertTime.put(type, now);
                return true;
            }
            return false;
        }
    }
}

