/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.commands;

import NC.noChance.alerts.StaffAlertManager;
import NC.noChance.core.ACConfig;
import NC.noChance.core.PlayerData;
import NC.noChance.core.ViolationScoring;
import NC.noChance.core.ViolationType;
import NC.noChance.database.DatabaseManager;
import NC.noChance.gui.ACMenuGUI;
import NC.noChance.replay.ReplayMgr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class NoChanceCommand
implements CommandExecutor,
TabCompleter {
    private final Plugin plugin;
    private final ACConfig config;
    private final Map<UUID, PlayerData> playerDataMap;
    private final ViolationScoring violationScoring;
    private final ACMenuGUI menuGUI;
    private final StaffAlertManager alertManager;
    private final DatabaseManager database;
    private ReplayMgr replayMgr;

    public NoChanceCommand(Plugin plugin, ACConfig config, Map<UUID, PlayerData> playerDataMap, ViolationScoring violationScoring, ACMenuGUI menuGUI, StaffAlertManager alertManager, DatabaseManager database) {
        this.plugin = plugin;
        this.config = config;
        this.playerDataMap = playerDataMap;
        this.violationScoring = violationScoring;
        this.menuGUI = menuGUI;
        this.alertManager = alertManager;
        this.database = database;
    }

    public void setReplayMgr(ReplayMgr replayMgr) {
        this.replayMgr = replayMgr;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("nochance.admin")) {
            sender.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77You don't have permission to use this command.");
            return true;
        }
        if (args.length == 0) {
            this.sendHelpMessage(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "menu": 
            case "gui": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77This command can only be used by players.");
                    return true;
                }
                this.menuGUI.openMainMenu((Player)sender);
                break;
            }
            case "reload": {
                this.handleReload(sender);
                break;
            }
            case "info": {
                if (args.length < 2) {
                    sender.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Usage: /nochance info <player>");
                    return true;
                }
                this.handleInfo(sender, args[1]);
                break;
            }
            case "violations": {
                if (args.length < 2) {
                    sender.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Usage: /nochance violations <player>");
                    return true;
                }
                this.handleViolations(sender, args[1]);
                break;
            }
            case "reset": {
                if (args.length < 2) {
                    sender.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Usage: /nochance reset <player>");
                    return true;
                }
                this.handleReset(sender, args[1]);
                break;
            }
            case "toggle": {
                if (args.length < 2) {
                    sender.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Usage: /nochance toggle <check>");
                    return true;
                }
                this.handleToggle(sender, args[1]);
                break;
            }
            case "stats": {
                this.handleStats(sender);
                break;
            }
            case "alerts": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77This command can only be used by players.");
                    return true;
                }
                this.handleAlerts((Player)sender);
                break;
            }
            case "replay": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77This command can only be used by players.");
                    return true;
                }
                this.handleReplay((Player)sender, args);
                break;
            }
            default: {
                this.sendHelpMessage(sender);
            }
        }
        return true;
    }

    private void sendHelpMessage(CommandSender sender) {
        sender.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Anti-Cheat Commands");
        sender.sendMessage("\u00a78\u00a7m                                              ");
        sender.sendMessage("\u00a7c/nochance menu \u00a78- \u00a77Open GUI configuration menu");
        sender.sendMessage("\u00a7c/nochance reload \u00a78- \u00a77Reload configuration");
        sender.sendMessage("\u00a7c/nochance info <player> \u00a78- \u00a77View player information");
        sender.sendMessage("\u00a7c/nochance violations <player> \u00a78- \u00a77View player violations");
        sender.sendMessage("\u00a7c/nochance reset <player> \u00a78- \u00a77Reset player violations");
        sender.sendMessage("\u00a7c/nochance toggle <check> \u00a78- \u00a77Toggle a check on/off");
        sender.sendMessage("\u00a7c/nochance stats \u00a78- \u00a77View overall statistics");
        sender.sendMessage("\u00a7c/nochance alerts \u00a78- \u00a77Toggle staff alerts");
        sender.sendMessage("\u00a7c/nochance replay <list|play|stop|pause|speed> \u00a78- \u00a77Replay system");
        sender.sendMessage("\u00a78\u00a7m                                              ");
    }

    private void handleReload(CommandSender sender) {
        this.config.reload();
        sender.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Configuration reloaded successfully.");
    }

    private void handleInfo(CommandSender sender, String playerName) {
        Player target = Bukkit.getPlayer((String)playerName);
        if (target == null) {
            sender.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Player not found.");
            return;
        }
        PlayerData data = this.playerDataMap.get(target.getUniqueId());
        if (data == null) {
            sender.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77No data found for this player.");
            return;
        }
        long timeWindow = (long)this.config.getTimeWindow() * 1000L;
        double score = this.violationScoring.calculateViolationScore(target.getUniqueId(), timeWindow);
        ViolationScoring.ConfidenceLevel confidence = this.violationScoring.getConfidenceLevel(score);
        sender.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Player Info: \u00a7f" + target.getName());
        sender.sendMessage("\u00a78\u00a7m                                              ");
        sender.sendMessage("\u00a77Skill Level: \u00a7c" + data.getSkillLevel().name());
        sender.sendMessage("\u00a77Average CPS: \u00a7c" + String.format("%.1f", data.getAverageCPS()));
        sender.sendMessage("\u00a77Average Rotation Speed: \u00a7c" + String.format("%.1f\u00b0/s", data.getAverageRotationSpeed()));
        sender.sendMessage("\u00a77Hit Accuracy: \u00a7c" + String.format("%.1f%%", data.getAverageAccuracy() * 100.0));
        sender.sendMessage("\u00a77Violation Score: \u00a7c" + String.format("%.2f", score));
        sender.sendMessage("\u00a77Confidence Level: \u00a7c" + confidence.name());
        sender.sendMessage("\u00a78\u00a7m                                              ");
    }

    private void handleViolations(CommandSender sender, String playerName) {
        Player target = Bukkit.getPlayer((String)playerName);
        if (target == null) {
            sender.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Player not found.");
            return;
        }
        PlayerData data = this.playerDataMap.get(target.getUniqueId());
        if (data == null) {
            sender.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77No data found for this player.");
            return;
        }
        sender.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Violations for \u00a7f" + target.getName());
        sender.sendMessage("\u00a78\u00a7m                                              ");
        long timeWindow = (long)this.config.getTimeWindow() * 1000L;
        boolean hasViolations = false;
        for (ViolationType type : ViolationType.values()) {
            List<PlayerData.ViolationRecord> violations = data.getViolations(type, timeWindow);
            if (violations.isEmpty()) continue;
            hasViolations = true;
            double avgSeverity = violations.stream().mapToDouble(v -> v.severity).average().orElse(0.0);
            sender.sendMessage(String.format("\u00a7c%s: \u00a77%d violations \u00a78(Avg Severity: \u00a77%.2f\u00a78)", type.name(), violations.size(), avgSeverity));
        }
        if (!hasViolations) {
            sender.sendMessage("\u00a77No recent violations.");
        }
        sender.sendMessage("\u00a78\u00a7m                                              ");
    }

    private void handleReset(CommandSender sender, String playerName) {
        Player target = Bukkit.getPlayer((String)playerName);
        if (target == null) {
            sender.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Player not found.");
            return;
        }
        this.playerDataMap.put(target.getUniqueId(), new PlayerData(target.getUniqueId()));
        sender.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Reset violations for \u00a7f" + target.getName());
    }

    private void handleToggle(CommandSender sender, String checkName) {
        String configPath = "checks." + checkName.toLowerCase() + ".enabled";
        boolean currentValue = this.config.isCheckEnabled(checkName.toLowerCase());
        this.plugin.getConfig().set(configPath, (Object)(!currentValue ? 1 : 0));
        this.plugin.saveConfig();
        sender.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Check \u00a7f" + checkName + " \u00a77is now " + (!currentValue ? "\u00a7aenabled" : "\u00a7cdisabled") + "\u00a77.");
    }

    private void handleStats(CommandSender sender) {
        int totalPlayers = this.playerDataMap.size();
        int playersWithViolations = 0;
        int totalViolations = 0;
        long timeWindow = (long)this.config.getTimeWindow() * 1000L;
        for (PlayerData data : this.playerDataMap.values()) {
            boolean hasViolations = false;
            for (ViolationType type : ViolationType.values()) {
                List<PlayerData.ViolationRecord> violations = data.getViolations(type, timeWindow);
                if (violations.isEmpty()) continue;
                hasViolations = true;
                totalViolations += violations.size();
            }
            if (!hasViolations) continue;
            ++playersWithViolations;
        }
        sender.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Statistics");
        sender.sendMessage("\u00a78\u00a7m                                              ");
        sender.sendMessage("\u00a77Total Players Monitored: \u00a7c" + totalPlayers);
        sender.sendMessage("\u00a77Players with Violations: \u00a7c" + playersWithViolations);
        sender.sendMessage("\u00a77Total Recent Violations: \u00a7c" + totalViolations);
        sender.sendMessage("\u00a78\u00a7m                                              ");
    }

    private void handleAlerts(Player player) {
        this.alertManager.toggleAlerts(player.getUniqueId());
        boolean enabled = this.alertManager.hasAlertsEnabled(player.getUniqueId());
        player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Staff alerts are now " + (enabled ? "\u00a7aenabled" : "\u00a7cdisabled") + "\u00a77.");
    }

    private void handleReplay(Player player, String[] args) {
        if (this.replayMgr == null || !this.replayMgr.isEnabled()) {
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Replay system is disabled.");
            return;
        }
        if (args.length < 2) {
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Replay Commands:");
            player.sendMessage("\u00a7c/nc replay list [player] \u00a78- \u00a77List replays");
            player.sendMessage("\u00a7c/nc replay play <file> \u00a78- \u00a77Watch replay");
            player.sendMessage("\u00a7c/nc replay stop \u00a78- \u00a77Stop");
            player.sendMessage("\u00a7c/nc replay pause \u00a78- \u00a77Pause/resume");
            player.sendMessage("\u00a7c/nc replay speed <x> \u00a78- \u00a77Playback speed");
            player.sendMessage("\u00a7c/nc replay follow \u00a78- \u00a77Toggle camera follow");
            return;
        }
        block9 : switch (args[1].toLowerCase()) {
            case "list": {
                String filterPlayer = args.length > 2 ? args[2] : null;
                List<String> replays = this.replayMgr.listReplays(filterPlayer);
                if (replays.isEmpty()) {
                    player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77No replays found.");
                    break;
                }
                player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Available replays:");
                int count = 0;
                for (String r : replays) {
                    if (count++ >= 10) {
                        player.sendMessage("\u00a77... and " + (replays.size() - 10) + " more");
                        break block9;
                    }
                    player.sendMessage("\u00a78- \u00a7f" + r);
                }
                break;
            }
            case "play": {
                if (args.length < 3) {
                    player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Usage: /nc replay play <filename>");
                    return;
                }
                this.replayMgr.playReplay(player, args[2]);
                break;
            }
            case "stop": {
                this.replayMgr.stopReplay(player);
                break;
            }
            case "pause": {
                this.replayMgr.pauseReplay(player);
                break;
            }
            case "speed": {
                if (args.length < 3) {
                    player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Usage: /nc replay speed <0.25-4>");
                    return;
                }
                try {
                    float speed = Float.parseFloat(args[2]);
                    this.replayMgr.setReplaySpeed(player, speed);
                }
                catch (NumberFormatException e) {
                    player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Invalid speed value.");
                }
                break;
            }
            case "follow": {
                this.replayMgr.toggleFollow(player);
                break;
            }
            default: {
                player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Unknown replay command.");
            }
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("nochance.admin")) {
            return new ArrayList<String>();
        }
        if (args.length == 1) {
            return Arrays.asList("menu", "gui", "reload", "info", "violations", "reset", "toggle", "stats", "alerts", "replay");
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("info") || args[0].equalsIgnoreCase("violations") || args[0].equalsIgnoreCase("reset")) {
                ArrayList<String> players = new ArrayList<String>();
                for (Player p : Bukkit.getOnlinePlayers()) {
                    players.add(p.getName());
                }
                return players;
            }
            if (args[0].equalsIgnoreCase("toggle")) {
                return Arrays.asList("fly", "speed", "noclip", "jesus", "fastbreak", "fastplace", "nuker", "killaura", "nofall", "autoclicker", "reach", "inventory", "scaffold", "timer", "velocity", "criticals", "phase", "step");
            }
            if (args[0].equalsIgnoreCase("replay")) {
                return Arrays.asList("list", "play", "stop", "pause", "speed", "follow");
            }
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("replay")) {
            if (args[1].equalsIgnoreCase("list")) {
                ArrayList<String> players = new ArrayList<String>();
                for (Player p : Bukkit.getOnlinePlayers()) {
                    players.add(p.getName());
                }
                return players;
            }
            if (args[1].equalsIgnoreCase("play") && this.replayMgr != null) {
                return this.replayMgr.listReplays(null);
            }
            if (args[1].equalsIgnoreCase("speed")) {
                return Arrays.asList("0.5", "1", "1.5", "2");
            }
        }
        return new ArrayList<String>();
    }
}

