/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.core;

import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class ACConfig {
    private FileConfiguration config;
    private final Plugin plugin;

    public ACConfig(Plugin plugin) {
        this.plugin = plugin;
        plugin.saveDefaultConfig();
        this.config = plugin.getConfig();
        this.validateConfig();
    }

    public boolean isCheckEnabled(String checkName) {
        return this.config.getBoolean("checks." + checkName + ".enabled", true);
    }

    public int getViolationThreshold(String checkName) {
        return this.config.getInt("checks." + checkName + ".threshold", 10);
    }

    public double getSeverityMultiplier(String checkName) {
        return this.config.getDouble("checks." + checkName + ".severity_multiplier", 1.0);
    }

    public int getTimeWindow() {
        return this.config.getInt("general.time_window_seconds", 60);
    }

    public int getGracePeriod() {
        return this.config.getInt("general.grace_period_seconds", 5);
    }

    public int getMinSamples() {
        return this.config.getInt("general.min_samples", 15);
    }

    public double getLowConfidenceThreshold() {
        return this.config.getDouble("thresholds.low_confidence", 0.6);
    }

    public double getMediumConfidenceThreshold() {
        return this.config.getDouble("thresholds.medium_confidence", 0.72);
    }

    public double getHighConfidenceThreshold() {
        return this.config.getDouble("thresholds.high_confidence", 0.82);
    }

    public boolean shouldKickOnHighConfidence() {
        return this.config.getBoolean("actions.kick_on_high_confidence", true);
    }

    public boolean shouldWarnOnMediumConfidence() {
        return this.config.getBoolean("actions.warn_on_medium_confidence", true);
    }

    public boolean shouldLogLowConfidence() {
        return this.config.getBoolean("actions.log_low_confidence", true);
    }

    public double getMaxSpeed() {
        return this.config.getDouble("checks.speed.max_speed", 0.35);
    }

    public double getSprintMultiplier() {
        return this.config.getDouble("checks.speed.sprint_multiplier", 1.3);
    }

    public double getSpeedPotionMultiplier(int level) {
        return 1.0 + 0.2 * (double)level;
    }

    public double getIceMultiplier() {
        return this.config.getDouble("checks.speed.ice_multiplier", 2.5);
    }

    public double getMaxFlyVelocityY() {
        return this.config.getDouble("checks.fly.max_velocity_y", 0.5);
    }

    public double getKillAuraMaxReach() {
        return this.config.getDouble("checks.killaura.max_reach", 3.0);
    }

    public double getKillAuraMaxAngle() {
        return this.config.getDouble("checks.killaura.max_angle", 45.0);
    }

    public double getKillAuraMaxRotationSpeed() {
        return this.config.getDouble("checks.killaura.max_rotation_speed", 600.0);
    }

    public int getHighSkillMaxCPS() {
        return this.config.getInt("skill_profiles.high.max_cps", 20);
    }

    public int getMediumSkillMaxCPS() {
        return this.config.getInt("skill_profiles.medium.max_cps", 12);
    }

    public int getLowSkillMaxCPS() {
        return this.config.getInt("skill_profiles.low.max_cps", 8);
    }

    public double getStandardDeviationMultiplier() {
        return this.config.getDouble("statistical.std_dev_multiplier", 3.2);
    }

    public int getOutlierForgiveness() {
        return this.config.getInt("statistical.outlier_forgiveness", 4);
    }

    public int getLowSkillMinCPS() {
        return this.config.getInt("skill_profiles.low.min_cps", 4);
    }

    public int getMediumSkillMinCPS() {
        return this.config.getInt("skill_profiles.medium.min_cps", 8);
    }

    public int getHighSkillMinCPS() {
        return this.config.getInt("skill_profiles.high.min_cps", 12);
    }

    public double getLowSkillMinRotation() {
        return this.config.getDouble("skill_profiles.low.min_rotation_speed", 120.0);
    }

    public double getMediumSkillMinRotation() {
        return this.config.getDouble("skill_profiles.medium.min_rotation_speed", 200.0);
    }

    public double getHighSkillMinRotation() {
        return this.config.getDouble("skill_profiles.high.min_rotation_speed", 350.0);
    }

    public double getLowSkillMaxRotation() {
        return this.config.getDouble("skill_profiles.low.max_rotation_speed", 200.0);
    }

    public double getMediumSkillMaxRotation() {
        return this.config.getDouble("skill_profiles.medium.max_rotation_speed", 350.0);
    }

    public double getHighSkillMaxRotation() {
        return this.config.getDouble("skill_profiles.high.max_rotation_speed", 600.0);
    }

    public double getLowSkillMinAccuracy() {
        return this.config.getDouble("skill_profiles.low.min_accuracy", 0.3);
    }

    public double getMediumSkillMinAccuracy() {
        return this.config.getDouble("skill_profiles.medium.min_accuracy", 0.5);
    }

    public double getHighSkillMinAccuracy() {
        return this.config.getDouble("skill_profiles.high.min_accuracy", 0.7);
    }

    public double getLowSkillMaxAccuracy() {
        return this.config.getDouble("skill_profiles.low.max_accuracy", 0.5);
    }

    public double getMediumSkillMaxAccuracy() {
        return this.config.getDouble("skill_profiles.medium.max_accuracy", 0.7);
    }

    public double getHighSkillMaxAccuracy() {
        return this.config.getDouble("skill_profiles.high.max_accuracy", 0.85);
    }

    public int getAutoClickerMaxCPS() {
        return this.config.getInt("checks.autoclicker.max_cps", 24);
    }

    public double getReachMaxEntityReach() {
        return this.config.getDouble("checks.reach.max_entity_reach", 3.8);
    }

    public double getReachMaxBlockReach() {
        return this.config.getDouble("checks.reach.max_block_reach", 4.2);
    }

    public int getInventoryMaxClicksPerSecond() {
        return this.config.getInt("checks.inventory.max_clicks_per_second", 15);
    }

    public int getFastPlaceMaxBlocksPerTick() {
        return this.config.getInt("checks.fastplace.max_blocks_per_tick", 1);
    }

    public int getFastPlaceMinIntervalMs() {
        return this.config.getInt("checks.fastplace.min_interval_ms", 50);
    }

    public int getFastPlaceMaxBlocksPerSecond() {
        return this.config.getInt("checks.fastplace.max_blocks_per_second", 12);
    }

    public double getFastPlaceMaxScaffoldAngle() {
        return this.config.getDouble("checks.fastplace.max_scaffold_angle", 35.0);
    }

    public double getFastPlaceMaxScaffoldDistance() {
        return this.config.getDouble("checks.fastplace.max_scaffold_distance", 5.0);
    }

    public int getFastPlaceScaffoldMinBlocks() {
        return this.config.getInt("checks.fastplace.scaffold_min_blocks", 3);
    }

    public String getDatabaseType() {
        return this.config.getString("database.type", "SQLITE");
    }

    public String getDatabaseHost() {
        return this.config.getString("database.host", "localhost");
    }

    public int getDatabasePort() {
        return this.config.getInt("database.port", 3306);
    }

    public String getDatabaseName() {
        return this.config.getString("database.database", "nochance");
    }

    public String getDatabaseUsername() {
        return this.config.getString("database.username", "root");
    }

    public String getDatabasePassword() {
        return this.config.getString("database.password", "password");
    }

    public String getDatabaseTablePrefix() {
        return this.config.getString("database.table_prefix", "nc_");
    }

    public boolean isDiscordEnabled() {
        return this.config.getBoolean("discord.enabled", false);
    }

    public String getDiscordWebhook() {
        return this.config.getString("discord.webhook_url", "");
    }

    public boolean isOpExempt() {
        return this.config.getBoolean("general.op_exempt", true);
    }

    public boolean shouldNotifyPlayerOnFlag() {
        return this.config.getBoolean("general.notify_player_on_flag", true);
    }

    public double getKillAuraMaxCPS() {
        return this.config.getDouble("checks.killaura.max_cps", 17.0);
    }

    public double getKillAuraCPSTrustedBonus() {
        return this.config.getDouble("checks.killaura.cps_trusted_bonus", 2.0);
    }

    public double getKillAuraCPSUntrustedPenalty() {
        return this.config.getDouble("checks.killaura.cps_untrusted_penalty", 2.0);
    }

    public double getKillAuraInstantFlagCPSOver() {
        return this.config.getDouble("checks.killaura.instant_flag_cps_over", 6.0);
    }

    public double getKillAuraAngleTrustedBonus() {
        return this.config.getDouble("checks.killaura.angle_trusted_bonus", 8.0);
    }

    public double getKillAuraAngleUntrustedPenalty() {
        return this.config.getDouble("checks.killaura.angle_untrusted_penalty", 5.0);
    }

    public double getKillAuraInstantFlagAngleOver() {
        return this.config.getDouble("checks.killaura.instant_flag_angle_over", 18.0);
    }

    public double getKillAuraRotationTrustedBonus() {
        return this.config.getDouble("checks.killaura.rotation_trusted_bonus", 60.0);
    }

    public double getKillAuraRotationUntrustedPenalty() {
        return this.config.getDouble("checks.killaura.rotation_untrusted_penalty", 50.0);
    }

    public double getKillAuraInstantFlagRotationOver() {
        return this.config.getDouble("checks.killaura.instant_flag_rotation_over", 140.0);
    }

    public double getKillAuraRotationVarianceThreshold() {
        return this.config.getDouble("checks.killaura.rotation_variance_threshold", 40.0);
    }

    public double getKillAuraRotationVarianceStrict() {
        return this.config.getDouble("checks.killaura.rotation_variance_strict", 20.0);
    }

    public int getKillAuraRequiredViolations() {
        return this.config.getInt("checks.killaura.required_violations", 2);
    }

    public double getKillAuraPacketVarianceThreshold() {
        return this.config.getDouble("checks.killaura.packet_variance_threshold", 25.0);
    }

    public double getKillAuraPacketVarianceStrict() {
        return this.config.getDouble("checks.killaura.packet_variance_strict", 12.0);
    }

    public int getKillAuraPacketAttackRateLimit() {
        return this.config.getInt("checks.killaura.packet_attack_rate_limit", 22);
    }

    public int getFastBreakBaseToleranceMs() {
        return this.config.getInt("checks.fastbreak.base_tolerance_ms", 50);
    }

    public double getFastBreakPercentageTolerance() {
        return this.config.getDouble("checks.fastbreak.percentage_tolerance", 0.1);
    }

    public int getFastBreakShovelInstantToleranceMs() {
        return this.config.getInt("checks.fastbreak.shovel_instant_tolerance_ms", 45);
    }

    public double getFastBreakShovelInstantPercentage() {
        return this.config.getDouble("checks.fastbreak.shovel_instant_percentage", 0.25);
    }

    public int getFastBreakHandInstantToleranceMs() {
        return this.config.getInt("checks.fastbreak.hand_instant_tolerance_ms", 28);
    }

    public double getFastBreakHandInstantPercentage() {
        return this.config.getDouble("checks.fastbreak.hand_instant_percentage", 0.18);
    }

    public int getFastBreakTrustBonusInstantMs() {
        return this.config.getInt("checks.fastbreak.trust_bonus_instant_ms", 15);
    }

    public int getFastBreakTrustBonusNormalMs() {
        return this.config.getInt("checks.fastbreak.trust_bonus_normal_ms", 50);
    }

    public int getAsyncThreadPoolSize() {
        return this.config.getInt("performance.async_thread_pool_size", 4);
    }

    public int getDatabaseMaxPoolSize() {
        return this.config.getInt("performance.database_max_pool_size", 10);
    }

    public int getDatabaseMinIdle() {
        return this.config.getInt("performance.database_min_idle", 2);
    }

    public long getDatabaseConnectionTimeout() {
        return this.config.getLong("performance.database_connection_timeout_ms", 30000L);
    }

    public long getDatabaseIdleTimeout() {
        return this.config.getLong("performance.database_idle_timeout_ms", 600000L);
    }

    public long getDatabaseMaxLifetime() {
        return this.config.getLong("performance.database_max_lifetime_ms", 1800000L);
    }

    public int getDatabaseBatchSize() {
        return this.config.getInt("performance.database_batch_size", 50);
    }

    public long getDatabaseBatchInterval() {
        return this.config.getLong("performance.database_batch_interval_ms", 1000L);
    }

    public boolean isAdaptiveSamplingEnabled() {
        return this.config.getBoolean("performance.adaptive_sampling_enabled", true);
    }

    public int getAdaptiveSamplingWarmupChecks() {
        return this.config.getInt("performance.adaptive_sampling_warmup_checks", 100);
    }

    public int getAdvancedAnalysisWarmupChecks() {
        return this.config.getInt("performance.advanced_analysis_warmup_checks", 100);
    }

    public int getAdvancedAnalysisStrictThreshold() {
        return this.config.getInt("performance.advanced_analysis_strict_threshold", 500);
    }

    private void validateConfig() {
        this.validatePositive("general.time_window_seconds", this.getTimeWindow());
        this.validatePositive("general.grace_period_seconds", this.getGracePeriod());
        this.validatePositive("general.min_samples", this.getMinSamples());
        this.validateRange("thresholds.low_confidence", this.getLowConfidenceThreshold(), 0.0, 1.0);
        this.validateRange("thresholds.medium_confidence", this.getMediumConfidenceThreshold(), 0.0, 1.0);
        this.validateRange("thresholds.high_confidence", this.getHighConfidenceThreshold(), 0.0, 1.0);
        this.validatePositive("checks.speed.max_speed", this.getMaxSpeed());
        this.validatePositive("checks.speed.sprint_multiplier", this.getSprintMultiplier());
        this.validatePositive("checks.speed.ice_multiplier", this.getIceMultiplier());
        this.validatePositive("checks.fly.max_velocity_y", this.getMaxFlyVelocityY());
        this.validatePositive("checks.killaura.max_reach", this.getKillAuraMaxReach());
        this.validateRange("checks.killaura.max_angle", this.getKillAuraMaxAngle(), 0.0, 360.0);
        this.validatePositive("checks.killaura.max_rotation_speed", this.getKillAuraMaxRotationSpeed());
        this.validatePositive("checks.killaura.max_cps", this.getKillAuraMaxCPS());
        this.validatePositive("checks.autoclicker.max_cps", this.getAutoClickerMaxCPS());
        this.validatePositive("checks.reach.max_entity_reach", this.getReachMaxEntityReach());
        this.validatePositive("checks.reach.max_block_reach", this.getReachMaxBlockReach());
        this.validatePositive("checks.inventory.max_clicks_per_second", this.getInventoryMaxClicksPerSecond());
        this.validatePositive("checks.fastplace.max_blocks_per_tick", this.getFastPlaceMaxBlocksPerTick());
        this.validatePositive("checks.fastplace.min_interval_ms", this.getFastPlaceMinIntervalMs());
        this.validatePositive("checks.fastplace.max_blocks_per_second", this.getFastPlaceMaxBlocksPerSecond());
        this.validatePositive("checks.fastplace.max_scaffold_angle", this.getFastPlaceMaxScaffoldAngle());
        this.validatePositive("checks.fastplace.max_scaffold_distance", this.getFastPlaceMaxScaffoldDistance());
        this.validatePositive("checks.fastplace.scaffold_min_blocks", this.getFastPlaceScaffoldMinBlocks());
        this.validatePositive("statistical.std_dev_multiplier", this.getStandardDeviationMultiplier());
        this.validatePositive("statistical.outlier_forgiveness", this.getOutlierForgiveness());
        this.validatePositive("performance.async_thread_pool_size", this.getAsyncThreadPoolSize());
        this.validatePositive("performance.database_max_pool_size", this.getDatabaseMaxPoolSize());
        this.validatePositive("performance.database_min_idle", this.getDatabaseMinIdle());
        this.validatePositive("performance.database_batch_size", this.getDatabaseBatchSize());
        String dbType = this.getDatabaseType().toUpperCase();
        if (!dbType.equals("SQLITE") && !dbType.equals("MYSQL")) {
            this.plugin.getLogger().warning("Invalid database type '" + dbType + "', must be SQLITE or MYSQL. Using SQLITE as default.");
        }
    }

    private void validatePositive(String path, double value) {
        if (value <= 0.0) {
            this.plugin.getLogger().severe("Config value '" + path + "' must be positive, got: " + value);
            throw new IllegalArgumentException("Invalid config: " + path + " must be positive");
        }
    }

    private void validatePositive(String path, int value) {
        if (value <= 0) {
            this.plugin.getLogger().severe("Config value '" + path + "' must be positive, got: " + value);
            throw new IllegalArgumentException("Invalid config: " + path + " must be positive");
        }
    }

    private void validateRange(String path, double value, double min, double max) {
        if (value < min || value > max) {
            this.plugin.getLogger().severe("Config value '" + path + "' must be between " + min + " and " + max + ", got: " + value);
            throw new IllegalArgumentException("Invalid config: " + path + " out of range");
        }
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.validateConfig();
        this.plugin.getLogger().info("Configuration reloaded successfully!");
    }

    public boolean isReplayEnabled() {
        return this.config.getBoolean("replay.enabled", true);
    }

    public int getReplayBufferSeconds() {
        return this.config.getInt("replay.buffer_seconds", 30);
    }

    public int getReplayRetentionDays() {
        return this.config.getInt("replay.retention_days", 7);
    }

    public boolean shouldSaveReplayOnHigh() {
        return this.config.getBoolean("replay.save_on_high", true);
    }

    public boolean shouldSaveReplayOnExtreme() {
        return this.config.getBoolean("replay.save_on_extreme", true);
    }
}

