/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.core;

import NC.noChance.core.DetectionEngine;
import NC.noChance.core.ViolationType;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;

public class AdaptiveSamplingSystem {
    private final Map<UUID, SamplingProfile> profiles;
    private final DetectionEngine detectionEngine;
    private static final int CLEAN_CHECK_INTERVAL = 2;
    private static final int LOW_CHECK_INTERVAL = 2;
    private static final int MEDIUM_CHECK_INTERVAL = 1;
    private static final int HIGH_CHECK_INTERVAL = 1;
    private static final int CONFIRMED_CHECK_INTERVAL = 1;

    public AdaptiveSamplingSystem(DetectionEngine detectionEngine) {
        this.detectionEngine = detectionEngine;
        this.profiles = new ConcurrentHashMap<UUID, SamplingProfile>();
    }

    public boolean shouldCheck(Player player, ViolationType type) {
        UUID playerId = player.getUniqueId();
        SamplingProfile profile = this.profiles.computeIfAbsent(playerId, k -> new SamplingProfile());
        DetectionEngine.SuspicionLevel suspicion = this.detectionEngine.getSuspicionLevel(playerId);
        int checkInterval = this.getCheckInterval(suspicion);
        profile.incrementTotalTicks();
        if (profile.getTotalTicks() % checkInterval == 0) {
            profile.recordCheck(type);
            return true;
        }
        return (suspicion == DetectionEngine.SuspicionLevel.HIGH || suspicion == DetectionEngine.SuspicionLevel.CONFIRMED) && this.isHighPriorityCheck(type);
    }

    private int getCheckInterval(DetectionEngine.SuspicionLevel suspicion) {
        switch (suspicion) {
            case CONFIRMED: {
                return 1;
            }
            case HIGH: {
                return 1;
            }
            case MEDIUM: {
                return 1;
            }
            case LOW: {
                return 2;
            }
        }
        return 2;
    }

    private boolean isHighPriorityCheck(ViolationType type) {
        return type == ViolationType.FLY || type == ViolationType.KILLAURA || type == ViolationType.KILLAURA_MULTI || type == ViolationType.SPEED || type == ViolationType.REACH;
    }

    public CheckFrequency getCheckFrequency(UUID playerId) {
        DetectionEngine.SuspicionLevel suspicion = this.detectionEngine.getSuspicionLevel(playerId);
        int interval = this.getCheckInterval(suspicion);
        return new CheckFrequency(interval, suspicion);
    }

    public void cleanup(UUID playerId) {
        this.profiles.remove(playerId);
    }

    private static class SamplingProfile {
        private int totalTicks = 0;
        private final Map<ViolationType, Integer> checkCounts = new HashMap<ViolationType, Integer>();

        public void incrementTotalTicks() {
            ++this.totalTicks;
        }

        public int getTotalTicks() {
            return this.totalTicks;
        }

        public void recordCheck(ViolationType type) {
            this.checkCounts.put(type, this.checkCounts.getOrDefault((Object)type, 0) + 1);
        }
    }

    public static class CheckFrequency {
        public final int tickInterval;
        public final DetectionEngine.SuspicionLevel suspicionLevel;

        public CheckFrequency(int tickInterval, DetectionEngine.SuspicionLevel suspicionLevel) {
            this.tickInterval = tickInterval;
            this.suspicionLevel = suspicionLevel;
        }

        public double getFrequencyMultiplier() {
            return 20.0 / (double)this.tickInterval;
        }
    }
}

