/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.core;

import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AsyncCheckProcessor {
    private final Plugin plugin;
    private final ExecutorService executor;
    private final Map<UUID, Queue<CheckTask>> taskQueues;
    private final Set<UUID> processing;

    public AsyncCheckProcessor(Plugin plugin, int threadPoolSize) {
        this.plugin = plugin;
        int poolSize = threadPoolSize > 0 ? threadPoolSize : Math.max(2, Runtime.getRuntime().availableProcessors() / 2);
        this.executor = Executors.newFixedThreadPool(poolSize, r -> {
            Thread t = new Thread(r, "NoChance-AsyncCheck");
            t.setDaemon(true);
            return t;
        });
        this.taskQueues = new ConcurrentHashMap<UUID, Queue<CheckTask>>();
        this.processing = ConcurrentHashMap.newKeySet();
    }

    public <T> CompletableFuture<T> submitCheck(Player player, Callable<T> check, CheckPriority priority) {
        UUID uuid = player.getUniqueId();
        CheckTask task = new CheckTask(check, priority);
        Queue queue = this.taskQueues.computeIfAbsent(uuid, k -> new PriorityBlockingQueue());
        queue.offer(task);
        this.processQueue(uuid);
        return task.future;
    }

    private void processQueue(UUID uuid) {
        if (!this.processing.add(uuid)) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                Queue<CheckTask> queue = this.taskQueues.get(uuid);
                if (queue == null || queue.isEmpty()) {
                    return;
                }
                CheckTask task = queue.poll();
                if (task != null) {
                    try {
                        Object result = task.callable.call();
                        task.future.complete(result);
                    }
                    catch (Exception e) {
                        task.future.completeExceptionally(e);
                    }
                }
            }
            finally {
                this.processing.remove(uuid);
                Queue<CheckTask> queue = this.taskQueues.get(uuid);
                if (queue != null && !queue.isEmpty()) {
                    this.processQueue(uuid);
                }
            }
        }, this.executor);
    }

    public void cleanup(UUID uuid) {
        this.taskQueues.remove(uuid);
        this.processing.remove(uuid);
    }

    public void shutdown() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private static final class CheckTask
    implements Comparable<CheckTask> {
        private final Callable<?> callable;
        private final CheckPriority priority;
        private final CompletableFuture future;
        private final long timestamp;

        private CheckTask(Callable<?> callable, CheckPriority priority) {
            this.callable = callable;
            this.priority = priority;
            this.future = new CompletableFuture();
            this.timestamp = System.currentTimeMillis();
        }

        @Override
        public int compareTo(CheckTask other) {
            int priorityCompare = Integer.compare(this.priority.getValue(), other.priority.getValue());
            if (priorityCompare != 0) {
                return priorityCompare;
            }
            return Long.compare(this.timestamp, other.timestamp);
        }
    }

    public static enum CheckPriority {
        LOW(3),
        NORMAL(2),
        HIGH(1),
        CRITICAL(0);

        private final int value;

        private CheckPriority(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

