/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.core;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;

public class BoundedDeque<T>
implements Iterable<T> {
    private final Deque<T> deque;
    private final int maxSize;

    public BoundedDeque(int maxSize) {
        this.maxSize = maxSize;
        this.deque = new ArrayDeque<T>(maxSize);
    }

    public synchronized void add(T element) {
        if (this.deque.size() >= this.maxSize) {
            this.deque.poll();
        }
        this.deque.add(element);
    }

    public synchronized void addFirst(T element) {
        if (this.deque.size() >= this.maxSize) {
            this.deque.pollLast();
        }
        this.deque.addFirst(element);
    }

    public synchronized T poll() {
        return this.deque.poll();
    }

    public synchronized T pollLast() {
        return this.deque.pollLast();
    }

    public synchronized T peek() {
        return this.deque.peek();
    }

    public synchronized T peekLast() {
        return this.deque.peekLast();
    }

    public synchronized int size() {
        return this.deque.size();
    }

    public synchronized boolean isEmpty() {
        return this.deque.isEmpty();
    }

    public synchronized void clear() {
        this.deque.clear();
    }

    public synchronized Deque<T> getDeque() {
        return new ArrayDeque<T>(this.deque);
    }

    public synchronized List<T> toList() {
        return new ArrayList<T>(this.deque);
    }

    @Override
    public synchronized Iterator<T> iterator() {
        return new ArrayList<T>(this.deque).iterator();
    }

    public synchronized boolean contains(T element) {
        return this.deque.contains(element);
    }

    public synchronized T[] toArray(T[] array) {
        return this.deque.toArray(array);
    }
}

