/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.core;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class BreakProfile {
    private final Map<UUID, Profile> profiles = new ConcurrentHashMap<UUID, Profile>();
    private static final int MAX_BREAKS_PER_MATERIAL = 50;
    private static final int MAX_RECENT_BREAKS = 100;

    public Profile getProfile(UUID playerId) {
        return this.profiles.computeIfAbsent(playerId, k -> new Profile());
    }

    public void recordBreak(Player player, Block block, long breakTimeMs, boolean suspicious) {
        Profile profile = this.getProfile(player.getUniqueId());
        profile.recordBreak(block.getType(), breakTimeMs, suspicious);
    }

    public boolean isConsistentlyFast(UUID playerId) {
        Profile profile = this.profiles.get(playerId);
        if (profile == null || profile.totalBreaks < 20) {
            return false;
        }
        return profile.getSuspiciousRatio() > 0.7;
    }

    public void cleanup(UUID playerId) {
        this.profiles.remove(playerId);
    }

    public static class Profile {
        private final Map<Material, List<Long>> blockBreakTimes = new HashMap<Material, List<Long>>();
        private final Deque<BreakEvent> recentBreaks = new ArrayDeque<BreakEvent>(100);
        private double averageBreakSpeed = 0.0;
        private int totalBreaks = 0;
        private int suspiciousBreaks = 0;

        public void recordBreak(Material material, long timeMs, boolean suspicious) {
            List times = this.blockBreakTimes.computeIfAbsent(material, k -> new ArrayList());
            times.add(timeMs);
            if (times.size() > 50) {
                times.remove(0);
            }
            this.recentBreaks.addLast(new BreakEvent(material, timeMs, System.currentTimeMillis(), suspicious));
            if (this.recentBreaks.size() > 100) {
                this.recentBreaks.pollFirst();
            }
            ++this.totalBreaks;
            if (suspicious) {
                ++this.suspiciousBreaks;
            }
            this.updateAverageSpeed();
        }

        private void updateAverageSpeed() {
            if (this.recentBreaks.isEmpty()) {
                return;
            }
            long total = this.recentBreaks.stream().mapToLong(e -> e.breakTimeMs).sum();
            this.averageBreakSpeed = (double)total / (double)this.recentBreaks.size();
        }

        public double getAverageBreakTime(Material material) {
            List<Long> times = this.blockBreakTimes.get(material);
            if (times == null || times.isEmpty()) {
                return 0.0;
            }
            return times.stream().mapToLong(Long::longValue).average().orElse(0.0);
        }

        public double getSuspiciousRatio() {
            return this.totalBreaks > 0 ? (double)this.suspiciousBreaks / (double)this.totalBreaks : 0.0;
        }

        public boolean hasEstablishedBaseline(Material material) {
            List<Long> times = this.blockBreakTimes.get(material);
            return times != null && times.size() >= 10;
        }

        public double getBaselineDeviation(Material material, long currentTime) {
            if (!this.hasEstablishedBaseline(material)) {
                return 0.0;
            }
            List<Long> times = this.blockBreakTimes.get(material);
            double avg = times.stream().mapToLong(Long::longValue).average().orElse(0.0);
            return Math.abs((double)currentTime - avg);
        }

        public List<BreakEvent> getRecentBreaks(int count) {
            ArrayList<BreakEvent> result = new ArrayList<BreakEvent>();
            int size = this.recentBreaks.size();
            int start = Math.max(0, size - count);
            int index = 0;
            for (BreakEvent event : this.recentBreaks) {
                if (index >= start) {
                    result.add(event);
                }
                ++index;
            }
            return result;
        }

        public int getBreakStreak() {
            int streak = 0;
            ArrayList<BreakEvent> breakList = new ArrayList<BreakEvent>(this.recentBreaks);
            for (int i = breakList.size() - 1; i >= 0 && ((BreakEvent)breakList.get((int)i)).suspicious; --i) {
                ++streak;
            }
            return streak;
        }

        public boolean hasBaseline(Material material) {
            return this.hasEstablishedBaseline(material);
        }

        public double getBaselineTime(Material material) {
            return this.getAverageBreakTime(material);
        }

        public int getTotalBreaks() {
            return this.totalBreaks;
        }

        public int getSuspiciousBreaks() {
            return this.suspiciousBreaks;
        }
    }

    public static class BreakEvent {
        public final Material material;
        public final long breakTimeMs;
        public final long timestamp;
        public final boolean suspicious;

        public BreakEvent(Material material, long breakTimeMs, long timestamp, boolean suspicious) {
            this.material = material;
            this.breakTimeMs = breakTimeMs;
            this.timestamp = timestamp;
            this.suspicious = suspicious;
        }
    }
}

