/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.core;

import NC.noChance.core.ACConfig;
import NC.noChance.core.LayerFiltering;
import NC.noChance.core.PlayerData;
import NC.noChance.detection.block.FastBreakCheck;
import NC.noChance.detection.block.FastPlaceCheck;
import NC.noChance.detection.block.NukerCheck;
import NC.noChance.detection.block.ScaffoldCheck;
import NC.noChance.detection.combat.AutoClickerCheck;
import NC.noChance.detection.combat.KillAuraCheck;
import NC.noChance.detection.combat.ReachCheck;
import NC.noChance.detection.damage.CriticalsCheck;
import NC.noChance.detection.damage.NoFallCheck;
import NC.noChance.detection.damage.VelocityCheck;
import NC.noChance.detection.movement.BoatFlyCheck;
import NC.noChance.detection.movement.ElytraFlyCheck;
import NC.noChance.detection.movement.FlyCheck;
import NC.noChance.detection.movement.GroundSpoofCheck;
import NC.noChance.detection.movement.JesusCheck;
import NC.noChance.detection.movement.NoClipCheck;
import NC.noChance.detection.movement.PhaseCheck;
import NC.noChance.detection.movement.SpeedCheck;
import NC.noChance.detection.movement.StepCheck;
import NC.noChance.detection.movement.StriderCheck;
import NC.noChance.detection.movement.TimerCheck;
import NC.noChance.detection.player.BadPacketsCheck;
import NC.noChance.detection.player.BlinkCheck;
import NC.noChance.detection.player.InventoryCheck;
import NC.noChance.detection.player.NoSlowCheck;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class CheckRegistry {
    private final Map<String, Object> checks;
    private final ACConfig config;
    private final Map<UUID, PlayerData> playerDataMap;
    private final LayerFiltering filtering;
    private FlyCheck flyCheck;
    private SpeedCheck speedCheck;
    private NoClipCheck noClipCheck;
    private JesusCheck jesusCheck;
    private FastBreakCheck fastBreakCheck;
    private FastPlaceCheck fastPlaceCheck;
    private NukerCheck nukerCheck;
    private KillAuraCheck killAuraCheck;
    private NoFallCheck noFallCheck;
    private AutoClickerCheck autoClickerCheck;
    private ReachCheck reachCheck;
    private InventoryCheck inventoryCheck;
    private ScaffoldCheck scaffoldCheck;
    private TimerCheck timerCheck;
    private VelocityCheck velocityCheck;
    private CriticalsCheck criticalsCheck;
    private PhaseCheck phaseCheck;
    private StepCheck stepCheck;
    private BlinkCheck blinkCheck;
    private NoSlowCheck noSlowCheck;
    private BadPacketsCheck badPacketsCheck;
    private GroundSpoofCheck groundSpoofCheck;
    private ElytraFlyCheck elytraFlyCheck;
    private StriderCheck striderCheck;
    private BoatFlyCheck boatFlyCheck;

    public CheckRegistry(ACConfig config, Map<UUID, PlayerData> playerDataMap, LayerFiltering filtering) {
        this.config = config;
        this.playerDataMap = playerDataMap;
        this.filtering = filtering;
        this.checks = new HashMap<String, Object>();
        this.initializeChecks();
    }

    private void initializeChecks() {
        this.flyCheck = new FlyCheck(this.config, this.playerDataMap, this.filtering);
        this.speedCheck = new SpeedCheck(this.config, this.playerDataMap, this.filtering);
        this.noClipCheck = new NoClipCheck(this.config, this.playerDataMap, this.filtering);
        this.jesusCheck = new JesusCheck(this.config, this.playerDataMap, this.filtering);
        this.fastBreakCheck = new FastBreakCheck(this.config, this.playerDataMap, this.filtering);
        this.fastPlaceCheck = new FastPlaceCheck(this.config, this.playerDataMap, this.filtering);
        this.nukerCheck = new NukerCheck(this.config, this.playerDataMap, this.filtering);
        this.killAuraCheck = new KillAuraCheck(this.config, this.playerDataMap, this.filtering);
        this.noFallCheck = new NoFallCheck(this.config, this.playerDataMap, this.filtering);
        this.autoClickerCheck = new AutoClickerCheck(this.config, this.playerDataMap, this.filtering);
        this.reachCheck = new ReachCheck(this.config, this.playerDataMap, this.filtering);
        this.inventoryCheck = new InventoryCheck(this.config, this.playerDataMap, this.filtering);
        this.scaffoldCheck = new ScaffoldCheck(this.config, this.playerDataMap, this.filtering);
        this.timerCheck = new TimerCheck(this.config, this.playerDataMap, this.filtering);
        this.velocityCheck = new VelocityCheck(this.config, this.playerDataMap, this.filtering);
        this.criticalsCheck = new CriticalsCheck(this.config, this.playerDataMap, this.filtering);
        this.phaseCheck = new PhaseCheck(this.config, this.playerDataMap, this.filtering);
        this.stepCheck = new StepCheck(this.config, this.playerDataMap, this.filtering);
        this.blinkCheck = new BlinkCheck(this.config, this.playerDataMap, this.filtering);
        this.noSlowCheck = new NoSlowCheck(this.config, this.playerDataMap, this.filtering);
        this.badPacketsCheck = new BadPacketsCheck(this.config, this.playerDataMap, this.filtering);
        this.groundSpoofCheck = new GroundSpoofCheck(this.config, this.playerDataMap, this.filtering);
        this.elytraFlyCheck = new ElytraFlyCheck(this.config, this.playerDataMap, this.filtering);
        this.striderCheck = new StriderCheck(this.config, this.playerDataMap, this.filtering);
        this.boatFlyCheck = new BoatFlyCheck(this.config, this.playerDataMap, this.filtering);
        this.registerCheck("fly", this.flyCheck);
        this.registerCheck("speed", this.speedCheck);
        this.registerCheck("noclip", this.noClipCheck);
        this.registerCheck("jesus", this.jesusCheck);
        this.registerCheck("fastbreak", this.fastBreakCheck);
        this.registerCheck("fastplace", this.fastPlaceCheck);
        this.registerCheck("nuker", this.nukerCheck);
        this.registerCheck("killaura", this.killAuraCheck);
        this.registerCheck("nofall", this.noFallCheck);
        this.registerCheck("autoclicker", this.autoClickerCheck);
        this.registerCheck("reach", this.reachCheck);
        this.registerCheck("inventory", this.inventoryCheck);
        this.registerCheck("scaffold", this.scaffoldCheck);
        this.registerCheck("timer", this.timerCheck);
        this.registerCheck("velocity", this.velocityCheck);
        this.registerCheck("criticals", this.criticalsCheck);
        this.registerCheck("phase", this.phaseCheck);
        this.registerCheck("step", this.stepCheck);
        this.registerCheck("blink", this.blinkCheck);
        this.registerCheck("noslow", this.noSlowCheck);
        this.registerCheck("badpackets", this.badPacketsCheck);
        this.registerCheck("groundspoof", this.groundSpoofCheck);
        this.registerCheck("elytrafly", this.elytraFlyCheck);
        this.registerCheck("strider", this.striderCheck);
        this.registerCheck("boatfly", this.boatFlyCheck);
    }

    private void registerCheck(String name, Object check) {
        this.checks.put(name.toLowerCase(), check);
    }

    public <T> T getCheck(String name) {
        return (T)this.checks.get(name.toLowerCase());
    }

    public int getCheckCount() {
        return this.checks.size();
    }

    public void cleanupPlayer(UUID playerId) {
        this.flyCheck.cleanup(playerId);
        this.speedCheck.cleanup(playerId);
        this.noClipCheck.cleanup(playerId);
        this.jesusCheck.cleanup(playerId);
        this.fastBreakCheck.cleanup(playerId);
        this.fastPlaceCheck.cleanup(playerId);
        this.nukerCheck.cleanup(playerId);
        this.killAuraCheck.cleanup(playerId);
        this.noFallCheck.cleanup(playerId);
        this.autoClickerCheck.cleanup(playerId);
        this.reachCheck.cleanup(playerId);
        this.inventoryCheck.cleanup(playerId);
        this.scaffoldCheck.cleanup(playerId);
        this.timerCheck.cleanup(playerId);
        this.velocityCheck.cleanup(playerId);
        this.criticalsCheck.cleanup(playerId);
        this.phaseCheck.cleanup(playerId);
        this.stepCheck.cleanup(playerId);
        this.blinkCheck.cleanup(playerId);
        this.noSlowCheck.cleanup(playerId);
        this.badPacketsCheck.cleanup(playerId);
        this.groundSpoofCheck.cleanup(playerId);
        this.elytraFlyCheck.cleanup(playerId);
        this.striderCheck.cleanup(playerId);
        this.boatFlyCheck.cleanup(playerId);
    }

    public void cleanupStale() {
        this.killAuraCheck.cleanupStale();
        this.fastBreakCheck.cleanupStale();
        this.speedCheck.cleanupStale();
        this.blinkCheck.cleanupStale();
        this.flyCheck.cleanupStale();
        this.noSlowCheck.cleanupStale();
        this.badPacketsCheck.cleanupStale();
        this.groundSpoofCheck.cleanupStale();
        this.elytraFlyCheck.cleanupStale();
        this.striderCheck.cleanupStale();
        this.boatFlyCheck.cleanupStale();
    }

    public FlyCheck getFlyCheck() {
        return this.flyCheck;
    }

    public SpeedCheck getSpeedCheck() {
        return this.speedCheck;
    }

    public NoClipCheck getNoClipCheck() {
        return this.noClipCheck;
    }

    public JesusCheck getJesusCheck() {
        return this.jesusCheck;
    }

    public FastBreakCheck getFastBreakCheck() {
        return this.fastBreakCheck;
    }

    public FastPlaceCheck getFastPlaceCheck() {
        return this.fastPlaceCheck;
    }

    public NukerCheck getNukerCheck() {
        return this.nukerCheck;
    }

    public KillAuraCheck getKillAuraCheck() {
        return this.killAuraCheck;
    }

    public NoFallCheck getNoFallCheck() {
        return this.noFallCheck;
    }

    public AutoClickerCheck getAutoClickerCheck() {
        return this.autoClickerCheck;
    }

    public ReachCheck getReachCheck() {
        return this.reachCheck;
    }

    public InventoryCheck getInventoryCheck() {
        return this.inventoryCheck;
    }

    public ScaffoldCheck getScaffoldCheck() {
        return this.scaffoldCheck;
    }

    public TimerCheck getTimerCheck() {
        return this.timerCheck;
    }

    public VelocityCheck getVelocityCheck() {
        return this.velocityCheck;
    }

    public CriticalsCheck getCriticalsCheck() {
        return this.criticalsCheck;
    }

    public PhaseCheck getPhaseCheck() {
        return this.phaseCheck;
    }

    public StepCheck getStepCheck() {
        return this.stepCheck;
    }

    public BlinkCheck getBlinkCheck() {
        return this.blinkCheck;
    }

    public NoSlowCheck getNoSlowCheck() {
        return this.noSlowCheck;
    }

    public BadPacketsCheck getBadPacketsCheck() {
        return this.badPacketsCheck;
    }

    public GroundSpoofCheck getGroundSpoofCheck() {
        return this.groundSpoofCheck;
    }

    public ElytraFlyCheck getElytraFlyCheck() {
        return this.elytraFlyCheck;
    }

    public StriderCheck getStriderCheck() {
        return this.striderCheck;
    }

    public BoatFlyCheck getBoatFlyCheck() {
        return this.boatFlyCheck;
    }
}

