/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.core;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class CombatTracker {
    private final Map<UUID, CombatContext> contexts = new ConcurrentHashMap<UUID, CombatContext>();

    public CombatContext getContext(UUID playerId) {
        return this.contexts.computeIfAbsent(playerId, k -> new CombatContext());
    }

    public void recordPlayerHit(Player attacker, Entity victim, double damage) {
        CombatContext context = this.getContext(attacker.getUniqueId());
        context.recordHit(victim.getUniqueId(), damage);
    }

    public void recordPlayerDamaged(Player victim, Entity attacker, double damage) {
        CombatContext context = this.getContext(victim.getUniqueId());
        context.recordDamage(attacker.getUniqueId(), damage);
    }

    public boolean isInCombat(UUID playerId) {
        CombatContext context = this.contexts.get(playerId);
        return context != null && context.isInCombat();
    }

    public void tick() {
        for (CombatContext context : this.contexts.values()) {
            context.tick();
        }
    }

    public void cleanup(UUID playerId) {
        this.contexts.remove(playerId);
    }

    public static class CombatContext {
        private long lastHitTime = 0L;
        private long lastDamagedTime = 0L;
        private UUID lastAttacker;
        private UUID lastVictim;
        private final Deque<CombatEvent> recentCombat = new ArrayDeque<CombatEvent>(20);
        private boolean inCombat = false;
        private int combatTicks = 0;

        public void recordHit(UUID victim, double damage) {
            long now;
            this.lastHitTime = now = System.currentTimeMillis();
            this.lastVictim = victim;
            this.inCombat = true;
            this.combatTicks = 100;
            this.recentCombat.addLast(new CombatEvent(CombatEvent.Type.HIT, victim, damage, now));
            if (this.recentCombat.size() > 20) {
                this.recentCombat.pollFirst();
            }
        }

        public void recordDamage(UUID attacker, double damage) {
            long now;
            this.lastDamagedTime = now = System.currentTimeMillis();
            this.lastAttacker = attacker;
            this.inCombat = true;
            this.combatTicks = 100;
            this.recentCombat.addLast(new CombatEvent(CombatEvent.Type.DAMAGED, attacker, damage, now));
            if (this.recentCombat.size() > 20) {
                this.recentCombat.pollFirst();
            }
        }

        public void tick() {
            if (this.combatTicks > 0) {
                --this.combatTicks;
            } else {
                this.inCombat = false;
            }
        }

        public boolean isInCombat() {
            return this.inCombat;
        }

        public long getTimeSinceLastHit() {
            return this.lastHitTime > 0L ? System.currentTimeMillis() - this.lastHitTime : Long.MAX_VALUE;
        }

        public long getTimeSinceLastDamage() {
            return this.lastDamagedTime > 0L ? System.currentTimeMillis() - this.lastDamagedTime : Long.MAX_VALUE;
        }

        public double getRecentCPS() {
            long now = System.currentTimeMillis();
            long cutoff = now - 1000L;
            long recentHits = this.recentCombat.stream().filter(e -> e.type == CombatEvent.Type.HIT && e.timestamp > cutoff).count();
            return recentHits;
        }

        public List<CombatEvent> getRecentEvents(long windowMs) {
            long cutoff = System.currentTimeMillis() - windowMs;
            ArrayList<CombatEvent> result = new ArrayList<CombatEvent>();
            for (CombatEvent event : this.recentCombat) {
                if (event.timestamp <= cutoff) continue;
                result.add(event);
            }
            return result;
        }
    }

    public static class CombatEvent {
        public final Type type;
        public final UUID entityId;
        public final double damage;
        public final long timestamp;

        public CombatEvent(Type type, UUID entityId, double damage, long timestamp) {
            this.type = type;
            this.entityId = entityId;
            this.damage = damage;
            this.timestamp = timestamp;
        }

        public static enum Type {
            HIT,
            DAMAGED;

        }
    }
}

