/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.core;

import NC.noChance.core.EnchantHelper;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class EnhancementTracker {
    public static MovementEnhancements calculateMovementEnhancements(Player player) {
        PotionEffect slowness;
        PotionEffectType slownessType;
        ItemStack boots;
        Block below;
        Material belowType;
        PotionEffect dolphinsGrace;
        PotionEffectType dolphinsGraceType;
        PotionEffect speedEffect;
        PotionEffectType speedType;
        MovementEnhancements enhancements = new MovementEnhancements();
        StringBuilder reasons = new StringBuilder();
        if (player.isFlying() && player.getAllowFlight()) {
            enhancements.hasLegitFlight = true;
            reasons.append("Creative/Spectator Flight, ");
        }
        if (player.isGliding()) {
            enhancements.speedMultiplier *= 3.5;
            enhancements.hasLegitFlight = true;
            reasons.append("Elytra, ");
        }
        if (player.isRiptiding()) {
            enhancements.speedMultiplier *= 4.0;
            reasons.append("Riptide, ");
        }
        if (player.isSprinting()) {
            enhancements.speedMultiplier *= 1.3;
            reasons.append("Sprinting, ");
        }
        if ((speedType = PotionEffectType.getByName((String)"SPEED")) != null && (speedEffect = player.getPotionEffect(speedType)) != null) {
            int amplifier = speedEffect.getAmplifier() + 1;
            enhancements.speedMultiplier *= 1.0 + (double)amplifier * 0.2;
            reasons.append("Speed ").append(amplifier).append(", ");
        }
        if ((dolphinsGraceType = PotionEffectType.getByName((String)"DOLPHINS_GRACE")) != null && (dolphinsGrace = player.getPotionEffect(dolphinsGraceType)) != null && (player.isSwimming() || player.isInWater())) {
            enhancements.speedMultiplier *= 1.5;
            enhancements.inWater = true;
            reasons.append("Dolphin's Grace, ");
        }
        if (player.isSwimming() || player.isInWater()) {
            int depthStrider;
            Enchantment depthStriderEnch;
            enhancements.inWater = true;
            ItemStack boots2 = player.getInventory().getBoots();
            if (boots2 != null && (depthStriderEnch = Enchantment.getByName((String)"DEPTH_STRIDER")) != null && (depthStrider = boots2.getEnchantmentLevel(depthStriderEnch)) > 0) {
                enhancements.speedMultiplier *= 1.0 + (double)depthStrider * 0.15;
                reasons.append("Depth Strider ").append(depthStrider).append(", ");
            }
        }
        if ((belowType = (below = player.getLocation().clone().subtract(0.0, 0.5, 0.0).getBlock()).getType()) == Material.ICE || belowType == Material.PACKED_ICE) {
            enhancements.speedMultiplier *= 2.0;
            enhancements.onIce = true;
            reasons.append("Ice, ");
        } else if (belowType == Material.BLUE_ICE) {
            enhancements.speedMultiplier *= 2.5;
            enhancements.onIce = true;
            reasons.append("Blue Ice, ");
        }
        if ((belowType == Material.SOUL_SAND || belowType == Material.SOUL_SOIL) && (boots = player.getInventory().getBoots()) != null) {
            Enchantment soulSpeedEnch = Enchantment.getByName((String)"SOUL_SPEED");
            int soulSpeed = 0;
            if (soulSpeedEnch != null) {
                soulSpeed = boots.getEnchantmentLevel(soulSpeedEnch);
            }
            if (soulSpeed > 0) {
                enhancements.speedMultiplier *= 1.0 + (double)soulSpeed * 0.25;
                reasons.append("Soul Speed ").append(soulSpeed).append(", ");
            } else {
                enhancements.speedMultiplier *= 0.4;
                reasons.append("Soul Sand Slow, ");
            }
        }
        if ((slownessType = PotionEffectType.getByName((String)"SLOWNESS")) == null) {
            slownessType = PotionEffectType.getByName((String)"SLOW");
        }
        if (slownessType != null && (slowness = player.getPotionEffect(slownessType)) != null) {
            int amplifier = slowness.getAmplifier() + 1;
            enhancements.speedMultiplier *= 1.0 - (double)amplifier * 0.15;
            reasons.append("Slowness ").append(amplifier).append(", ");
        }
        if (player.getVehicle() != null) {
            enhancements.speedMultiplier *= 2.5;
            reasons.append("Vehicle, ");
        }
        enhancements.reason = reasons.length() > 0 ? reasons.substring(0, reasons.length() - 2) : "None";
        return enhancements;
    }

    public static BlockBreakEnhancements calculateBlockBreakEnhancements(Player player, Block block) {
        ItemStack currentTool = player.getInventory().getItemInMainHand();
        String toolName = currentTool != null && currentTool.getType() != Material.AIR ? currentTool.getType().name() : "HAND";
        int efficiency = currentTool != null && currentTool.getType() != Material.AIR ? EnchantHelper.getEfficiencyLevel(currentTool) : 0;
        return EnhancementTracker.calculateBlockBreakEnhancements(player, block, toolName, efficiency);
    }

    public static BlockBreakEnhancements calculateBlockBreakEnhancements(Player player, Block block, String initialToolName, int initialEfficiency) {
        PotionEffect fatigue;
        PotionEffectType fatigueType;
        PotionEffect haste;
        BlockBreakEnhancements enhancements = new BlockBreakEnhancements();
        StringBuilder reasons = new StringBuilder();
        if (player.getGameMode() == GameMode.CREATIVE) {
            enhancements.canInstamine = true;
            enhancements.reason = "Creative Mode";
            return enhancements;
        }
        PotionEffectType hasteType = PotionEffectType.getByName((String)"HASTE");
        if (hasteType == null) {
            hasteType = PotionEffectType.getByName((String)"FAST_DIGGING");
        }
        if (hasteType != null && (haste = player.getPotionEffect(hasteType)) != null) {
            enhancements.hasteLevel = haste.getAmplifier() + 1;
            reasons.append("Haste ").append(enhancements.hasteLevel).append(", ");
        }
        if ((fatigueType = PotionEffectType.getByName((String)"MINING_FATIGUE")) == null) {
            fatigueType = PotionEffectType.getByName((String)"SLOW_DIGGING");
        }
        if (fatigueType != null && (fatigue = player.getPotionEffect(fatigueType)) != null) {
            int level = Math.min(fatigue.getAmplifier() + 1, 4);
            enhancements.breakSpeedMultiplier *= Math.pow(0.3, level);
            reasons.append("Mining Fatigue ").append(level).append(", ");
        }
        ItemStack tool = null;
        String toolName = initialToolName;
        if (toolName != null && !toolName.equals("HAND")) {
            try {
                Material toolMat = Material.valueOf((String)toolName);
                tool = new ItemStack(toolMat);
                ItemStack actualTool = player.getInventory().getItemInMainHand();
                if (actualTool != null && actualTool.getType() == toolMat) {
                    tool = actualTool;
                }
            }
            catch (IllegalArgumentException e) {
                tool = null;
            }
        }
        if (tool != null && tool.getType() != Material.AIR) {
            double toolSpeed;
            enhancements.efficiencyLevel = initialEfficiency > 0 ? initialEfficiency : EnchantHelper.getEfficiencyLevel(tool);
            toolName = tool.getType().name().toUpperCase();
            Material blockType = block.getType();
            if (toolName.contains("PICKAXE")) {
                enhancements.toolType = "PICKAXE";
                if (EnhancementTracker.isStone(blockType) || EnhancementTracker.isOre(blockType) || EnhancementTracker.isMetal(blockType) || EnhancementTracker.isRedstone(blockType)) {
                    enhancements.hasCorrectTool = true;
                }
                enhancements.toolMaterial = EnhancementTracker.extractToolMaterial(toolName);
            } else if (toolName.contains("AXE") && !toolName.contains("PICKAXE")) {
                enhancements.toolType = "AXE";
                if (EnhancementTracker.isWood(blockType)) {
                    enhancements.hasCorrectTool = true;
                }
                enhancements.toolMaterial = EnhancementTracker.extractToolMaterial(toolName);
            } else if (toolName.contains("SHOVEL") || toolName.contains("SPADE")) {
                enhancements.toolType = "SHOVEL";
                if (EnhancementTracker.isDirt(blockType) || EnhancementTracker.isSand(blockType) || EnhancementTracker.isSnow(blockType)) {
                    enhancements.hasCorrectTool = true;
                }
                enhancements.toolMaterial = EnhancementTracker.extractToolMaterial(toolName);
            } else if (toolName.contains("HOE")) {
                enhancements.toolType = "HOE";
                if (EnhancementTracker.isPlant(blockType) || EnhancementTracker.isCrop(blockType)) {
                    enhancements.hasCorrectTool = true;
                }
                enhancements.toolMaterial = EnhancementTracker.extractToolMaterial(toolName);
            } else if (toolName.contains("SWORD")) {
                enhancements.toolType = "SWORD";
                if (EnhancementTracker.isPlant(blockType) || blockType == Material.COBWEB) {
                    enhancements.hasCorrectTool = true;
                }
                enhancements.toolMaterial = EnhancementTracker.extractToolMaterial(toolName);
            } else if (toolName.contains("SHEARS")) {
                enhancements.toolType = "SHEARS";
                if (EnhancementTracker.isWool(blockType) || EnhancementTracker.isLeaves(blockType) || blockType == Material.COBWEB) {
                    enhancements.hasCorrectTool = true;
                }
                enhancements.toolMaterial = "HAND";
            }
            if (enhancements.hasCorrectTool) {
                reasons.append(enhancements.toolMaterial).append(" Tool, ");
            }
            if (enhancements.efficiencyLevel > 0) {
                reasons.append("Efficiency ").append(enhancements.efficiencyLevel).append(", ");
            }
            if ((toolSpeed = enhancements.getBreakSpeedMultiplier()) >= 30.0) {
                enhancements.canInstamine = true;
                reasons.append("Instamine Capable, ");
            }
        }
        if (player.isInWater() && !EnhancementTracker.hasAquaAffinity(player)) {
            enhancements.breakSpeedMultiplier *= 0.2;
            reasons.append("Underwater Penalty, ");
        }
        if (!player.isOnGround() && !player.isFlying()) {
            enhancements.breakSpeedMultiplier *= 0.2;
            reasons.append("Midair Penalty, ");
        }
        enhancements.reason = reasons.length() > 0 ? reasons.substring(0, reasons.length() - 2) : "None";
        return enhancements;
    }

    public static CombatEnhancements calculateCombatEnhancements(Player player) {
        PotionEffect strength;
        PotionEffectType strengthType;
        CombatEnhancements enhancements = new CombatEnhancements();
        StringBuilder reasons = new StringBuilder();
        ItemStack weapon = player.getInventory().getItemInMainHand();
        if (weapon != null && weapon.getType() != Material.AIR) {
            int bane;
            int smite;
            enhancements.sharpnessLevel = EnchantHelper.getSharpnessLevel(weapon);
            if (enhancements.sharpnessLevel > 0) {
                reasons.append("Sharpness ").append(enhancements.sharpnessLevel).append(", ");
            }
            if ((smite = EnchantHelper.getSmiteLevel(weapon)) > 0) {
                reasons.append("Smite ").append(smite).append(", ");
            }
            if ((bane = EnchantHelper.getBaneLevel(weapon)) > 0) {
                reasons.append("Bane ").append(bane).append(", ");
            }
        }
        if ((strengthType = PotionEffectType.getByName((String)"STRENGTH")) == null) {
            strengthType = PotionEffectType.getByName((String)"INCREASE_DAMAGE");
        }
        if (strengthType != null && (strength = player.getPotionEffect(strengthType)) != null) {
            enhancements.strengthLevel = strength.getAmplifier() + 1;
            reasons.append("Strength ").append(enhancements.strengthLevel).append(", ");
        }
        if (player.getFallDistance() > 0.0f && !player.isOnGround()) {
            enhancements.criticalHit = true;
            reasons.append("Critical Hit, ");
        }
        enhancements.reason = reasons.length() > 0 ? reasons.substring(0, reasons.length() - 2) : "None";
        return enhancements;
    }

    private static String extractToolMaterial(String toolName) {
        if (toolName.contains("NETHERITE")) {
            return "NETHERITE";
        }
        if (toolName.contains("DIAMOND")) {
            return "DIAMOND";
        }
        if (toolName.contains("GOLDEN")) {
            return "GOLDEN";
        }
        if (toolName.contains("IRON")) {
            return "IRON";
        }
        if (toolName.contains("STONE")) {
            return "STONE";
        }
        if (toolName.contains("WOODEN") || toolName.contains("WOOD")) {
            return "WOOD";
        }
        return "HAND";
    }

    private static boolean isStone(Material type) {
        String name = type.name();
        return name.contains("STONE") || name.contains("COBBLESTONE") || name.contains("ANDESITE") || name.contains("DIORITE") || name.contains("GRANITE") || name.contains("NETHERRACK") || name.contains("BASALT") || name.contains("BLACKSTONE") || name.contains("TERRACOTTA") || name.contains("BRICKS") || name.contains("PRISMARINE") || name.contains("SANDSTONE") || name.contains("DEEPSLATE") || type == Material.END_STONE || type == Material.OBSIDIAN || type == Material.CRYING_OBSIDIAN;
    }

    private static boolean isOre(Material type) {
        String name = type.name();
        return name.contains("_ORE") || type == Material.ANCIENT_DEBRIS || type == Material.GILDED_BLACKSTONE;
    }

    private static boolean isMetal(Material type) {
        String name = type.name();
        return name.contains("IRON_BLOCK") || name.contains("GOLD_BLOCK") || name.contains("DIAMOND_BLOCK") || name.contains("EMERALD_BLOCK") || name.contains("NETHERITE_BLOCK") || name.contains("COPPER_BLOCK") || name.contains("COPPER") || name.contains("HOPPER") || name.contains("ANVIL") || name.contains("CHAIN");
    }

    private static boolean isRedstone(Material type) {
        String name = type.name();
        return name.contains("REDSTONE") || type == Material.OBSERVER || type == Material.DISPENSER || type == Material.DROPPER || type == Material.HOPPER || type == Material.PISTON || type == Material.STICKY_PISTON;
    }

    private static boolean isWood(Material type) {
        String name = type.name();
        return name.contains("LOG") || name.contains("WOOD") && !name.contains("SWORD") || name.contains("PLANKS") || type == Material.CRAFTING_TABLE || name.contains("CHEST") || name.contains("BARREL") || name.contains("BOOKSHELF") || name.contains("LECTERN") || name.contains("CAMPFIRE") || name.contains("FENCE") && !name.contains("NETHER") || name.contains("STAIRS") && name.contains("OAK") || name.contains("STAIRS") && name.contains("SPRUCE") || name.contains("STAIRS") && name.contains("BIRCH") || name.contains("STAIRS") && name.contains("JUNGLE") || name.contains("STAIRS") && name.contains("ACACIA") || name.contains("STAIRS") && name.contains("DARK_OAK") || name.contains("STAIRS") && name.contains("MANGROVE") || name.contains("STAIRS") && name.contains("CHERRY") || name.contains("STAIRS") && name.contains("BAMBOO") || name.contains("_STEM") || name.contains("HYPHAE") || name.contains("MUSHROOM_BLOCK");
    }

    private static boolean isDirt(Material type) {
        String name = type.name();
        return name.contains("DIRT") || type == Material.GRASS_BLOCK || type == Material.MYCELIUM || type == Material.PODZOL || type == Material.CLAY || name.contains("FARMLAND") || type == Material.ROOTED_DIRT || type == Material.COARSE_DIRT || type == Material.MUD || name.contains("MUDDY");
    }

    private static boolean isSand(Material type) {
        String name = type.name();
        return name.contains("SAND") || name.contains("GRAVEL") || name.contains("CONCRETE_POWDER") || type == Material.SOUL_SAND || type == Material.SOUL_SOIL;
    }

    private static boolean isSnow(Material type) {
        return type == Material.SNOW || type == Material.SNOW_BLOCK || type == Material.POWDER_SNOW;
    }

    private static boolean isPlant(Material type) {
        String name = type.name();
        return name.contains("LEAVES") || name.contains("SAPLING") || name.contains("FLOWER") || name.contains("GRASS") && !name.contains("_BLOCK") || name.contains("FERN") || name.contains("VINE") || name.contains("KELP") || name.contains("SEAGRASS") || type == Material.SUGAR_CANE || type == Material.BAMBOO || type == Material.CACTUS || name.contains("FUNGUS") || name.contains("ROOTS") || type == Material.LILY_PAD || type == Material.MOSS_CARPET || type == Material.MOSS_BLOCK || name.contains("CORAL") && !name.contains("_BLOCK");
    }

    private static boolean isCrop(Material type) {
        String name = type.name();
        return type == Material.WHEAT || type == Material.CARROTS || type == Material.POTATOES || type == Material.BEETROOTS || type == Material.NETHER_WART || type == Material.COCOA || type == Material.SWEET_BERRY_BUSH || type == Material.PUMPKIN || type == Material.MELON || name.contains("STEM");
    }

    private static boolean isWool(Material type) {
        String name = type.name();
        return name.contains("WOOL") || name.contains("CARPET");
    }

    private static boolean isLeaves(Material type) {
        return type.name().contains("LEAVES");
    }

    private static boolean hasAquaAffinity(Player player) {
        return EnchantHelper.hasAquaAffinity(player);
    }

    public static class MovementEnhancements {
        public double speedMultiplier = 1.0;
        public double baseSpeed = 0.35;
        public boolean hasLegitFlight = false;
        public boolean inWater = false;
        public boolean onIce = false;
        public String reason = "";

        public double getMaxSpeed() {
            return this.baseSpeed * this.speedMultiplier;
        }
    }

    public static class BlockBreakEnhancements {
        public double breakSpeedMultiplier = 1.0;
        public int efficiencyLevel = 0;
        public int hasteLevel = 0;
        public boolean hasCorrectTool = false;
        public String toolMaterial = "HAND";
        public String toolType = "HAND";
        public boolean canInstamine = false;
        public String reason = "";

        public double getBreakSpeedMultiplier() {
            double speedMultiplier = 1.0;
            if (this.hasCorrectTool) {
                switch (this.toolMaterial) {
                    case "NETHERITE": {
                        speedMultiplier = 9.0;
                        break;
                    }
                    case "DIAMOND": {
                        speedMultiplier = 8.0;
                        break;
                    }
                    case "GOLDEN": {
                        speedMultiplier = 12.0;
                        break;
                    }
                    case "IRON": {
                        speedMultiplier = 6.0;
                        break;
                    }
                    case "STONE": {
                        speedMultiplier = 4.0;
                        break;
                    }
                    case "WOOD": {
                        speedMultiplier = 2.0;
                    }
                }
            } else {
                speedMultiplier = 1.0;
            }
            if (this.efficiencyLevel > 0) {
                speedMultiplier += (double)(this.efficiencyLevel * this.efficiencyLevel) + 1.0;
            }
            if (this.hasteLevel > 0) {
                speedMultiplier *= 0.2 * (double)this.hasteLevel + 1.0;
            }
            return speedMultiplier;
        }
    }

    public static class CombatEnhancements {
        public double damageMultiplier = 1.0;
        public double reachBonus = 0.0;
        public int sharpnessLevel = 0;
        public int strengthLevel = 0;
        public boolean criticalHit = false;
        public String reason = "";

        public double getDamageMultiplier() {
            double multiplier = this.damageMultiplier;
            if (this.sharpnessLevel > 0) {
                multiplier *= 1.0 + (double)this.sharpnessLevel * 0.125;
            }
            if (this.strengthLevel > 0) {
                multiplier *= 1.0 + (double)this.strengthLevel * 0.3;
            }
            if (this.criticalHit) {
                multiplier *= 1.5;
            }
            return multiplier;
        }
    }
}

