/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.core;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class EnvironmentHelper {
    public static EnvironmentalFactors calculate(Player player) {
        EnvironmentalFactors factors = new EnvironmentalFactors();
        StringBuilder details = new StringBuilder();
        EnvironmentHelper.applyPotionEffects(player, factors, details);
        EnvironmentHelper.applyBlockEffects(player, factors, details);
        EnvironmentHelper.applyBeaconEffects(player, factors, details);
        EnvironmentHelper.applyConduitEffects(player, factors, details);
        factors.details = details.length() > 0 ? details.substring(0, Math.min(details.length(), 200)) : "None";
        return factors;
    }

    private static void applyPotionEffects(Player player, EnvironmentalFactors factors, StringBuilder details) {
        try {
            PotionEffect weakness;
            PotionEffectType weaknessType;
            PotionEffect strength;
            PotionEffectType strengthType;
            PotionEffect slowFalling;
            PotionEffectType slowFallingType;
            PotionEffect levitation;
            PotionEffectType levitationType;
            PotionEffect jumpBoost;
            PotionEffectType jumpType;
            PotionEffect slowness;
            PotionEffectType slownessType;
            PotionEffect speed;
            PotionEffectType speedType = EnvironmentHelper.getEffectType("SPEED");
            if (speedType != null && (speed = player.getPotionEffect(speedType)) != null) {
                int level = speed.getAmplifier() + 1;
                factors.speedMultiplier *= 1.0 + (double)level * 0.2;
                details.append("Speed ").append(level).append(", ");
                factors.hasStatusEffects = true;
            }
            if ((slownessType = EnvironmentHelper.getEffectType("SLOW", "SLOWNESS")) != null && (slowness = player.getPotionEffect(slownessType)) != null) {
                int level = slowness.getAmplifier() + 1;
                factors.speedMultiplier *= 1.0 - (double)level * 0.15;
                details.append("Slowness ").append(level).append(", ");
                factors.hasStatusEffects = true;
            }
            if ((jumpType = EnvironmentHelper.getEffectType("JUMP", "JUMP_BOOST")) != null && (jumpBoost = player.getPotionEffect(jumpType)) != null) {
                int level = jumpBoost.getAmplifier() + 1;
                factors.gravityMultiplier *= 1.0 + (double)level * 0.1;
                details.append("Jump Boost ").append(level).append(", ");
                factors.hasStatusEffects = true;
            }
            if ((levitationType = EnvironmentHelper.getEffectType("LEVITATION")) != null && (levitation = player.getPotionEffect(levitationType)) != null) {
                int level = levitation.getAmplifier() + 1;
                factors.gravityMultiplier *= 1.0 + (double)level * 0.3;
                details.append("Levitation ").append(level).append(", ");
                factors.hasStatusEffects = true;
            }
            if ((slowFallingType = EnvironmentHelper.getEffectType("SLOW_FALLING")) != null && (slowFalling = player.getPotionEffect(slowFallingType)) != null) {
                factors.gravityMultiplier *= 0.1;
                details.append("Slow Falling, ");
                factors.hasStatusEffects = true;
            }
            if ((strengthType = EnvironmentHelper.getEffectType("INCREASE_DAMAGE", "STRENGTH")) != null && (strength = player.getPotionEffect(strengthType)) != null) {
                int level = strength.getAmplifier() + 1;
                factors.damageMultiplier *= 1.0 + (double)level * 0.3;
                details.append("Strength ").append(level).append(", ");
                factors.hasStatusEffects = true;
            }
            if ((weaknessType = EnvironmentHelper.getEffectType("WEAKNESS")) != null && (weakness = player.getPotionEffect(weaknessType)) != null) {
                int level = weakness.getAmplifier() + 1;
                factors.damageMultiplier *= 1.0 - (double)level * 0.2;
                details.append("Weakness ").append(level).append(", ");
                factors.hasStatusEffects = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void applyBlockEffects(Player player, EnvironmentalFactors factors, StringBuilder details) {
        try {
            Block blockAt;
            Material atType;
            Block blockBelow = player.getLocation().clone().subtract(0.0, 0.5, 0.0).getBlock();
            Material belowType = blockBelow.getType();
            if (belowType == Material.ICE || belowType == Material.PACKED_ICE || belowType == Material.BLUE_ICE) {
                factors.speedMultiplier *= 1.8;
                factors.onSlipperyBlock = true;
                details.append("Ice, ");
            }
            if (belowType == Material.SLIME_BLOCK) {
                factors.gravityMultiplier *= 2.0;
                details.append("Slime Block, ");
            }
            if (belowType == Material.HONEY_BLOCK) {
                factors.speedMultiplier *= 0.4;
                factors.gravityMultiplier *= 0.5;
                details.append("Honey Block, ");
            }
            if ((atType = (blockAt = player.getLocation().getBlock()).getType()) == Material.COBWEB) {
                factors.speedMultiplier *= 0.15;
                factors.gravityMultiplier *= 0.1;
                details.append("Cobweb, ");
            }
            if (!(atType != Material.SOUL_SAND && atType != Material.SOUL_SOIL || EnvironmentHelper.hasSoulSpeed(player))) {
                factors.speedMultiplier *= 0.4;
                details.append("Soul Sand, ");
            }
            if (atType == Material.POWDER_SNOW) {
                factors.speedMultiplier *= 0.7;
                details.append("Powder Snow, ");
            }
            if (atType.name().contains("LAVA") || atType == Material.LAVA) {
                factors.speedMultiplier *= 0.3;
                factors.inDangerZone = true;
                details.append("Lava, ");
            }
            if (atType == Material.BUBBLE_COLUMN) {
                String blockData = blockAt.getBlockData().getAsString();
                if (blockData.contains("drag=false")) {
                    factors.gravityMultiplier *= -2.0;
                    details.append("Bubble Column (Up), ");
                } else {
                    factors.gravityMultiplier *= -1.5;
                    details.append("Bubble Column (Down), ");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void applyBeaconEffects(Player player, EnvironmentalFactors factors, StringBuilder details) {
        try {
            PotionEffect resistance;
            PotionEffectType resistanceType;
            PotionEffect haste;
            PotionEffectType hasteType = EnvironmentHelper.getEffectType("FAST_DIGGING", "HASTE");
            if (hasteType != null && (haste = player.getPotionEffect(hasteType)) != null && haste.getDuration() > 200) {
                int level = haste.getAmplifier() + 1;
                details.append("Beacon Haste ").append(level).append(", ");
            }
            if ((resistanceType = EnvironmentHelper.getEffectType("DAMAGE_RESISTANCE", "RESISTANCE")) != null && (resistance = player.getPotionEffect(resistanceType)) != null && resistance.getDuration() > 200) {
                factors.damageMultiplier *= 0.8;
                details.append("Beacon Resistance, ");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void applyConduitEffects(Player player, EnvironmentalFactors factors, StringBuilder details) {
        try {
            PotionEffect conduitPower;
            PotionEffectType conduitType = EnvironmentHelper.getEffectType("CONDUIT_POWER");
            if (conduitType != null && (conduitPower = player.getPotionEffect(conduitType)) != null) {
                factors.speedMultiplier *= 1.3;
                details.append("Conduit Power, ");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean hasSoulSpeed(Player player) {
        try {
            ItemStack boots = player.getInventory().getBoots();
            if (boots == null) {
                return false;
            }
            Enchantment soulSpeed = null;
            try {
                soulSpeed = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)"soul_speed"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (soulSpeed == null) {
                try {
                    soulSpeed = Enchantment.getByName((String)"SOUL_SPEED");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return soulSpeed != null && boots.containsEnchantment(soulSpeed);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isInDangerousEnvironment(Player player) {
        try {
            Location loc = player.getLocation();
            Block block = loc.getBlock();
            Material type = block.getType();
            if (type == Material.LAVA || type.name().contains("LAVA")) {
                return true;
            }
            if (type == Material.FIRE || type.name().contains("FIRE")) {
                return true;
            }
            if (loc.getY() < 10.0) {
                return true;
            }
            if (player.getHealth() < 6.0) {
                return true;
            }
            if (player.getFoodLevel() < 6) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static PotionEffectType getEffectType(String ... names) {
        for (String name : names) {
            try {
                PotionEffectType type = PotionEffectType.getByName((String)name);
                if (type == null) continue;
                return type;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static class EnvironmentalFactors {
        public double speedMultiplier = 1.0;
        public double gravityMultiplier = 1.0;
        public double damageMultiplier = 1.0;
        public double reachBonus = 0.0;
        public boolean hasStatusEffects = false;
        public boolean onSlipperyBlock = false;
        public boolean inDangerZone = false;
        public String details = "None";
    }
}

