/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.core;

import NC.noChance.core.ACConfig;
import NC.noChance.core.CheckResult;
import NC.noChance.core.PlayerData;
import NC.noChance.core.ViolationType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

public class LayerFiltering {
    private final ACConfig config;
    private final Map<UUID, PingHistory> pingHistoryMap;
    private final Map<UUID, List<Double>> movementHistoryMap;
    private static final double EWMA_ALPHA = 0.3;
    private static final double SIGMOID_STEEPNESS = 0.015;
    private static final double ENTROPY_THRESHOLD = 2.5;
    private static final double AUTOCORR_THRESHOLD = 0.75;
    private static final int HISTORY_SIZE = 100;

    public LayerFiltering(ACConfig config) {
        this.config = config;
        this.pingHistoryMap = new ConcurrentHashMap<UUID, PingHistory>();
        this.movementHistoryMap = new ConcurrentHashMap<UUID, List<Double>>();
    }

    public boolean passesLayer2HeuristicFiltering(Player player, ViolationType type, CheckResult preliminaryResult) {
        if (!preliminaryResult.isFailed()) {
            return true;
        }
        switch (type) {
            case FLY: {
                return !this.isLegitimateFlightScenario(player);
            }
            case SPEED: {
                return !this.isLegitimateSpeedScenario(player);
            }
            case NOCLIP: {
                return !this.isLegitimateNoClipScenario(player);
            }
            case PHASE: {
                return !this.isLegitimatePhaseScenario(player);
            }
            case JESUS: {
                return !this.isLegitimateJesusScenario(player);
            }
            case FASTBREAK: 
            case FASTPLACE: 
            case NUKER: {
                return !this.isLegitimateBlockInteractionScenario(player, type);
            }
            case KILLAURA: 
            case KILLAURA_MULTI: 
            case KILLAURA_ANGLE: 
            case KILLAURA_ROTATION: 
            case KILLAURA_PATTERN: {
                return !this.isLegitimateKillAuraScenario(player);
            }
            case NOFALL: {
                return !this.isLegitimateNoFallScenario(player);
            }
            case NOSLOW: {
                return !this.isLegitimateNoSlowScenario(player);
            }
        }
        return true;
    }

    private boolean isLegitimateFlightScenario(Player player) {
        if (player.isGliding()) {
            return true;
        }
        if (player.isSwimming()) {
            return true;
        }
        if (player.isClimbing()) {
            return true;
        }
        if (player.isFlying() && player.getAllowFlight()) {
            return true;
        }
        if (player.getVehicle() != null) {
            return true;
        }
        if (player.hasPotionEffect(PotionEffectType.LEVITATION)) {
            return true;
        }
        if (player.hasPotionEffect(PotionEffectType.SLOW_FALLING)) {
            return true;
        }
        if (player.isRiptiding()) {
            return true;
        }
        Location loc = player.getLocation();
        Block below = loc.clone().subtract(0.0, 1.0, 0.0).getBlock();
        if (below.getType() == Material.SLIME_BLOCK || below.getType() == Material.HONEY_BLOCK) {
            return true;
        }
        if (this.isOnLadderOrVine(player)) {
            return true;
        }
        if (this.isInLiquid(player)) {
            return true;
        }
        return this.isOnScaffolding(player);
    }

    private boolean isLegitimateSpeedScenario(Player player) {
        if (player.hasPotionEffect(PotionEffectType.SPEED)) {
            return true;
        }
        if (player.hasPotionEffect(PotionEffectType.DOLPHINS_GRACE)) {
            return true;
        }
        if (player.isSprinting()) {
            return true;
        }
        if (player.getVehicle() != null) {
            return true;
        }
        if (player.isRiptiding()) {
            return true;
        }
        Location loc = player.getLocation();
        Block below = loc.clone().subtract(0.0, 1.0, 0.0).getBlock();
        Material belowType = below.getType();
        if (belowType == Material.ICE || belowType == Material.PACKED_ICE || belowType == Material.BLUE_ICE || belowType == Material.FROSTED_ICE) {
            return true;
        }
        if ((belowType == Material.SOUL_SAND || belowType == Material.SOUL_SOIL) && player.getInventory().getBoots() != null && player.getInventory().getBoots().getEnchantments().containsKey(Enchantment.SOUL_SPEED)) {
            return true;
        }
        return player.isSwimming() && player.getInventory().getBoots() != null && player.getInventory().getBoots().getEnchantments().containsKey(Enchantment.DEPTH_STRIDER);
    }

    private boolean isLegitimateNoClipScenario(Player player) {
        if (player.getGameMode() == GameMode.SPECTATOR) {
            return true;
        }
        if (player.isSwimming()) {
            return true;
        }
        if (player.getVehicle() != null) {
            return true;
        }
        if (player.isGliding()) {
            return true;
        }
        if (player.isFlying() && player.getAllowFlight()) {
            return true;
        }
        Location loc = player.getLocation();
        Block block = loc.getBlock();
        Material type = block.getType();
        if (!type.isSolid()) {
            return true;
        }
        if (type == Material.LADDER || type == Material.VINE) {
            return true;
        }
        if (type.name().contains("TRAPDOOR")) {
            return true;
        }
        if (type.name().contains("DOOR")) {
            return true;
        }
        if (type.name().contains("FENCE")) {
            return true;
        }
        if (type.name().contains("GATE")) {
            return true;
        }
        long timeSinceJoin = System.currentTimeMillis() - player.getFirstPlayed();
        return timeSinceJoin < 2000L;
    }

    private boolean isLegitimatePhaseScenario(Player player) {
        if (player.getGameMode() == GameMode.SPECTATOR) {
            return true;
        }
        if (player.isSwimming()) {
            return true;
        }
        if (player.getVehicle() != null) {
            return true;
        }
        if (player.isGliding()) {
            return true;
        }
        if (player.isFlying() && player.getAllowFlight()) {
            return true;
        }
        if (player.isRiptiding()) {
            return true;
        }
        Location loc = player.getLocation();
        Block block = loc.getBlock();
        Material type = block.getType();
        if (!type.isSolid()) {
            return true;
        }
        if (type == Material.LADDER || type == Material.VINE) {
            return true;
        }
        if (type == Material.SCAFFOLDING) {
            return true;
        }
        if (type == Material.COBWEB) {
            return true;
        }
        if (type == Material.POWDER_SNOW) {
            return true;
        }
        if (type == Material.HONEY_BLOCK) {
            return true;
        }
        if (type.name().contains("TRAPDOOR")) {
            return true;
        }
        if (type.name().contains("DOOR")) {
            return true;
        }
        if (type.name().contains("FENCE")) {
            return true;
        }
        if (type.name().contains("GATE")) {
            return true;
        }
        int ping = this.getPing(player);
        return ping > 300;
    }

    private boolean isLegitimateJesusScenario(Player player) {
        Location loc = player.getLocation();
        Block below = loc.clone().subtract(0.0, 0.1, 0.0).getBlock();
        if (below.getType() == Material.LILY_PAD) {
            return true;
        }
        if (player.getVehicle() != null) {
            return true;
        }
        if (player.isSwimming()) {
            return true;
        }
        if (player.isInWater()) {
            return true;
        }
        if (player.hasPotionEffect(PotionEffectType.DOLPHINS_GRACE)) {
            return true;
        }
        if (player.getInventory().getBoots() != null && player.getInventory().getBoots().getEnchantments().containsKey(Enchantment.FROST_WALKER)) {
            return true;
        }
        Block feetBlock = loc.getBlock();
        if (feetBlock.getType().name().contains("BUBBLE")) {
            return true;
        }
        Block headBlock = loc.clone().add(0.0, 1.0, 0.0).getBlock();
        return headBlock.getType() == Material.WATER || headBlock.getType().name().contains("WATER");
    }

    private boolean isLegitimateBlockInteractionScenario(Player player, ViolationType type) {
        if (player.getGameMode() == GameMode.CREATIVE) {
            return true;
        }
        return type == ViolationType.FASTBREAK && player.hasPotionEffect(PotionEffectType.HASTE);
    }

    private boolean isLegitimateKillAuraScenario(Player player) {
        if (player.hasPotionEffect(PotionEffectType.BLINDNESS)) {
            return true;
        }
        return player.hasPotionEffect(PotionEffectType.NAUSEA);
    }

    private boolean isLegitimateNoFallScenario(Player player) {
        if (player.hasPotionEffect(PotionEffectType.SLOW_FALLING)) {
            return true;
        }
        if (player.isGliding()) {
            return true;
        }
        if (player.getVehicle() != null) {
            return true;
        }
        if (player.isSwimming()) {
            return true;
        }
        if (this.isOnLadderOrVine(player)) {
            return true;
        }
        Location loc = player.getLocation();
        Block below = loc.clone().subtract(0.0, 1.0, 0.0).getBlock();
        Material belowType = below.getType();
        if (belowType == Material.WATER || belowType.name().contains("WATER")) {
            return true;
        }
        if (belowType == Material.SLIME_BLOCK || belowType == Material.HONEY_BLOCK) {
            return true;
        }
        if (belowType == Material.HAY_BLOCK) {
            return true;
        }
        if (belowType.name().contains("BED")) {
            return true;
        }
        if (belowType == Material.COBWEB) {
            return true;
        }
        if (belowType == Material.SWEET_BERRY_BUSH) {
            return true;
        }
        if (belowType == Material.POWDER_SNOW) {
            return true;
        }
        return belowType == Material.SCAFFOLDING;
    }

    private boolean isLegitimateNoSlowScenario(Player player) {
        if (player.isFlying() && player.getAllowFlight()) {
            return true;
        }
        if (player.getGameMode() == GameMode.CREATIVE) {
            return true;
        }
        if (player.getGameMode() == GameMode.SPECTATOR) {
            return true;
        }
        if (player.getVehicle() != null) {
            return true;
        }
        if (player.isGliding()) {
            return true;
        }
        if (player.isSwimming()) {
            return true;
        }
        if (player.isRiptiding()) {
            return true;
        }
        int ping = this.getPing(player);
        return ping > 350;
    }

    public double getLagCompensation(Player player) {
        UUID playerId = player.getUniqueId();
        int currentPing = this.getPing(player);
        PingHistory history = this.pingHistoryMap.computeIfAbsent(playerId, k -> new PingHistory());
        history.addPing(currentPing);
        double avgPing = history.getAveragePing();
        double jitter = history.getJitter();
        double tps = this.getCurrentTPS();
        double pingFactor = this.calculateSigmoidPingPenalty(avgPing);
        double jitterFactor = Math.min(0.2, jitter / 1000.0);
        double tpsFactor = (1.0 - tps / 20.0) * 0.4;
        double baseTolerance = 0.05;
        return pingFactor + jitterFactor + tpsFactor + baseTolerance;
    }

    private double calculateSigmoidPingPenalty(double ping) {
        return 1.0 / (1.0 + Math.exp(-0.015 * (ping - 150.0)));
    }

    private double getCurrentTPS() {
        try {
            Object server = Bukkit.getServer().getClass().getMethod("getServer", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
            double[] recentTps = (double[])server.getClass().getField("recentTps").get(server);
            return Math.min(20.0, recentTps[0]);
        }
        catch (Exception e) {
            return 20.0;
        }
    }

    public int getPing(Player player) {
        try {
            Object handle = player.getClass().getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
            int ping = (Integer)handle.getClass().getField("ping").get(handle);
            return Math.max(0, ping);
        }
        catch (Exception e) {
            return 50;
        }
    }

    public double calculateEWMA(List<Double> values, double alpha) {
        if (values.isEmpty()) {
            return 0.0;
        }
        double ewma = values.get(0);
        for (int i = 1; i < values.size(); ++i) {
            ewma = alpha * values.get(i) + (1.0 - alpha) * ewma;
        }
        return ewma;
    }

    public double calculateMovingAverage(List<Double> values, int window) {
        if (values.isEmpty()) {
            return 0.0;
        }
        int start = Math.max(0, values.size() - window);
        double sum = 0.0;
        for (int i = start; i < values.size(); ++i) {
            sum += values.get(i).doubleValue();
        }
        return sum / (double)(values.size() - start);
    }

    public double calculateShannonEntropy(List<Long> timings) {
        if (timings.size() < 5) {
            return 0.0;
        }
        HashMap<Long, Integer> bucketCounts = new HashMap<Long, Integer>();
        long minVal = Collections.min(timings);
        long maxVal = Collections.max(timings);
        long bucketSize = Math.max(1L, (maxVal - minVal) / 10L);
        for (Long timing : timings) {
            long bucket = (timing - minVal) / bucketSize;
            bucketCounts.put(bucket, bucketCounts.getOrDefault(bucket, 0) + 1);
        }
        double entropy = 0.0;
        int total = timings.size();
        Iterator iterator = bucketCounts.values().iterator();
        while (iterator.hasNext()) {
            int count = (Integer)iterator.next();
            if (count <= 0) continue;
            double probability = (double)count / (double)total;
            entropy -= probability * (Math.log(probability) / Math.log(2.0));
        }
        return entropy;
    }

    public double calculateAutocorrelation(List<Double> values, int lag) {
        if (values.size() < lag + 10) {
            return 0.0;
        }
        int n = values.size();
        double mean = values.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
        double c0 = 0.0;
        for (int i = 0; i < n; ++i) {
            c0 += Math.pow(values.get(i) - mean, 2.0);
        }
        double cLag = 0.0;
        for (int i = 0; i < n - lag; ++i) {
            cLag += (values.get(i) - mean) * (values.get(i + lag) - mean);
        }
        if (c0 == 0.0) {
            return 0.0;
        }
        return cLag / c0;
    }

    public boolean detectConsistentPattern(List<Double> values, double threshold) {
        if (values.size() < 5) {
            return false;
        }
        double mean = values.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
        double variance = values.stream().mapToDouble(v -> Math.pow(v - mean, 2.0)).average().orElse(0.0);
        double stdDev = Math.sqrt(variance);
        return stdDev < threshold;
    }

    public boolean detectMachinePattern(List<Long> timestamps) {
        double cv;
        if (timestamps.size() < 10) {
            return false;
        }
        ArrayList<Long> intervals = new ArrayList<Long>();
        for (int i = 1; i < timestamps.size(); ++i) {
            intervals.add(timestamps.get(i) - timestamps.get(i - 1));
        }
        double entropy = this.calculateShannonEntropy(intervals);
        if (entropy < 2.5) {
            return true;
        }
        long mean = intervals.stream().mapToLong(Long::longValue).sum() / (long)intervals.size();
        double variance = intervals.stream().mapToDouble(v -> Math.pow(v - mean, 2.0)).average().orElse(0.0);
        double stdDev = Math.sqrt(variance);
        double d = cv = mean > 0L ? stdDev / (double)mean : 0.0;
        if (cv < 0.15) {
            return true;
        }
        ArrayList<Double> doubleIntervals = new ArrayList<Double>();
        for (Long interval : intervals) {
            doubleIntervals.add(interval.doubleValue());
        }
        double autocorr1 = this.calculateAutocorrelation(doubleIntervals, 1);
        if (autocorr1 > 0.75) {
            return true;
        }
        boolean hasOutliers = this.detectOutliersIQR(doubleIntervals);
        return !hasOutliers && stdDev < 5.0;
    }

    public boolean detectOutliersIQR(List<Double> values) {
        if (values.size() < 4) {
            return false;
        }
        ArrayList<Double> sorted = new ArrayList<Double>(values);
        Collections.sort(sorted);
        int n = sorted.size();
        double q1 = (Double)sorted.get(n / 4);
        double q3 = (Double)sorted.get(3 * n / 4);
        double iqr = q3 - q1;
        double lowerBound = q1 - 1.5 * iqr;
        double upperBound = q3 + 1.5 * iqr;
        for (Double value : values) {
            if (!(value < lowerBound) && !(value > upperBound)) continue;
            return true;
        }
        return false;
    }

    public double calculateZScore(double value, List<Double> dataset) {
        if (dataset.isEmpty()) {
            return 0.0;
        }
        double mean = dataset.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
        double variance = dataset.stream().mapToDouble(v -> Math.pow(v - mean, 2.0)).average().orElse(0.0);
        double stdDev = Math.sqrt(variance);
        if (stdDev == 0.0) {
            return 0.0;
        }
        return (value - mean) / stdDev;
    }

    private boolean isOnLadderOrVine(Player player) {
        Location loc = player.getLocation();
        Material type = loc.getBlock().getType();
        return type == Material.LADDER || type == Material.VINE;
    }

    private boolean isInLiquid(Player player) {
        Location loc = player.getLocation();
        Material type = loc.getBlock().getType();
        return type == Material.WATER || type == Material.LAVA || type.name().contains("WATER") || type.name().contains("LAVA");
    }

    private boolean isOnScaffolding(Player player) {
        Location loc = player.getLocation();
        return loc.getBlock().getType() == Material.SCAFFOLDING;
    }

    public boolean isRealisticHumanBehavior(PlayerData data) {
        double cps = data.getAverageCPS();
        double rotationSpeed = data.getAverageRotationSpeed();
        double accuracy = data.getAverageAccuracy();
        PlayerData.SkillLevel skill = data.getSkillLevel();
        boolean cpsInRange = cps >= (double)skill.minCPS && cps <= (double)skill.maxCPS;
        boolean rotationInRange = rotationSpeed >= skill.minRotationSpeed && rotationSpeed <= skill.maxRotationSpeed;
        boolean accuracyInRange = accuracy >= skill.minAccuracy && accuracy <= skill.maxAccuracy;
        return cpsInRange && rotationInRange && accuracyInRange;
    }

    public boolean hasVariability(List<Double> values) {
        if (values.size() < 5) {
            return true;
        }
        double mean = values.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
        double variance = values.stream().mapToDouble(v -> Math.pow(v - mean, 2.0)).average().orElse(0.0);
        return variance > 0.01;
    }

    public void recordMovement(Player player, double distance) {
        UUID playerId = player.getUniqueId();
        List history = this.movementHistoryMap.computeIfAbsent(playerId, k -> new ArrayList());
        history.add(distance);
        if (history.size() > 100) {
            history.remove(0);
        }
    }

    public void cleanup(UUID playerId) {
        this.pingHistoryMap.remove(playerId);
        this.movementHistoryMap.remove(playerId);
    }

    private static class PingHistory {
        private final Deque<Integer> pings = new ArrayDeque<Integer>(50);
        private double ewmaPing = 0.0;
        private boolean initialized = false;

        public void addPing(int ping) {
            this.pings.addLast(ping);
            if (this.pings.size() > 50) {
                this.pings.pollFirst();
            }
            if (!this.initialized) {
                this.ewmaPing = ping;
                this.initialized = true;
            } else {
                this.ewmaPing = 0.3 * (double)ping + 0.7 * this.ewmaPing;
            }
        }

        public double getAveragePing() {
            return this.ewmaPing;
        }

        public double getJitter() {
            if (this.pings.size() < 2) {
                return 0.0;
            }
            ArrayList<Integer> pingList = new ArrayList<Integer>(this.pings);
            ArrayList<Integer> deltas = new ArrayList<Integer>();
            for (int i = 1; i < pingList.size(); ++i) {
                deltas.add(Math.abs((Integer)pingList.get(i) - (Integer)pingList.get(i - 1)));
            }
            double mean = deltas.stream().mapToInt(Integer::intValue).average().orElse(0.0);
            double variance = deltas.stream().mapToDouble(v -> Math.pow((double)v.intValue() - mean, 2.0)).average().orElse(0.0);
            return Math.sqrt(variance);
        }
    }
}

