/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.core;

import NC.noChance.core.WaterHelper;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class MovementPredictor {
    private static final double GRAVITY = 0.08;
    private static final double DRAG = 0.98;
    private static final double AIR_RESISTANCE = 0.91;
    private static final double JUMP_VELOCITY = 0.42;
    private static final double SWIM_SPEED = 0.02;
    private static final double WALK_SPEED = 0.1;
    private static final double SPRINT_MULTIPLIER = 1.3;
    private static final double SNEAK_MULTIPLIER = 0.3;
    private static final double PRECISION = 1.0E-8;

    public static PredictionResult predict(Player player, Location from, Location to, Vector lastVelocity) {
        MovementContext ctx = new MovementContext(player, from, to, lastVelocity);
        Set<Vector> possibleVelocities = MovementPredictor.calculatePossibleVelocities(ctx);
        Vector actualVelocity = to.toVector().subtract(from.toVector());
        Vector bestMatch = null;
        double bestDistance = Double.MAX_VALUE;
        for (Vector possible : possibleVelocities) {
            double distance = possible.distance(actualVelocity);
            if (!(distance < bestDistance)) continue;
            bestDistance = distance;
            bestMatch = possible;
        }
        if (bestMatch == null) {
            return PredictionResult.invalid("No possible velocities calculated");
        }
        double confidence = MovementPredictor.calculateConfidence(bestDistance, ctx);
        boolean valid = bestDistance < MovementPredictor.getMaxOffset(ctx);
        Location predictedLocation = from.clone().add(bestMatch);
        return PredictionResult.valid(bestMatch, predictedLocation, confidence, possibleVelocities);
    }

    private static Set<Vector> calculatePossibleVelocities(MovementContext ctx) {
        HashSet<Vector> velocities = new HashSet<Vector>();
        if (ctx.isFlying) {
            velocities.addAll(MovementPredictor.calculateFlyingVelocities(ctx));
        } else if (ctx.isGliding) {
            velocities.addAll(MovementPredictor.calculateGlidingVelocities(ctx));
        } else if (ctx.inWater) {
            velocities.addAll(MovementPredictor.calculateSwimmingVelocities(ctx));
        } else if (ctx.inLava) {
            velocities.addAll(MovementPredictor.calculateLavaVelocities(ctx));
        } else if (ctx.inWeb) {
            velocities.addAll(MovementPredictor.calculateWebVelocities(ctx));
        } else {
            velocities.addAll(MovementPredictor.calculateGroundVelocities(ctx));
        }
        return velocities;
    }

    private static Set<Vector> calculateGroundVelocities(MovementContext ctx) {
        HashSet<Vector> velocities = new HashSet<Vector>();
        double baseSpeed = 0.1 * ctx.speedMultiplier;
        if (ctx.speedLevel > 0) {
            baseSpeed *= 1.0 + (double)ctx.speedLevel * 0.2;
        }
        if (ctx.slownessLevel > 0) {
            baseSpeed *= 1.0 - (double)ctx.slownessLevel * 0.15;
        }
        double horizontalSpeed = baseSpeed;
        if (ctx.isSprinting) {
            horizontalSpeed *= 1.3;
        } else if (ctx.isSneaking) {
            horizontalSpeed *= 0.3;
        }
        Block below = ctx.from.clone().subtract(0.0, 0.5, 0.0).getBlock();
        double friction = MovementPredictor.getFriction(below.getType());
        for (double x = -horizontalSpeed; x <= horizontalSpeed; x += horizontalSpeed / 3.0) {
            for (double z = -horizontalSpeed; z <= horizontalSpeed; z += horizontalSpeed / 3.0) {
                Vector horizontal = new Vector(x, 0.0, z);
                if (horizontal.lengthSquared() > horizontalSpeed * horizontalSpeed) {
                    horizontal.normalize().multiply(horizontalSpeed);
                }
                horizontal.multiply(friction);
                double verticalVelocity = ctx.velocity.getY();
                if (ctx.onGround && ctx.wasOnGround) {
                    verticalVelocity = 0.0;
                } else if (ctx.onGround && !ctx.wasOnGround) {
                    verticalVelocity = 0.42;
                    if (ctx.jumpBoostLevel > 0) {
                        verticalVelocity += (double)ctx.jumpBoostLevel * 0.1;
                    }
                } else {
                    verticalVelocity -= 0.08;
                    verticalVelocity *= 0.98;
                }
                Vector velocity = new Vector(horizontal.getX(), verticalVelocity, horizontal.getZ());
                velocities.add(velocity);
            }
        }
        return velocities;
    }

    private static Set<Vector> calculateSwimmingVelocities(MovementContext ctx) {
        HashSet<Vector> velocities = new HashSet<Vector>();
        double swimSpeed = 0.02 * ctx.speedMultiplier;
        if (ctx.speedLevel > 0) {
            swimSpeed *= 1.0 + (double)ctx.speedLevel * 0.2;
        }
        for (double x = -swimSpeed; x <= swimSpeed; x += swimSpeed / 2.0) {
            for (double y = -swimSpeed; y <= swimSpeed; y += swimSpeed / 2.0) {
                for (double z = -swimSpeed; z <= swimSpeed; z += swimSpeed / 2.0) {
                    Vector velocity = new Vector(x, y, z);
                    if (velocity.lengthSquared() > swimSpeed * swimSpeed) {
                        velocity.normalize().multiply(swimSpeed);
                    }
                    velocity.multiply(0.8);
                    velocities.add(velocity);
                }
            }
        }
        return velocities;
    }

    private static Set<Vector> calculateLavaVelocities(MovementContext ctx) {
        HashSet<Vector> velocities = new HashSet<Vector>();
        double lavaSpeed = 0.01 * ctx.speedMultiplier;
        for (double x = -lavaSpeed; x <= lavaSpeed; x += lavaSpeed / 2.0) {
            for (double y = -lavaSpeed; y <= lavaSpeed; y += lavaSpeed / 2.0) {
                for (double z = -lavaSpeed; z <= lavaSpeed; z += lavaSpeed / 2.0) {
                    Vector velocity = new Vector(x, y, z);
                    velocity.multiply(0.5);
                    velocities.add(velocity);
                }
            }
        }
        return velocities;
    }

    private static Set<Vector> calculateWebVelocities(MovementContext ctx) {
        HashSet<Vector> velocities = new HashSet<Vector>();
        double webSpeed = 0.025 * ctx.speedMultiplier;
        for (double x = -webSpeed; x <= webSpeed; x += webSpeed / 2.0) {
            for (double z = -webSpeed; z <= webSpeed; z += webSpeed / 2.0) {
                Vector velocity = new Vector(x, -0.08, z);
                velocities.add(velocity);
            }
        }
        return velocities;
    }

    private static Set<Vector> calculateFlyingVelocities(MovementContext ctx) {
        HashSet<Vector> velocities = new HashSet<Vector>();
        double flySpeed = 0.1 * ctx.speedMultiplier * 2.0;
        for (double x = -flySpeed; x <= flySpeed; x += flySpeed / 2.0) {
            for (double y = -flySpeed; y <= flySpeed; y += flySpeed / 2.0) {
                for (double z = -flySpeed; z <= flySpeed; z += flySpeed / 2.0) {
                    Vector velocity = new Vector(x, y, z);
                    if (velocity.lengthSquared() > flySpeed * flySpeed) {
                        velocity.normalize().multiply(flySpeed);
                    }
                    velocities.add(velocity);
                }
            }
        }
        return velocities;
    }

    private static Set<Vector> calculateGlidingVelocities(MovementContext ctx) {
        HashSet<Vector> velocities = new HashSet<Vector>();
        Vector look = ctx.from.getDirection();
        double glideSpeed = 0.6;
        for (double multiplier = 0.8; multiplier <= 1.2; multiplier += 0.1) {
            Vector velocity = look.clone().multiply(glideSpeed * multiplier);
            velocity.setY(velocity.getY() - 0.08);
            velocities.add(velocity);
        }
        return velocities;
    }

    private static double getFriction(Material material) {
        if (material == Material.ICE || material == Material.PACKED_ICE) {
            return 0.98;
        }
        if (material == Material.BLUE_ICE) {
            return 0.989;
        }
        if (material == Material.SLIME_BLOCK) {
            return 0.8;
        }
        if (material == Material.SOUL_SAND || material == Material.SOUL_SOIL) {
            return 0.4;
        }
        if (material == Material.HONEY_BLOCK) {
            return 0.4;
        }
        return 0.91;
    }

    private static double calculateConfidence(double offset, MovementContext ctx) {
        double maxOffset = MovementPredictor.getMaxOffset(ctx);
        if (offset < 1.0E-8) {
            return 1.0;
        }
        double confidence = 1.0 - offset / maxOffset;
        return Math.max(0.0, Math.min(1.0, confidence));
    }

    private static double getMaxOffset(MovementContext ctx) {
        double baseOffset = 0.03;
        if (ctx.inWater || ctx.inLava) {
            baseOffset = 0.05;
        } else if (ctx.inWeb) {
            baseOffset = 0.08;
        } else if (ctx.isFlying) {
            baseOffset = 0.1;
        } else if (ctx.isGliding) {
            baseOffset = 0.15;
        }
        return baseOffset;
    }

    public static class MovementContext {
        public final Location from;
        public final Location to;
        public final Vector velocity;
        public final boolean onGround;
        public final boolean wasOnGround;
        public final boolean inWater;
        public final boolean inLava;
        public final boolean inWeb;
        public final boolean isSprinting;
        public final boolean isSneaking;
        public final boolean isFlying;
        public final boolean isGliding;
        public final double speedMultiplier;
        public final int jumpBoostLevel;
        public final int speedLevel;
        public final int slownessLevel;

        public MovementContext(Player player, Location from, Location to, Vector velocity) {
            this.from = from;
            this.to = to;
            this.velocity = velocity;
            this.onGround = player.isOnGround();
            this.wasOnGround = from.getY() % 1.0 == 0.0;
            this.inWater = WaterHelper.isInWater(player);
            this.inLava = this.isInLava(player);
            this.inWeb = this.isInWeb(player);
            this.isSprinting = player.isSprinting();
            this.isSneaking = player.isSneaking();
            this.isFlying = player.isFlying();
            this.isGliding = player.isGliding();
            this.speedMultiplier = (double)player.getWalkSpeed() / 0.2;
            PotionEffect jumpBoost = player.getPotionEffect(MovementContext.getPotionEffect("JUMP", "JUMP_BOOST"));
            this.jumpBoostLevel = jumpBoost != null ? jumpBoost.getAmplifier() + 1 : 0;
            PotionEffect speed = player.getPotionEffect(MovementContext.getPotionEffect("SPEED"));
            this.speedLevel = speed != null ? speed.getAmplifier() + 1 : 0;
            PotionEffect slowness = player.getPotionEffect(MovementContext.getPotionEffect("SLOW", "SLOWNESS"));
            this.slownessLevel = slowness != null ? slowness.getAmplifier() + 1 : 0;
        }

        private static PotionEffectType getPotionEffect(String ... names) {
            for (String name : names) {
                PotionEffectType type = PotionEffectType.getByName((String)name);
                if (type == null) continue;
                return type;
            }
            return null;
        }

        private boolean isInLava(Player player) {
            Block block = player.getLocation().getBlock();
            Material type = block.getType();
            return type == Material.LAVA || type.name().contains("LAVA");
        }

        private boolean isInWeb(Player player) {
            return player.getLocation().getBlock().getType() == Material.COBWEB;
        }
    }

    public static class PredictionResult {
        public final Vector predictedVelocity;
        public final Location predictedLocation;
        public final double confidence;
        public final boolean valid;
        public final String reason;
        public final Set<Vector> possibleVelocities;

        public PredictionResult(Vector predicted, Location location, double confidence, boolean valid, String reason, Set<Vector> possible) {
            this.predictedVelocity = predicted;
            this.predictedLocation = location;
            this.confidence = confidence;
            this.valid = valid;
            this.reason = reason;
            this.possibleVelocities = possible;
        }

        public static PredictionResult invalid(String reason) {
            return new PredictionResult(new Vector(0, 0, 0), null, 0.0, false, reason, new HashSet<Vector>());
        }

        public static PredictionResult valid(Vector velocity, Location location, double confidence, Set<Vector> possible) {
            return new PredictionResult(velocity, location, confidence, true, "Valid", possible);
        }
    }
}

