/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.core;

import NC.noChance.core.ACConfig;
import NC.noChance.core.AdaptiveSamplingSystem;
import NC.noChance.core.CheckResult;
import NC.noChance.core.DetectionEngine;
import NC.noChance.core.LayerFiltering;
import NC.noChance.core.PlayerData;
import NC.noChance.core.ViolationType;
import NC.noChance.packets.PacketAnalyzer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class MultiLayerValidator {
    private final ACConfig config;
    private final Map<UUID, PlayerData> playerDataMap;
    private final LayerFiltering filtering;
    private final Map<UUID, LayerState> layerStates;
    private final DetectionEngine advancedEngine;
    private final AdaptiveSamplingSystem samplingSystem;
    private PacketAnalyzer packetAnalyzer;
    private static final double DECAY_FACTOR = 0.85;
    private static final double SIGMOID_MIDPOINT = 150.0;
    private static final double SIGMOID_STEEPNESS = 0.02;
    private static final double TREND_THRESHOLD = 0.25;
    private static final double MOMENTUM_ALPHA = 0.4;

    public MultiLayerValidator(ACConfig config, Map<UUID, PlayerData> playerDataMap, LayerFiltering filtering) {
        this.config = config;
        this.playerDataMap = playerDataMap;
        this.filtering = filtering;
        this.layerStates = new HashMap<UUID, LayerState>();
        this.advancedEngine = new DetectionEngine(config);
        this.samplingSystem = new AdaptiveSamplingSystem(this.advancedEngine);
        this.packetAnalyzer = null;
    }

    public void setPacketAnalyzer(PacketAnalyzer packetAnalyzer) {
        this.packetAnalyzer = packetAnalyzer;
    }

    public ValidationResult validate(Player player, CheckResult checkResult, ViolationType type) {
        if (!checkResult.isFailed()) {
            return ValidationResult.passed();
        }
        UUID playerId = player.getUniqueId();
        if (!this.samplingSystem.shouldCheck(player, type)) {
            return ValidationResult.passed();
        }
        LayerState state = this.layerStates.computeIfAbsent(playerId, k -> new LayerState());
        PlayerData data = this.playerDataMap.get(playerId);
        if (data == null) {
            return ValidationResult.passed();
        }
        if (!this.layerA_InitialDetection(checkResult, type, state, data)) {
            return ValidationResult.passed();
        }
        if (!this.layerB_ContextualValidation(player, checkResult, type, state, data)) {
            return ValidationResult.passed();
        }
        if (!this.layerC_PatternConfirmation(player, checkResult, type, state, data)) {
            return ValidationResult.passed();
        }
        ValidationResult baseResult = this.layerD_FinalConfidenceScoring(player, checkResult, type, state, data);
        DetectionEngine.AnalysisResult advancedResult = this.advancedEngine.analyze(player, data, checkResult, type);
        PacketAnalyzer.PacketViolationResult packetResult = null;
        if (this.packetAnalyzer != null) {
            packetResult = this.packetAnalyzer.analyzeForViolations(player, type);
        }
        ValidationResult combined = this.combineResults(baseResult, advancedResult, packetResult, checkResult);
        return combined;
    }

    private boolean layerA_InitialDetection(CheckResult result, ViolationType type, LayerState state, PlayerData data) {
        double severityThreshold = 0.42;
        int complexityFactor = type.getComplexity();
        if (complexityFactor >= 4) {
            severityThreshold = 0.52;
        } else if (complexityFactor >= 3) {
            severityThreshold = 0.46;
        }
        if (data != null && data.isStrictDetectionMode()) {
            severityThreshold *= 0.7;
        }
        if (result.getSeverity() < severityThreshold) {
            state.resetLayer(type);
            return false;
        }
        state.recordLayerA(type, result.getSeverity());
        return true;
    }

    private boolean layerB_ContextualValidation(Player player, CheckResult result, ViolationType type, LayerState state, PlayerData data) {
        if (!this.filtering.passesLayer2HeuristicFiltering(player, type, result)) {
            state.resetLayer(type);
            return false;
        }
        int requiredViolations = 1;
        List<Double> recentSeverities = state.getRecentSeverities(type, 8000L);
        if (recentSeverities.size() < requiredViolations) {
            return false;
        }
        double avgSeverity = this.calculateWeightedAverage(recentSeverities);
        double avgThreshold = 0.38;
        if (data != null && data.isStrictDetectionMode()) {
            avgThreshold *= 0.7;
        }
        if (avgSeverity < avgThreshold) {
            state.resetLayer(type);
            return false;
        }
        if (!this.validateCrossMetrics(player, type, data)) {
            state.resetLayer(type);
            return false;
        }
        state.recordLayerB(type, avgSeverity);
        return true;
    }

    private boolean layerC_PatternConfirmation(Player player, CheckResult result, ViolationType type, LayerState state, PlayerData data) {
        long highSeverityCount;
        double highSeverityThreshold;
        int requiredPatternSamples = 1;
        List<Double> patternSamples = state.getRecentSeverities(type, 10000L);
        if (patternSamples.size() < requiredPatternSamples) {
            return false;
        }
        double variance = this.calculateRobustVariance(patternSamples);
        double trend = this.calculateTrend(patternSamples);
        double autocorr = this.filtering.calculateAutocorrelation(patternSamples, 1);
        boolean isSuspiciousPattern = false;
        boolean strictMode = data != null && data.isStrictDetectionMode();
        double varianceThreshold = strictMode ? 0.021599999999999998 : 0.018;
        double allMatchThreshold = strictMode ? 0.33599999999999997 : 0.48;
        double consecutiveThreshold = strictMode ? 0.378 : 0.54;
        double d = highSeverityThreshold = strictMode ? 0.33599999999999997 : 0.48;
        if (variance < varianceThreshold) {
            isSuspiciousPattern = true;
        }
        if (trend > 0.25) {
            isSuspiciousPattern = true;
        }
        if (autocorr > 0.7) {
            isSuspiciousPattern = true;
        }
        if (patternSamples.stream().allMatch(s -> s > allMatchThreshold)) {
            isSuspiciousPattern = true;
        }
        double consecutiveHighSeverity = 0.0;
        for (int i = Math.max(0, patternSamples.size() - 3); i < patternSamples.size(); ++i) {
            if (!(patternSamples.get(i) > consecutiveThreshold)) continue;
            consecutiveHighSeverity += 1.0;
        }
        if (consecutiveHighSeverity >= 2.0) {
            isSuspiciousPattern = true;
        }
        if ((highSeverityCount = patternSamples.stream().filter(s -> s > highSeverityThreshold).count()) >= 2L) {
            isSuspiciousPattern = true;
        }
        if (!isSuspiciousPattern) {
            return false;
        }
        if (!this.filtering.isRealisticHumanBehavior(data)) {
            isSuspiciousPattern = true;
        }
        if (!isSuspiciousPattern) {
            return false;
        }
        state.recordLayerC(type);
        return true;
    }

    private ValidationResult layerD_FinalConfidenceScoring(Player player, CheckResult result, ViolationType type, LayerState state, PlayerData data) {
        List<Double> allSeverities = state.getRecentSeverities(type, 15000L);
        DetectionEngine.SuspicionLevel suspicion = this.advancedEngine.getSuspicionLevel(player.getUniqueId());
        int requiredViolations = 2;
        if (suspicion == DetectionEngine.SuspicionLevel.HIGH || suspicion == DetectionEngine.SuspicionLevel.CONFIRMED) {
            requiredViolations = 1;
        } else if (suspicion == DetectionEngine.SuspicionLevel.MEDIUM) {
            requiredViolations = 1;
        }
        if (data != null && data.isStrictDetectionMode()) {
            requiredViolations = Math.max(1, requiredViolations - 1);
        }
        if (allSeverities.size() < requiredViolations) {
            return ValidationResult.inconclusive();
        }
        double baseScore = this.calculateWeightedAverage(allSeverities);
        double typeWeight = type.getWeight();
        double frequency = Math.min(1.0, (double)allSeverities.size() / 5.0);
        double rawScore = baseScore * typeWeight * frequency;
        double lagPenalty = this.calculateContinuousLagPenalty(player);
        double behaviorMultiplier = this.filtering.isRealisticHumanBehavior(data) ? 0.85 : 1.3;
        double consistencyMultiplier = this.calculateAdvancedConsistencyMultiplier(allSeverities);
        double momentumMultiplier = this.calculateMomentumMultiplier(allSeverities);
        if (data != null && data.isStrictDetectionMode()) {
            behaviorMultiplier *= 1.15;
        }
        double finalScore = rawScore * (1.0 - lagPenalty) * behaviorMultiplier * consistencyMultiplier * momentumMultiplier;
        ConfidenceLevel confidence = this.determineConfidenceLevel(finalScore);
        return new ValidationResult(true, confidence, finalScore, result);
    }

    private boolean validateCrossMetrics(Player player, ViolationType type, PlayerData data) {
        switch (type) {
            case KILLAURA: 
            case KILLAURA_ANGLE: 
            case KILLAURA_MULTI: 
            case KILLAURA_ROTATION: 
            case KILLAURA_PATTERN: {
                double cps = data.getAverageCPS();
                double rotSpeed = data.getAverageRotationSpeed();
                if (cps > 22.0 || rotSpeed > 720.0) {
                    return true;
                }
                return cps > 16.0 && rotSpeed > 480.0;
            }
            case SPEED: 
            case FLY: {
                return data.getLocationHistory().size() > 5;
            }
        }
        return true;
    }

    private double calculateRobustVariance(List<Double> values) {
        if (values.isEmpty()) {
            return 0.0;
        }
        ArrayList<Double> sorted = new ArrayList<Double>(values);
        Collections.sort(sorted);
        int n = sorted.size();
        int lowerIndex = n / 4;
        int upperIndex = 3 * n / 4;
        List trimmed = sorted.subList(lowerIndex, Math.min(upperIndex + 1, n));
        double mean = trimmed.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
        return trimmed.stream().mapToDouble(v -> Math.pow(v - mean, 2.0)).average().orElse(0.0);
    }

    private double calculateWeightedAverage(List<Double> values) {
        if (values.isEmpty()) {
            return 0.0;
        }
        double weightedSum = 0.0;
        double totalWeight = 0.0;
        for (int i = 0; i < values.size(); ++i) {
            double weight = Math.pow(0.85, values.size() - 1 - i);
            weightedSum += values.get(i) * weight;
            totalWeight += weight;
        }
        return totalWeight > 0.0 ? weightedSum / totalWeight : 0.0;
    }

    private double calculateTrend(List<Double> values) {
        if (values.size() < 3) {
            return 0.0;
        }
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXY = 0.0;
        double sumX2 = 0.0;
        int n = values.size();
        for (int i = 0; i < n; ++i) {
            sumX += (double)i;
            sumY += values.get(i).doubleValue();
            sumXY += (double)i * values.get(i);
            sumX2 += (double)(i * i);
        }
        double denominator = (double)n * sumX2 - sumX * sumX;
        if (denominator == 0.0) {
            return 0.0;
        }
        double slope = ((double)n * sumXY - sumX * sumY) / denominator;
        return slope;
    }

    private double calculateContinuousLagPenalty(Player player) {
        int ping = this.filtering.getPing(player);
        double normalizedPing = (double)ping / 300.0;
        return 1.0 / (1.0 + Math.exp(-0.02 * ((double)ping - 150.0)));
    }

    private double calculateAdvancedConsistencyMultiplier(List<Double> severities) {
        if (severities.size() < 3) {
            return 1.0;
        }
        double variance = this.calculateRobustVariance(severities);
        double cv = this.calculateCoefficientOfVariation(severities);
        double varianceScore = variance < 0.005 ? 1.5 : (variance < 0.02 ? 1.3 : (variance < 0.05 ? 1.1 : 0.9));
        double cvScore = cv < 0.1 ? 1.4 : (cv < 0.25 ? 1.2 : (cv < 0.5 ? 1.0 : 0.85));
        return (varianceScore + cvScore) / 2.0;
    }

    private double calculateMomentumMultiplier(List<Double> severities) {
        if (severities.size() < 3) {
            return 1.0;
        }
        double momentum = 0.0;
        for (int i = 1; i < severities.size(); ++i) {
            double change = severities.get(i) - severities.get(i - 1);
            momentum = 0.4 * change + 0.6 * momentum;
        }
        if (momentum > 0.15) {
            return 1.3;
        }
        if (momentum > 0.05) {
            return 1.15;
        }
        if (momentum < -0.05) {
            return 0.9;
        }
        return 1.0;
    }

    private double calculateCoefficientOfVariation(List<Double> values) {
        if (values.isEmpty()) {
            return 0.0;
        }
        double mean = values.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
        if (mean == 0.0) {
            return 0.0;
        }
        double variance = values.stream().mapToDouble(v -> Math.pow(v - mean, 2.0)).average().orElse(0.0);
        double stdDev = Math.sqrt(variance);
        return stdDev / mean;
    }

    private ConfidenceLevel determineConfidenceLevel(double score) {
        if (score >= 0.98) {
            return ConfidenceLevel.EXTREME;
        }
        if (score >= 0.95) {
            return ConfidenceLevel.HIGH;
        }
        if (score >= 0.85) {
            return ConfidenceLevel.MEDIUM;
        }
        if (score >= 0.7) {
            return ConfidenceLevel.LOW;
        }
        return ConfidenceLevel.NONE;
    }

    private ValidationResult combineResults(ValidationResult baseResult, DetectionEngine.AnalysisResult advancedResult, PacketAnalyzer.PacketViolationResult packetResult, CheckResult originalCheck) {
        double packetConfidence;
        boolean packetFlag;
        boolean baseFlag = baseResult.shouldFlag();
        boolean advancedFlag = advancedResult.shouldFlag;
        boolean bl = packetFlag = packetResult != null && packetResult.violated;
        if (!(baseFlag || advancedFlag || packetFlag)) {
            return ValidationResult.passed();
        }
        int systemsTriggered = 0;
        if (baseFlag) {
            ++systemsTriggered;
        }
        if (advancedFlag) {
            ++systemsTriggered;
        }
        if (packetFlag) {
            ++systemsTriggered;
        }
        double baseConfidence = baseResult.getScore();
        double advancedConfidence = advancedResult.confidence;
        double d = packetConfidence = packetResult != null ? packetResult.severity : 0.0;
        double combinedConfidence = packetResult != null && packetResult.violated ? (systemsTriggered >= 2 ? baseConfidence * 0.35 + advancedConfidence * 0.3 + packetConfidence * 0.35 : packetConfidence * 0.75) : baseConfidence * 0.56 + advancedConfidence * 0.44;
        if (combinedConfidence < 0.65) {
            return ValidationResult.inconclusive();
        }
        if (combinedConfidence >= 0.95 && systemsTriggered < 2) {
            return ValidationResult.inconclusive();
        }
        if (packetFlag && packetConfidence > 0.82) {
            combinedConfidence = Math.min(1.0, combinedConfidence + 0.1);
        }
        ConfidenceLevel finalConfidence = this.determineConfidenceLevel(combinedConfidence);
        Object detectionMethod = advancedResult.detectionMethod;
        if (packetFlag && packetResult.severity > advancedConfidence) {
            detectionMethod = "Packet-" + packetResult.reason;
        }
        return new ValidationResult(true, finalConfidence, combinedConfidence, originalCheck, (String)detectionMethod, advancedResult.entropyScore, advancedResult.consistencyScore, advancedResult.correlationScore, advancedResult.variant, advancedResult.punishmentMultiplier);
    }

    public void cleanupPlayer(UUID playerId) {
        this.layerStates.remove(playerId);
        this.advancedEngine.cleanup(playerId);
        this.samplingSystem.cleanup(playerId);
        if (this.packetAnalyzer != null) {
            this.packetAnalyzer.cleanup(playerId);
        }
    }

    public void cleanupOldData() {
        long now = System.currentTimeMillis();
        this.layerStates.values().forEach(state -> state.cleanupOld(now, 60000L));
    }

    public DetectionEngine.SuspicionLevel getSuspicionLevel(UUID playerId) {
        return this.advancedEngine.getSuspicionLevel(playerId);
    }

    public static class ValidationResult {
        private final boolean shouldFlag;
        private final ConfidenceLevel confidence;
        private final double score;
        private final CheckResult originalResult;
        private final String detectionMethod;
        private final double entropyScore;
        private final double consistencyScore;
        private final double correlationScore;
        private final String variant;
        private final double punishmentMultiplier;

        public ValidationResult(boolean shouldFlag, ConfidenceLevel confidence, double score, CheckResult originalResult, String detectionMethod, double entropyScore, double consistencyScore, double correlationScore, String variant, double punishmentMultiplier) {
            this.shouldFlag = shouldFlag;
            this.confidence = confidence;
            this.score = score;
            this.originalResult = originalResult;
            this.detectionMethod = detectionMethod;
            this.entropyScore = entropyScore;
            this.consistencyScore = consistencyScore;
            this.correlationScore = correlationScore;
            this.variant = variant;
            this.punishmentMultiplier = punishmentMultiplier;
        }

        public ValidationResult(boolean shouldFlag, ConfidenceLevel confidence, double score, CheckResult originalResult) {
            this(shouldFlag, confidence, score, originalResult, "Standard", 0.0, 0.0, 0.0, "", 1.0);
        }

        public static ValidationResult passed() {
            return new ValidationResult(false, ConfidenceLevel.NONE, 0.0, null);
        }

        public static ValidationResult inconclusive() {
            return new ValidationResult(false, ConfidenceLevel.NONE, 0.0, null);
        }

        public boolean shouldFlag() {
            return this.shouldFlag;
        }

        public ConfidenceLevel getConfidence() {
            return this.confidence;
        }

        public double getScore() {
            return this.score;
        }

        public CheckResult getOriginalResult() {
            return this.originalResult;
        }

        public String getDetectionMethod() {
            return this.detectionMethod;
        }

        public String getVariant() {
            return this.variant;
        }

        public double getPunishmentMultiplier() {
            return this.punishmentMultiplier;
        }
    }

    private static class LayerState {
        private final Map<ViolationType, List<SeverityRecord>> severityHistory = new HashMap<ViolationType, List<SeverityRecord>>();
        private final Map<ViolationType, Long> layerBPassTime = new HashMap<ViolationType, Long>();
        private final Map<ViolationType, Long> layerCPassTime = new HashMap<ViolationType, Long>();

        public void recordLayerA(ViolationType type, double severity) {
            this.severityHistory.computeIfAbsent(type, k -> new ArrayList()).add(new SeverityRecord(severity, System.currentTimeMillis()));
        }

        public void recordLayerB(ViolationType type, double avgSeverity) {
            this.layerBPassTime.put(type, System.currentTimeMillis());
        }

        public void recordLayerC(ViolationType type) {
            this.layerCPassTime.put(type, System.currentTimeMillis());
        }

        public List<Double> getRecentSeverities(ViolationType type, long timeWindow) {
            long cutoff = System.currentTimeMillis() - timeWindow;
            List records = this.severityHistory.getOrDefault((Object)type, new ArrayList());
            ArrayList<Double> recent = new ArrayList<Double>();
            for (SeverityRecord record : records) {
                if (record.timestamp <= cutoff) continue;
                recent.add(record.severity);
            }
            return recent;
        }

        public void resetLayer(ViolationType type) {
            this.severityHistory.remove((Object)type);
            this.layerBPassTime.remove((Object)type);
            this.layerCPassTime.remove((Object)type);
        }

        public void cleanupOld(long now, long maxAge) {
            for (List<SeverityRecord> records : this.severityHistory.values()) {
                records.removeIf(r -> now - r.timestamp > maxAge);
            }
        }

        private static class SeverityRecord {
            final double severity;
            final long timestamp;

            SeverityRecord(double severity, long timestamp) {
                this.severity = severity;
                this.timestamp = timestamp;
            }
        }
    }

    public static enum ConfidenceLevel {
        NONE,
        LOW,
        MEDIUM,
        HIGH,
        EXTREME;

    }
}

