/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.core;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PacketTracker {
    private final Map<UUID, SequenceData> sequences = new ConcurrentHashMap<UUID, SequenceData>();

    public void recordPacket(UUID playerId, PacketAction action, Location location) {
        SequenceData data = this.sequences.computeIfAbsent(playerId, k -> new SequenceData());
        long now = System.currentTimeMillis();
        data.events.addLast(new PacketEvent(action, location));
        if (data.events.size() > 50) {
            data.events.pollFirst();
        }
        if (action == PacketAction.START_DIG) {
            data.currentDigLocation = location;
            data.currentDigStartTime = now;
        } else if (action == PacketAction.FINISH_DIG) {
            if (data.currentDigLocation == null) {
                ++data.invalidSequences;
            } else if (data.currentDigLocation.distance(location) > 0.5) {
                ++data.invalidSequences;
            }
            data.currentDigLocation = null;
            data.currentDigStartTime = 0L;
        } else if (action == PacketAction.ABORT_DIG) {
            data.currentDigLocation = null;
            data.currentDigStartTime = 0L;
        }
    }

    public boolean hasValidSequence(UUID playerId) {
        SequenceData data = this.sequences.get(playerId);
        if (data == null) {
            return true;
        }
        return data.invalidSequences < 5;
    }

    public long getDigDuration(UUID playerId) {
        SequenceData data = this.sequences.get(playerId);
        if (data == null || data.currentDigStartTime == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - data.currentDigStartTime;
    }

    public boolean isDigInProgress(UUID playerId) {
        SequenceData data = this.sequences.get(playerId);
        return data != null && data.currentDigLocation != null;
    }

    public SequenceViolation checkSequence(UUID playerId) {
        long startEvents;
        SequenceData data = this.sequences.get(playerId);
        if (data == null || data.events.size() < 5) {
            return new SequenceViolation(false, 0.0, "Insufficient data");
        }
        ArrayList<PacketEvent> recentEvents = new ArrayList<PacketEvent>();
        long cutoff = System.currentTimeMillis() - 2000L;
        for (PacketEvent event : data.events) {
            if (event.timestamp <= cutoff) continue;
            recentEvents.add(event);
        }
        long finishWithoutStart = recentEvents.stream().filter(e -> e.action == PacketAction.FINISH_DIG).count();
        if (finishWithoutStart > (startEvents = recentEvents.stream().filter(e -> e.action == PacketAction.START_DIG).count()) + 2L) {
            return new SequenceViolation(true, 0.85, String.format("Invalid packet sequence: %d finish without start", finishWithoutStart - startEvents));
        }
        if (data.invalidSequences >= 8) {
            return new SequenceViolation(true, 0.78, String.format("Multiple invalid sequences: %d", data.invalidSequences));
        }
        long rapidFinishes = 0L;
        PacketEvent lastFinish = null;
        for (PacketEvent event : recentEvents) {
            if (event.action != PacketAction.FINISH_DIG) continue;
            if (lastFinish != null && event.timestamp - lastFinish.timestamp < 50L) {
                ++rapidFinishes;
            }
            lastFinish = event;
        }
        if (rapidFinishes >= 3L) {
            return new SequenceViolation(true, 0.82, String.format("Rapid packet sequence: %d finishes <50ms apart", rapidFinishes));
        }
        return new SequenceViolation(false, 0.0, "Clean sequence");
    }

    public SequenceViolation checkSequence(UUID playerId, Player player) {
        PotionEffect haste;
        SequenceData data = this.sequences.get(playerId);
        if (data == null || data.events.size() < 5) {
            return new SequenceViolation(false, 0.0, "Insufficient data");
        }
        ItemStack tool = player.getInventory().getItemInMainHand();
        String toolType = tool != null && tool.getType() != Material.AIR ? tool.getType().name() : "HAND";
        int efficiencyLevel = 0;
        if (tool != null && tool.getType() != Material.AIR) {
            Enchantment effEnch = Enchantment.getByName((String)"EFFICIENCY");
            if (effEnch == null) {
                effEnch = Enchantment.getByName((String)"DIG_SPEED");
            }
            if (effEnch != null) {
                efficiencyLevel = tool.getEnchantmentLevel(effEnch);
            }
        }
        boolean isShovel = toolType.contains("SHOVEL") || toolType.contains("SPADE");
        boolean isAxe = toolType.contains("AXE") && !toolType.contains("PICKAXE");
        boolean isGoldenTool = toolType.contains("GOLDEN");
        boolean hasHighEfficiency = efficiencyLevel >= 4;
        PotionEffectType hasteType = PotionEffectType.getByName((String)"HASTE");
        if (hasteType == null) {
            hasteType = PotionEffectType.getByName((String)"FAST_DIGGING");
        }
        int hasteLevel = 0;
        if (hasteType != null && (haste = player.getPotionEffect(hasteType)) != null) {
            hasteLevel = haste.getAmplifier() + 1;
        }
        ArrayList<PacketEvent> recentEvents = new ArrayList<PacketEvent>();
        long cutoff = System.currentTimeMillis() - 2000L;
        for (PacketEvent event : data.events) {
            if (event.timestamp <= cutoff) continue;
            recentEvents.add(event);
        }
        long finishWithoutStart = recentEvents.stream().filter(e -> e.action == PacketAction.FINISH_DIG).count();
        long startEvents = recentEvents.stream().filter(e -> e.action == PacketAction.START_DIG).count();
        int allowedFinishOverage = 2;
        if ((isShovel || isAxe) && hasHighEfficiency) {
            allowedFinishOverage = 5;
        } else if (isGoldenTool && hasHighEfficiency) {
            allowedFinishOverage = 6;
        } else if (hasHighEfficiency && hasteLevel >= 2) {
            allowedFinishOverage = 4;
        } else if (hasHighEfficiency || hasteLevel >= 1) {
            allowedFinishOverage = 3;
        }
        if (finishWithoutStart > startEvents + (long)allowedFinishOverage) {
            return new SequenceViolation(true, 0.85, String.format("Invalid packet sequence: %d finish without start", finishWithoutStart - startEvents));
        }
        if (data.invalidSequences >= 8) {
            return new SequenceViolation(true, 0.78, String.format("Multiple invalid sequences: %d", data.invalidSequences));
        }
        int rapidThreshold = 50;
        int requiredRapid = 3;
        if (isShovel && efficiencyLevel >= 5) {
            rapidThreshold = 20;
            requiredRapid = 15;
        } else if (isAxe && efficiencyLevel >= 5) {
            rapidThreshold = 30;
            requiredRapid = 12;
        } else if (isGoldenTool && efficiencyLevel >= 4) {
            rapidThreshold = 25;
            requiredRapid = 13;
        } else if (hasHighEfficiency && hasteLevel >= 2) {
            rapidThreshold = 30;
            requiredRapid = 10;
        } else if (hasHighEfficiency || hasteLevel >= 1) {
            rapidThreshold = 35;
            requiredRapid = 8;
        }
        long rapidFinishes = 0L;
        PacketEvent lastFinish = null;
        for (PacketEvent event : recentEvents) {
            if (event.action != PacketAction.FINISH_DIG) continue;
            if (lastFinish != null && event.timestamp - lastFinish.timestamp < (long)rapidThreshold) {
                ++rapidFinishes;
            }
            lastFinish = event;
        }
        if (rapidFinishes >= (long)requiredRapid) {
            return new SequenceViolation(true, 0.82, String.format("Rapid packet sequence: %d finishes <%dms apart", rapidFinishes, rapidThreshold));
        }
        return new SequenceViolation(false, 0.0, "Clean sequence");
    }

    public void cleanup(UUID playerId) {
        this.sequences.remove(playerId);
    }

    private static class SequenceData {
        private final Deque<PacketEvent> events = new ArrayDeque<PacketEvent>(50);
        private Location currentDigLocation = null;
        private long currentDigStartTime = 0L;
        private int invalidSequences = 0;
    }

    private static class PacketEvent {
        public final PacketAction action;
        public final Location location;
        public final long timestamp;

        public PacketEvent(PacketAction action, Location location) {
            this.action = action;
            this.location = location;
            this.timestamp = System.currentTimeMillis();
        }
    }

    public static enum PacketAction {
        START_DIG,
        ABORT_DIG,
        FINISH_DIG,
        BLOCK_PLACE,
        SWING_ARM,
        USE_ITEM;

    }

    public static class SequenceViolation {
        public final boolean violated;
        public final double severity;
        public final String reason;

        public SequenceViolation(boolean violated, double severity, String reason) {
            this.violated = violated;
            this.severity = severity;
            this.reason = reason;
        }
    }
}

