/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.core;

import NC.noChance.core.BoundedDeque;
import NC.noChance.core.ViolationType;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;

public class PlayerData {
    private final UUID playerId;
    private final long joinTime;
    private final Map<ViolationType, List<ViolationRecord>> violations;
    private final Map<String, Double> baseline;
    private final BoundedDeque<LocationData> locationHistory;
    private final BoundedDeque<Long> clickHistory;
    private final BoundedDeque<RotationData> rotationHistory;
    private final BoundedDeque<VelocityData> velocityHistory;
    private Location lastLocation;
    private long lastMoveTime;
    private double totalFallDistance;
    private long lastGroundTime;
    private boolean wasOnGround;
    private long lastVelocityTime;
    private double lastKnockbackVelocity;
    private int airTicks;
    private double lastVerticalVelocity;
    private long lastBlockBreakTime;
    private Location lastBlockBreak;
    private long blockBreakStartTime;
    private String blockBreakInitialTool;
    private int blockBreakInitialEfficiency;
    private final BoundedDeque<Long> blockBreakIntervals;
    private int consecutiveFastBreaks;
    private long lastBlockPlaceTime;
    private int blocksPlacedInTick;
    private int currentTick;
    private final BoundedDeque<Long> blockPlaceIntervals;
    private final BoundedDeque<LocationData> blockPlaceLocations;
    private Location lastBlockPlace;
    private double averageCPS;
    private double averageRotationSpeed;
    private double averageAccuracy;
    private int totalHits;
    private int totalAttempts;
    private SkillLevel skillLevel;
    private long sessionStartTime;
    private int outlierCount;
    private long lastEnderPearlTime;
    private long lastChorusFruitTime;
    private int totalViolationCount;
    private int totalCheckCount;
    private int historicalViolationCount;
    private long lastKickTime;
    private int effectiveGracePeriod;
    private boolean strictDetectionMode;

    public PlayerData(UUID playerId) {
        this.playerId = playerId;
        this.joinTime = System.currentTimeMillis();
        this.violations = new ConcurrentHashMap<ViolationType, List<ViolationRecord>>();
        this.baseline = new ConcurrentHashMap<String, Double>();
        this.locationHistory = new BoundedDeque(20);
        this.clickHistory = new BoundedDeque(100);
        this.rotationHistory = new BoundedDeque(50);
        this.velocityHistory = new BoundedDeque(30);
        this.sessionStartTime = System.currentTimeMillis();
        this.skillLevel = SkillLevel.MEDIUM;
        this.outlierCount = 0;
        this.wasOnGround = true;
        this.airTicks = 0;
        this.lastVerticalVelocity = 0.0;
        this.blockBreakIntervals = new BoundedDeque(20);
        this.consecutiveFastBreaks = 0;
        this.blockPlaceIntervals = new BoundedDeque(30);
        this.blockPlaceLocations = new BoundedDeque(15);
        this.historicalViolationCount = 0;
        this.lastKickTime = 0L;
        this.effectiveGracePeriod = 5;
        this.strictDetectionMode = false;
    }

    public void addViolation(ViolationType type, double severity, String details) {
        this.violations.computeIfAbsent(type, k -> new ArrayList()).add(new ViolationRecord(type, severity, details, System.currentTimeMillis()));
    }

    public List<ViolationRecord> getViolations(ViolationType type, long timeWindow) {
        long cutoff = System.currentTimeMillis() - timeWindow;
        List typeViolations = this.violations.getOrDefault((Object)type, new ArrayList());
        ArrayList<ViolationRecord> recent = new ArrayList<ViolationRecord>();
        for (ViolationRecord v : typeViolations) {
            if (v.timestamp <= cutoff) continue;
            recent.add(v);
        }
        return recent;
    }

    public void cleanOldViolations(long timeWindow) {
        long cutoff = System.currentTimeMillis() - timeWindow;
        for (List<ViolationRecord> vList : this.violations.values()) {
            vList.removeIf(v -> v.timestamp < cutoff);
        }
    }

    public void updateLocationHistory(Location loc) {
        this.locationHistory.add(new LocationData(loc, System.currentTimeMillis()));
        this.lastLocation = loc;
        this.lastMoveTime = System.currentTimeMillis();
    }

    public void updateClickHistory() {
        long now = System.currentTimeMillis();
        this.clickHistory.add(now);
        this.updateAverageCPS();
    }

    public void updateRotationHistory(float yaw, float pitch) {
        this.rotationHistory.add(new RotationData(yaw, pitch, System.currentTimeMillis()));
        this.updateAverageRotationSpeed();
    }

    private void updateAverageCPS() {
        if (this.clickHistory.size() < 2) {
            return;
        }
        long now = System.currentTimeMillis();
        long oneSecondAgo = now - 1000L;
        int clicks = 0;
        for (long clickTime : this.clickHistory) {
            if (clickTime <= oneSecondAgo) continue;
            ++clicks;
        }
        this.averageCPS = clicks;
    }

    private void updateAverageRotationSpeed() {
        if (this.rotationHistory.size() < 2) {
            return;
        }
        ArrayList<RotationData> rotList = new ArrayList<RotationData>(this.rotationHistory.getDeque());
        double totalSpeed = 0.0;
        int count = 0;
        for (int i = 1; i < rotList.size(); ++i) {
            RotationData prev = (RotationData)rotList.get(i - 1);
            RotationData curr = (RotationData)rotList.get(i);
            double deltaYaw = Math.abs(curr.yaw - prev.yaw);
            double deltaPitch = Math.abs(curr.pitch - prev.pitch);
            double deltaTime = (double)(curr.timestamp - prev.timestamp) / 1000.0;
            if (!(deltaTime > 0.0)) continue;
            double speed = Math.sqrt(deltaYaw * deltaYaw + deltaPitch * deltaPitch) / deltaTime;
            totalSpeed += speed;
            ++count;
        }
        if (count > 0) {
            this.averageRotationSpeed = totalSpeed / (double)count;
        }
    }

    public void updateAccuracy(boolean hit) {
        ++this.totalAttempts;
        if (hit) {
            ++this.totalHits;
        }
        this.averageAccuracy = this.totalAttempts > 0 ? (double)this.totalHits / (double)this.totalAttempts : 0.0;
    }

    public void calibrateSkillLevel() {
        long sessionDuration = System.currentTimeMillis() - this.sessionStartTime;
        if (sessionDuration < 60000L) {
            return;
        }
        this.skillLevel = this.averageCPS >= 14.0 && this.averageRotationSpeed >= 380.0 && this.averageAccuracy >= 0.72 ? SkillLevel.HIGH : (this.averageCPS >= 9.0 && this.averageRotationSpeed >= 220.0 && this.averageAccuracy >= 0.52 ? SkillLevel.MEDIUM : SkillLevel.LOW);
    }

    public boolean isInGracePeriod(int gracePeriodSeconds) {
        return System.currentTimeMillis() - this.joinTime < (long)this.effectiveGracePeriod * 1000L;
    }

    public void setHistoricalData(int violationCount, long kickTime) {
        this.historicalViolationCount = violationCount;
        this.lastKickTime = kickTime;
        this.effectiveGracePeriod = violationCount > 20 ? 0 : (violationCount > 10 ? 1 : (violationCount > 5 ? 2 : (violationCount > 0 ? 3 : 5)));
        long timeSinceKick = System.currentTimeMillis() - kickTime;
        if (kickTime > 0L && timeSinceKick < 300000L) {
            this.strictDetectionMode = true;
            this.effectiveGracePeriod = 0;
        }
    }

    public boolean isStrictDetectionMode() {
        return this.strictDetectionMode;
    }

    public int getHistoricalViolationCount() {
        return this.historicalViolationCount;
    }

    public long getLastKickTime() {
        return this.lastKickTime;
    }

    public boolean wasRecentlyKicked() {
        if (this.lastKickTime == 0L) {
            return false;
        }
        long timeSinceKick = System.currentTimeMillis() - this.lastKickTime;
        return timeSinceKick < 300000L;
    }

    public double getHorizontalDistance(Location from, Location to) {
        double dx = to.getX() - from.getX();
        double dz = to.getZ() - from.getZ();
        return Math.sqrt(dx * dx + dz * dz);
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public Location getLastLocation() {
        return this.lastLocation;
    }

    public long getLastMoveTime() {
        return this.lastMoveTime;
    }

    public double getTotalFallDistance() {
        return this.totalFallDistance;
    }

    public void setTotalFallDistance(double distance) {
        this.totalFallDistance = distance;
    }

    public void addFallDistance(double distance) {
        this.totalFallDistance += distance;
    }

    public void resetFallDistance() {
        this.totalFallDistance = 0.0;
    }

    public long getLastGroundTime() {
        return this.lastGroundTime;
    }

    public void setLastGroundTime(long time) {
        this.lastGroundTime = time;
    }

    public boolean wasOnGround() {
        return this.wasOnGround;
    }

    public void setWasOnGround(boolean onGround) {
        this.wasOnGround = onGround;
    }

    public long getLastBlockBreakTime() {
        return this.lastBlockBreakTime;
    }

    public void setLastBlockBreakTime(long time) {
        long interval;
        if (this.lastBlockBreakTime > 0L && (interval = time - this.lastBlockBreakTime) <= 3000L) {
            this.blockBreakIntervals.add(interval);
            if (interval < 100L) {
                ++this.consecutiveFastBreaks;
            } else if (interval >= 100L && interval <= 500L) {
                if (this.consecutiveFastBreaks > 0) {
                    this.consecutiveFastBreaks = Math.max(0, this.consecutiveFastBreaks - 1);
                }
            } else if (interval > 500L && interval <= 1000L) {
                this.consecutiveFastBreaks = 0;
            }
        }
        this.lastBlockBreakTime = time;
    }

    public Deque<Long> getBlockBreakIntervals() {
        return this.blockBreakIntervals.getDeque();
    }

    public int getConsecutiveFastBreaks() {
        return this.consecutiveFastBreaks;
    }

    public void resetConsecutiveFastBreaks() {
        this.consecutiveFastBreaks = 0;
    }

    public Location getLastBlockBreak() {
        return this.lastBlockBreak;
    }

    public void setLastBlockBreak(Location loc) {
        this.lastBlockBreak = loc;
    }

    public long getBlockBreakStartTime() {
        return this.blockBreakStartTime;
    }

    public void setBlockBreakStartTime(long time) {
        this.blockBreakStartTime = time;
    }

    public String getBlockBreakInitialTool() {
        return this.blockBreakInitialTool;
    }

    public void setBlockBreakInitialTool(String tool) {
        this.blockBreakInitialTool = tool;
    }

    public int getBlockBreakInitialEfficiency() {
        return this.blockBreakInitialEfficiency;
    }

    public void setBlockBreakInitialEfficiency(int efficiency) {
        this.blockBreakInitialEfficiency = efficiency;
    }

    public long getLastBlockPlaceTime() {
        return this.lastBlockPlaceTime;
    }

    public void setLastBlockPlaceTime(long time) {
        this.lastBlockPlaceTime = time;
    }

    public int getBlocksPlacedInTick() {
        return this.blocksPlacedInTick;
    }

    public void incrementBlocksPlacedInTick() {
        ++this.blocksPlacedInTick;
    }

    public void resetBlocksPlacedInTick() {
        this.blocksPlacedInTick = 0;
    }

    public int getCurrentTick() {
        return this.currentTick;
    }

    public void setCurrentTick(int tick) {
        this.currentTick = tick;
    }

    public Deque<Long> getBlockPlaceIntervals() {
        return this.blockPlaceIntervals.getDeque();
    }

    public Deque<LocationData> getBlockPlaceLocations() {
        return this.blockPlaceLocations.getDeque();
    }

    public Location getLastBlockPlace() {
        return this.lastBlockPlace;
    }

    public void setLastBlockPlace(Location loc) {
        this.lastBlockPlace = loc;
    }

    public void addBlockPlaceInterval(long interval) {
        this.blockPlaceIntervals.add(interval);
    }

    public void addBlockPlaceLocation(Location loc) {
        this.blockPlaceLocations.add(new LocationData(loc, System.currentTimeMillis()));
    }

    public Deque<LocationData> getLocationHistory() {
        return this.locationHistory.getDeque();
    }

    public Deque<Long> getClickHistory() {
        return this.clickHistory.getDeque();
    }

    public Deque<RotationData> getRotationHistory() {
        return this.rotationHistory.getDeque();
    }

    public double getAverageCPS() {
        return this.averageCPS;
    }

    public double getAverageRotationSpeed() {
        return this.averageRotationSpeed;
    }

    public double getAverageAccuracy() {
        return this.averageAccuracy;
    }

    public SkillLevel getSkillLevel() {
        return this.skillLevel;
    }

    public void incrementOutlierCount() {
        ++this.outlierCount;
    }

    public int getOutlierCount() {
        return this.outlierCount;
    }

    public void resetOutlierCount() {
        this.outlierCount = 0;
    }

    public Map<String, Double> getBaseline() {
        return this.baseline;
    }

    public void updateBaseline(String key, double value) {
        this.baseline.put(key, value);
    }

    public double getBaselineValue(String key, double defaultValue) {
        return this.baseline.getOrDefault(key, defaultValue);
    }

    public long getLastEnderPearlTime() {
        return this.lastEnderPearlTime;
    }

    public void setLastEnderPearlTime(long time) {
        this.lastEnderPearlTime = time;
    }

    public long getLastChorusFruitTime() {
        return this.lastChorusFruitTime;
    }

    public void setLastChorusFruitTime(long time) {
        this.lastChorusFruitTime = time;
    }

    public Deque<VelocityData> getVelocityHistory() {
        return this.velocityHistory.getDeque();
    }

    public void updateVelocityHistory(double velocityX, double velocityY, double velocityZ) {
        this.velocityHistory.add(new VelocityData(velocityX, velocityY, velocityZ, System.currentTimeMillis()));
        this.lastVerticalVelocity = velocityY;
    }

    public void setLastVelocityTime(long time) {
        this.lastVelocityTime = time;
    }

    public long getLastVelocityTime() {
        return this.lastVelocityTime;
    }

    public void setLastKnockbackVelocity(double velocity) {
        this.lastKnockbackVelocity = velocity;
    }

    public double getLastKnockbackVelocity() {
        return this.lastKnockbackVelocity;
    }

    public int getAirTicks() {
        return this.airTicks;
    }

    public void incrementAirTicks() {
        ++this.airTicks;
    }

    public void resetAirTicks() {
        this.airTicks = 0;
    }

    public double getLastVerticalVelocity() {
        return this.lastVerticalVelocity;
    }

    public void incrementTotalChecks() {
        ++this.totalCheckCount;
    }

    public int getTotalChecks() {
        return this.totalCheckCount;
    }

    public void incrementTotalViolations() {
        ++this.totalViolationCount;
    }

    public int getTotalViolations() {
        return this.totalViolationCount;
    }

    public double getViolationRatio() {
        if (this.totalCheckCount == 0) {
            return 0.0;
        }
        return (double)this.totalViolationCount / (double)this.totalCheckCount;
    }

    public double getHistoricalConfidenceMultiplier() {
        double ratio = this.getViolationRatio();
        if (ratio > 0.32) {
            return 1.35;
        }
        if (ratio > 0.18) {
            return 1.18;
        }
        if (ratio < 0.06) {
            return 0.82;
        }
        return 1.0;
    }

    public static enum SkillLevel {
        LOW(4, 9, 120.0, 220.0, 0.3, 0.52),
        MEDIUM(9, 14, 220.0, 380.0, 0.52, 0.72),
        HIGH(14, 22, 380.0, 650.0, 0.72, 0.88);

        public final int minCPS;
        public final int maxCPS;
        public final double minRotationSpeed;
        public final double maxRotationSpeed;
        public final double minAccuracy;
        public final double maxAccuracy;

        private SkillLevel(int minCPS, int maxCPS, double minRotationSpeed, double maxRotationSpeed, double minAccuracy, double maxAccuracy) {
            this.minCPS = minCPS;
            this.maxCPS = maxCPS;
            this.minRotationSpeed = minRotationSpeed;
            this.maxRotationSpeed = maxRotationSpeed;
            this.minAccuracy = minAccuracy;
            this.maxAccuracy = maxAccuracy;
        }
    }

    public static class ViolationRecord {
        public final ViolationType type;
        public final double severity;
        public final String details;
        public final long timestamp;

        public ViolationRecord(ViolationType type, double severity, String details, long timestamp) {
            this.type = type;
            this.severity = severity;
            this.details = details;
            this.timestamp = timestamp;
        }
    }

    public static class LocationData {
        public final Location location;
        public final long timestamp;

        public LocationData(Location location, long timestamp) {
            this.location = location;
            this.timestamp = timestamp;
        }
    }

    public static class RotationData {
        public final float yaw;
        public final float pitch;
        public final long timestamp;

        public RotationData(float yaw, float pitch, long timestamp) {
            this.yaw = yaw;
            this.pitch = pitch;
            this.timestamp = timestamp;
        }
    }

    public static class VelocityData {
        public final double x;
        public final double y;
        public final double z;
        public final long timestamp;

        public VelocityData(double x, double y, double z, long timestamp) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.timestamp = timestamp;
        }
    }
}

