/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.core;

import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class PrecisionReach {
    private static final double E8_PRECISION = 1.0E-8;
    private static final double MAX_ENTITY_REACH = 3.0;
    private static final double MAX_BLOCK_REACH = 4.5;
    private static final double PING_COMPENSATION_MULTIPLIER = 0.0028;

    public static ReachResult checkEntityReach(Player player, Entity target, int ping) {
        double threshold;
        Location eyeLocation = player.getEyeLocation();
        Vector eyePos = eyeLocation.toVector();
        Vector lookDirection = eyeLocation.getDirection().normalize();
        BoundingBox targetBox = target.getBoundingBox();
        Vector closestPoint = PrecisionReach.getClosestPointOnBox(eyePos, targetBox);
        double distance = PrecisionReach.calculatePreciseDistance(eyePos, closestPoint);
        double maxReach = 3.0;
        maxReach += (double)ping * 0.0028;
        double rayDistance = PrecisionReach.getRayBoxIntersection(eyePos, lookDirection, targetBox);
        if (rayDistance > 0.0) {
            distance = Math.min(distance, rayDistance);
        }
        if (distance <= (threshold = maxReach + 0.15)) {
            return ReachResult.valid(distance, maxReach, closestPoint);
        }
        double excess = distance - maxReach;
        double confidence = Math.min(1.0, excess / 1.5);
        String reason = String.format("Reach exceeded by %.8f blocks (%.8f > %.2f)", excess, distance, maxReach);
        return ReachResult.invalid(distance, maxReach, confidence, reason, closestPoint);
    }

    public static ReachResult checkBlockReach(Player player, Location blockLocation, int ping) {
        Location eyeLocation = player.getEyeLocation();
        Vector eyePos = eyeLocation.toVector();
        Vector blockCenter = blockLocation.toVector().add(new Vector(0.5, 0.5, 0.5));
        BoundingBox blockBox = new BoundingBox(blockLocation.getX(), blockLocation.getY(), blockLocation.getZ(), blockLocation.getX() + 1.0, blockLocation.getY() + 1.0, blockLocation.getZ() + 1.0);
        Vector closestPoint = PrecisionReach.getClosestPointOnBox(eyePos, blockBox);
        double distance = PrecisionReach.calculatePreciseDistance(eyePos, closestPoint);
        double maxReach = 4.5;
        double threshold = (maxReach += (double)ping * 0.0028) + 0.2;
        if (distance <= threshold) {
            return ReachResult.valid(distance, maxReach, closestPoint);
        }
        double excess = distance - maxReach;
        double confidence = Math.min(1.0, excess / 2.0);
        String reason = String.format("Block reach exceeded by %.8f blocks (%.8f > %.2f)", excess, distance, maxReach);
        return ReachResult.invalid(distance, maxReach, confidence, reason, closestPoint);
    }

    private static double calculatePreciseDistance(Vector from, Vector to) {
        double dx = to.getX() - from.getX();
        double dy = to.getY() - from.getY();
        double dz = to.getZ() - from.getZ();
        double distanceSquared = dx * dx + dy * dy + dz * dz;
        return Math.sqrt(distanceSquared);
    }

    private static Vector getClosestPointOnBox(Vector point, BoundingBox box) {
        double closestX = PrecisionReach.clamp(point.getX(), box.getMinX(), box.getMaxX());
        double closestY = PrecisionReach.clamp(point.getY(), box.getMinY(), box.getMaxY());
        double closestZ = PrecisionReach.clamp(point.getZ(), box.getMinZ(), box.getMaxZ());
        return new Vector(closestX, closestY, closestZ);
    }

    private static double getRayBoxIntersection(Vector rayOrigin, Vector rayDirection, BoundingBox box) {
        double tzMax;
        double tzMin;
        double tyMax;
        double tyMin;
        double tMax;
        double tMin = (box.getMinX() - rayOrigin.getX()) / rayDirection.getX();
        if (tMin > (tMax = (box.getMaxX() - rayOrigin.getX()) / rayDirection.getX())) {
            double temp = tMin;
            tMin = tMax;
            tMax = temp;
        }
        if ((tyMin = (box.getMinY() - rayOrigin.getY()) / rayDirection.getY()) > (tyMax = (box.getMaxY() - rayOrigin.getY()) / rayDirection.getY())) {
            double temp = tyMin;
            tyMin = tyMax;
            tyMax = temp;
        }
        if (tMin > tyMax || tyMin > tMax) {
            return -1.0;
        }
        if (tyMin > tMin) {
            tMin = tyMin;
        }
        if (tyMax < tMax) {
            tMax = tyMax;
        }
        if ((tzMin = (box.getMinZ() - rayOrigin.getZ()) / rayDirection.getZ()) > (tzMax = (box.getMaxZ() - rayOrigin.getZ()) / rayDirection.getZ())) {
            double temp = tzMin;
            tzMin = tzMax;
            tzMax = temp;
        }
        if (tMin > tzMax || tzMin > tMax) {
            return -1.0;
        }
        if (tzMin > tMin) {
            tMin = tzMin;
        }
        if (tMin < 0.0) {
            return -1.0;
        }
        return tMin;
    }

    private static double clamp(double value, double min, double max) {
        return Math.max(min, Math.min(max, value));
    }

    public static double getHorizontalDistance(Location from, Location to) {
        double dx = to.getX() - from.getX();
        double dz = to.getZ() - from.getZ();
        return Math.sqrt(dx * dx + dz * dz);
    }

    public static double getVerticalDistance(Location from, Location to) {
        return Math.abs(to.getY() - from.getY());
    }

    public static Vector interpolatePosition(Vector from, Vector to, double progress) {
        double x = from.getX() + (to.getX() - from.getX()) * progress;
        double y = from.getY() + (to.getY() - from.getY()) * progress;
        double z = from.getZ() + (to.getZ() - from.getZ()) * progress;
        return new Vector(x, y, z);
    }

    public static class ReachResult {
        public final double distance;
        public final double maxReach;
        public final boolean valid;
        public final double confidence;
        public final String reason;
        public final Vector closestPoint;

        public ReachResult(double distance, double maxReach, boolean valid, double confidence, String reason, Vector closest) {
            this.distance = distance;
            this.maxReach = maxReach;
            this.valid = valid;
            this.confidence = confidence;
            this.reason = reason;
            this.closestPoint = closest;
        }

        public static ReachResult valid(double distance, double maxReach, Vector closest) {
            return new ReachResult(distance, maxReach, true, 1.0, "Valid reach", closest);
        }

        public static ReachResult invalid(double distance, double maxReach, double confidence, String reason, Vector closest) {
            return new ReachResult(distance, maxReach, false, confidence, reason, closest);
        }
    }
}

