/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.core;

import NC.noChance.core.ViolationType;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Server;

public class ThresholdAdapter {
    private final Map<ViolationType, ThresholdData> thresholds = new ConcurrentHashMap<ViolationType, ThresholdData>();
    private final Deque<Double> tpsHistory = new ArrayDeque<Double>(20);
    private double currentTPSMultiplier = 1.0;
    private long lastTPSUpdate = System.currentTimeMillis();
    private static final int TPS_HISTORY_SIZE = 20;
    private static final double TARGET_TPS = 20.0;

    public ThresholdAdapter() {
        for (ViolationType type : ViolationType.values()) {
            this.thresholds.put(type, new ThresholdData(type));
        }
    }

    public void updateTPS() {
        long now = System.currentTimeMillis();
        if (now - this.lastTPSUpdate < 1000L) {
            return;
        }
        this.lastTPSUpdate = now;
        try {
            double tps = this.getTPS();
            if (this.tpsHistory.size() >= 20) {
                this.tpsHistory.pollFirst();
            }
            this.tpsHistory.addLast(tps);
            double avgTPS = this.tpsHistory.stream().mapToDouble(Double::doubleValue).average().orElse(20.0);
            this.currentTPSMultiplier = avgTPS < 15.0 ? 1.5 : (avgTPS < 17.0 ? 1.3 : (avgTPS < 19.0 ? 1.15 : 1.0));
        }
        catch (Exception e) {
            this.currentTPSMultiplier = 1.0;
        }
    }

    private double getTPS() {
        try {
            Server server = Bukkit.getServer();
            Object minecraftServer = server.getClass().getMethod("getServer", new Class[0]).invoke((Object)server, new Object[0]);
            double[] recentTps = (double[])minecraftServer.getClass().getField("recentTps").get(minecraftServer);
            return recentTps[0];
        }
        catch (Exception e) {
            return 20.0;
        }
    }

    public double getAdjustedThreshold(ViolationType type) {
        ThresholdData data = this.thresholds.get((Object)type);
        if (data == null) {
            return 0.7;
        }
        return data.currentThreshold * this.currentTPSMultiplier;
    }

    public double getToleranceMultiplier(ViolationType type) {
        return this.currentTPSMultiplier;
    }

    public void recordFalsePositive(ViolationType type) {
        ThresholdData data = this.thresholds.get((Object)type);
        if (data == null) {
            return;
        }
        ++data.falsePositiveCount;
        this.adjustThreshold(data);
    }

    public void recordTruePositive(ViolationType type) {
        ThresholdData data = this.thresholds.get((Object)type);
        if (data == null) {
            return;
        }
        ++data.truePositiveCount;
        this.adjustThreshold(data);
    }

    private void adjustThreshold(ThresholdData data) {
        long now = System.currentTimeMillis();
        if (now - data.lastAdjustment < 300000L) {
            return;
        }
        int totalSamples = data.falsePositiveCount + data.truePositiveCount;
        if (totalSamples < 20) {
            return;
        }
        double falsePositiveRate = (double)data.falsePositiveCount / (double)totalSamples;
        if (falsePositiveRate > 0.15) {
            data.currentThreshold = Math.min(0.95, data.currentThreshold + 0.05);
        } else if (falsePositiveRate < 0.03 && data.truePositiveCount > data.falsePositiveCount * 5) {
            data.currentThreshold = Math.max(0.55, data.currentThreshold - 0.03);
        }
        data.lastAdjustment = now;
        data.falsePositiveCount = 0;
        data.truePositiveCount = 0;
    }

    public double getCurrentTPSMultiplier() {
        return this.currentTPSMultiplier;
    }

    public double getAverageTPS() {
        return this.tpsHistory.stream().mapToDouble(Double::doubleValue).average().orElse(20.0);
    }

    public boolean isServerLagging() {
        return this.getAverageTPS() < 18.0;
    }

    private static class ThresholdData {
        private final ViolationType type;
        private double baseThreshold;
        private double currentThreshold;
        private int falsePositiveCount;
        private int truePositiveCount;
        private long lastAdjustment;

        public ThresholdData(ViolationType type) {
            this.type = type;
            this.baseThreshold = 0.7;
            this.currentThreshold = 0.7;
            this.falsePositiveCount = 0;
            this.truePositiveCount = 0;
            this.lastAdjustment = System.currentTimeMillis();
        }
    }
}

