/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.core;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TimingStats {
    private static final int MAX_SAMPLES = 50;
    private static final double ZSCORE_THRESHOLD = 3.2;

    public static TimingPattern analyzeTimings(Deque<Long> timings) {
        if (timings.size() < 5) {
            return new TimingPattern(0.0, 0.0, 0.0, 0.0, 0.0, false, 0.0, false, "Insufficient data");
        }
        List<Long> samples = new ArrayList<Long>(timings);
        if (samples.size() > 50) {
            samples = samples.subList(samples.size() - 50, samples.size());
        }
        double mean = samples.stream().mapToLong(Long::longValue).average().orElse(0.0);
        double variance = samples.stream().mapToDouble(v -> Math.pow((double)v.longValue() - mean, 2.0)).average().orElse(0.0);
        double stdDev = Math.sqrt(variance);
        double cv = mean > 0.01 ? stdDev / mean : 0.0;
        long lastValue = samples.get(samples.size() - 1);
        double zScore = stdDev > 0.0 ? Math.abs(((double)lastValue - mean) / stdDev) : 0.0;
        boolean suspicious = false;
        double severity = 0.0;
        boolean macroDetected = false;
        String reason = "Clean";
        if (cv < 0.08 && mean < 120.0) {
            suspicious = true;
            severity = Math.min(1.0, (0.08 - cv) / 0.08 * 0.95);
            reason = String.format("Bot-like consistency: CV=%.3f, Mean=%.1fms", cv, mean);
        } else if (zScore > 3.2 && (double)lastValue < mean * 0.5) {
            suspicious = true;
            severity = Math.min(1.0, zScore / 10.0);
            reason = String.format("Anomalous fast timing: Z=%.2f", zScore);
        } else if ((double)samples.stream().filter(v -> v < 50L).count() >= (double)samples.size() * 0.7) {
            suspicious = true;
            severity = 0.82;
            reason = "70%+ timings under 50ms";
        }
        if (TimingStats.detectMacroPattern(new ArrayDeque<Long>(samples))) {
            macroDetected = true;
            if (!suspicious) {
                severity = 0.88;
            }
        }
        return new TimingPattern(mean, stdDev, variance, cv, zScore, suspicious, severity, macroDetected, reason);
    }

    public static boolean hasConsistentPattern(List<Long> intervals, int minCount) {
        if (intervals.size() < minCount) {
            return false;
        }
        HashMap<Long, Integer> frequencyMap = new HashMap<Long, Integer>();
        for (Long interval : intervals) {
            long rounded = interval / 10L * 10L;
            frequencyMap.put(rounded, frequencyMap.getOrDefault(rounded, 0) + 1);
        }
        int maxFrequency = frequencyMap.values().stream().max(Integer::compareTo).orElse(0);
        return maxFrequency >= minCount && (double)maxFrequency >= (double)intervals.size() * 0.6;
    }

    public static double calculateEntropy(List<Long> values) {
        if (values.isEmpty()) {
            return 0.0;
        }
        HashMap<Long, Integer> frequency = new HashMap<Long, Integer>();
        for (Long value : values) {
            long bucket = value / 20L * 20L;
            frequency.put(bucket, frequency.getOrDefault(bucket, 0) + 1);
        }
        double entropy = 0.0;
        int total = values.size();
        Iterator iterator = frequency.values().iterator();
        while (iterator.hasNext()) {
            int count = (Integer)iterator.next();
            double probability = (double)count / (double)total;
            if (!(probability > 0.0)) continue;
            entropy -= probability * (Math.log(probability) / Math.log(2.0));
        }
        return entropy;
    }

    public static boolean detectMacroPattern(Deque<Long> intervals) {
        if (intervals.size() < 8) {
            return false;
        }
        ArrayList<Long> list = new ArrayList<Long>(intervals);
        List<Long> recentIntervals = list.subList(Math.max(0, list.size() - 10), list.size());
        double entropy = TimingStats.calculateEntropy(recentIntervals);
        if (entropy < 1.2) {
            return true;
        }
        long mode = TimingStats.findMode(recentIntervals);
        long modeCount = recentIntervals.stream().filter(v -> Math.abs(v - mode) < 15L).count();
        return (double)modeCount >= (double)recentIntervals.size() * 0.65;
    }

    private static long findMode(List<Long> values) {
        HashMap<Long, Integer> frequency = new HashMap<Long, Integer>();
        for (Long value : values) {
            long bucket = value / 10L * 10L;
            frequency.put(bucket, frequency.getOrDefault(bucket, 0) + 1);
        }
        return frequency.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(0L);
    }

    public static class TimingPattern {
        public final double mean;
        public final double stdDev;
        public final double variance;
        public final double coefficientOfVariation;
        public final double zScore;
        public final boolean suspicious;
        public final double severity;
        public final boolean macroDetected;
        public final String reason;

        public TimingPattern(double mean, double stdDev, double variance, double cv, double zScore, boolean suspicious, double severity, boolean macroDetected, String reason) {
            this.mean = mean;
            this.stdDev = stdDev;
            this.variance = variance;
            this.coefficientOfVariation = cv;
            this.zScore = zScore;
            this.suspicious = suspicious;
            this.severity = severity;
            this.macroDetected = macroDetected;
            this.reason = reason;
        }
    }
}

