/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.core;

import NC.noChance.core.EnchantHelper;
import NC.noChance.core.WaterHelper;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ToolSpeed {
    public static BreakSpeedData calculate(Player player, Block block) {
        ItemStack tool;
        PotionEffect fatigue;
        PotionEffectType fatigueType;
        PotionEffect haste;
        BreakSpeedData data = new BreakSpeedData();
        StringBuilder details = new StringBuilder();
        if (player.getGameMode() == GameMode.CREATIVE) {
            data.canInstamine = true;
            data.details = "Creative Mode";
            return data;
        }
        PotionEffectType hasteType = PotionEffectType.getByName((String)"HASTE");
        if (hasteType == null) {
            hasteType = PotionEffectType.getByName((String)"FAST_DIGGING");
        }
        if (hasteType != null && (haste = player.getPotionEffect(hasteType)) != null) {
            data.hasteLevel = haste.getAmplifier() + 1;
            details.append("Haste ").append(data.hasteLevel).append(", ");
        }
        if ((fatigueType = PotionEffectType.getByName((String)"MINING_FATIGUE")) == null) {
            fatigueType = PotionEffectType.getByName((String)"SLOW_DIGGING");
        }
        if (fatigueType != null && (fatigue = player.getPotionEffect(fatigueType)) != null) {
            int level = fatigue.getAmplifier() + 1;
            data.speedMultiplier *= 1.0 - (double)level * 0.3;
            details.append("Mining Fatigue ").append(level).append(", ");
        }
        if ((tool = player.getInventory().getItemInMainHand()) != null && tool.getType() != Material.AIR) {
            data.efficiencyLevel = EnchantHelper.getEfficiencyLevel(tool);
            String toolName = tool.getType().name().toUpperCase();
            Material blockType = block.getType();
            if (toolName.contains("PICKAXE")) {
                if (ToolSpeed.isPickaxeBlock(blockType)) {
                    data.hasCorrectTool = true;
                }
                data.toolMaterial = ToolSpeed.extractToolMaterial(toolName);
            } else if (toolName.contains("AXE") && !toolName.contains("PICKAXE")) {
                if (ToolSpeed.isAxeBlock(blockType)) {
                    data.hasCorrectTool = true;
                }
                data.toolMaterial = ToolSpeed.extractToolMaterial(toolName);
            } else if (toolName.contains("SHOVEL") || toolName.contains("SPADE")) {
                if (ToolSpeed.isShovelBlock(blockType)) {
                    data.hasCorrectTool = true;
                }
                data.toolMaterial = ToolSpeed.extractToolMaterial(toolName);
            } else if (toolName.contains("HOE")) {
                if (ToolSpeed.isHoeBlock(blockType)) {
                    data.hasCorrectTool = true;
                }
                data.toolMaterial = ToolSpeed.extractToolMaterial(toolName);
            } else if (toolName.contains("SWORD")) {
                if (ToolSpeed.isSwordBlock(blockType)) {
                    data.hasCorrectTool = true;
                }
                data.toolMaterial = ToolSpeed.extractToolMaterial(toolName);
            } else if (toolName.contains("SHEARS")) {
                if (ToolSpeed.isShearsBlock(blockType)) {
                    data.hasCorrectTool = true;
                }
                data.toolMaterial = "HAND";
            }
            if (data.hasCorrectTool) {
                details.append(data.toolMaterial).append(" Tool, ");
            }
            if (data.efficiencyLevel > 0) {
                details.append("Efficiency ").append(data.efficiencyLevel).append(", ");
            }
            if (data.toolMaterial.equals("NETHERITE") && data.efficiencyLevel >= 5 && data.hasteLevel >= 2) {
                data.canInstamine = true;
                details.append("Instamine Capable, ");
            } else if (data.toolMaterial.equals("DIAMOND") && data.efficiencyLevel >= 5 && data.hasteLevel >= 2) {
                data.canInstamine = true;
                details.append("Instamine Capable, ");
            } else if (data.toolMaterial.equals("GOLDEN") && data.efficiencyLevel >= 5) {
                data.canInstamine = true;
                details.append("Instamine Capable, ");
            }
        }
        if (WaterHelper.isInWater(player) && !EnchantHelper.hasAquaAffinity(player.getInventory().getHelmet())) {
            data.underwaterPenalty = 0.2;
            details.append("Underwater Penalty, ");
        }
        if (!player.isOnGround() && !player.isFlying()) {
            data.midairPenalty = 0.2;
            details.append("Midair Penalty, ");
        }
        data.details = details.length() > 0 ? details.substring(0, details.length() - 2) : "None";
        return data;
    }

    private static String extractToolMaterial(String toolName) {
        if (toolName.contains("NETHERITE")) {
            return "NETHERITE";
        }
        if (toolName.contains("DIAMOND")) {
            return "DIAMOND";
        }
        if (toolName.contains("GOLDEN")) {
            return "GOLDEN";
        }
        if (toolName.contains("IRON")) {
            return "IRON";
        }
        if (toolName.contains("STONE")) {
            return "STONE";
        }
        if (toolName.contains("WOODEN") || toolName.contains("WOOD")) {
            return "WOOD";
        }
        return "HAND";
    }

    private static boolean isPickaxeBlock(Material type) {
        String name = type.name();
        return name.contains("STONE") || name.contains("COBBLESTONE") || name.contains("ANDESITE") || name.contains("DIORITE") || name.contains("GRANITE") || name.contains("NETHERRACK") || name.contains("BASALT") || name.contains("BLACKSTONE") || name.contains("TERRACOTTA") || name.contains("BRICKS") || name.contains("PRISMARINE") || name.contains("SANDSTONE") || name.contains("DEEPSLATE") || type == Material.END_STONE || type == Material.OBSIDIAN || type == Material.CRYING_OBSIDIAN || name.contains("_ORE") || type == Material.ANCIENT_DEBRIS || type == Material.GILDED_BLACKSTONE || name.contains("IRON_BLOCK") || name.contains("GOLD_BLOCK") || name.contains("DIAMOND_BLOCK") || name.contains("EMERALD_BLOCK") || name.contains("NETHERITE_BLOCK") || name.contains("COPPER") || name.contains("REDSTONE") || type == Material.OBSERVER || type == Material.DISPENSER || type == Material.DROPPER || type == Material.HOPPER || type == Material.PISTON || type == Material.STICKY_PISTON;
    }

    private static boolean isAxeBlock(Material type) {
        String name = type.name();
        return name.contains("LOG") || name.contains("WOOD") && !name.contains("SWORD") || name.contains("PLANKS") || type == Material.CRAFTING_TABLE || name.contains("CHEST") || name.contains("BARREL") || name.contains("BOOKSHELF") || name.contains("LECTERN") || name.contains("CAMPFIRE") || name.contains("FENCE") || name.contains("STAIRS") || name.contains("_STEM") || name.contains("HYPHAE") || name.contains("MUSHROOM_BLOCK");
    }

    private static boolean isShovelBlock(Material type) {
        String name = type.name();
        return name.contains("DIRT") || type == Material.GRASS_BLOCK || type == Material.MYCELIUM || type == Material.PODZOL || type == Material.CLAY || name.contains("FARMLAND") || type == Material.ROOTED_DIRT || type == Material.COARSE_DIRT || type == Material.MUD || name.contains("MUDDY") || name.contains("SAND") || name.contains("GRAVEL") || name.contains("CONCRETE_POWDER") || type == Material.SOUL_SAND || type == Material.SOUL_SOIL || type == Material.SNOW || type == Material.SNOW_BLOCK || type == Material.POWDER_SNOW;
    }

    private static boolean isHoeBlock(Material type) {
        String name = type.name();
        return name.contains("LEAVES") || name.contains("SAPLING") || type == Material.WHEAT || type == Material.CARROTS || type == Material.POTATOES || type == Material.BEETROOTS || type == Material.NETHER_WART || name.contains("WART_BLOCK") || type == Material.HAY_BLOCK || type == Material.DRIED_KELP_BLOCK || type == Material.TARGET || type == Material.SPONGE || type == Material.WET_SPONGE;
    }

    private static boolean isSwordBlock(Material type) {
        String name = type.name();
        return name.contains("LEAVES") || type == Material.COBWEB || name.contains("VINE") || type == Material.BAMBOO || type == Material.SUGAR_CANE || name.contains("MELON");
    }

    private static boolean isShearsBlock(Material type) {
        String name = type.name();
        return name.contains("WOOL") || name.contains("CARPET") || name.contains("LEAVES") || type == Material.COBWEB || name.contains("VINE") || name.contains("SEAGRASS") || type == Material.GLOW_LICHEN || name.contains("HANGING_ROOTS");
    }

    public static class BreakSpeedData {
        public double speedMultiplier = 1.0;
        public int efficiencyLevel = 0;
        public int hasteLevel = 0;
        public String toolMaterial = "HAND";
        public boolean hasCorrectTool = false;
        public boolean canInstamine = false;
        public double underwaterPenalty = 1.0;
        public double midairPenalty = 1.0;
        public String details = "None";

        public double getFinalSpeedMultiplier() {
            double speed = 1.0;
            if (this.hasCorrectTool) {
                switch (this.toolMaterial) {
                    case "NETHERITE": {
                        speed = 9.0;
                        break;
                    }
                    case "DIAMOND": {
                        speed = 8.0;
                        break;
                    }
                    case "GOLDEN": {
                        speed = 12.0;
                        break;
                    }
                    case "IRON": {
                        speed = 6.0;
                        break;
                    }
                    case "STONE": {
                        speed = 4.0;
                        break;
                    }
                    case "WOOD": {
                        speed = 2.0;
                    }
                }
            } else {
                speed = 1.0;
            }
            if (this.efficiencyLevel > 0) {
                speed += (double)(this.efficiencyLevel * this.efficiencyLevel) + 1.0;
            }
            if (this.hasteLevel > 0) {
                speed *= 1.0 + 0.2 * (double)this.hasteLevel;
            }
            speed *= this.speedMultiplier;
            speed *= this.underwaterPenalty;
            return speed *= this.midairPenalty;
        }
    }
}

