/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.core;

import NC.noChance.core.ViolationType;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class VariantCheck {
    private final Map<UUID, VariantAssignment> playerVariants = new ConcurrentHashMap<UUID, VariantAssignment>();
    private final Map<ViolationType, VariantConfig> variantConfigs = new ConcurrentHashMap<ViolationType, VariantConfig>();
    private final Map<ViolationType, Map<String, VariantMetrics>> metrics = new ConcurrentHashMap<ViolationType, Map<String, VariantMetrics>>();
    private final Random random = new Random();
    private static final double VARIANT_A_RATIO = 0.4;
    private static final double VARIANT_B_RATIO = 0.4;
    private static final double VARIANT_C_RATIO = 0.2;
    private static final int MIN_SAMPLES_FOR_ANALYSIS = 100;
    private static final double CONFIDENCE_THRESHOLD = 0.05;

    public VariantCheck() {
        this.initializeDefaultConfigs();
    }

    private void initializeDefaultConfigs() {
        this.variantConfigs.put(ViolationType.REACH, new VariantConfig(new ThresholdSet(3.1, 0.66, 0.75), new ThresholdSet(3.3, 0.7, 0.8), new ThresholdSet(3.5, 0.72, 0.82)));
        this.variantConfigs.put(ViolationType.FLY, new VariantConfig(new ThresholdSet(0.18, 0.66, 0.7), new ThresholdSet(0.22, 0.68, 0.72), new ThresholdSet(0.25, 0.7, 0.74)));
        this.variantConfigs.put(ViolationType.SPEED, new VariantConfig(new ThresholdSet(0.28, 0.65, 0.72), new ThresholdSet(0.32, 0.68, 0.74), new ThresholdSet(0.35, 0.7, 0.76)));
        this.variantConfigs.put(ViolationType.KILLAURA, new VariantConfig(new ThresholdSet(180.0, 0.7, 0.78), new ThresholdSet(160.0, 0.72, 0.8), new ThresholdSet(140.0, 0.74, 0.82)));
        this.variantConfigs.put(ViolationType.AUTOCLICKER, new VariantConfig(new ThresholdSet(22.0, 0.68, 0.76), new ThresholdSet(24.0, 0.7, 0.78), new ThresholdSet(26.0, 0.72, 0.8)));
        this.variantConfigs.put(ViolationType.FASTBREAK, new VariantConfig(new ThresholdSet(0.85, 0.65, 0.72), new ThresholdSet(0.8, 0.68, 0.74), new ThresholdSet(0.75, 0.7, 0.76)));
        this.variantConfigs.put(ViolationType.SCAFFOLD, new VariantConfig(new ThresholdSet(4.0, 0.66, 0.74), new ThresholdSet(5.0, 0.68, 0.76), new ThresholdSet(6.0, 0.7, 0.78)));
        this.variantConfigs.put(ViolationType.VELOCITY, new VariantConfig(new ThresholdSet(0.7, 0.68, 0.75), new ThresholdSet(0.65, 0.7, 0.77), new ThresholdSet(0.6, 0.72, 0.79)));
        for (ViolationType type : this.variantConfigs.keySet()) {
            ConcurrentHashMap<String, VariantMetrics> typeMetrics = new ConcurrentHashMap<String, VariantMetrics>();
            typeMetrics.put("A", new VariantMetrics());
            typeMetrics.put("B", new VariantMetrics());
            typeMetrics.put("C", new VariantMetrics());
            this.metrics.put(type, typeMetrics);
        }
    }

    public String getPlayerVariant(UUID playerId, ViolationType type) {
        VariantAssignment assignment = this.playerVariants.computeIfAbsent(playerId, k -> this.assignVariant());
        return assignment.getVariant(type);
    }

    private VariantAssignment assignVariant() {
        HashMap<ViolationType, String> assignments = new HashMap<ViolationType, String>();
        for (ViolationType type : ViolationType.values()) {
            double roll = this.random.nextDouble();
            String variant = roll < 0.4 ? "A" : (roll < 0.8 ? "B" : (roll < 1.0 ? "C" : "A"));
            assignments.put(type, variant);
        }
        return new VariantAssignment(assignments);
    }

    public ThresholdSet getThresholds(UUID playerId, ViolationType type) {
        if (!this.variantConfigs.containsKey((Object)type)) {
            return new ThresholdSet(0.0, 0.66, 0.75);
        }
        String variant = this.getPlayerVariant(playerId, type);
        VariantConfig config = this.variantConfigs.get((Object)type);
        switch (variant) {
            case "A": {
                return config.variantA;
            }
            case "B": {
                return config.variantB;
            }
            case "C": {
                return config.variantC;
            }
        }
        return config.variantA;
    }

    public void recordDetection(UUID playerId, ViolationType type, boolean truePositive) {
        if (!this.metrics.containsKey((Object)type)) {
            return;
        }
        String variant = this.getPlayerVariant(playerId, type);
        VariantMetrics variantMetrics = this.metrics.get((Object)type).get(variant);
        if (variantMetrics != null) {
            variantMetrics.recordDetection(truePositive);
        }
    }

    public void recordFalsePositive(UUID playerId, ViolationType type) {
        if (!this.metrics.containsKey((Object)type)) {
            return;
        }
        String variant = this.getPlayerVariant(playerId, type);
        VariantMetrics variantMetrics = this.metrics.get((Object)type).get(variant);
        if (variantMetrics != null) {
            variantMetrics.recordFalsePositive();
        }
    }

    public VariantAnalysis analyzeVariants(ViolationType type) {
        if (!this.metrics.containsKey((Object)type)) {
            return new VariantAnalysis("A", 0.0, false);
        }
        Map<String, VariantMetrics> typeMetrics = this.metrics.get((Object)type);
        VariantMetrics metricsA = typeMetrics.get("A");
        VariantMetrics metricsB = typeMetrics.get("B");
        VariantMetrics metricsC = typeMetrics.get("C");
        if (metricsA.getTotalSamples() < 100 || metricsB.getTotalSamples() < 100 || metricsC.getTotalSamples() < 100) {
            return new VariantAnalysis("A", 0.0, false);
        }
        double scoreA = metricsA.getAccuracyScore();
        double scoreB = metricsB.getAccuracyScore();
        double scoreC = metricsC.getAccuracyScore();
        String bestVariant = "A";
        double bestScore = scoreA;
        if (scoreB > bestScore) {
            bestVariant = "B";
            bestScore = scoreB;
        }
        if (scoreC > bestScore) {
            bestVariant = "C";
            bestScore = scoreC;
        }
        double secondBestScore = Math.max(bestVariant.equals("A") ? Math.max(scoreB, scoreC) : Math.max(scoreA, bestVariant.equals("B") ? scoreC : scoreB), 0.0);
        double improvement = bestScore - secondBestScore;
        boolean significant = improvement > 0.05 && bestScore > 0.8;
        return new VariantAnalysis(bestVariant, improvement, significant);
    }

    public Map<String, String> getMetricsSummary(ViolationType type) {
        if (!this.metrics.containsKey((Object)type)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> summary = new HashMap<String, String>();
        Map<String, VariantMetrics> typeMetrics = this.metrics.get((Object)type);
        for (Map.Entry<String, VariantMetrics> entry : typeMetrics.entrySet()) {
            String variant = entry.getKey();
            VariantMetrics m = entry.getValue();
            summary.put(variant + "_samples", String.valueOf(m.getTotalSamples()));
            summary.put(variant + "_accuracy", String.format("%.2f%%", m.getAccuracyScore() * 100.0));
            summary.put(variant + "_fp_rate", String.format("%.2f%%", m.getFalsePositiveRate() * 100.0));
            summary.put(variant + "_tp_rate", String.format("%.2f%%", m.getTruePositiveRate() * 100.0));
        }
        return summary;
    }

    public void cleanup(UUID playerId) {
        this.playerVariants.remove(playerId);
    }

    private static class VariantConfig {
        private final ThresholdSet variantA;
        private final ThresholdSet variantB;
        private final ThresholdSet variantC;

        private VariantConfig(ThresholdSet variantA, ThresholdSet variantB, ThresholdSet variantC) {
            this.variantA = variantA;
            this.variantB = variantB;
            this.variantC = variantC;
        }
    }

    public static class ThresholdSet {
        public final double primaryThreshold;
        public final double minConfidence;
        public final double highConfidence;

        public ThresholdSet(double primaryThreshold, double minConfidence, double highConfidence) {
            this.primaryThreshold = primaryThreshold;
            this.minConfidence = minConfidence;
            this.highConfidence = highConfidence;
        }
    }

    private static class VariantMetrics {
        private int truePositives = 0;
        private int falsePositives = 0;
        private int totalDetections = 0;

        private VariantMetrics() {
        }

        private synchronized void recordDetection(boolean truePositive) {
            ++this.totalDetections;
            if (truePositive) {
                ++this.truePositives;
            }
        }

        private synchronized void recordFalsePositive() {
            ++this.falsePositives;
        }

        private int getTotalSamples() {
            return this.totalDetections + this.falsePositives;
        }

        private double getTruePositiveRate() {
            if (this.totalDetections == 0) {
                return 0.0;
            }
            return (double)this.truePositives / (double)this.totalDetections;
        }

        private double getFalsePositiveRate() {
            int total = this.getTotalSamples();
            if (total == 0) {
                return 0.0;
            }
            return (double)this.falsePositives / (double)total;
        }

        private double getAccuracyScore() {
            int total = this.getTotalSamples();
            if (total == 0) {
                return 0.0;
            }
            double tpRate = this.getTruePositiveRate();
            double fpRate = this.getFalsePositiveRate();
            return tpRate * 0.7 + (1.0 - fpRate) * 0.3;
        }
    }

    private static class VariantAssignment {
        private final Map<ViolationType, String> assignments;

        private VariantAssignment(Map<ViolationType, String> assignments) {
            this.assignments = assignments;
        }

        private String getVariant(ViolationType type) {
            return this.assignments.getOrDefault((Object)type, "A");
        }
    }

    public static class VariantAnalysis {
        public final String bestVariant;
        public final double improvement;
        public final boolean statistically_significant;

        private VariantAnalysis(String bestVariant, double improvement, boolean significant) {
            this.bestVariant = bestVariant;
            this.improvement = improvement;
            this.statistically_significant = significant;
        }
    }
}

