/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.core;

import NC.noChance.core.ViolationType;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class ViolationQueue {
    private final Map<UUID, Map<ViolationType, BufferData>> buffers = new ConcurrentHashMap<UUID, Map<ViolationType, BufferData>>();
    private static final int BUFFER_SIZE = 3;
    private static final long BUFFER_WINDOW_MS = 2000L;

    public boolean shouldFlag(UUID playerId, ViolationType type, double severity, String details) {
        Map playerBuffers = this.buffers.computeIfAbsent(playerId, k -> new ConcurrentHashMap());
        BufferData buffer = playerBuffers.computeIfAbsent(type, k -> new BufferData());
        long now = System.currentTimeMillis();
        buffer.instances.removeIf(instance -> now - instance.timestamp > 2000L);
        buffer.instances.addLast(new ViolationInstance(severity, details));
        buffer.lastViolationTime = now;
        if (buffer.instances.size() > 10) {
            buffer.instances.pollFirst();
        }
        if (severity >= 0.95) {
            return true;
        }
        if (buffer.instances.size() < 3) {
            return false;
        }
        double avgSeverity = buffer.instances.stream().mapToDouble(i -> i.severity).average().orElse(0.0);
        if (avgSeverity >= 0.75) {
            return true;
        }
        long highSeverityCount = buffer.instances.stream().filter(i -> i.severity >= 0.7).count();
        return highSeverityCount >= 3L;
    }

    public void reset(UUID playerId, ViolationType type) {
        Map<ViolationType, BufferData> playerBuffers = this.buffers.get(playerId);
        if (playerBuffers != null) {
            playerBuffers.remove((Object)type);
        }
    }

    public void cleanup(UUID playerId) {
        this.buffers.remove(playerId);
    }

    public int getViolationCount(UUID playerId, ViolationType type) {
        Map<ViolationType, BufferData> playerBuffers = this.buffers.get(playerId);
        if (playerBuffers == null) {
            return 0;
        }
        BufferData buffer = playerBuffers.get((Object)type);
        if (buffer == null) {
            return 0;
        }
        return buffer.instances.size();
    }

    public double getAverageSeverity(UUID playerId, ViolationType type) {
        Map<ViolationType, BufferData> playerBuffers = this.buffers.get(playerId);
        if (playerBuffers == null) {
            return 0.0;
        }
        BufferData buffer = playerBuffers.get((Object)type);
        if (buffer == null) {
            return 0.0;
        }
        return buffer.instances.stream().mapToDouble(i -> i.severity).average().orElse(0.0);
    }

    private static class BufferData {
        private final Deque<ViolationInstance> instances = new ArrayDeque<ViolationInstance>();
        private long lastViolationTime = 0L;
    }

    private static class ViolationInstance {
        public final double severity;
        public final long timestamp;
        public final String details;

        public ViolationInstance(double severity, String details) {
            this.severity = severity;
            this.timestamp = System.currentTimeMillis();
            this.details = details;
        }
    }
}

