/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.core;

import NC.noChance.alerts.StaffAlertManager;
import NC.noChance.core.ACConfig;
import NC.noChance.core.AdaptiveSamplingSystem;
import NC.noChance.core.CheckResult;
import NC.noChance.core.DetectionEngine;
import NC.noChance.core.PlayerData;
import NC.noChance.core.ViolationType;
import NC.noChance.database.DatabaseManager;
import NC.noChance.punishment.PunishmentManager;
import NC.noChance.replay.ReplayMgr;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ViolationScoring {
    private final ACConfig config;
    private final Map<UUID, PlayerData> playerDataMap;
    private final DatabaseManager database;
    private final PunishmentManager punishmentManager;
    private final StaffAlertManager alertManager;
    private final DetectionEngine detectionEngine;
    private final AdaptiveSamplingSystem samplingSystem;
    private ReplayMgr replayMgr;

    public ViolationScoring(ACConfig config, Map<UUID, PlayerData> playerDataMap, DatabaseManager database, PunishmentManager punishmentManager, StaffAlertManager alertManager, DetectionEngine detectionEngine, AdaptiveSamplingSystem samplingSystem) {
        this.config = config;
        this.playerDataMap = playerDataMap;
        this.database = database;
        this.punishmentManager = punishmentManager;
        this.alertManager = alertManager;
        this.detectionEngine = detectionEngine;
        this.samplingSystem = samplingSystem;
    }

    public void setReplayMgr(ReplayMgr replayMgr) {
        this.replayMgr = replayMgr;
    }

    public double calculateViolationScore(UUID playerId, long timeWindow) {
        PlayerData data = this.playerDataMap.get(playerId);
        if (data == null) {
            return 0.0;
        }
        double finalScore = 0.0;
        for (ViolationType type : ViolationType.values()) {
            List<PlayerData.ViolationRecord> violations = data.getViolations(type, timeWindow);
            if (violations.isEmpty()) continue;
            double typeWeight = type.getWeight();
            double frequency = (double)violations.size() / ((double)timeWindow / 1000.0);
            double avgSeverity = violations.stream().mapToDouble(v -> v.severity).average().orElse(0.0);
            finalScore += typeWeight * frequency * avgSeverity;
        }
        return finalScore;
    }

    public ConfidenceLevel getConfidenceLevel(double score) {
        double highThreshold = this.config.getHighConfidenceThreshold();
        double mediumThreshold = this.config.getMediumConfidenceThreshold();
        double lowThreshold = this.config.getLowConfidenceThreshold();
        if (score >= highThreshold) {
            return ConfidenceLevel.HIGH;
        }
        if (score >= mediumThreshold) {
            return ConfidenceLevel.MEDIUM;
        }
        if (score >= lowThreshold) {
            return ConfidenceLevel.LOW;
        }
        return ConfidenceLevel.NONE;
    }

    public void handleViolation(Player player, CheckResult result) {
        this.handleViolationWithAdvancedMetrics(player, result, 0.0, "Legacy");
    }

    public void handleViolationWithAdvancedMetrics(Player player, CheckResult result, double advancedScore, String detectionMethod) {
        String finalDetectionMethod;
        double finalScore;
        boolean useAdvancedAnalysis;
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data == null) {
            return;
        }
        data.incrementTotalChecks();
        if (!result.isFailed()) {
            return;
        }
        if (this.config.isOpExempt() && player.isOp()) {
            return;
        }
        if (data.isInGracePeriod(this.config.getGracePeriod())) {
            return;
        }
        boolean bl = useAdvancedAnalysis = data.getTotalChecks() >= this.config.getAdvancedAnalysisWarmupChecks() && this.config.isAdaptiveSamplingEnabled();
        if (useAdvancedAnalysis && data.getTotalChecks() >= this.config.getAdaptiveSamplingWarmupChecks() && !this.samplingSystem.shouldCheck(player, result.getViolationType())) {
            return;
        }
        DetectionEngine.AnalysisResult analysis = null;
        if (useAdvancedAnalysis) {
            analysis = this.detectionEngine.analyze(player, data, result, result.getViolationType());
            if (!analysis.shouldFlag && data.getTotalChecks() > this.config.getAdvancedAnalysisStrictThreshold()) {
                return;
            }
        }
        data.incrementTotalViolations();
        data.addViolation(result.getViolationType(), result.getSeverity(), result.getDetails());
        long timeWindow = (long)this.config.getTimeWindow() * 1000L;
        double score = this.calculateViolationScore(player.getUniqueId(), timeWindow);
        double histMult = data.getHistoricalConfidenceMultiplier();
        score *= histMult;
        String variant = "";
        if (analysis != null && analysis.confidence > 0.0) {
            finalScore = analysis.confidence * analysis.punishmentMultiplier;
            finalDetectionMethod = analysis.detectionMethod;
            variant = analysis.variant != null ? analysis.variant : "";
        } else if (advancedScore > 0.0) {
            finalScore = advancedScore;
            finalDetectionMethod = detectionMethod;
        } else {
            finalScore = score;
            finalDetectionMethod = detectionMethod;
        }
        if (result.getViolationType() == ViolationType.NOSLOW) {
            variant = this.extractNoSlowVariant(result.getDetails());
        }
        ConfidenceLevel confidence = this.getConfidenceLevel(finalScore);
        if (this.replayMgr != null) {
            boolean shouldSave;
            boolean bl2 = shouldSave = confidence == ConfidenceLevel.HIGH && this.config.shouldSaveReplayOnHigh() || finalScore >= this.config.getHighConfidenceThreshold() * 1.1 && this.config.shouldSaveReplayOnExtreme();
            if (shouldSave) {
                this.replayMgr.saveReplay(player, result.getViolationType(), confidence.name());
            }
        }
        this.database.logViolation(player.getUniqueId(), player.getName(), result.getViolationType(), result.getSeverity(), result.getDetails(), confidence.name(), finalDetectionMethod);
        this.alertManager.sendAlert(player, result.getViolationType(), result.getSeverity(), result.getDetails(), confidence.name(), finalScore, finalDetectionMethod, variant);
        this.punishmentManager.handleViolation(player, result.getViolationType(), result.getSeverity(), result.getDetails(), confidence.name());
    }

    public double calculateAdaptiveThreshold(ViolationType type) {
        double baseTPS = 20.0;
        double currentTPS = this.getCurrentTPS();
        double tpsRatio = currentTPS / baseTPS;
        double baseThreshold = this.config.getViolationThreshold(type.name().toLowerCase());
        return baseThreshold * (2.0 - tpsRatio);
    }

    private double getCurrentTPS() {
        try {
            Object server = Bukkit.getServer().getClass().getMethod("getServer", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
            double[] recentTps = (double[])server.getClass().getField("recentTps").get(server);
            return recentTps[0];
        }
        catch (Exception e) {
            return 20.0;
        }
    }

    public boolean isStatisticalOutlier(PlayerData data, double value, String metricKey) {
        double threshold;
        double baseline = data.getBaselineValue(metricKey, value);
        double stdDev = data.getBaselineValue(metricKey + "_stddev", 0.0);
        if (stdDev == 0.0) {
            data.updateBaseline(metricKey, value);
            return false;
        }
        double deviation = Math.abs(value - baseline);
        if (deviation > (threshold = this.config.getStandardDeviationMultiplier() * stdDev)) {
            data.incrementOutlierCount();
            if (data.getOutlierCount() > this.config.getOutlierForgiveness()) {
                return true;
            }
        } else {
            data.resetOutlierCount();
        }
        this.updateBaseline(data, metricKey, value);
        return false;
    }

    private void updateBaseline(PlayerData data, String key, double newValue) {
        double oldMean = data.getBaselineValue(key, newValue);
        double count = data.getBaselineValue(key + "_count", 0.0) + 1.0;
        double newMean = (oldMean * (count - 1.0) + newValue) / count;
        data.updateBaseline(key, newMean);
        data.updateBaseline(key + "_count", count);
        double variance = data.getBaselineValue(key + "_variance", 0.0);
        double delta = newValue - oldMean;
        double delta2 = newValue - newMean;
        variance = ((count - 1.0) * variance + delta * delta2) / count;
        double stdDev = Math.sqrt(variance);
        data.updateBaseline(key + "_variance", variance);
        data.updateBaseline(key + "_stddev", stdDev);
    }

    private String extractNoSlowVariant(String details) {
        if (details == null) {
            return "";
        }
        if (details.contains("[NoWeb]")) {
            return "NoWeb";
        }
        if (details.contains("[NoHoney]")) {
            return "NoHoney";
        }
        if (details.contains("[NoSoulSand]")) {
            return "NoSoulSand";
        }
        if (details.contains("[NoPowderSnow]")) {
            return "NoPowderSnow";
        }
        if (details.contains("[NoBerry]")) {
            return "NoBerry";
        }
        if (details.contains("[NoItemSlow]")) {
            return "NoItemSlow";
        }
        if (details.contains("[NoSneak]")) {
            return "NoSneak";
        }
        if (details.contains("[NoSlow]")) {
            return "NoSlow";
        }
        return "";
    }

    public static enum ConfidenceLevel {
        NONE,
        LOW,
        MEDIUM,
        HIGH;

    }
}

