/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.core;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;

public class WaterHelper {
    public static boolean isInWater(Player player) {
        if (player.isInWater() || player.isSwimming()) {
            return true;
        }
        Block block = player.getLocation().getBlock();
        if (WaterHelper.isWaterBlock(block)) {
            return true;
        }
        Block above = player.getLocation().clone().add(0.0, 1.0, 0.0).getBlock();
        return WaterHelper.isWaterBlock(above);
    }

    public static boolean isNearWater(Location location, int radius) {
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    Block block = location.clone().add((double)x, (double)y, (double)z).getBlock();
                    if (!WaterHelper.isWaterBlock(block)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isWaterBlock(Block block) {
        if (block == null) {
            return false;
        }
        Material type = block.getType();
        return type == Material.WATER || type.name().contains("WATER") || type == Material.BUBBLE_COLUMN || type == Material.SEAGRASS || type == Material.TALL_SEAGRASS || type == Material.KELP || type == Material.KELP_PLANT || type.name().contains("CORAL") && !type.name().contains("BLOCK");
    }

    public static boolean isInLiquid(Player player) {
        Block block = player.getLocation().getBlock();
        Material type = block.getType();
        return type == Material.WATER || type.name().contains("WATER") || type == Material.LAVA || type.name().contains("LAVA") || type == Material.BUBBLE_COLUMN;
    }

    public static double getWaterDragMultiplier(Player player) {
        int depthStriderLevel;
        boolean hasDepthStrider;
        block10: {
            if (!WaterHelper.isInWater(player)) {
                return 1.0;
            }
            hasDepthStrider = false;
            depthStriderLevel = 0;
            try {
                ItemStack boots = player.getInventory().getBoots();
                if (boots == null) break block10;
                Enchantment depthStrider = null;
                try {
                    depthStrider = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)"depth_strider"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (depthStrider == null) {
                    try {
                        depthStrider = Enchantment.getByName((String)"DEPTH_STRIDER");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (depthStrider != null && boots.containsEnchantment(depthStrider)) {
                    hasDepthStrider = true;
                    depthStriderLevel = boots.getEnchantmentLevel(depthStrider);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (hasDepthStrider) {
            return 1.0 - (double)depthStriderLevel * 0.15;
        }
        return 0.5;
    }

    public static double getBuoyancyEffect(Player player) {
        Block block = player.getLocation().getBlock();
        if (block.getType() == Material.BUBBLE_COLUMN) {
            try {
                String blockData = block.getBlockData().getAsString();
                if (blockData.contains("drag=false")) {
                    return 0.8;
                }
                return -0.6;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (WaterHelper.isWaterBlock(block)) {
            return -0.02;
        }
        return 0.0;
    }

    public static boolean hasWaterBreathing(Player player) {
        try {
            PotionEffectType waterBreathing = null;
            try {
                waterBreathing = PotionEffectType.getByName((String)"WATER_BREATHING");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (waterBreathing != null && player.hasPotionEffect(waterBreathing)) {
                return true;
            }
        }
        catch (Exception waterBreathing) {
            // empty catch block
        }
        try {
            ItemStack helmet = player.getInventory().getHelmet();
            if (helmet != null && helmet.getType().name().equals("TURTLE_SHELL")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static double getSwimmingSpeedMultiplier(Player player) {
        double multiplier = 1.0;
        if (player.isSwimming()) {
            multiplier = 1.3;
        }
        try {
            if (player.hasPotionEffect(PotionEffectType.DOLPHINS_GRACE)) {
                multiplier *= 1.5;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return multiplier *= WaterHelper.getWaterDragMultiplier(player);
    }
}

