/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.detection.block;

import NC.noChance.core.ACConfig;
import NC.noChance.core.BreakProfile;
import NC.noChance.core.CheckResult;
import NC.noChance.core.EnchantHelper;
import NC.noChance.core.EnhancementTracker;
import NC.noChance.core.EnvironmentHelper;
import NC.noChance.core.FalsePositiveFilter;
import NC.noChance.core.LayerFiltering;
import NC.noChance.core.PacketTracker;
import NC.noChance.core.PlayerData;
import NC.noChance.core.ToolSpeed;
import NC.noChance.core.ViolationType;
import NC.noChance.core.WaterHelper;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class FastBreakCheck {
    private final ACConfig config;
    private final Map<UUID, PlayerData> playerDataMap;
    private final LayerFiltering filtering;
    private final BreakProfile profiler;
    private final ToolSpeed toolCalc;
    private final PacketTracker packetAnalyzer;
    private final FalsePositiveFilter falsePositiveFilter;
    private final Map<UUID, Long> lastCheckTime;
    private final Map<UUID, Integer> rapidCheckCount;
    private static final long MIN_CHECK_INTERVAL = 25L;
    private static final int MAX_RAPID_CHECKS = 15;
    private static final Map<Material, Double> BLOCK_HARDNESS = new HashMap<Material, Double>();

    public FastBreakCheck(ACConfig config, Map<UUID, PlayerData> playerDataMap, LayerFiltering filtering) {
        this.config = config;
        this.playerDataMap = playerDataMap;
        this.filtering = filtering;
        this.profiler = new BreakProfile();
        this.toolCalc = new ToolSpeed();
        this.packetAnalyzer = new PacketTracker();
        this.falsePositiveFilter = new FalsePositiveFilter();
        this.lastCheckTime = new ConcurrentHashMap<UUID, Long>();
        this.rapidCheckCount = new ConcurrentHashMap<UUID, Integer>();
    }

    public void onStartDigging(Player player, Block block) {
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data == null) {
            this.playerDataMap.put(player.getUniqueId(), new PlayerData(player.getUniqueId()));
            data = this.playerDataMap.get(player.getUniqueId());
        }
        long now = System.currentTimeMillis();
        data.setBlockBreakStartTime(now);
        data.setLastBlockBreak(block.getLocation());
        ItemStack tool = player.getInventory().getItemInMainHand();
        String toolName = tool != null && tool.getType() != Material.AIR ? tool.getType().name() : "HAND";
        int efficiency = tool != null && tool.getType() != Material.AIR ? EnchantHelper.getEfficiencyLevel(tool) : 0;
        data.setBlockBreakInitialTool(toolName);
        data.setBlockBreakInitialEfficiency(efficiency);
        this.packetAnalyzer.recordPacket(player.getUniqueId(), PacketTracker.PacketAction.START_DIG, block.getLocation());
    }

    public CheckResult check(Player player, Block block) {
        double suspiciousRatioThreshold;
        double extraTolerance;
        double minTime;
        PotionEffect fatigue;
        PotionEffectType fatigueType;
        int consecutiveThreshold;
        boolean isPickaxeBlock;
        ItemStack currentTool;
        long timeSinceLastBreak;
        if (!this.config.isCheckEnabled("fastbreak")) {
            return CheckResult.passed();
        }
        UUID playerId = player.getUniqueId();
        long now = System.currentTimeMillis();
        Long lastCheck = this.lastCheckTime.get(playerId);
        if (lastCheck != null) {
            long timeSinceLastCheck = now - lastCheck;
            if (timeSinceLastCheck < 25L) {
                int rapid = this.rapidCheckCount.getOrDefault(playerId, 0) + 1;
                this.rapidCheckCount.put(playerId, rapid);
                if (rapid > 15) {
                    return CheckResult.passed();
                }
            } else {
                this.rapidCheckCount.put(playerId, 0);
            }
        }
        this.lastCheckTime.put(playerId, now);
        PlayerData data = this.playerDataMap.get(playerId);
        if (data == null) {
            return CheckResult.passed();
        }
        if (data.isInGracePeriod(this.config.getGracePeriod())) {
            this.falsePositiveFilter.recordLegitAction(player, ViolationType.FASTBREAK);
            return CheckResult.passed();
        }
        long breakStartTime = data.getBlockBreakStartTime();
        if (breakStartTime == 0L || breakStartTime > now) {
            data.setBlockBreakStartTime(now);
            this.falsePositiveFilter.recordLegitAction(player, ViolationType.FASTBREAK);
            return CheckResult.passed();
        }
        long actualTime = now - breakStartTime;
        if (actualTime > 5000L) {
            data.setBlockBreakStartTime(now);
            return CheckResult.passed();
        }
        this.falsePositiveFilter.recordBreakTiming(player, actualTime);
        long lastBreakTime = data.getLastBlockBreakTime();
        long l = timeSinceLastBreak = lastBreakTime > 0L ? now - lastBreakTime : 1000L;
        if (timeSinceLastBreak > 3000L) {
            timeSinceLastBreak = 1000L;
        }
        data.setLastBlockBreakTime(now);
        this.packetAnalyzer.recordPacket(player.getUniqueId(), PacketTracker.PacketAction.FINISH_DIG, block.getLocation());
        PacketTracker.SequenceViolation seqViolation = this.packetAnalyzer.checkSequence(player.getUniqueId(), player);
        if (seqViolation.violated) {
            CheckResult prelimResult = CheckResult.failed(ViolationType.FASTBREAK, seqViolation.severity, seqViolation.reason);
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.FASTBREAK, prelimResult)) {
                return CheckResult.passed();
            }
            return prelimResult;
        }
        String initialTool = data.getBlockBreakInitialTool();
        if (initialTool == null) {
            initialTool = player.getInventory().getItemInMainHand() != null && player.getInventory().getItemInMainHand().getType() != Material.AIR ? player.getInventory().getItemInMainHand().getType().name() : "HAND";
        }
        String currentToolName = (currentTool = player.getInventory().getItemInMainHand()) != null && currentTool.getType() != Material.AIR ? currentTool.getType().name() : "HAND";
        int currentEfficiency = currentTool != null && currentTool.getType() != Material.AIR ? EnchantHelper.getEfficiencyLevel(currentTool) : 0;
        boolean toolWasSwitched = !initialTool.equals(currentToolName);
        boolean efficiencyChanged = data.getBlockBreakInitialEfficiency() != currentEfficiency;
        int initialEfficiency = data.getBlockBreakInitialEfficiency();
        EnhancementTracker.BlockBreakEnhancements initialEnhancements = EnhancementTracker.calculateBlockBreakEnhancements(player, block, initialTool, initialEfficiency);
        EnhancementTracker.BlockBreakEnhancements currentEnhancements = EnhancementTracker.calculateBlockBreakEnhancements(player, block, currentToolName, currentEfficiency);
        EnhancementTracker.BlockBreakEnhancements enhancements = initialEnhancements;
        if ((toolWasSwitched || efficiencyChanged) && currentEnhancements.getBreakSpeedMultiplier() > initialEnhancements.getBreakSpeedMultiplier()) {
            enhancements = currentEnhancements;
        }
        if (enhancements.canInstamine && actualTime >= 25L) {
            this.falsePositiveFilter.recordLegitAction(player, ViolationType.FASTBREAK);
            return CheckResult.passed();
        }
        double blockHardness = this.getBlockHardness(block.getType());
        boolean isShovelBlock = (initialEnhancements.toolType.equals("SHOVEL") || currentEnhancements.toolType.equals("SHOVEL")) && blockHardness <= 0.6;
        boolean bl = isPickaxeBlock = !(!initialEnhancements.toolType.equals("PICKAXE") && !currentEnhancements.toolType.equals("PICKAXE") || !(blockHardness >= 1.0) && !block.getType().name().contains("STONE") && !block.getType().name().contains("ORE"));
        if (isShovelBlock && !toolWasSwitched && !efficiencyChanged) {
            int minShovelTime = 35;
            minShovelTime = enhancements.hasteLevel >= 2 ? (enhancements.efficiencyLevel >= 5 ? 30 : (enhancements.efficiencyLevel >= 4 ? 32 : (enhancements.efficiencyLevel >= 3 ? 34 : (enhancements.efficiencyLevel >= 2 ? 36 : (enhancements.efficiencyLevel >= 1 ? 38 : 40))))) : (enhancements.hasteLevel == 1 ? (enhancements.efficiencyLevel >= 5 ? 32 : (enhancements.efficiencyLevel >= 4 ? 34 : (enhancements.efficiencyLevel >= 3 ? 36 : (enhancements.efficiencyLevel >= 2 ? 38 : (enhancements.efficiencyLevel >= 1 ? 40 : 45))))) : (enhancements.efficiencyLevel >= 5 ? 35 : (enhancements.efficiencyLevel >= 4 ? 38 : (enhancements.efficiencyLevel >= 3 ? 40 : (enhancements.efficiencyLevel >= 2 ? 42 : (enhancements.efficiencyLevel >= 1 ? 45 : 50))))));
            if (actualTime < (long)minShovelTime) {
                CheckResult prelimResult = CheckResult.failed(ViolationType.FASTBREAK, 0.97, String.format("Shovel too fast (%.0fms, Eff%d, Haste%d, min %dms, hardness:%.1f)", actualTime, enhancements.efficiencyLevel, enhancements.hasteLevel, minShovelTime, blockHardness));
                if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.FASTBREAK, prelimResult)) {
                    return CheckResult.passed();
                }
                return prelimResult;
            }
        }
        boolean hasProperTool = enhancements.hasCorrectTool;
        boolean hasHighEfficiency = enhancements.efficiencyLevel >= 4;
        boolean hasTopTierTool = enhancements.toolMaterial.equals("GOLDEN") || enhancements.toolMaterial.equals("NETHERITE") || enhancements.toolMaterial.equals("DIAMOND");
        int instantBreakThreshold = 20;
        if (hasProperTool && enhancements.efficiencyLevel >= 5 && hasTopTierTool) {
            if (blockHardness <= 0.4) {
                instantBreakThreshold = 0;
            } else if (blockHardness <= 1.0) {
                instantBreakThreshold = 3;
            } else if (blockHardness <= 1.5) {
                instantBreakThreshold = 5;
            } else if (blockHardness <= 2.0) {
                instantBreakThreshold = 8;
            }
        } else if (hasProperTool && enhancements.efficiencyLevel >= 4) {
            if (blockHardness <= 0.4) {
                instantBreakThreshold = 3;
            } else if (blockHardness <= 1.5) {
                instantBreakThreshold = 10;
            }
        } else if (hasProperTool && enhancements.efficiencyLevel >= 3 && blockHardness <= 0.4) {
            instantBreakThreshold = 8;
        }
        if (instantBreakThreshold > 0 && actualTime < (long)instantBreakThreshold && blockHardness > 0.1) {
            if (enhancements.toolMaterial.equals("GOLDEN") && actualTime < 15L && blockHardness <= 1.5) {
                this.falsePositiveFilter.recordLegitAction(player, ViolationType.FASTBREAK);
                return CheckResult.passed();
            }
            CheckResult prelimResult = CheckResult.failed(ViolationType.FASTBREAK, 0.95, String.format("Instant break without instamine capability: %dms (hardness: %.1f, threshold: %dms)", actualTime, blockHardness, instantBreakThreshold));
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.FASTBREAK, prelimResult)) {
                return CheckResult.passed();
            }
            return prelimResult;
        }
        if (timeSinceLastBreak < 45L && actualTime < 40L && blockHardness > 0.5) {
            if (enhancements.toolMaterial.equals("GOLDEN") && enhancements.efficiencyLevel >= 4) {
                this.falsePositiveFilter.recordLegitAction(player, ViolationType.FASTBREAK);
                return CheckResult.passed();
            }
            CheckResult prelimResult = CheckResult.failed(ViolationType.FASTBREAK, 0.94, String.format("Rapid succession breaks: %dms interval, %dms break (hardness: %.1f)", timeSinceLastBreak, actualTime, blockHardness));
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.FASTBREAK, prelimResult)) {
                return CheckResult.passed();
            }
            return prelimResult;
        }
        int consecutiveFast = data.getConsecutiveFastBreaks();
        double trustScore = this.falsePositiveFilter.getPlayerTrustScore(playerId);
        int n = trustScore > 0.7 ? 8 : (consecutiveThreshold = trustScore > 0.5 ? 6 : 5);
        if (consecutiveFast >= consecutiveThreshold) {
            CheckResult prelimResult = CheckResult.failed(ViolationType.FASTBREAK, Math.min(1.0, 0.7 + (double)consecutiveFast * 0.05), String.format("Pattern: %d consecutive fast breaks <100ms (trust:%.2f)", consecutiveFast, trustScore));
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.FASTBREAK, prelimResult)) {
                data.resetConsecutiveFastBreaks();
                return CheckResult.passed();
            }
            return prelimResult;
        }
        Deque<Long> intervals = data.getBlockBreakIntervals();
        if (intervals.size() >= 6) {
            long veryFastCount = intervals.stream().filter(i -> i < 80L).count();
            if (veryFastCount >= 5L) {
                CheckResult prelimResult = CheckResult.failed(ViolationType.FASTBREAK, 0.86, String.format("Pattern: %d breaks with <80ms intervals", veryFastCount));
                if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.FASTBREAK, prelimResult)) {
                    return CheckResult.passed();
                }
                return prelimResult;
            }
            ArrayList<Long> recentIntervals = new ArrayList<Long>(intervals);
            if (recentIntervals.size() >= 8) {
                double mean = recentIntervals.stream().mapToLong(Long::longValue).average().orElse(0.0);
                double variance = recentIntervals.stream().mapToDouble(i -> Math.pow((double)i.longValue() - mean, 2.0)).average().orElse(0.0);
                if (variance < 25.0 && mean < 120.0) {
                    CheckResult prelimResult = CheckResult.failed(ViolationType.FASTBREAK, 0.82, String.format("Pattern: Perfect consistency var=%.1f mean=%.1fms", variance, mean));
                    if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.FASTBREAK, prelimResult)) {
                        return CheckResult.passed();
                    }
                    return prelimResult;
                }
            }
        }
        if (blockHardness == 0.0 || blockHardness < 0.05) {
            return CheckResult.passed();
        }
        if (player.getGameMode() == GameMode.CREATIVE) {
            return CheckResult.passed();
        }
        if (player.getGameMode() == GameMode.SPECTATOR) {
            return CheckResult.passed();
        }
        EnvironmentHelper.EnvironmentalFactors envFactors = EnvironmentHelper.calculate(player);
        double speedMultiplier = 1.0;
        if (enhancements.hasCorrectTool) {
            switch (enhancements.toolMaterial) {
                case "NETHERITE": {
                    speedMultiplier = 9.0;
                    break;
                }
                case "DIAMOND": {
                    speedMultiplier = 8.0;
                    break;
                }
                case "GOLDEN": {
                    speedMultiplier = 12.0;
                    break;
                }
                case "IRON": {
                    speedMultiplier = 6.0;
                    break;
                }
                case "STONE": {
                    speedMultiplier = 4.0;
                    break;
                }
                case "WOOD": {
                    speedMultiplier = 2.0;
                }
            }
        }
        if (enhancements.efficiencyLevel > 0) {
            speedMultiplier += (double)(enhancements.efficiencyLevel * enhancements.efficiencyLevel) + 1.0;
        }
        if (enhancements.hasteLevel > 0) {
            speedMultiplier *= 0.2 * (double)enhancements.hasteLevel + 1.0;
        }
        if ((fatigueType = PotionEffectType.getByName((String)"MINING_FATIGUE")) == null) {
            fatigueType = PotionEffectType.getByName((String)"SLOW_DIGGING");
        }
        if (fatigueType != null && (fatigue = player.getPotionEffect(fatigueType)) != null) {
            int level = Math.min(fatigue.getAmplifier() + 1, 4);
            speedMultiplier *= Math.pow(0.3, level);
        }
        if (WaterHelper.isInWater(player) && !EnchantHelper.hasAquaAffinity(player)) {
            speedMultiplier /= 5.0;
        }
        if (!player.isOnGround() && !player.isFlying()) {
            speedMultiplier /= 5.0;
        }
        boolean canHarvestBlock = this.canToolHarvest(block.getType(), enhancements);
        double damage = speedMultiplier / blockHardness;
        damage = canHarvestBlock ? (damage /= 30.0) : (damage /= 100.0);
        double ticksToBreak = damage >= 1.0 ? 1.0 : Math.ceil(1.0 / damage);
        double expectedTime = ticksToBreak * 50.0;
        int ping = this.filtering.getPing(player);
        double tpsMultiplier = this.getTPSMultiplier();
        double baseTolerance = 70.0 + (double)ping * 0.8;
        baseTolerance *= tpsMultiplier;
        if (enhancements.efficiencyLevel >= 5) {
            baseTolerance += 30.0;
        } else if (enhancements.efficiencyLevel >= 4) {
            baseTolerance += 25.0;
        } else if (enhancements.efficiencyLevel >= 3) {
            baseTolerance += 20.0;
        } else if (enhancements.efficiencyLevel >= 2) {
            baseTolerance += 15.0;
        } else if (enhancements.efficiencyLevel >= 1) {
            baseTolerance += 10.0;
        }
        if (enhancements.hasteLevel >= 2) {
            baseTolerance += 50.0;
        } else if (enhancements.hasteLevel >= 1) {
            baseTolerance += 30.0;
        }
        if (enhancements.toolMaterial.equals("GOLDEN")) {
            baseTolerance += 40.0;
        } else if (enhancements.toolMaterial.equals("NETHERITE") || enhancements.toolMaterial.equals("DIAMOND")) {
            baseTolerance += 20.0;
        } else if (enhancements.toolMaterial.equals("IRON")) {
            baseTolerance += 15.0;
        } else if (enhancements.toolMaterial.equals("STONE")) {
            baseTolerance += 10.0;
        }
        if (envFactors.hasStatusEffects) {
            baseTolerance += 20.0;
        }
        if (envFactors.onSlipperyBlock || envFactors.inDangerZone) {
            baseTolerance += 15.0;
        }
        if (blockHardness < 1.0) {
            baseTolerance += 10.0;
        }
        double percentageTolerance = expectedTime * 0.25;
        if (toolWasSwitched || efficiencyChanged) {
            boolean pickaxeToShovel;
            baseTolerance *= 2.0;
            percentageTolerance *= 1.3;
            boolean shovelToPickaxe = initialTool.contains("SHOVEL") && currentToolName.contains("PICKAXE");
            boolean bl2 = pickaxeToShovel = initialTool.contains("PICKAXE") && currentToolName.contains("SHOVEL");
            if (shovelToPickaxe || pickaxeToShovel) {
                baseTolerance += 150.0;
                percentageTolerance *= 1.8;
                if (actualTime < 200L) {
                    this.falsePositiveFilter.recordLegitAction(player, ViolationType.FASTBREAK);
                    return CheckResult.passed();
                }
            } else if (isShovelBlock && currentToolName.contains("PICKAXE")) {
                baseTolerance += 80.0;
            } else if (!isShovelBlock && currentToolName.contains("SHOVEL")) {
                baseTolerance += 80.0;
            }
        }
        boolean isInstantMine = expectedTime <= 100.0;
        boolean isHandBreaking = enhancements.toolMaterial.equals("HAND");
        if (blockHardness <= 0.6 && enhancements.hasCorrectTool && !toolWasSwitched) {
            percentageTolerance = expectedTime * 0.15;
            if (isInstantMine) {
                baseTolerance = Math.min(baseTolerance, 40.0);
                percentageTolerance = expectedTime * 0.1;
            } else {
                baseTolerance = Math.min(baseTolerance, 60.0);
            }
        }
        if (isShovelBlock && !toolWasSwitched) {
            if (isInstantMine) {
                if (enhancements.efficiencyLevel >= 3) {
                    baseTolerance = Math.min(baseTolerance, 20.0);
                    percentageTolerance = expectedTime * 0.08;
                } else if (enhancements.efficiencyLevel >= 1) {
                    baseTolerance = Math.min(baseTolerance, 25.0);
                    percentageTolerance = expectedTime * 0.12;
                } else {
                    baseTolerance = Math.min(baseTolerance, 35.0);
                    percentageTolerance = expectedTime * 0.2;
                }
            } else {
                baseTolerance = Math.min(baseTolerance, 50.0);
                percentageTolerance = expectedTime * 0.12;
            }
        }
        if (isHandBreaking && blockHardness >= 0.3 && blockHardness <= 0.8) {
            if (isInstantMine) {
                baseTolerance = Math.min(baseTolerance, 25.0);
                percentageTolerance = expectedTime * 0.15;
            } else {
                baseTolerance = Math.min(baseTolerance, 50.0);
                percentageTolerance = expectedTime * 0.2;
            }
        }
        double tolerance = Math.max(baseTolerance, percentageTolerance);
        trustScore = this.falsePositiveFilter.getPlayerTrustScore(playerId);
        int trustBonus = 0;
        if ((isShovelBlock || isHandBreaking) && isInstantMine) {
            if (trustScore > 0.8) {
                trustBonus = 10;
            } else if (trustScore > 0.65) {
                trustBonus = 6;
            } else if (trustScore > 0.5) {
                trustBonus = 3;
            }
        } else if (trustScore > 0.8) {
            trustBonus = isInstantMine ? 15 : 30;
        } else if (trustScore > 0.65) {
            trustBonus = isInstantMine ? 10 : 20;
        } else if (trustScore > 0.5) {
            trustBonus = isInstantMine ? 5 : 10;
        }
        tolerance += (double)trustBonus;
        if (enhancements.hasteLevel == 2 && enhancements.efficiencyLevel >= 5) {
            tolerance += isShovelBlock && isInstantMine ? 15.0 : (double)(isInstantMine ? 25 : 40);
        }
        if (enhancements.efficiencyLevel >= 3 && enhancements.hasCorrectTool) {
            double hardMinTime;
            double minTimeRatio = 0.45;
            if (isInstantMine) {
                minTimeRatio = 0.35;
            }
            if ((double)actualTime < (hardMinTime = expectedTime * minTimeRatio)) {
                CheckResult prelimResult = CheckResult.failed(ViolationType.FASTBREAK, 0.94, String.format("Too fast for Eff%d instant-mine (%.0fms vs min %.0fms for %.0fms expected, hardness: %.1f)", enhancements.efficiencyLevel, (double)actualTime, hardMinTime, expectedTime, blockHardness));
                if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.FASTBREAK, prelimResult)) {
                    return CheckResult.passed();
                }
                return prelimResult;
            }
        }
        boolean suspicious = (double)actualTime < (minTime = Math.max(30.0, expectedTime - tolerance));
        BreakProfile.Profile profile = this.profiler.getProfile(player.getUniqueId());
        this.profiler.recordBreak(player, block, actualTime, suspicious);
        trustScore = this.falsePositiveFilter.getPlayerTrustScore(playerId);
        if (trustScore > 0.9 && profile.getTotalBreaks() > 150 && (double)actualTime >= minTime - (extraTolerance = 50.0)) {
            this.falsePositiveFilter.recordLegitAction(player, ViolationType.FASTBREAK);
            return CheckResult.passed();
        }
        if (profile.hasBaseline(block.getType())) {
            double deviationThreshold;
            double baseline = profile.getBaselineTime(block.getType());
            double d = deviationThreshold = trustScore > 0.7 ? 0.35 : 0.5;
            if (enhancements.efficiencyLevel >= 3) {
                double d2 = deviationThreshold = trustScore > 0.7 ? 0.3 : 0.4;
            }
            if ((double)actualTime < baseline * deviationThreshold && baseline > 100.0) {
                double percentFaster;
                double severity = enhancements.efficiencyLevel >= 3 ? 0.91 : 0.88;
                CheckResult prelimResult = CheckResult.failed(ViolationType.FASTBREAK, severity, String.format("Breaking %.0f%% faster than baseline (%.0fms vs %.0fms, Eff:%d, trust:%.2f)", percentFaster = (1.0 - (double)actualTime / baseline) * 100.0, (double)actualTime, baseline, enhancements.efficiencyLevel, trustScore));
                if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.FASTBREAK, prelimResult)) {
                    return CheckResult.passed();
                }
                return prelimResult;
            }
        }
        double d = trustScore > 0.7 ? 0.75 : (suspiciousRatioThreshold = trustScore > 0.5 ? 0.65 : 0.6);
        if (enhancements.efficiencyLevel >= 4) {
            suspiciousRatioThreshold -= 0.1;
        }
        if (profile.getSuspiciousRatio() > suspiciousRatioThreshold && profile.getTotalBreaks() > 20) {
            CheckResult prelimResult;
            double severity = 0.81;
            if (enhancements.efficiencyLevel >= 4) {
                severity = 0.86;
            }
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.FASTBREAK, prelimResult = CheckResult.failed(ViolationType.FASTBREAK, severity, String.format("Suspicious pattern: %.0f%% of breaks flagged (%d/%d, Eff:%d, trust:%.2f)", profile.getSuspiciousRatio() * 100.0, profile.getSuspiciousBreaks(), profile.getTotalBreaks(), enhancements.efficiencyLevel, trustScore)))) {
                return CheckResult.passed();
            }
            return prelimResult;
        }
        if (isHandBreaking && blockHardness >= 0.3 && blockHardness <= 0.8) {
            if ((double)actualTime < expectedTime * 0.3 && expectedTime >= 50.0) {
                CheckResult prelimResult = CheckResult.failed(ViolationType.FASTBREAK, 0.93, String.format("Hand breaking too fast (%.0fms vs %.0fms expected, hardness:%.1f)", actualTime, expectedTime, blockHardness));
                if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.FASTBREAK, prelimResult)) {
                    return CheckResult.passed();
                }
                return prelimResult;
            }
            if (actualTime < 28L && expectedTime >= 50.0) {
                CheckResult prelimResult = CheckResult.failed(ViolationType.FASTBREAK, 0.95, String.format("Impossible hand break speed (%.0fms for hardness %.1f, expected %.0fms)", actualTime, blockHardness, expectedTime));
                if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.FASTBREAK, prelimResult)) {
                    return CheckResult.passed();
                }
                return prelimResult;
            }
        }
        if (isShovelBlock && !toolWasSwitched && !efficiencyChanged) {
            int absoluteMin = 50;
            absoluteMin = enhancements.hasteLevel >= 2 ? (enhancements.efficiencyLevel >= 5 ? 30 : (enhancements.efficiencyLevel >= 4 ? 32 : (enhancements.efficiencyLevel >= 3 ? 34 : 36))) : (enhancements.hasteLevel == 1 ? (enhancements.efficiencyLevel >= 5 ? 32 : (enhancements.efficiencyLevel >= 4 ? 34 : (enhancements.efficiencyLevel >= 3 ? 36 : 38))) : (enhancements.efficiencyLevel >= 5 ? 35 : (enhancements.efficiencyLevel >= 4 ? 38 : (enhancements.efficiencyLevel >= 3 ? 40 : 42))));
            if (actualTime < (long)absoluteMin) {
                CheckResult prelimResult = CheckResult.failed(ViolationType.FASTBREAK, 0.96, String.format("Shovel break too fast (%.0fms, Eff%d, min %dms, hardness:%.1f)", actualTime, enhancements.efficiencyLevel, absoluteMin, blockHardness));
                if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.FASTBREAK, prelimResult)) {
                    return CheckResult.passed();
                }
                return prelimResult;
            }
            double minRatio = 0.5;
            minRatio = enhancements.efficiencyLevel >= 5 ? 0.45 : (enhancements.efficiencyLevel >= 4 ? 0.48 : (enhancements.efficiencyLevel >= 3 ? 0.5 : (enhancements.efficiencyLevel >= 1 ? 0.52 : 0.55)));
            if ((double)actualTime < expectedTime * minRatio) {
                CheckResult prelimResult = CheckResult.failed(ViolationType.FASTBREAK, 0.94, String.format("Shovel breaking too fast (%.0fms vs %.0fms expected, min %.0fms, Eff%d, hardness:%.1f)", actualTime, expectedTime, expectedTime * minRatio, enhancements.efficiencyLevel, blockHardness));
                if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.FASTBREAK, prelimResult)) {
                    return CheckResult.passed();
                }
                return prelimResult;
            }
        }
        if ((double)actualTime < minTime) {
            double diff = minTime - (double)actualTime;
            double impossibleThreshold = 0.25;
            if (enhancements.efficiencyLevel >= 4) {
                impossibleThreshold = 0.2;
            }
            if (enhancements.efficiencyLevel >= 5) {
                impossibleThreshold = 0.15;
            }
            if (!enhancements.canInstamine && blockHardness > 0.5 && expectedTime > 250.0 && (double)actualTime < expectedTime * impossibleThreshold) {
                CheckResult prelimResult = CheckResult.failed(ViolationType.FASTBREAK, 0.96, String.format("Impossible break speed for Eff%d (%.0fms vs expected %.0fms, hardness:%.1f)", enhancements.efficiencyLevel, (double)actualTime, expectedTime, blockHardness));
                if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.FASTBREAK, prelimResult)) {
                    return CheckResult.passed();
                }
                return prelimResult;
            }
            int minDiffThreshold = 35;
            if ((isShovelBlock || isHandBreaking) && isInstantMine) {
                minDiffThreshold = 12;
                if (trustScore > 0.75) {
                    minDiffThreshold = 15;
                } else if (trustScore > 0.6) {
                    minDiffThreshold = 13;
                }
            } else if (trustScore > 0.75) {
                minDiffThreshold = 50;
            } else if (trustScore > 0.6) {
                minDiffThreshold = 40;
            }
            if (diff < (double)minDiffThreshold) {
                this.falsePositiveFilter.recordLegitAction(player, ViolationType.FASTBREAK);
                return CheckResult.passed();
            }
            if (trustScore > 0.85) {
                int trustDiffThreshold = 70;
                if ((isShovelBlock || isHandBreaking) && isInstantMine) {
                    trustDiffThreshold = 20;
                }
                if (diff < (double)trustDiffThreshold) {
                    this.falsePositiveFilter.recordLegitAction(player, ViolationType.FASTBREAK);
                    return CheckResult.passed();
                }
            }
            if (enhancements.canInstamine && actualTime < 50L && (!isShovelBlock || actualTime >= 25L)) {
                this.falsePositiveFilter.recordLegitAction(player, ViolationType.FASTBREAK);
                return CheckResult.passed();
            }
            if (blockHardness < 0.3 && !enhancements.hasCorrectTool && diff < 25.0) {
                this.falsePositiveFilter.recordLegitAction(player, ViolationType.FASTBREAK);
                return CheckResult.passed();
            }
            if (actualTime < 100L && expectedTime < 150.0 && blockHardness >= 0.8) {
                this.falsePositiveFilter.recordLegitAction(player, ViolationType.FASTBREAK);
                return CheckResult.passed();
            }
            if (ping > 150 && diff < 50.0) {
                this.falsePositiveFilter.recordLegitAction(player, ViolationType.FASTBREAK);
                return CheckResult.passed();
            }
            double rawSeverity = Math.min(1.0, diff / Math.max(150.0, expectedTime * 0.5));
            ItemStack tool = player.getInventory().getItemInMainHand();
            String toolInfo = "Hand";
            if (tool != null && tool.getType() != Material.AIR) {
                toolInfo = String.format("%s (Eff:%d)", tool.getType().name().replace("_", " "), enhancements.efficiencyLevel);
            }
            String blockInfo = block.getType().name().replace("_", " ");
            String potionInfo = enhancements.hasteLevel > 0 ? String.format("Haste:%d", enhancements.hasteLevel) : "None";
            String speedInfo = String.format("Speed:%.1fx", speedMultiplier);
            String envInfo = envFactors.details.equals("None") ? "" : " | Env:" + envFactors.details;
            String reason = String.format("Tool:%s | Block:%s | Haste:%s | %s%s | Break:%dms | Min:%.0fms | Exp:%.0fms | Diff:%.0fms | TPS:%.1f", toolInfo, blockInfo, potionInfo, speedInfo, envInfo, actualTime, minTime, expectedTime, diff, this.getAverageTPS());
            FalsePositiveFilter.FilterResult filterResult = this.falsePositiveFilter.evaluate(player, ViolationType.FASTBREAK, rawSeverity, reason);
            if (filterResult.shouldFilter) {
                return CheckResult.passed();
            }
            double adjustedSeverity = filterResult.adjustedConfidence;
            String suspicionLevel = adjustedSeverity > 0.9 ? "EXTREME" : (adjustedSeverity > 0.8 ? "HIGH" : (adjustedSeverity > 0.7 ? "MODERATE" : "LOW"));
            String detailedReason = String.format("[%s] %s | Trust:%.2f | Conf:%.2f", suspicionLevel, reason, trustScore = this.falsePositiveFilter.getPlayerTrustScore(playerId), adjustedSeverity);
            CheckResult prelimResult = CheckResult.failed(ViolationType.FASTBREAK, adjustedSeverity, detailedReason);
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.FASTBREAK, prelimResult)) {
                return CheckResult.passed();
            }
            return prelimResult;
        }
        this.falsePositiveFilter.recordLegitAction(player, ViolationType.FASTBREAK);
        return CheckResult.passed();
    }

    private static void initializeBlockHardness() {
        BLOCK_HARDNESS.put(Material.STONE, 1.5);
        BLOCK_HARDNESS.put(Material.COBBLESTONE, 1.5);
        BLOCK_HARDNESS.put(Material.SANDSTONE, 1.5);
        BLOCK_HARDNESS.put(Material.SMOOTH_SANDSTONE, 1.5);
        BLOCK_HARDNESS.put(Material.CHISELED_SANDSTONE, 1.5);
        BLOCK_HARDNESS.put(Material.CUT_SANDSTONE, 1.5);
        BLOCK_HARDNESS.put(Material.RED_SANDSTONE, 1.5);
        BLOCK_HARDNESS.put(Material.SMOOTH_RED_SANDSTONE, 1.5);
        BLOCK_HARDNESS.put(Material.CHISELED_RED_SANDSTONE, 1.5);
        BLOCK_HARDNESS.put(Material.CUT_RED_SANDSTONE, 1.5);
        BLOCK_HARDNESS.put(Material.OBSIDIAN, 50.0);
        BLOCK_HARDNESS.put(Material.CRYING_OBSIDIAN, 50.0);
        BLOCK_HARDNESS.put(Material.DIRT, 0.5);
        BLOCK_HARDNESS.put(Material.GRASS_BLOCK, 0.6);
        BLOCK_HARDNESS.put(Material.PODZOL, 0.5);
        BLOCK_HARDNESS.put(Material.MYCELIUM, 0.5);
        BLOCK_HARDNESS.put(Material.COARSE_DIRT, 0.5);
        BLOCK_HARDNESS.put(Material.ROOTED_DIRT, 0.5);
        BLOCK_HARDNESS.put(Material.SAND, 0.5);
        BLOCK_HARDNESS.put(Material.RED_SAND, 0.5);
        BLOCK_HARDNESS.put(Material.GRAVEL, 0.5);
        BLOCK_HARDNESS.put(Material.SOUL_SAND, 0.5);
        BLOCK_HARDNESS.put(Material.SOUL_SOIL, 0.5);
        BLOCK_HARDNESS.put(Material.CLAY, 0.6);
        BLOCK_HARDNESS.put(Material.DEEPSLATE, 3.0);
        BLOCK_HARDNESS.put(Material.COBBLED_DEEPSLATE, 3.0);
        BLOCK_HARDNESS.put(Material.POLISHED_DEEPSLATE, 3.0);
        BLOCK_HARDNESS.put(Material.REINFORCED_DEEPSLATE, 55.0);
        BLOCK_HARDNESS.put(Material.NETHERRACK, 0.4);
        BLOCK_HARDNESS.put(Material.NETHER_WART_BLOCK, 0.4);
        BLOCK_HARDNESS.put(Material.WARPED_WART_BLOCK, 0.4);
        BLOCK_HARDNESS.put(Material.END_STONE, 3.0);
        BLOCK_HARDNESS.put(Material.DIAMOND_ORE, 3.0);
        BLOCK_HARDNESS.put(Material.DEEPSLATE_DIAMOND_ORE, 3.0);
        BLOCK_HARDNESS.put(Material.EMERALD_ORE, 3.0);
        BLOCK_HARDNESS.put(Material.DEEPSLATE_EMERALD_ORE, 3.0);
        BLOCK_HARDNESS.put(Material.COAL_ORE, 3.0);
        BLOCK_HARDNESS.put(Material.DEEPSLATE_COAL_ORE, 3.0);
        BLOCK_HARDNESS.put(Material.IRON_ORE, 3.0);
        BLOCK_HARDNESS.put(Material.DEEPSLATE_IRON_ORE, 3.0);
        BLOCK_HARDNESS.put(Material.GOLD_ORE, 3.0);
        BLOCK_HARDNESS.put(Material.DEEPSLATE_GOLD_ORE, 3.0);
        BLOCK_HARDNESS.put(Material.LAPIS_ORE, 3.0);
        BLOCK_HARDNESS.put(Material.DEEPSLATE_LAPIS_ORE, 3.0);
        BLOCK_HARDNESS.put(Material.REDSTONE_ORE, 3.0);
        BLOCK_HARDNESS.put(Material.DEEPSLATE_REDSTONE_ORE, 3.0);
        BLOCK_HARDNESS.put(Material.COPPER_ORE, 3.0);
        BLOCK_HARDNESS.put(Material.DEEPSLATE_COPPER_ORE, 3.0);
        BLOCK_HARDNESS.put(Material.NETHER_GOLD_ORE, 3.0);
        BLOCK_HARDNESS.put(Material.NETHER_QUARTZ_ORE, 3.0);
        BLOCK_HARDNESS.put(Material.ANCIENT_DEBRIS, 30.0);
        BLOCK_HARDNESS.put(Material.COPPER_BLOCK, 3.0);
        BLOCK_HARDNESS.put(Material.EXPOSED_COPPER, 3.0);
        BLOCK_HARDNESS.put(Material.WEATHERED_COPPER, 3.0);
        BLOCK_HARDNESS.put(Material.OXIDIZED_COPPER, 3.0);
        BLOCK_HARDNESS.put(Material.CUT_COPPER, 3.0);
        BLOCK_HARDNESS.put(Material.WAXED_COPPER_BLOCK, 3.0);
        BLOCK_HARDNESS.put(Material.WAXED_EXPOSED_COPPER, 3.0);
        BLOCK_HARDNESS.put(Material.WAXED_WEATHERED_COPPER, 3.0);
        BLOCK_HARDNESS.put(Material.WAXED_OXIDIZED_COPPER, 3.0);
        BLOCK_HARDNESS.put(Material.WAXED_CUT_COPPER, 3.0);
        BLOCK_HARDNESS.put(Material.AMETHYST_BLOCK, 1.5);
        BLOCK_HARDNESS.put(Material.BUDDING_AMETHYST, 1.5);
        BLOCK_HARDNESS.put(Material.SCULK, 1.5);
        BLOCK_HARDNESS.put(Material.SCULK_CATALYST, 1.5);
        BLOCK_HARDNESS.put(Material.SCULK_SENSOR, 1.5);
        BLOCK_HARDNESS.put(Material.SCULK_SHRIEKER, 1.5);
        BLOCK_HARDNESS.put(Material.SCULK_VEIN, 1.5);
        BLOCK_HARDNESS.put(Material.POINTED_DRIPSTONE, 1.5);
        BLOCK_HARDNESS.put(Material.DRIPSTONE_BLOCK, 1.5);
        BLOCK_HARDNESS.put(Material.TUFF, 1.5);
        BLOCK_HARDNESS.put(Material.CALCITE, 1.5);
        BLOCK_HARDNESS.put(Material.ANDESITE, 1.5);
        BLOCK_HARDNESS.put(Material.DIORITE, 1.5);
        BLOCK_HARDNESS.put(Material.GRANITE, 1.5);
        BLOCK_HARDNESS.put(Material.POLISHED_ANDESITE, 1.5);
        BLOCK_HARDNESS.put(Material.POLISHED_DIORITE, 1.5);
        BLOCK_HARDNESS.put(Material.POLISHED_GRANITE, 1.5);
        BLOCK_HARDNESS.put(Material.BASALT, 1.25);
        BLOCK_HARDNESS.put(Material.SMOOTH_BASALT, 1.25);
        BLOCK_HARDNESS.put(Material.POLISHED_BASALT, 1.25);
        BLOCK_HARDNESS.put(Material.BLACKSTONE, 1.5);
        BLOCK_HARDNESS.put(Material.POLISHED_BLACKSTONE, 1.5);
        BLOCK_HARDNESS.put(Material.GILDED_BLACKSTONE, 1.5);
        BLOCK_HARDNESS.put(Material.SNOW, 0.2);
        BLOCK_HARDNESS.put(Material.SNOW_BLOCK, 0.2);
        BLOCK_HARDNESS.put(Material.ICE, 0.5);
        BLOCK_HARDNESS.put(Material.PACKED_ICE, 0.5);
        BLOCK_HARDNESS.put(Material.BLUE_ICE, 0.5);
        BLOCK_HARDNESS.put(Material.TERRACOTTA, 1.25);
        BLOCK_HARDNESS.put(Material.WHITE_TERRACOTTA, 1.25);
        BLOCK_HARDNESS.put(Material.ORANGE_TERRACOTTA, 1.25);
        BLOCK_HARDNESS.put(Material.MAGENTA_TERRACOTTA, 1.25);
        BLOCK_HARDNESS.put(Material.LIGHT_BLUE_TERRACOTTA, 1.25);
        BLOCK_HARDNESS.put(Material.YELLOW_TERRACOTTA, 1.25);
        BLOCK_HARDNESS.put(Material.LIME_TERRACOTTA, 1.25);
        BLOCK_HARDNESS.put(Material.PINK_TERRACOTTA, 1.25);
        BLOCK_HARDNESS.put(Material.GRAY_TERRACOTTA, 1.25);
        BLOCK_HARDNESS.put(Material.LIGHT_GRAY_TERRACOTTA, 1.25);
        BLOCK_HARDNESS.put(Material.CYAN_TERRACOTTA, 1.25);
        BLOCK_HARDNESS.put(Material.PURPLE_TERRACOTTA, 1.25);
        BLOCK_HARDNESS.put(Material.BLUE_TERRACOTTA, 1.25);
        BLOCK_HARDNESS.put(Material.BROWN_TERRACOTTA, 1.25);
        BLOCK_HARDNESS.put(Material.GREEN_TERRACOTTA, 1.25);
        BLOCK_HARDNESS.put(Material.RED_TERRACOTTA, 1.25);
        BLOCK_HARDNESS.put(Material.BLACK_TERRACOTTA, 1.25);
        BLOCK_HARDNESS.put(Material.GLOWSTONE, 0.3);
        BLOCK_HARDNESS.put(Material.GLASS, 0.3);
        BLOCK_HARDNESS.put(Material.WHITE_STAINED_GLASS, 0.3);
        BLOCK_HARDNESS.put(Material.ORANGE_STAINED_GLASS, 0.3);
        BLOCK_HARDNESS.put(Material.MAGENTA_STAINED_GLASS, 0.3);
        BLOCK_HARDNESS.put(Material.LIGHT_BLUE_STAINED_GLASS, 0.3);
        BLOCK_HARDNESS.put(Material.YELLOW_STAINED_GLASS, 0.3);
        BLOCK_HARDNESS.put(Material.LIME_STAINED_GLASS, 0.3);
        BLOCK_HARDNESS.put(Material.PINK_STAINED_GLASS, 0.3);
        BLOCK_HARDNESS.put(Material.GRAY_STAINED_GLASS, 0.3);
        BLOCK_HARDNESS.put(Material.LIGHT_GRAY_STAINED_GLASS, 0.3);
        BLOCK_HARDNESS.put(Material.CYAN_STAINED_GLASS, 0.3);
        BLOCK_HARDNESS.put(Material.PURPLE_STAINED_GLASS, 0.3);
        BLOCK_HARDNESS.put(Material.BLUE_STAINED_GLASS, 0.3);
        BLOCK_HARDNESS.put(Material.BROWN_STAINED_GLASS, 0.3);
        BLOCK_HARDNESS.put(Material.GREEN_STAINED_GLASS, 0.3);
        BLOCK_HARDNESS.put(Material.RED_STAINED_GLASS, 0.3);
        BLOCK_HARDNESS.put(Material.BLACK_STAINED_GLASS, 0.3);
        BLOCK_HARDNESS.put(Material.TALL_GRASS, 0.0);
        BLOCK_HARDNESS.put(Material.SHORT_GRASS, 0.0);
        BLOCK_HARDNESS.put(Material.FERN, 0.0);
        BLOCK_HARDNESS.put(Material.LARGE_FERN, 0.0);
        BLOCK_HARDNESS.put(Material.DEAD_BUSH, 0.0);
        BLOCK_HARDNESS.put(Material.DANDELION, 0.0);
        BLOCK_HARDNESS.put(Material.POPPY, 0.0);
        BLOCK_HARDNESS.put(Material.BLUE_ORCHID, 0.0);
        BLOCK_HARDNESS.put(Material.ALLIUM, 0.0);
        BLOCK_HARDNESS.put(Material.AZURE_BLUET, 0.0);
        BLOCK_HARDNESS.put(Material.RED_TULIP, 0.0);
        BLOCK_HARDNESS.put(Material.ORANGE_TULIP, 0.0);
        BLOCK_HARDNESS.put(Material.WHITE_TULIP, 0.0);
        BLOCK_HARDNESS.put(Material.PINK_TULIP, 0.0);
        BLOCK_HARDNESS.put(Material.OXEYE_DAISY, 0.0);
        BLOCK_HARDNESS.put(Material.CORNFLOWER, 0.0);
        BLOCK_HARDNESS.put(Material.LILY_OF_THE_VALLEY, 0.0);
        BLOCK_HARDNESS.put(Material.WITHER_ROSE, 0.0);
        BLOCK_HARDNESS.put(Material.SUNFLOWER, 0.0);
        BLOCK_HARDNESS.put(Material.LILAC, 0.0);
        BLOCK_HARDNESS.put(Material.ROSE_BUSH, 0.0);
        BLOCK_HARDNESS.put(Material.PEONY, 0.0);
        BLOCK_HARDNESS.put(Material.OAK_SAPLING, 0.0);
        BLOCK_HARDNESS.put(Material.SPRUCE_SAPLING, 0.0);
        BLOCK_HARDNESS.put(Material.BIRCH_SAPLING, 0.0);
        BLOCK_HARDNESS.put(Material.JUNGLE_SAPLING, 0.0);
        BLOCK_HARDNESS.put(Material.ACACIA_SAPLING, 0.0);
        BLOCK_HARDNESS.put(Material.DARK_OAK_SAPLING, 0.0);
        BLOCK_HARDNESS.put(Material.RED_MUSHROOM, 0.0);
        BLOCK_HARDNESS.put(Material.BROWN_MUSHROOM, 0.0);
        BLOCK_HARDNESS.put(Material.CRIMSON_FUNGUS, 0.0);
        BLOCK_HARDNESS.put(Material.WARPED_FUNGUS, 0.0);
        BLOCK_HARDNESS.put(Material.TORCH, 0.0);
        BLOCK_HARDNESS.put(Material.REDSTONE_TORCH, 0.0);
        BLOCK_HARDNESS.put(Material.FIRE, 0.0);
    }

    private double getBlockHardness(Material material) {
        Double hardness = BLOCK_HARDNESS.get(material);
        if (hardness != null) {
            return hardness;
        }
        String name = material.name();
        if (name.contains("LOG") || name.contains("WOOD") && !name.contains("SWORD")) {
            return 2.0;
        }
        if (name.contains("LEAVES")) {
            return 0.2;
        }
        if (name.contains("PLANKS")) {
            return 2.0;
        }
        if (name.contains("WOOL") || name.contains("CARPET")) {
            return 0.8;
        }
        if (name.contains("CONCRETE") && !name.contains("POWDER")) {
            return 1.8;
        }
        if (name.contains("CONCRETE_POWDER")) {
            return 0.5;
        }
        if (name.contains("SPONGE")) {
            return 0.6;
        }
        if (name.contains("_STEM")) {
            return 2.0;
        }
        if (name.contains("PUMPKIN") || name.contains("MELON")) {
            return 1.0;
        }
        return 1.0;
    }

    private boolean canToolHarvest(Material blockType, EnhancementTracker.BlockBreakEnhancements enhancements) {
        String blockName = blockType.name();
        String toolMaterial = enhancements.toolMaterial;
        if (blockName.contains("STONE") || blockName.contains("_ORE") || blockName.contains("COBBLESTONE")) {
            if (!enhancements.hasCorrectTool) {
                return false;
            }
            if (toolMaterial.equals("WOOD")) {
                return false;
            }
            if (blockType == Material.OBSIDIAN || blockType == Material.CRYING_OBSIDIAN) {
                return toolMaterial.equals("DIAMOND") || toolMaterial.equals("NETHERITE");
            }
            if (blockName.contains("DIAMOND") || blockName.contains("EMERALD")) {
                return toolMaterial.equals("IRON") || toolMaterial.equals("DIAMOND") || toolMaterial.equals("NETHERITE");
            }
            if (blockName.contains("GOLD") || blockName.contains("REDSTONE")) {
                return !toolMaterial.equals("WOOD");
            }
            return true;
        }
        if (blockName.contains("LOG") || blockName.contains("PLANKS")) {
            return enhancements.hasCorrectTool;
        }
        return true;
    }

    private double getTPSMultiplier() {
        try {
            double tps = this.getAverageTPS();
            if (tps < 15.0) {
                return 1.6;
            }
            if (tps < 17.0) {
                return 1.4;
            }
            if (tps < 19.0) {
                return 1.2;
            }
            return 1.0;
        }
        catch (Exception e) {
            return 1.0;
        }
    }

    private double getAverageTPS() {
        try {
            Object server = Bukkit.getServer().getClass().getMethod("getServer", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
            double[] recentTps = (double[])server.getClass().getField("recentTps").get(server);
            return Math.min(20.0, recentTps[0]);
        }
        catch (Exception e) {
            return 20.0;
        }
    }

    public void cleanup(UUID playerId) {
        this.profiler.cleanup(playerId);
        this.packetAnalyzer.cleanup(playerId);
        this.falsePositiveFilter.cleanup(playerId);
        this.lastCheckTime.remove(playerId);
        this.rapidCheckCount.remove(playerId);
    }

    public void cleanupStale() {
        long now = System.currentTimeMillis();
        this.lastCheckTime.entrySet().removeIf(entry -> now - (Long)entry.getValue() > 60000L);
        this.rapidCheckCount.entrySet().removeIf(entry -> !this.lastCheckTime.containsKey(entry.getKey()));
    }

    static {
        FastBreakCheck.initializeBlockHardness();
    }
}

