/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.detection.block;

import NC.noChance.core.ACConfig;
import NC.noChance.core.CheckResult;
import NC.noChance.core.LayerFiltering;
import NC.noChance.core.PlayerData;
import NC.noChance.core.ViolationType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class FastPlaceCheck {
    private final ACConfig config;
    private final Map<UUID, PlayerData> playerDataMap;
    private final LayerFiltering filtering;

    public FastPlaceCheck(ACConfig config, Map<UUID, PlayerData> playerDataMap, LayerFiltering filtering) {
        this.config = config;
        this.playerDataMap = playerDataMap;
        this.filtering = filtering;
    }

    public CheckResult check(Player player, Location blockLocation) {
        CheckResult scaffoldResult;
        Deque<Long> intervals;
        if (!this.config.isCheckEnabled("fastplace")) {
            return CheckResult.passed();
        }
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data == null) {
            return CheckResult.passed();
        }
        if (data.isInGracePeriod(this.config.getGracePeriod())) {
            return CheckResult.passed();
        }
        long now = System.currentTimeMillis();
        long lastPlaceTime = data.getLastBlockPlaceTime();
        if (lastPlaceTime == 0L) {
            data.setLastBlockPlaceTime(now);
            data.setLastBlockPlace(blockLocation);
            data.addBlockPlaceLocation(blockLocation);
            return CheckResult.passed();
        }
        long interval = now - lastPlaceTime;
        data.setLastBlockPlaceTime(now);
        data.addBlockPlaceInterval(interval);
        data.setLastBlockPlace(blockLocation);
        data.addBlockPlaceLocation(blockLocation);
        int currentTick = (int)(now / 50L % 20L);
        if (currentTick != data.getCurrentTick()) {
            data.setCurrentTick(currentTick);
            data.resetBlocksPlacedInTick();
        }
        data.incrementBlocksPlacedInTick();
        double tps = this.getCurrentTPS();
        int maxBlocksPerTick = this.config.getFastPlaceMaxBlocksPerTick();
        if (tps < 19.0) {
            maxBlocksPerTick = (int)Math.ceil((double)maxBlocksPerTick * (20.0 / tps));
        }
        if (data.getBlocksPlacedInTick() > maxBlocksPerTick) {
            CheckResult prelimResult = CheckResult.failed(ViolationType.FASTPLACE, Math.min(1.0, (double)data.getBlocksPlacedInTick() / (double)maxBlocksPerTick), String.format("Placed %d blocks in single tick (max: %d, TPS: %.1f)", data.getBlocksPlacedInTick(), maxBlocksPerTick, tps));
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.FASTPLACE, prelimResult)) {
                return CheckResult.passed();
            }
            return prelimResult;
        }
        Deque<PlayerData.LocationData> placements = data.getBlockPlaceLocations();
        if (placements.size() >= 5) {
            long oneSecondAgo = now - 1000L;
            int placesInLastSecond = 0;
            for (PlayerData.LocationData placement : placements) {
                if (placement.timestamp <= oneSecondAgo) continue;
                ++placesInLastSecond;
            }
            int maxPlacesPerSecond = this.config.getFastPlaceMaxBlocksPerSecond();
            if (tps < 19.0) {
                maxPlacesPerSecond = (int)Math.ceil((double)maxPlacesPerSecond * (20.0 / tps));
            }
            if (placesInLastSecond > maxPlacesPerSecond) {
                CheckResult prelimResult = CheckResult.failed(ViolationType.FASTPLACE, Math.min(1.0, (double)placesInLastSecond / (double)maxPlacesPerSecond), String.format("Placed %d blocks/second (max: %d, TPS: %.1f)", placesInLastSecond, maxPlacesPerSecond, tps));
                if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.FASTPLACE, prelimResult)) {
                    return CheckResult.passed();
                }
                return prelimResult;
            }
        }
        if ((intervals = data.getBlockPlaceIntervals()).size() >= 5) {
            ArrayList<Long> intervalList = new ArrayList<Long>(intervals);
            ArrayList<Long> recentIntervals = new ArrayList<Long>();
            for (int i = Math.max(0, intervalList.size() - 10); i < intervalList.size(); ++i) {
                recentIntervals.add((Long)intervalList.get(i));
            }
            double mean = recentIntervals.stream().mapToLong(Long::longValue).average().orElse(0.0);
            double variance = recentIntervals.stream().mapToDouble(v -> Math.pow((double)v.longValue() - mean, 2.0)).average().orElse(0.0);
            double stdDev = Math.sqrt(variance);
            int minInterval = this.config.getFastPlaceMinIntervalMs();
            if (stdDev < 8.0 && mean < (double)minInterval && mean > 0.0) {
                CheckResult prelimResult = CheckResult.failed(ViolationType.FASTPLACE, Math.min(1.0, ((double)minInterval - mean) / (double)minInterval), String.format("Block placement too consistent: Mean=%.1fms, StdDev=%.2fms (min: %dms)", mean, stdDev, minInterval));
                if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.FASTPLACE, prelimResult)) {
                    return CheckResult.passed();
                }
                return prelimResult;
            }
        }
        if ((scaffoldResult = this.checkScaffoldPattern(player, blockLocation, data)).isFailed()) {
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.FASTPLACE, scaffoldResult)) {
                return CheckResult.passed();
            }
            return scaffoldResult;
        }
        return CheckResult.passed();
    }

    private CheckResult checkScaffoldPattern(Player player, Location blockLocation, PlayerData data) {
        Deque<PlayerData.LocationData> placements = data.getBlockPlaceLocations();
        if (placements.size() < this.config.getFastPlaceScaffoldMinBlocks()) {
            return CheckResult.passed();
        }
        ArrayList<PlayerData.LocationData> recentPlacements = new ArrayList<PlayerData.LocationData>();
        long now = System.currentTimeMillis();
        for (PlayerData.LocationData placement : placements) {
            if (now - placement.timestamp >= 2000L) continue;
            recentPlacements.add(placement);
        }
        if (recentPlacements.size() < this.config.getFastPlaceScaffoldMinBlocks()) {
            return CheckResult.passed();
        }
        Location playerLoc = player.getLocation();
        Vector playerDir = playerLoc.getDirection().normalize();
        int scaffoldCount = 0;
        double totalDistance = 0.0;
        double totalAngle = 0.0;
        for (PlayerData.LocationData placement : recentPlacements) {
            Vector toBlock;
            double angle;
            Location placeLoc = placement.location;
            double distance = playerLoc.distance(placeLoc);
            if (distance > this.config.getFastPlaceMaxScaffoldDistance() || !((angle = Math.toDegrees(Math.acos(playerDir.dot(toBlock = placeLoc.toVector().subtract(playerLoc.toVector()).normalize())))) < this.config.getFastPlaceMaxScaffoldAngle())) continue;
            ++scaffoldCount;
            totalDistance += distance;
            totalAngle += angle;
        }
        if (scaffoldCount >= this.config.getFastPlaceScaffoldMinBlocks()) {
            double avgDistance = totalDistance / (double)scaffoldCount;
            double avgAngle = totalAngle / (double)scaffoldCount;
            if (avgAngle < 25.0 && avgDistance < 4.0) {
                return CheckResult.failed(ViolationType.FASTPLACE, Math.min(1.0, (double)scaffoldCount / 8.0), String.format("Scaffold pattern: %d blocks, avg angle: %.1f\u00b0, avg dist: %.1f", scaffoldCount, avgAngle, avgDistance));
            }
        }
        return CheckResult.passed();
    }

    private double getCurrentTPS() {
        try {
            Server server = Bukkit.getServer();
            Method getTPS = server.getClass().getMethod("getTPS", new Class[0]);
            double[] tpsArray = (double[])getTPS.invoke((Object)server, new Object[0]);
            return tpsArray[0];
        }
        catch (Exception e) {
            return 20.0;
        }
    }

    public void cleanup(UUID playerId) {
    }
}

