/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.detection.block;

import NC.noChance.core.ACConfig;
import NC.noChance.core.CheckResult;
import NC.noChance.core.LayerFiltering;
import NC.noChance.core.PlayerData;
import NC.noChance.core.ViolationType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class NukerCheck {
    private final ACConfig config;
    private final Map<UUID, PlayerData> playerDataMap;
    private final LayerFiltering filtering;
    private final Map<UUID, List<BlockBreakRecord>> recentBreaks;

    public NukerCheck(ACConfig config, Map<UUID, PlayerData> playerDataMap, LayerFiltering filtering) {
        this.config = config;
        this.playerDataMap = playerDataMap;
        this.filtering = filtering;
        this.recentBreaks = new ConcurrentHashMap<UUID, List<BlockBreakRecord>>();
    }

    public CheckResult check(Player player, Location blockLocation) {
        double avgSpread;
        if (!this.config.isCheckEnabled("nuker")) {
            return CheckResult.passed();
        }
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data == null) {
            return CheckResult.passed();
        }
        if (data.isInGracePeriod(this.config.getGracePeriod())) {
            return CheckResult.passed();
        }
        UUID playerId = player.getUniqueId();
        long now = System.currentTimeMillis();
        List breaks = this.recentBreaks.computeIfAbsent(playerId, k -> new ArrayList());
        breaks.add(new BlockBreakRecord(blockLocation, now));
        breaks.removeIf(record -> now - record.timestamp > 500L);
        if (breaks.size() < 3) {
            return CheckResult.passed();
        }
        int simultaneousBreaks = this.countSimultaneousBreaks(breaks);
        if (simultaneousBreaks >= 3) {
            String toolInfo = this.getToolInfo(player);
            double bps = (double)breaks.size() / 0.5;
            String pattern = this.analyzeBreakPattern(breaks);
            CheckResult prelimResult = CheckResult.failed(ViolationType.NUKER, Math.min(1.0, (double)simultaneousBreaks / 4.0), String.format("[MULTI-BREAK] %d blocks/tick | Tool: %s | BPS: %.1f | Pattern: %s", simultaneousBreaks, toolInfo, bps, pattern));
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.NUKER, prelimResult)) {
                return CheckResult.passed();
            }
            return prelimResult;
        }
        List<BlockBreakRecord> recentBreaks = this.getRecentBreaks(breaks, 300L);
        if (recentBreaks.size() >= 5 && (avgSpread = this.calculateAverageSpread(recentBreaks)) > 3.5) {
            String toolInfo = this.getToolInfo(player);
            double bps = (double)recentBreaks.size() / 0.3;
            String pattern = this.analyzeBreakPattern(recentBreaks);
            CheckResult prelimResult = CheckResult.failed(ViolationType.NUKER, Math.min(1.0, avgSpread / 6.0), String.format("[SPREAD] Avg spread: %.1f blocks | Tool: %s | BPS: %.1f | Blocks: %d | Pattern: %s", avgSpread, toolInfo, bps, recentBreaks.size(), pattern));
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.NUKER, prelimResult)) {
                return CheckResult.passed();
            }
            return prelimResult;
        }
        return CheckResult.passed();
    }

    private int countSimultaneousBreaks(List<BlockBreakRecord> breaks) {
        HashMap<Long, Integer> breaksPerTick = new HashMap<Long, Integer>();
        for (BlockBreakRecord record : breaks) {
            long tick = record.timestamp / 50L;
            breaksPerTick.put(tick, breaksPerTick.getOrDefault(tick, 0) + 1);
        }
        return breaksPerTick.values().stream().max(Integer::compareTo).orElse(0);
    }

    private double calculateMaxBreakRadius(List<BlockBreakRecord> breaks) {
        if (breaks.size() < 2) {
            return 0.0;
        }
        double maxDistance = 0.0;
        for (int i = 0; i < breaks.size(); ++i) {
            for (int j = i + 1; j < breaks.size(); ++j) {
                Location loc1 = breaks.get((int)i).location;
                Location loc2 = breaks.get((int)j).location;
                double distance = loc1.distance(loc2);
                maxDistance = Math.max(maxDistance, distance);
            }
        }
        return maxDistance;
    }

    private List<BlockBreakRecord> getRecentBreaks(List<BlockBreakRecord> allBreaks, long windowMs) {
        long cutoff = System.currentTimeMillis() - windowMs;
        ArrayList<BlockBreakRecord> recent = new ArrayList<BlockBreakRecord>();
        for (BlockBreakRecord record : allBreaks) {
            if (record.timestamp <= cutoff) continue;
            recent.add(record);
        }
        return recent;
    }

    private double calculateAverageSpread(List<BlockBreakRecord> breaks) {
        if (breaks.size() < 2) {
            return 0.0;
        }
        double totalDistance = 0.0;
        int comparisons = 0;
        for (int i = 0; i < breaks.size(); ++i) {
            for (int j = i + 1; j < breaks.size(); ++j) {
                Location loc1 = breaks.get((int)i).location;
                Location loc2 = breaks.get((int)j).location;
                totalDistance += loc1.distance(loc2);
                ++comparisons;
            }
        }
        return comparisons > 0 ? totalDistance / (double)comparisons : 0.0;
    }

    private String getToolInfo(Player player) {
        ItemStack tool = player.getInventory().getItemInMainHand();
        if (tool == null || tool.getType() == Material.AIR) {
            return "Hand";
        }
        Enchantment effEnch = Enchantment.getByName((String)"EFFICIENCY");
        int effLevel = 0;
        if (effEnch != null) {
            effLevel = tool.getEnchantmentLevel(effEnch);
        }
        String toolName = tool.getType().name().replace("_", " ");
        if (effLevel > 0) {
            return String.format("%s (Eff:%d)", toolName, effLevel);
        }
        return toolName;
    }

    private String analyzeBreakPattern(List<BlockBreakRecord> breaks) {
        if (breaks.size() < 3) {
            return "Linear";
        }
        HashSet<Integer> uniqueX = new HashSet<Integer>();
        HashSet<Integer> uniqueY = new HashSet<Integer>();
        HashSet<Integer> uniqueZ = new HashSet<Integer>();
        for (BlockBreakRecord record : breaks) {
            uniqueX.add(record.location.getBlockX());
            uniqueY.add(record.location.getBlockY());
            uniqueZ.add(record.location.getBlockZ());
        }
        if (uniqueY.size() == 1 && (uniqueX.size() > 2 || uniqueZ.size() > 2)) {
            return "Horizontal Layer";
        }
        if (uniqueX.size() == 1 && uniqueZ.size() == 1) {
            return "Vertical Tunnel";
        }
        if (uniqueX.size() > 2 && uniqueY.size() > 2 && uniqueZ.size() > 2) {
            return "3D Sphere/Cube";
        }
        if (uniqueX.size() == 1 || uniqueZ.size() == 1) {
            return "Tunnel/Line";
        }
        return "Scattered";
    }

    public void cleanup(UUID playerId) {
        this.recentBreaks.remove(playerId);
    }

    private static class BlockBreakRecord {
        final Location location;
        final long timestamp;

        BlockBreakRecord(Location location, long timestamp) {
            this.location = location;
            this.timestamp = timestamp;
        }
    }
}

