/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.detection.block;

import NC.noChance.core.ACConfig;
import NC.noChance.core.CheckResult;
import NC.noChance.core.LayerFiltering;
import NC.noChance.core.PlayerData;
import NC.noChance.core.ViolationType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;

public class ScaffoldCheck {
    private final ACConfig config;
    private final Map<UUID, PlayerData> playerDataMap;
    private final LayerFiltering filtering;
    private final Map<UUID, List<BlockPlaceRecord>> recentPlacements;

    public ScaffoldCheck(ACConfig config, Map<UUID, PlayerData> playerDataMap, LayerFiltering filtering) {
        this.config = config;
        this.playerDataMap = playerDataMap;
        this.filtering = filtering;
        this.recentPlacements = new HashMap<UUID, List<BlockPlaceRecord>>();
    }

    public CheckResult check(Player player, Block block) {
        int i;
        double playerDistance;
        if (!this.config.isCheckEnabled("scaffold")) {
            return CheckResult.passed();
        }
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data == null) {
            return CheckResult.passed();
        }
        if (data.isInGracePeriod(this.config.getGracePeriod())) {
            return CheckResult.passed();
        }
        UUID playerId = player.getUniqueId();
        long now = System.currentTimeMillis();
        Location blockLoc = block.getLocation();
        List placements = this.recentPlacements.computeIfAbsent(playerId, k -> new ArrayList());
        placements.add(new BlockPlaceRecord(blockLoc, now));
        placements.removeIf(record -> now - record.timestamp > 3000L);
        boolean hasSupport = false;
        for (BlockFace face : new BlockFace[]{BlockFace.DOWN, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}) {
            Block adjacent = block.getRelative(face);
            if (!adjacent.getType().isSolid()) continue;
            hasSupport = true;
            break;
        }
        double playerY = player.getLocation().getY();
        double blockY = blockLoc.getY();
        double verticalDiff = blockY - playerY;
        if (!hasSupport && verticalDiff > 2.8 && (playerDistance = player.getLocation().distance(blockLoc)) > 5.8) {
            CheckResult prelimResult = CheckResult.failed(ViolationType.SCAFFOLD, 0.92, String.format("Impossible placement: %.1f blocks away, %.1f blocks above", playerDistance, verticalDiff));
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.SCAFFOLD, prelimResult)) {
                return CheckResult.passed();
            }
            return prelimResult;
        }
        if (placements.size() >= 7) {
            ArrayList<Long> placementTimes = new ArrayList<Long>();
            for (i = 1; i < placements.size(); ++i) {
                placementTimes.add(((BlockPlaceRecord)placements.get((int)i)).timestamp - ((BlockPlaceRecord)placements.get((int)(i - 1))).timestamp);
            }
            if (placementTimes.size() >= 5) {
                double avgTime = placementTimes.stream().mapToLong(Long::longValue).average().orElse(0.0);
                double variance = this.calculateVariance(placementTimes);
                if (avgTime < 90.0 && variance < 45.0) {
                    int sameYCount = 0;
                    double avgY = placements.stream().mapToDouble(r -> r.location.getY()).average().orElse(0.0);
                    for (BlockPlaceRecord record2 : placements) {
                        if (!(Math.abs(record2.location.getY() - avgY) < 0.5)) continue;
                        ++sameYCount;
                    }
                    if (sameYCount >= 5) {
                        CheckResult prelimResult = CheckResult.failed(ViolationType.SCAFFOLD, 0.88, String.format("Scaffold pattern: %d blocks, %.0fms avg, %.0f variance", sameYCount, avgTime, variance));
                        if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.SCAFFOLD, prelimResult)) {
                            return CheckResult.passed();
                        }
                        return prelimResult;
                    }
                }
            }
        }
        ArrayList<BlockPlaceRecord> towerBlocks = new ArrayList<BlockPlaceRecord>();
        for (i = 1; i < placements.size(); ++i) {
            BlockPlaceRecord prev = (BlockPlaceRecord)placements.get(i - 1);
            BlockPlaceRecord curr = (BlockPlaceRecord)placements.get(i);
            if (curr.location.getY() != prev.location.getY() + 1.0 || curr.location.getX() != prev.location.getX() || curr.location.getZ() != prev.location.getZ() || !towerBlocks.isEmpty() && towerBlocks.get(towerBlocks.size() - 1) != prev) continue;
            if (towerBlocks.isEmpty()) {
                towerBlocks.add(prev);
            }
            towerBlocks.add(curr);
        }
        if (towerBlocks.size() >= 4) {
            ArrayList<Long> towerTimes = new ArrayList<Long>();
            for (int i2 = 1; i2 < towerBlocks.size(); ++i2) {
                towerTimes.add(((BlockPlaceRecord)towerBlocks.get((int)i2)).timestamp - ((BlockPlaceRecord)towerBlocks.get((int)(i2 - 1))).timestamp);
            }
            if (!towerTimes.isEmpty()) {
                double avgTime = towerTimes.stream().mapToLong(Long::longValue).average().orElse(0.0);
                double variance = this.calculateVariance(towerTimes);
                if (avgTime < 90.0 && variance < 90.0) {
                    CheckResult prelimResult = CheckResult.failed(ViolationType.SCAFFOLD, Math.min(1.0, (140.0 - avgTime) / 140.0), String.format("Tower cheat: %d blocks, %.0fms avg, %.0f variance", towerBlocks.size(), avgTime, variance));
                    if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.SCAFFOLD, prelimResult)) {
                        return CheckResult.passed();
                    }
                    return prelimResult;
                }
            }
        }
        return CheckResult.passed();
    }

    private double calculateVariance(List<Long> values) {
        if (values.isEmpty()) {
            return 0.0;
        }
        double mean = values.stream().mapToLong(Long::longValue).average().orElse(0.0);
        return values.stream().mapToDouble(v -> Math.pow((double)v.longValue() - mean, 2.0)).average().orElse(0.0);
    }

    public void cleanup(UUID playerId) {
        this.recentPlacements.remove(playerId);
    }

    private static class BlockPlaceRecord {
        final Location location;
        final long timestamp;

        BlockPlaceRecord(Location location, long timestamp) {
            this.location = location;
            this.timestamp = timestamp;
        }
    }
}

