/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.detection.combat;

import NC.noChance.core.ACConfig;
import NC.noChance.core.CheckResult;
import NC.noChance.core.LayerFiltering;
import NC.noChance.core.PlayerData;
import NC.noChance.core.TimingStats;
import NC.noChance.core.ViolationType;
import java.util.Deque;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class AutoClickerCheck {
    private final ACConfig config;
    private final Map<UUID, PlayerData> playerDataMap;
    private final LayerFiltering filtering;
    private final TimingStats timingAnalyzer;

    public AutoClickerCheck(ACConfig config, Map<UUID, PlayerData> playerDataMap, LayerFiltering filtering) {
        this.config = config;
        this.playerDataMap = playerDataMap;
        this.filtering = filtering;
        this.timingAnalyzer = new TimingStats();
    }

    public CheckResult check(Player player) {
        int maxCPS;
        if (!this.config.isCheckEnabled("autoclicker")) {
            return CheckResult.passed();
        }
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data == null) {
            return CheckResult.passed();
        }
        if (data.isInGracePeriod(this.config.getGracePeriod())) {
            return CheckResult.passed();
        }
        Deque<Long> clickHistory = data.getClickHistory();
        if (clickHistory.size() < 12) {
            return CheckResult.passed();
        }
        TimingStats.TimingPattern pattern = TimingStats.analyzeTimings(clickHistory);
        if (pattern.suspicious) {
            CheckResult prelimResult = CheckResult.failed(ViolationType.AUTOCLICKER, pattern.severity, pattern.reason);
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.AUTOCLICKER, prelimResult)) {
                return CheckResult.passed();
            }
            return prelimResult;
        }
        if (pattern.macroDetected) {
            CheckResult prelimResult = CheckResult.failed(ViolationType.AUTOCLICKER, 0.92, "Macro pattern detected: " + pattern.reason);
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.AUTOCLICKER, prelimResult)) {
                return CheckResult.passed();
            }
            return prelimResult;
        }
        double cps = data.getAverageCPS();
        if (cps > (double)(maxCPS = this.config.getAutoClickerMaxCPS())) {
            CheckResult prelimResult = CheckResult.failed(ViolationType.AUTOCLICKER, Math.min(1.0, cps / 40.0), String.format("CPS too high: %.1f", cps));
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.AUTOCLICKER, prelimResult)) {
                return CheckResult.passed();
            }
            return prelimResult;
        }
        return CheckResult.passed();
    }

    public void cleanup(UUID playerId) {
    }
}

