/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.detection.combat;

import NC.noChance.core.ACConfig;
import NC.noChance.core.CheckResult;
import NC.noChance.core.CombatTracker;
import NC.noChance.core.EnhancementTracker;
import NC.noChance.core.FalsePositiveFilter;
import NC.noChance.core.LayerFiltering;
import NC.noChance.core.PlayerData;
import NC.noChance.core.ViolationType;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class KillAuraCheck {
    private final ACConfig config;
    private final Map<UUID, PlayerData> playerDataMap;
    private final LayerFiltering filtering;
    private final Map<UUID, ConcurrentLinkedDeque<HitRecord>> recentHits;
    private final CombatTracker combatTracker;
    private final FalsePositiveFilter falsePositiveFilter;
    private final Map<UUID, KillAuraTracker> trackers;

    public KillAuraCheck(ACConfig config, Map<UUID, PlayerData> playerDataMap, LayerFiltering filtering) {
        this.config = config;
        this.playerDataMap = playerDataMap;
        this.filtering = filtering;
        this.recentHits = new ConcurrentHashMap<UUID, ConcurrentLinkedDeque<HitRecord>>();
        this.combatTracker = new CombatTracker();
        this.falsePositiveFilter = new FalsePositiveFilter();
        this.trackers = new ConcurrentHashMap<UUID, KillAuraTracker>();
    }

    public CheckResult check(Player player, Entity target) {
        if (!this.config.isCheckEnabled("killaura")) {
            return CheckResult.passed();
        }
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data == null) {
            return CheckResult.passed();
        }
        if (data.isInGracePeriod(this.config.getGracePeriod())) {
            return CheckResult.passed();
        }
        UUID uuid = player.getUniqueId();
        KillAuraTracker tracker = this.trackers.computeIfAbsent(uuid, k -> new KillAuraTracker());
        this.combatTracker.recordPlayerHit(player, target, 1.0);
        CombatTracker.CombatContext context = this.combatTracker.getContext(uuid);
        double recentCPS = context.getRecentCPS();
        Location currentLoc = player.getLocation();
        Location lastLoc = data.getLastLocation();
        if (lastLoc != null) {
            float yawDiff = Math.abs(currentLoc.getYaw() - lastLoc.getYaw());
            float pitchDiff = Math.abs(currentLoc.getPitch() - lastLoc.getPitch());
            double rotationSpeed = Math.sqrt(yawDiff * yawDiff + pitchDiff * pitchDiff);
            this.falsePositiveFilter.recordRotation(player, rotationSpeed);
        }
        double trustScore = this.falsePositiveFilter.getPlayerTrustScore(uuid);
        double maxCPS = this.config.getKillAuraMaxCPS();
        if (trustScore > 0.75) {
            maxCPS += this.config.getKillAuraCPSTrustedBonus();
        } else if (trustScore < 0.4) {
            maxCPS -= this.config.getKillAuraCPSUntrustedPenalty();
        }
        if (recentCPS > maxCPS) {
            tracker.recordCPSViolation();
            int requiredViolations = this.config.getKillAuraRequiredViolations();
            if (recentCPS > maxCPS + this.config.getKillAuraInstantFlagCPSOver()) {
                requiredViolations = 1;
            }
            if (tracker.getCPSViolations() < requiredViolations) {
                return CheckResult.passed();
            }
            double severity = Math.min(0.96, 0.72 + (recentCPS - maxCPS) / 22.0);
            CheckResult prelimResult = CheckResult.failed(ViolationType.KILLAURA, severity, String.format("Excessive combat CPS: %.1f (max: %.1f, violations: %d, trust: %.2f)", recentCPS, maxCPS, tracker.getCPSViolations(), trustScore));
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.KILLAURA, prelimResult)) {
                tracker.decayCPS();
                return CheckResult.passed();
            }
            return prelimResult;
        }
        tracker.decayCPS();
        CheckResult angleCheck = this.checkHitAngle(player, target, data);
        if (angleCheck.isFailed()) {
            return angleCheck;
        }
        CheckResult distanceCheck = this.checkHitDistance(player, target);
        if (distanceCheck.isFailed()) {
            return distanceCheck;
        }
        CheckResult rotationCheck = this.checkRotationSpeed(player, target, data);
        if (rotationCheck.isFailed()) {
            return rotationCheck;
        }
        CheckResult multiCheck = this.checkMultiAura(player, target);
        if (multiCheck.isFailed()) {
            return multiCheck;
        }
        CheckResult patternCheck = this.checkPatternDetection(player, target);
        if (patternCheck.isFailed()) {
            return patternCheck;
        }
        CheckResult sprintCheck = this.checkSprintHit(player, target);
        if (sprintCheck.isFailed()) {
            return sprintCheck;
        }
        return CheckResult.passed();
    }

    private CheckResult checkSprintHit(Player player, Entity target) {
        Vector toTarget;
        UUID uuid = player.getUniqueId();
        KillAuraTracker tracker = this.trackers.get(uuid);
        if (!player.isSprinting()) {
            return CheckResult.passed();
        }
        Location playerLoc = player.getLocation();
        Location targetLoc = target.getLocation();
        Vector playerDir = playerLoc.getDirection().normalize();
        double dotProduct = playerDir.dot(toTarget = targetLoc.toVector().subtract(playerLoc.toVector()).normalize());
        if (dotProduct < -0.25) {
            tracker.recordAngleViolation();
            if (tracker.getAngleViolations() < 1) {
                return CheckResult.passed();
            }
            double severity = Math.min(0.92, 0.78 + Math.abs(dotProduct) * 0.3);
            CheckResult prelimResult = CheckResult.failed(ViolationType.KILLAURA, severity, String.format("Sprint-hit backwards (direction: %.2f, violations: %d)", dotProduct, tracker.getAngleViolations()));
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.KILLAURA, prelimResult)) {
                return CheckResult.passed();
            }
            return prelimResult;
        }
        return CheckResult.passed();
    }

    private CheckResult checkHitAngle(Player player, Entity target, PlayerData data) {
        LivingEntity living;
        UUID uuid = player.getUniqueId();
        KillAuraTracker tracker = this.trackers.get(uuid);
        Location eyeLoc = player.getEyeLocation();
        Vector playerView = eyeLoc.getDirection().normalize();
        Location targetLoc = target.getLocation().add(0.0, target.getHeight() / 2.0, 0.0);
        Vector toTarget = targetLoc.toVector().subtract(eyeLoc.toVector()).normalize();
        double dotProduct = playerView.dot(toTarget);
        dotProduct = Math.max(-1.0, Math.min(1.0, dotProduct));
        double hitAngle = Math.toDegrees(Math.acos(dotProduct));
        Vector horizontalView = playerView.clone().setY(0).normalize();
        Vector horizontalTarget = toTarget.clone().setY(0).normalize();
        double horizontalDot = horizontalView.dot(horizontalTarget);
        horizontalDot = Math.max(-1.0, Math.min(1.0, horizontalDot));
        double yawAngle = Math.toDegrees(Math.acos(horizontalDot));
        double pitchDiff = Math.abs(Math.toDegrees(Math.asin(playerView.getY())) - Math.toDegrees(Math.asin(toTarget.getY())));
        double maxAngle = this.config.getKillAuraMaxAngle();
        PlayerData.SkillLevel skill = data.getSkillLevel();
        double trustScore = this.falsePositiveFilter.getPlayerTrustScore(uuid);
        if (skill == PlayerData.SkillLevel.HIGH) {
            maxAngle += 10.0;
        }
        if (trustScore > 0.75) {
            maxAngle += this.config.getKillAuraAngleTrustedBonus();
        } else if (trustScore < 0.4) {
            maxAngle -= this.config.getKillAuraAngleUntrustedPenalty();
        }
        int ping = this.filtering.getPing(player);
        if (ping > 150) {
            maxAngle += 5.0;
        } else if (ping > 200) {
            maxAngle += 8.0;
        }
        if (player.getVelocity().length() > 0.3) {
            maxAngle += 3.0;
        }
        if (target instanceof LivingEntity && (living = (LivingEntity)target).getVelocity().length() > 0.4) {
            maxAngle += 4.0;
        }
        if (hitAngle > maxAngle) {
            if (yawAngle > maxAngle * 0.85 || pitchDiff > maxAngle * 0.75) {
                tracker.recordAngleViolation();
                int requiredViolations = this.config.getKillAuraRequiredViolations();
                if (hitAngle > maxAngle + this.config.getKillAuraInstantFlagAngleOver()) {
                    requiredViolations = Math.max(2, requiredViolations - 1);
                }
                if (tracker.getAngleViolations() < requiredViolations) {
                    this.falsePositiveFilter.recordLegitAction(player, ViolationType.KILLAURA);
                    return CheckResult.passed();
                }
                double severity = Math.min(0.92, 0.62 + (hitAngle - maxAngle) / 60.0 + (double)tracker.getAngleViolations() * 0.04);
                CheckResult prelimResult = CheckResult.failed(ViolationType.KILLAURA_ANGLE, severity, String.format("Hit angle: %.1f\u00b0 yaw:%.1f\u00b0 pitch:%.1f\u00b0 (max: %.1f\u00b0, vl: %d, trust: %.2f)", hitAngle, yawAngle, pitchDiff, maxAngle, tracker.getAngleViolations(), trustScore));
                if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.KILLAURA, prelimResult)) {
                    tracker.decayAngle();
                    this.falsePositiveFilter.recordLegitAction(player, ViolationType.KILLAURA);
                    return CheckResult.passed();
                }
                return prelimResult;
            }
            tracker.decayAngle();
        } else {
            tracker.decayAngle();
        }
        this.falsePositiveFilter.recordLegitAction(player, ViolationType.KILLAURA);
        return CheckResult.passed();
    }

    private CheckResult checkHitDistance(Player player, Entity target) {
        double distance = player.getLocation().distance(target.getLocation());
        double maxReach = this.config.getKillAuraMaxReach();
        EnhancementTracker.CombatEnhancements enhancements = EnhancementTracker.calculateCombatEnhancements(player);
        maxReach += enhancements.reachBonus;
        int ping = this.filtering.getPing(player);
        if (ping > 100) {
            maxReach += 0.5;
        }
        if (distance > maxReach) {
            CheckResult prelimResult = CheckResult.failed(ViolationType.KILLAURA, Math.min(1.0, (distance - maxReach) / maxReach), String.format("Hit distance: %.2f blocks (max: %.1f) | Enhancements: %s", distance, maxReach, enhancements.reason));
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.KILLAURA, prelimResult)) {
                return CheckResult.passed();
            }
            return prelimResult;
        }
        return CheckResult.passed();
    }

    private CheckResult checkRotationSpeed(Player player, Entity target, PlayerData data) {
        UUID uuid = player.getUniqueId();
        KillAuraTracker tracker = this.trackers.get(uuid);
        Deque<PlayerData.RotationData> rotations = data.getRotationHistory();
        if (rotations.size() < 3) {
            return CheckResult.passed();
        }
        ArrayList<PlayerData.RotationData> rotList = new ArrayList<PlayerData.RotationData>(rotations);
        PlayerData.RotationData current = (PlayerData.RotationData)rotList.get(rotList.size() - 1);
        PlayerData.RotationData previous = (PlayerData.RotationData)rotList.get(rotList.size() - 2);
        float deltaYaw = Math.abs(current.yaw - previous.yaw);
        float deltaPitch = Math.abs(current.pitch - previous.pitch);
        double deltaTime = (double)(current.timestamp - previous.timestamp) / 1000.0;
        if (deltaTime == 0.0 || deltaTime > 1.0) {
            return CheckResult.passed();
        }
        double rotationSpeed = Math.sqrt(deltaYaw * deltaYaw + deltaPitch * deltaPitch) / deltaTime;
        double maxRotationSpeed = this.config.getKillAuraMaxRotationSpeed();
        double trustScore = this.falsePositiveFilter.getPlayerTrustScore(uuid);
        if (trustScore > 0.75) {
            maxRotationSpeed += this.config.getKillAuraRotationTrustedBonus();
        } else if (trustScore < 0.4) {
            maxRotationSpeed -= this.config.getKillAuraRotationUntrustedPenalty();
        }
        if (rotList.size() >= 6) {
            CheckResult gcdCheck = this.checkRotationGCD(rotList, player);
            if (gcdCheck.isFailed()) {
                return gcdCheck;
            }
            CheckResult accelCheck = this.checkRotationAcceleration(rotList, player);
            if (accelCheck.isFailed()) {
                return accelCheck;
            }
        }
        if (rotationSpeed > maxRotationSpeed) {
            ArrayList<Double> recentSpeeds = new ArrayList<Double>();
            for (int i = Math.max(0, rotList.size() - 5); i < rotList.size() - 1; ++i) {
                PlayerData.RotationData curr = (PlayerData.RotationData)rotList.get(i + 1);
                PlayerData.RotationData prev = (PlayerData.RotationData)rotList.get(i);
                double dt = (double)(curr.timestamp - prev.timestamp) / 1000.0;
                if (!(dt > 0.0) || !(dt < 1.0)) continue;
                float dy = Math.abs(curr.yaw - prev.yaw);
                float dp = Math.abs(curr.pitch - prev.pitch);
                recentSpeeds.add(Math.sqrt(dy * dy + dp * dp) / dt);
            }
            if (recentSpeeds.size() >= 3) {
                double avg = recentSpeeds.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
                double variance = recentSpeeds.stream().mapToDouble(s -> Math.pow(s - avg, 2.0)).average().orElse(0.0);
                if (variance < this.config.getKillAuraRotationVarianceThreshold() && avg > maxRotationSpeed * 0.7) {
                    int requiredViolations;
                    tracker.recordRotationViolation();
                    int n = requiredViolations = variance < this.config.getKillAuraRotationVarianceStrict() ? 2 : this.config.getKillAuraRequiredViolations();
                    if (tracker.getRotationViolations() < requiredViolations) {
                        return CheckResult.passed();
                    }
                    CheckResult prelimResult = CheckResult.failed(ViolationType.KILLAURA_ROTATION, 0.9, String.format("Consistent rotation: %.1f\u00b0/s (var: %.1f, violations: %d)", avg, variance, tracker.getRotationViolations()));
                    if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.KILLAURA, prelimResult)) {
                        tracker.decayRotation();
                        return CheckResult.passed();
                    }
                    return prelimResult;
                }
            }
            tracker.recordRotationViolation();
            int requiredViolations = this.config.getKillAuraRequiredViolations();
            if (rotationSpeed > maxRotationSpeed + this.config.getKillAuraInstantFlagRotationOver()) {
                requiredViolations = Math.max(1, requiredViolations - 1);
            }
            if (tracker.getRotationViolations() < requiredViolations) {
                this.falsePositiveFilter.recordLegitAction(player, ViolationType.KILLAURA);
                return CheckResult.passed();
            }
            double severity = Math.min(0.94, 0.65 + (rotationSpeed - maxRotationSpeed) / 800.0 + (double)tracker.getRotationViolations() * 0.04);
            CheckResult prelimResult = CheckResult.failed(ViolationType.KILLAURA_ROTATION, severity, String.format("Rotation speed: %.1f\u00b0/s (max: %.1f\u00b0/s, violations: %d, trust: %.2f)", rotationSpeed, maxRotationSpeed, tracker.getRotationViolations(), trustScore));
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.KILLAURA, prelimResult)) {
                tracker.decayRotation();
                this.falsePositiveFilter.recordLegitAction(player, ViolationType.KILLAURA);
                return CheckResult.passed();
            }
            return prelimResult;
        }
        tracker.decayRotation();
        this.falsePositiveFilter.recordLegitAction(player, ViolationType.KILLAURA);
        return CheckResult.passed();
    }

    private CheckResult checkRotationGCD(List<PlayerData.RotationData> rotations, Player player) {
        ArrayList<Float> yawChanges = new ArrayList<Float>();
        ArrayList<Float> pitchChanges = new ArrayList<Float>();
        for (int i = 1; i < rotations.size(); ++i) {
            float yawDelta = Math.abs(rotations.get((int)i).yaw - rotations.get((int)(i - 1)).yaw);
            float pitchDelta = Math.abs(rotations.get((int)i).pitch - rotations.get((int)(i - 1)).pitch);
            if (yawDelta > 0.02f) {
                yawChanges.add(Float.valueOf(yawDelta));
            }
            if (!(pitchDelta > 0.02f)) continue;
            pitchChanges.add(Float.valueOf(pitchDelta));
        }
        if (yawChanges.size() < 8 || pitchChanges.size() < 8) {
            return CheckResult.passed();
        }
        float yawGCD = this.calculateGCD(yawChanges);
        float pitchGCD = this.calculateGCD(pitchChanges);
        if (yawGCD > 0.08f && yawGCD < 0.6f && pitchGCD > 0.08f && pitchGCD < 0.6f) {
            double divisibleYaw = yawChanges.stream().filter(v -> Math.abs(v.floatValue() % yawGCD) < 0.015f).count();
            double divisiblePitch = pitchChanges.stream().filter(v -> Math.abs(v.floatValue() % pitchGCD) < 0.015f).count();
            double yawRatio = divisibleYaw / (double)yawChanges.size();
            double pitchRatio = divisiblePitch / (double)pitchChanges.size();
            if (yawRatio > 0.97 && pitchRatio > 0.97 && yawChanges.size() >= 12) {
                CheckResult prelimResult = CheckResult.failed(ViolationType.KILLAURA_ROTATION, 0.94, String.format("Aim assist GCD detected (yaw: %.3f, pitch: %.3f, ratio: %.2f/%.2f, samples: %d)", Float.valueOf(yawGCD), Float.valueOf(pitchGCD), yawRatio, pitchRatio, yawChanges.size()));
                if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.KILLAURA, prelimResult)) {
                    return CheckResult.passed();
                }
                return prelimResult;
            }
        }
        return CheckResult.passed();
    }

    private float calculateGCD(List<Float> values) {
        if (values.size() < 2) {
            return 0.0f;
        }
        float gcd = values.get(0).floatValue();
        for (int i = 1; i < Math.min(values.size(), 10) && !((gcd = this.gcdFloat(gcd, values.get(i).floatValue())) < 0.001f); ++i) {
        }
        return gcd;
    }

    private float gcdFloat(float a, float b) {
        float epsilon = 0.001f;
        while (Math.abs(b) > epsilon) {
            float temp = b;
            b = a % b;
            a = temp;
        }
        return Math.abs(a);
    }

    private CheckResult checkRotationAcceleration(List<PlayerData.RotationData> rotations, Player player) {
        ArrayList<Double> accelerations = new ArrayList<Double>();
        for (int i = 2; i < rotations.size(); ++i) {
            PlayerData.RotationData curr = rotations.get(i);
            PlayerData.RotationData prev = rotations.get(i - 1);
            PlayerData.RotationData prevPrev = rotations.get(i - 2);
            double dt1 = (double)(prev.timestamp - prevPrev.timestamp) / 1000.0;
            double dt2 = (double)(curr.timestamp - prev.timestamp) / 1000.0;
            if (!(dt1 > 0.0) || !(dt1 < 1.0) || !(dt2 > 0.0) || !(dt2 < 1.0)) continue;
            float delta1 = (float)Math.sqrt(Math.pow(prev.yaw - prevPrev.yaw, 2.0) + Math.pow(prev.pitch - prevPrev.pitch, 2.0));
            float delta2 = (float)Math.sqrt(Math.pow(curr.yaw - prev.yaw, 2.0) + Math.pow(curr.pitch - prev.pitch, 2.0));
            double speed1 = (double)delta1 / dt1;
            double speed2 = (double)delta2 / dt2;
            double accel = (speed2 - speed1) / ((dt1 + dt2) / 2.0);
            accelerations.add(Math.abs(accel));
        }
        if (accelerations.size() >= 8) {
            double avgAccel = accelerations.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
            long lowAccelCount = accelerations.stream().filter(a -> a < 5.0).count();
            double lowAccelRatio = (double)lowAccelCount / (double)accelerations.size();
            if (lowAccelRatio > 0.96 && avgAccel < 4.0 && accelerations.size() >= 12) {
                CheckResult prelimResult = CheckResult.failed(ViolationType.KILLAURA_ROTATION, 0.9, String.format("No rotation acceleration (avg: %.1f, low: %.2f%%, samples: %d)", avgAccel, lowAccelRatio * 100.0, accelerations.size()));
                if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.KILLAURA, prelimResult)) {
                    return CheckResult.passed();
                }
                return prelimResult;
            }
        }
        return CheckResult.passed();
    }

    private CheckResult checkMultiAura(Player player, Entity target) {
        UUID playerId = player.getUniqueId();
        KillAuraTracker tracker = this.trackers.get(playerId);
        long now = System.currentTimeMillis();
        ConcurrentLinkedDeque hits = this.recentHits.computeIfAbsent(playerId, k -> new ConcurrentLinkedDeque());
        hits.add(new HitRecord(target.getUniqueId(), now, player.getLocation()));
        hits.removeIf(record -> now - record.timestamp > 1000L);
        HashSet<UUID> uniqueTargets = new HashSet<UUID>();
        for (HitRecord hit : hits) {
            uniqueTargets.add(hit.targetId);
        }
        if (uniqueTargets.size() >= 4) {
            long timeWindow = 600L;
            long recentTime = now - timeWindow;
            int recentHitCount = 0;
            HashSet<UUID> recentTargets = new HashSet<UUID>();
            for (HitRecord hit : hits) {
                if (hit.timestamp < recentTime) continue;
                ++recentHitCount;
                recentTargets.add(hit.targetId);
            }
            double playerMovement = 0.0;
            if (hits.size() >= 2) {
                HitRecord first = (HitRecord)hits.getFirst();
                HitRecord last = (HitRecord)hits.getLast();
                playerMovement = first.location.distance(last.location);
            }
            if (recentTargets.size() >= 4 && recentHitCount >= 5 && playerMovement < 2.5) {
                tracker.recordMultiTargetViolation();
                int requiredViolations = 2;
                if (recentTargets.size() >= 5) {
                    requiredViolations = 1;
                }
                if (tracker.getMultiTargetViolations() < requiredViolations) {
                    return CheckResult.passed();
                }
                double severity = Math.min(0.96, 0.72 + (double)recentTargets.size() * 0.08 + (double)tracker.getMultiTargetViolations() * 0.05);
                CheckResult prelimResult = CheckResult.failed(ViolationType.KILLAURA_MULTI, severity, String.format("Hit %d entities in %dms with %.1f blocks movement (hits: %d, vl: %d)", recentTargets.size(), timeWindow, playerMovement, recentHitCount, tracker.getMultiTargetViolations()));
                if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.KILLAURA, prelimResult)) {
                    tracker.decayMultiTarget();
                    return CheckResult.passed();
                }
                return prelimResult;
            }
            tracker.decayMultiTarget();
        } else {
            tracker.decayMultiTarget();
        }
        return CheckResult.passed();
    }

    private CheckResult checkPatternDetection(Player player, Entity target) {
        UUID playerId = player.getUniqueId();
        PlayerData data = this.playerDataMap.get(playerId);
        ConcurrentLinkedDeque<HitRecord> hits = this.recentHits.get(playerId);
        if (hits == null || hits.size() < 7) {
            return CheckResult.passed();
        }
        ArrayList<Long> timestamps = new ArrayList<Long>();
        for (HitRecord hit : hits) {
            timestamps.add(hit.timestamp);
        }
        if (this.filtering.detectMachinePattern(timestamps)) {
            CheckResult prelimResult = CheckResult.failed(ViolationType.KILLAURA_PATTERN, 0.9, "Machine-like attack pattern detected (too consistent)");
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.KILLAURA, prelimResult)) {
                return CheckResult.passed();
            }
            return prelimResult;
        }
        return CheckResult.passed();
    }

    public void cleanup(UUID playerId) {
        this.recentHits.remove(playerId);
        this.trackers.remove(playerId);
    }

    public void cleanupStale() {
        long now = System.currentTimeMillis();
        this.recentHits.entrySet().removeIf(entry -> {
            ConcurrentLinkedDeque hits = (ConcurrentLinkedDeque)entry.getValue();
            hits.removeIf(record -> now - record.timestamp > 5000L);
            return hits.isEmpty();
        });
        this.trackers.entrySet().removeIf(entry -> {
            KillAuraTracker tracker = (KillAuraTracker)entry.getValue();
            return now - Math.max(Math.max(tracker.lastCPSViolation, tracker.lastAngleViolation), Math.max(tracker.lastRotationViolation, tracker.lastMultiTargetViolation)) > 30000L;
        });
    }

    private static class KillAuraTracker {
        private int cpsViolations = 0;
        private int angleViolations = 0;
        private int rotationViolations = 0;
        private int multiTargetViolations = 0;
        private long lastCPSViolation = 0L;
        private long lastAngleViolation = 0L;
        private long lastRotationViolation = 0L;
        private long lastMultiTargetViolation = 0L;

        private KillAuraTracker() {
        }

        void recordCPSViolation() {
            long now = System.currentTimeMillis();
            this.cpsViolations = now - this.lastCPSViolation < 3000L ? ++this.cpsViolations : 1;
            this.lastCPSViolation = now;
        }

        void recordAngleViolation() {
            long now = System.currentTimeMillis();
            this.angleViolations = now - this.lastAngleViolation < 2000L ? ++this.angleViolations : 1;
            this.lastAngleViolation = now;
        }

        void recordRotationViolation() {
            long now = System.currentTimeMillis();
            this.rotationViolations = now - this.lastRotationViolation < 2000L ? ++this.rotationViolations : 1;
            this.lastRotationViolation = now;
        }

        void recordMultiTargetViolation() {
            long now = System.currentTimeMillis();
            this.multiTargetViolations = now - this.lastMultiTargetViolation < 1500L ? ++this.multiTargetViolations : 1;
            this.lastMultiTargetViolation = now;
        }

        void decayCPS() {
            long now = System.currentTimeMillis();
            if (now - this.lastCPSViolation > 5000L) {
                this.cpsViolations = Math.max(0, this.cpsViolations - 1);
            }
        }

        void decayAngle() {
            long now = System.currentTimeMillis();
            if (now - this.lastAngleViolation > 4000L) {
                this.angleViolations = Math.max(0, this.angleViolations - 1);
            }
        }

        void decayRotation() {
            long now = System.currentTimeMillis();
            if (now - this.lastRotationViolation > 4000L) {
                this.rotationViolations = Math.max(0, this.rotationViolations - 1);
            }
        }

        void decayMultiTarget() {
            long now = System.currentTimeMillis();
            if (now - this.lastMultiTargetViolation > 3000L) {
                this.multiTargetViolations = Math.max(0, this.multiTargetViolations - 1);
            }
        }

        int getCPSViolations() {
            return this.cpsViolations;
        }

        int getAngleViolations() {
            return this.angleViolations;
        }

        int getRotationViolations() {
            return this.rotationViolations;
        }

        int getMultiTargetViolations() {
            return this.multiTargetViolations;
        }
    }

    private static class HitRecord {
        final UUID targetId;
        final long timestamp;
        final Location location;

        HitRecord(UUID targetId, long timestamp, Location location) {
            this.targetId = targetId;
            this.timestamp = timestamp;
            this.location = location;
        }
    }
}

