/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.detection.combat;

import NC.noChance.core.ACConfig;
import NC.noChance.core.CheckResult;
import NC.noChance.core.CombatTracker;
import NC.noChance.core.LayerFiltering;
import NC.noChance.core.PlayerData;
import NC.noChance.core.PrecisionReach;
import NC.noChance.core.ViolationType;
import java.util.Map;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class ReachCheck {
    private final ACConfig config;
    private final Map<UUID, PlayerData> playerDataMap;
    private final LayerFiltering filtering;
    private final CombatTracker combatTracker;

    public ReachCheck(ACConfig config, Map<UUID, PlayerData> playerDataMap, LayerFiltering filtering) {
        this.config = config;
        this.playerDataMap = playerDataMap;
        this.filtering = filtering;
        this.combatTracker = new CombatTracker();
    }

    public CheckResult checkEntityReach(Player player, Entity target) {
        if (!this.config.isCheckEnabled("reach")) {
            return CheckResult.passed();
        }
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data == null) {
            return CheckResult.passed();
        }
        if (data.isInGracePeriod(this.config.getGracePeriod())) {
            return CheckResult.passed();
        }
        this.combatTracker.recordPlayerHit(player, target, 1.0);
        int ping = this.filtering.getPing(player);
        PrecisionReach.ReachResult result = PrecisionReach.checkEntityReach(player, target, ping);
        if (result.valid) {
            return CheckResult.passed();
        }
        double distance = result.distance;
        double maxReach = result.maxReach;
        double confidence = result.confidence;
        if (ping > 100) {
            maxReach += 0.3;
        }
        if (distance > maxReach) {
            CheckResult prelimResult = CheckResult.failed(ViolationType.REACH, Math.min(1.0, (distance - maxReach) / maxReach), String.format("Entity reach: %.2f blocks (max: %.1f) | Confidence: %.2f", distance, maxReach, confidence));
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.REACH, prelimResult)) {
                return CheckResult.passed();
            }
            return prelimResult;
        }
        return CheckResult.passed();
    }

    public CheckResult checkBlockReach(Player player, Block block) {
        if (!this.config.isCheckEnabled("reach")) {
            return CheckResult.passed();
        }
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data == null) {
            return CheckResult.passed();
        }
        if (data.isInGracePeriod(this.config.getGracePeriod())) {
            return CheckResult.passed();
        }
        int ping = this.filtering.getPing(player);
        PrecisionReach.ReachResult result = PrecisionReach.checkBlockReach(player, block.getLocation(), ping);
        if (player.getGameMode() == GameMode.CREATIVE && result.distance <= 6.0) {
            return CheckResult.passed();
        }
        if (result.valid) {
            return CheckResult.passed();
        }
        double distance = result.distance;
        double maxReach = result.maxReach;
        if (player.getGameMode() == GameMode.CREATIVE) {
            maxReach = 6.0;
        }
        double confidence = result.confidence;
        if (distance > maxReach) {
            CheckResult prelimResult = CheckResult.failed(ViolationType.REACH, Math.min(1.0, (distance - maxReach) / maxReach), String.format("Block reach: %.2f blocks (max: %.1f) | Confidence: %.2f", distance, maxReach, confidence));
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.REACH, prelimResult)) {
                return CheckResult.passed();
            }
            return prelimResult;
        }
        return CheckResult.passed();
    }

    public void cleanup(UUID playerId) {
        this.combatTracker.cleanup(playerId);
    }
}

