/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.detection.damage;

import NC.noChance.core.ACConfig;
import NC.noChance.core.CheckResult;
import NC.noChance.core.LayerFiltering;
import NC.noChance.core.PlayerData;
import NC.noChance.core.ViolationType;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class CriticalsCheck {
    private final ACConfig config;
    private final Map<UUID, PlayerData> playerDataMap;
    private final LayerFiltering filtering;
    private final Map<UUID, CriticalTracker> trackers;

    public CriticalsCheck(ACConfig config, Map<UUID, PlayerData> playerDataMap, LayerFiltering filtering) {
        this.config = config;
        this.playerDataMap = playerDataMap;
        this.filtering = filtering;
        this.trackers = new HashMap<UUID, CriticalTracker>();
    }

    public CheckResult check(Player player, Entity target, boolean isCritical) {
        if (!this.config.isCheckEnabled("criticals")) {
            return CheckResult.passed();
        }
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data == null) {
            return CheckResult.passed();
        }
        if (data.isInGracePeriod(this.config.getGracePeriod())) {
            return CheckResult.passed();
        }
        UUID uuid = player.getUniqueId();
        CriticalTracker tracker = this.trackers.computeIfAbsent(uuid, k -> new CriticalTracker());
        if (!isCritical) {
            tracker.recordNormalHit();
            return CheckResult.passed();
        }
        boolean onGround = player.isOnGround();
        boolean inLiquid = player.isInWater();
        boolean onLadder = player.isClimbing();
        double fallDistance = player.getFallDistance();
        double verticalVelocity = data.getLastVerticalVelocity();
        if (inLiquid || onLadder) {
            tracker.recordLegitCrit();
            return CheckResult.passed();
        }
        if (onGround && fallDistance < 0.1 && verticalVelocity < 0.1) {
            tracker.recordSuspiciousCrit();
            if (tracker.getSuspiciousCount() >= 4) {
                double severity = Math.min(1.0, (double)tracker.getSuspiciousCount() / 6.0);
                CheckResult prelimResult = CheckResult.failed(ViolationType.CRITICALS, severity, String.format("Criticals on ground: %d/8 suspicious", tracker.getSuspiciousCount()));
                if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.CRITICALS, prelimResult)) {
                    tracker.reset();
                    return CheckResult.passed();
                }
                tracker.reset();
                return prelimResult;
            }
        } else {
            tracker.recordLegitCrit();
        }
        double critRate = tracker.getCriticalRate();
        if (tracker.getTotalHits() >= 15 && critRate > 0.85) {
            double severity = (critRate - 0.5) / 0.5;
            CheckResult prelimResult = CheckResult.failed(ViolationType.CRITICALS, severity, String.format("Abnormal crit rate: %.1f%% (%d/%d hits)", critRate * 100.0, tracker.getCriticalHits(), tracker.getTotalHits()));
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.CRITICALS, prelimResult)) {
                tracker.reset();
                return CheckResult.passed();
            }
            tracker.reset();
            return prelimResult;
        }
        return CheckResult.passed();
    }

    public void cleanup(UUID uuid) {
        this.trackers.remove(uuid);
    }

    private static class CriticalTracker {
        private int totalHits = 0;
        private int criticalHits = 0;
        private int suspiciousCrits = 0;
        private long lastResetTime = System.currentTimeMillis();

        private CriticalTracker() {
        }

        void recordNormalHit() {
            this.checkReset();
            ++this.totalHits;
        }

        void recordLegitCrit() {
            this.checkReset();
            ++this.totalHits;
            ++this.criticalHits;
        }

        void recordSuspiciousCrit() {
            this.checkReset();
            ++this.totalHits;
            ++this.criticalHits;
            ++this.suspiciousCrits;
        }

        void checkReset() {
            if (System.currentTimeMillis() - this.lastResetTime > 10000L) {
                this.reset();
            }
        }

        void reset() {
            this.totalHits = 0;
            this.criticalHits = 0;
            this.suspiciousCrits = 0;
            this.lastResetTime = System.currentTimeMillis();
        }

        int getTotalHits() {
            return this.totalHits;
        }

        int getCriticalHits() {
            return this.criticalHits;
        }

        int getSuspiciousCount() {
            return this.suspiciousCrits;
        }

        double getCriticalRate() {
            return this.totalHits > 0 ? (double)this.criticalHits / (double)this.totalHits : 0.0;
        }
    }
}

