/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.detection.damage;

import NC.noChance.core.ACConfig;
import NC.noChance.core.CheckResult;
import NC.noChance.core.LayerFiltering;
import NC.noChance.core.PlayerData;
import NC.noChance.core.ViolationType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class VelocityCheck {
    private final ACConfig config;
    private final Map<UUID, PlayerData> playerDataMap;
    private final LayerFiltering filtering;
    private final Map<UUID, VelocityTracker> trackers;

    public VelocityCheck(ACConfig config, Map<UUID, PlayerData> playerDataMap, LayerFiltering filtering) {
        this.config = config;
        this.playerDataMap = playerDataMap;
        this.filtering = filtering;
        this.trackers = new HashMap<UUID, VelocityTracker>();
    }

    public void recordVelocity(Player player, Vector velocity) {
        UUID uuid = player.getUniqueId();
        VelocityTracker tracker = this.trackers.computeIfAbsent(uuid, k -> new VelocityTracker());
        tracker.setExpectedVelocity(velocity, System.currentTimeMillis());
    }

    public CheckResult check(Player player, Vector actualVelocity) {
        if (!this.config.isCheckEnabled("velocity")) {
            return CheckResult.passed();
        }
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data == null) {
            return CheckResult.passed();
        }
        if (data.isInGracePeriod(this.config.getGracePeriod())) {
            return CheckResult.passed();
        }
        UUID uuid = player.getUniqueId();
        VelocityTracker tracker = this.trackers.get(uuid);
        if (tracker == null || !tracker.hasExpectedVelocity()) {
            return CheckResult.passed();
        }
        Vector expected = tracker.getExpectedVelocity();
        long timeSinceVelocity = System.currentTimeMillis() - tracker.getVelocityTime();
        if (timeSinceVelocity > 1000L) {
            tracker.clear();
            return CheckResult.passed();
        }
        double horizontalExpected = Math.sqrt(expected.getX() * expected.getX() + expected.getZ() * expected.getZ());
        double horizontalActual = Math.sqrt(actualVelocity.getX() * actualVelocity.getX() + actualVelocity.getZ() * actualVelocity.getZ());
        double verticalExpected = expected.getY();
        double verticalActual = actualVelocity.getY();
        double horizontalPercent = horizontalExpected > 0.01 ? horizontalActual / horizontalExpected : 1.0;
        double verticalPercent = verticalExpected > 0.01 ? verticalActual / verticalExpected : 1.0;
        tracker.recordResult(horizontalPercent, verticalPercent);
        if (tracker.getViolationCount() < 3) {
            return CheckResult.passed();
        }
        double avgHorizontal = tracker.getAverageHorizontal();
        double avgVertical = tracker.getAverageVertical();
        if (avgHorizontal < 0.25 || avgVertical < 0.25) {
            double severity = 1.0 - Math.max(avgHorizontal, avgVertical);
            CheckResult prelimResult = CheckResult.failed(ViolationType.VELOCITY, severity, String.format("Velocity: H:%.1f%% V:%.1f%%", avgHorizontal * 100.0, avgVertical * 100.0));
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.VELOCITY, prelimResult)) {
                tracker.clear();
                return CheckResult.passed();
            }
            tracker.clear();
            return prelimResult;
        }
        return CheckResult.passed();
    }

    public void cleanup(UUID uuid) {
        this.trackers.remove(uuid);
    }

    private static class VelocityTracker {
        private Vector expectedVelocity;
        private long velocityTime;
        private final List<Double> horizontalResults = new ArrayList<Double>();
        private final List<Double> verticalResults = new ArrayList<Double>();

        private VelocityTracker() {
        }

        void setExpectedVelocity(Vector velocity, long time) {
            this.expectedVelocity = velocity.clone();
            this.velocityTime = time;
            this.horizontalResults.clear();
            this.verticalResults.clear();
        }

        void recordResult(double horizontal, double vertical) {
            this.horizontalResults.add(horizontal);
            this.verticalResults.add(vertical);
            if (this.horizontalResults.size() > 5) {
                this.horizontalResults.remove(0);
                this.verticalResults.remove(0);
            }
        }

        boolean hasExpectedVelocity() {
            return this.expectedVelocity != null;
        }

        Vector getExpectedVelocity() {
            return this.expectedVelocity;
        }

        long getVelocityTime() {
            return this.velocityTime;
        }

        int getViolationCount() {
            return this.horizontalResults.size();
        }

        double getAverageHorizontal() {
            return this.horizontalResults.stream().mapToDouble(Double::doubleValue).average().orElse(1.0);
        }

        double getAverageVertical() {
            return this.verticalResults.stream().mapToDouble(Double::doubleValue).average().orElse(1.0);
        }

        void clear() {
            this.expectedVelocity = null;
            this.horizontalResults.clear();
            this.verticalResults.clear();
        }
    }
}

