/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.detection.movement;

import NC.noChance.core.ACConfig;
import NC.noChance.core.CheckResult;
import NC.noChance.core.LayerFiltering;
import NC.noChance.core.PlayerData;
import NC.noChance.core.ViolationType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;

public class BoatFlyCheck {
    private final ACConfig config;
    private final Map<UUID, PlayerData> playerDataMap;
    private final LayerFiltering filtering;
    private final Map<UUID, VehicleData> vehicleDataMap;
    private static final double MAX_BOAT_AIR_Y = 0.05;
    private static final int MAX_AIR_TICKS = 40;

    public BoatFlyCheck(ACConfig config, Map<UUID, PlayerData> playerDataMap, LayerFiltering filtering) {
        this.config = config;
        this.playerDataMap = playerDataMap;
        this.filtering = filtering;
        this.vehicleDataMap = new HashMap<UUID, VehicleData>();
    }

    public CheckResult check(Player player) {
        if (!this.config.isCheckEnabled("boatfly")) {
            return CheckResult.passed();
        }
        Entity vehicle = player.getVehicle();
        if (vehicle == null) {
            return CheckResult.passed();
        }
        if (!(vehicle instanceof Boat || vehicle instanceof Minecart || vehicle instanceof Horse)) {
            return CheckResult.passed();
        }
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data == null) {
            return CheckResult.passed();
        }
        if (data.isInGracePeriod(this.config.getGracePeriod())) {
            return CheckResult.passed();
        }
        UUID uuid = player.getUniqueId();
        VehicleData vData = this.vehicleDataMap.computeIfAbsent(uuid, k -> new VehicleData());
        Location vehicleLoc = vehicle.getLocation();
        Location lastLoc = vData.getLastLocation();
        if (lastLoc == null || lastLoc.getWorld() != vehicleLoc.getWorld()) {
            vData.setLastLocation(vehicleLoc);
            return CheckResult.passed();
        }
        double deltaY = vehicleLoc.getY() - lastLoc.getY();
        boolean inAir = !this.isVehicleGrounded(vehicle);
        boolean inWater = this.isVehicleInWater(vehicle);
        vData.recordMovement(deltaY, inAir);
        vData.setLastLocation(vehicleLoc);
        if (inWater) {
            vData.resetAirTicks();
            return CheckResult.passed();
        }
        if (inAir) {
            List<Double> recentY;
            vData.incrementAirTicks();
            if (deltaY > 0.05 && vData.getAirTicks() > 10) {
                vData.incrementViolations();
                if (vData.getViolations() < 3) {
                    return CheckResult.passed();
                }
                double severity = Math.min(0.92, 0.7 + deltaY * 0.5 + (double)vData.getViolations() * 0.04);
                CheckResult prelimResult = CheckResult.failed(ViolationType.BOATFLY, severity, String.format("Vehicle rising: deltaY=%.3f airTicks=%d vl=%d", deltaY, vData.getAirTicks(), vData.getViolations()));
                if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.BOATFLY, prelimResult)) {
                    vData.decay();
                    return CheckResult.passed();
                }
                return prelimResult;
            }
            if (vData.getAirTicks() > 40 && (recentY = vData.getRecentYMovements(15)).size() >= 10) {
                double avgY = recentY.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
                long stableCount = recentY.stream().filter(y -> Math.abs(y) < 0.03).count();
                if (stableCount >= 7L || avgY > -0.02) {
                    vData.incrementViolations();
                    if (vData.getViolations() < 4) {
                        return CheckResult.passed();
                    }
                    CheckResult prelimResult = CheckResult.failed(ViolationType.BOATFLY, 0.88, String.format("Vehicle hover: avgY=%.4f stable=%d airTicks=%d vl=%d", avgY, stableCount, vData.getAirTicks(), vData.getViolations()));
                    if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.BOATFLY, prelimResult)) {
                        vData.decay();
                        return CheckResult.passed();
                    }
                    return prelimResult;
                }
            }
        } else {
            vData.resetAirTicks();
            vData.decay();
        }
        return CheckResult.passed();
    }

    private boolean isVehicleGrounded(Entity vehicle) {
        Location loc = vehicle.getLocation();
        for (double x = -0.6; x <= 0.6; x += 0.6) {
            for (double z = -0.6; z <= 0.6; z += 0.6) {
                Block block = loc.clone().add(x, -0.1, z).getBlock();
                if (!block.getType().isSolid()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isVehicleInWater(Entity vehicle) {
        Location loc = vehicle.getLocation();
        Block at = loc.getBlock();
        Block below = loc.clone().subtract(0.0, 0.5, 0.0).getBlock();
        return at.getType() == Material.WATER || below.getType() == Material.WATER || at.getType().name().contains("WATER") || below.getType().name().contains("WATER");
    }

    public void cleanup(UUID playerId) {
        this.vehicleDataMap.remove(playerId);
    }

    public void cleanupStale() {
        long now = System.currentTimeMillis();
        this.vehicleDataMap.entrySet().removeIf(entry -> {
            PlayerData data = this.playerDataMap.get(entry.getKey());
            return data == null || now - data.getLastMoveTime() > 300000L;
        });
    }

    private static class VehicleData {
        private Location lastLocation;
        private final Deque<Double> yMovements = new ArrayDeque<Double>(20);
        private int airTicks;
        private int violations;
        private long lastViolation;

        private VehicleData() {
        }

        void recordMovement(double deltaY, boolean inAir) {
            if (this.yMovements.size() >= 20) {
                this.yMovements.pollFirst();
            }
            this.yMovements.addLast(deltaY);
        }

        List<Double> getRecentYMovements(int count) {
            ArrayList<Double> result = new ArrayList<Double>();
            int idx = 0;
            int start = Math.max(0, this.yMovements.size() - count);
            for (Double y : this.yMovements) {
                if (idx >= start) {
                    result.add(y);
                }
                ++idx;
            }
            return result;
        }

        Location getLastLocation() {
            return this.lastLocation;
        }

        void setLastLocation(Location loc) {
            this.lastLocation = loc;
        }

        int getAirTicks() {
            return this.airTicks;
        }

        void incrementAirTicks() {
            ++this.airTicks;
        }

        void resetAirTicks() {
            this.airTicks = 0;
        }

        void incrementViolations() {
            long now = System.currentTimeMillis();
            if (now - this.lastViolation > 5000L) {
                this.violations = 0;
            }
            ++this.violations;
            this.lastViolation = now;
        }

        void decay() {
            if (System.currentTimeMillis() - this.lastViolation > 8000L) {
                this.violations = Math.max(0, this.violations - 1);
            }
        }

        int getViolations() {
            return this.violations;
        }
    }
}

