/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.detection.movement;

import NC.noChance.core.ACConfig;
import NC.noChance.core.CheckResult;
import NC.noChance.core.LayerFiltering;
import NC.noChance.core.PlayerData;
import NC.noChance.core.ViolationType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class ElytraFlyCheck {
    private final ACConfig config;
    private final Map<UUID, PlayerData> playerDataMap;
    private final LayerFiltering filtering;
    private final Map<UUID, ElytraData> elytraDataMap;
    private static final double MAX_ELYTRA_SPEED = 3.2;
    private static final double MIN_GLIDE_DESCENT = -0.03;
    private static final double FIREWORK_BOOST_DURATION = 1500.0;

    public ElytraFlyCheck(ACConfig config, Map<UUID, PlayerData> playerDataMap, LayerFiltering filtering) {
        this.config = config;
        this.playerDataMap = playerDataMap;
        this.filtering = filtering;
        this.elytraDataMap = new HashMap<UUID, ElytraData>();
    }

    public CheckResult check(Player player, Location from, Location to) {
        if (!this.config.isCheckEnabled("elytrafly")) {
            return CheckResult.passed();
        }
        if (!player.isGliding()) {
            return CheckResult.passed();
        }
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data == null) {
            return CheckResult.passed();
        }
        if (data.isInGracePeriod(this.config.getGracePeriod())) {
            return CheckResult.passed();
        }
        UUID uuid = player.getUniqueId();
        ElytraData elytraData = this.elytraDataMap.computeIfAbsent(uuid, k -> new ElytraData());
        long now = System.currentTimeMillis();
        long timeSinceVelocity = now - data.getLastVelocityTime();
        boolean hasFirework = (double)timeSinceVelocity < 1500.0;
        double deltaX = to.getX() - from.getX();
        double deltaY = to.getY() - from.getY();
        double deltaZ = to.getZ() - from.getZ();
        double horizontalSpeed = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
        double totalSpeed = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
        elytraData.recordMovement(horizontalSpeed, deltaY, now);
        if (hasFirework) {
            return CheckResult.passed();
        }
        if (player.isRiptiding()) {
            return CheckResult.passed();
        }
        double maxSpeed = 3.2;
        int ping = this.filtering.getPing(player);
        if (ping > 150) {
            maxSpeed += 0.5;
        }
        if (totalSpeed > maxSpeed) {
            elytraData.incrementSpeedViolations();
            if (elytraData.getSpeedViolations() < 3) {
                return CheckResult.passed();
            }
            double severity = Math.min(0.95, 0.7 + (totalSpeed - maxSpeed) * 0.2);
            CheckResult prelimResult = CheckResult.failed(ViolationType.ELYTRAFLY, severity, String.format("Speed: %.2f (max: %.2f) vl=%d", totalSpeed, maxSpeed, elytraData.getSpeedViolations()));
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.ELYTRAFLY, prelimResult)) {
                elytraData.decaySpeed();
                return CheckResult.passed();
            }
            return prelimResult;
        }
        elytraData.decaySpeed();
        List<Double> recentY = elytraData.getRecentYMovements(15);
        if (recentY.size() >= 10) {
            long stableCount = recentY.stream().filter(y -> Math.abs(y) < 0.02).count();
            if (stableCount >= 8L && horizontalSpeed > 0.5) {
                elytraData.incrementHoverViolations();
                if (elytraData.getHoverViolations() < 4) {
                    return CheckResult.passed();
                }
                double avgY = recentY.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
                CheckResult prelimResult = CheckResult.failed(ViolationType.ELYTRAFLY, 0.85, String.format("Hover: stable=%d avgY=%.4f hSpeed=%.2f vl=%d", stableCount, avgY, horizontalSpeed, elytraData.getHoverViolations()));
                if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.ELYTRAFLY, prelimResult)) {
                    elytraData.decayHover();
                    return CheckResult.passed();
                }
                return prelimResult;
            }
            elytraData.decayHover();
            long risingCount = recentY.stream().filter(y -> y > 0.08).count();
            if (risingCount >= 6L) {
                elytraData.incrementRiseViolations();
                if (elytraData.getRiseViolations() < 3) {
                    return CheckResult.passed();
                }
                CheckResult prelimResult = CheckResult.failed(ViolationType.ELYTRAFLY, 0.88, String.format("Rising without boost: rises=%d vl=%d", risingCount, elytraData.getRiseViolations()));
                if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.ELYTRAFLY, prelimResult)) {
                    elytraData.decayRise();
                    return CheckResult.passed();
                }
                return prelimResult;
            }
            elytraData.decayRise();
        }
        return CheckResult.passed();
    }

    public void cleanup(UUID playerId) {
        this.elytraDataMap.remove(playerId);
    }

    public void cleanupStale() {
        long now = System.currentTimeMillis();
        this.elytraDataMap.entrySet().removeIf(entry -> {
            PlayerData data = this.playerDataMap.get(entry.getKey());
            return data == null || now - data.getLastMoveTime() > 300000L;
        });
    }

    private static class ElytraData {
        private final Deque<MovementRecord> movements = new ArrayDeque<MovementRecord>(30);
        private int speedViolations;
        private int hoverViolations;
        private int riseViolations;
        private long lastSpeedVl;
        private long lastHoverVl;
        private long lastRiseVl;

        private ElytraData() {
        }

        void recordMovement(double hSpeed, double yDelta, long time) {
            if (this.movements.size() >= 30) {
                this.movements.pollFirst();
            }
            this.movements.addLast(new MovementRecord(hSpeed, yDelta, time));
        }

        List<Double> getRecentYMovements(int count) {
            ArrayList<Double> result = new ArrayList<Double>();
            int idx = 0;
            int start = Math.max(0, this.movements.size() - count);
            for (MovementRecord r : this.movements) {
                if (idx >= start) {
                    result.add(r.yDelta);
                }
                ++idx;
            }
            return result;
        }

        void incrementSpeedViolations() {
            long now = System.currentTimeMillis();
            if (now - this.lastSpeedVl > 3000L) {
                this.speedViolations = 0;
            }
            ++this.speedViolations;
            this.lastSpeedVl = now;
        }

        void incrementHoverViolations() {
            long now = System.currentTimeMillis();
            if (now - this.lastHoverVl > 4000L) {
                this.hoverViolations = 0;
            }
            ++this.hoverViolations;
            this.lastHoverVl = now;
        }

        void incrementRiseViolations() {
            long now = System.currentTimeMillis();
            if (now - this.lastRiseVl > 3000L) {
                this.riseViolations = 0;
            }
            ++this.riseViolations;
            this.lastRiseVl = now;
        }

        void decaySpeed() {
            if (System.currentTimeMillis() - this.lastSpeedVl > 5000L) {
                this.speedViolations = Math.max(0, this.speedViolations - 1);
            }
        }

        void decayHover() {
            if (System.currentTimeMillis() - this.lastHoverVl > 6000L) {
                this.hoverViolations = Math.max(0, this.hoverViolations - 1);
            }
        }

        void decayRise() {
            if (System.currentTimeMillis() - this.lastRiseVl > 5000L) {
                this.riseViolations = Math.max(0, this.riseViolations - 1);
            }
        }

        int getSpeedViolations() {
            return this.speedViolations;
        }

        int getHoverViolations() {
            return this.hoverViolations;
        }

        int getRiseViolations() {
            return this.riseViolations;
        }

        private static class MovementRecord {
            final double hSpeed;
            final double yDelta;
            final long time;

            MovementRecord(double hSpeed, double yDelta, long time) {
                this.hSpeed = hSpeed;
                this.yDelta = yDelta;
                this.time = time;
            }
        }
    }
}

