/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.detection.movement;

import NC.noChance.core.ACConfig;
import NC.noChance.core.CheckResult;
import NC.noChance.core.LayerFiltering;
import NC.noChance.core.PlayerData;
import NC.noChance.core.ViolationType;
import NC.noChance.core.WaterHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class GroundSpoofCheck {
    private final ACConfig config;
    private final Map<UUID, PlayerData> playerDataMap;
    private final LayerFiltering filtering;
    private final Map<UUID, SpoofData> spoofDataMap;

    public GroundSpoofCheck(ACConfig config, Map<UUID, PlayerData> playerDataMap, LayerFiltering filtering) {
        this.config = config;
        this.playerDataMap = playerDataMap;
        this.filtering = filtering;
        this.spoofDataMap = new HashMap<UUID, SpoofData>();
    }

    public CheckResult check(Player player, Location from, Location to, boolean clientGround) {
        Block below;
        double distanceToGround;
        if (!this.config.isCheckEnabled("groundspoof")) {
            return CheckResult.passed();
        }
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data == null) {
            return CheckResult.passed();
        }
        if (data.isInGracePeriod(this.config.getGracePeriod())) {
            return CheckResult.passed();
        }
        if (WaterHelper.isInWater(player) || player.isSwimming() || player.isClimbing()) {
            return CheckResult.passed();
        }
        if (player.isGliding() || player.isFlying()) {
            return CheckResult.passed();
        }
        if (player.getVehicle() != null) {
            return CheckResult.passed();
        }
        UUID uuid = player.getUniqueId();
        SpoofData spoofData = this.spoofDataMap.computeIfAbsent(uuid, k -> new SpoofData());
        boolean serverGround = this.isActuallyOnGround(player, to);
        double deltaY = to.getY() - from.getY();
        if (clientGround && !serverGround && (distanceToGround = this.getDistanceToGround(to)) > 0.5) {
            spoofData.incrementViolations();
            if (spoofData.getViolations() < 3) {
                return CheckResult.passed();
            }
            double severity = Math.min(0.95, 0.65 + distanceToGround * 0.15 + (double)spoofData.getViolations() * 0.03);
            CheckResult prelimResult = CheckResult.failed(ViolationType.GROUNDSPOOF, severity, String.format("Ground: client=%s server=%s dist=%.2f vl=%d", clientGround, serverGround, distanceToGround, spoofData.getViolations()));
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.GROUNDSPOOF, prelimResult)) {
                spoofData.decay();
                return CheckResult.passed();
            }
            return prelimResult;
        }
        if (!clientGround && serverGround && deltaY > 0.42 && (below = to.clone().subtract(0.0, 0.1, 0.0).getBlock()).getType() != Material.SLIME_BLOCK && below.getType() != Material.HONEY_BLOCK) {
            spoofData.incrementViolations();
            if (spoofData.getViolations() < 4) {
                return CheckResult.passed();
            }
            CheckResult prelimResult = CheckResult.failed(ViolationType.GROUNDSPOOF, 0.75, String.format("NoGround spoof: claimed air on ground, deltaY=%.3f vl=%d", deltaY, spoofData.getViolations()));
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.GROUNDSPOOF, prelimResult)) {
                spoofData.decay();
                return CheckResult.passed();
            }
            return prelimResult;
        }
        spoofData.decay();
        return CheckResult.passed();
    }

    private boolean isActuallyOnGround(Player player, Location loc) {
        for (double x = -0.3; x <= 0.3; x += 0.3) {
            for (double z = -0.3; z <= 0.3; z += 0.3) {
                Block block = loc.clone().add(x, -0.001, z).getBlock();
                if (block.getType().isSolid()) {
                    return true;
                }
                Block below = loc.clone().add(x, -0.5, z).getBlock();
                Material type = below.getType();
                if (type != Material.SCAFFOLDING && type != Material.COBWEB && !type.name().contains("FENCE") && !type.name().contains("WALL") && type != Material.CHAIN && !type.name().contains("CARPET") && !type.name().contains("SNOW") && type != Material.LILY_PAD) continue;
                return true;
            }
        }
        return false;
    }

    private double getDistanceToGround(Location loc) {
        for (double y = 0.0; y <= 5.0; y += 0.1) {
            Block block = loc.clone().subtract(0.0, y, 0.0).getBlock();
            if (!block.getType().isSolid()) continue;
            return y;
        }
        return 5.0;
    }

    public void cleanup(UUID playerId) {
        this.spoofDataMap.remove(playerId);
    }

    public void cleanupStale() {
        long now = System.currentTimeMillis();
        this.spoofDataMap.entrySet().removeIf(entry -> {
            PlayerData data = this.playerDataMap.get(entry.getKey());
            return data == null || now - data.getLastMoveTime() > 300000L;
        });
    }

    private static class SpoofData {
        private int violations;
        private long lastViolation;

        private SpoofData() {
        }

        void incrementViolations() {
            long now = System.currentTimeMillis();
            this.violations = now - this.lastViolation > 3000L ? 1 : ++this.violations;
            this.lastViolation = now;
        }

        void decay() {
            if (System.currentTimeMillis() - this.lastViolation > 5000L) {
                this.violations = Math.max(0, this.violations - 1);
            }
        }

        int getViolations() {
            return this.violations;
        }
    }
}

