/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.detection.movement;

import NC.noChance.core.ACConfig;
import NC.noChance.core.CheckResult;
import NC.noChance.core.EnhancementTracker;
import NC.noChance.core.LayerFiltering;
import NC.noChance.core.PlayerData;
import NC.noChance.core.ViolationType;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.entity.Player;

public class JesusCheck {
    private final ACConfig config;
    private final Map<UUID, PlayerData> playerDataMap;
    private final LayerFiltering filtering;
    private final Map<UUID, JesusTracker> trackers;

    public JesusCheck(ACConfig config, Map<UUID, PlayerData> playerDataMap, LayerFiltering filtering) {
        this.config = config;
        this.playerDataMap = playerDataMap;
        this.filtering = filtering;
        this.trackers = new ConcurrentHashMap<UUID, JesusTracker>();
    }

    public CheckResult check(Player player, Location from, Location to) {
        boolean stableOnLiquid;
        if (!this.config.isCheckEnabled("jesus")) {
            return CheckResult.passed();
        }
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data == null) {
            return CheckResult.passed();
        }
        if (data.isInGracePeriod(this.config.getGracePeriod())) {
            return CheckResult.passed();
        }
        EnhancementTracker.MovementEnhancements enhancements = EnhancementTracker.calculateMovementEnhancements(player);
        if (enhancements.hasLegitFlight) {
            return CheckResult.passed();
        }
        Block feetBlock = to.getBlock();
        Block belowFeet = to.clone().subtract(0.0, 0.1, 0.0).getBlock();
        boolean onLiquid = this.isLiquid(feetBlock) || this.isLiquid(belowFeet);
        UUID uuid = player.getUniqueId();
        JesusTracker tracker = this.trackers.computeIfAbsent(uuid, k -> new JesusTracker());
        if (!onLiquid) {
            tracker.reset();
            return CheckResult.passed();
        }
        if (player.isSwimming()) {
            tracker.reset();
            return CheckResult.passed();
        }
        boolean actuallyInWater = this.isPlayerSubmergedInWater(player, to);
        if (actuallyInWater) {
            tracker.reset();
            return CheckResult.passed();
        }
        if (this.isInFlowingWater(to)) {
            tracker.reset();
            return CheckResult.passed();
        }
        double velocityY = to.getY() - from.getY();
        double dx = to.getX() - from.getX();
        double dz = to.getZ() - from.getZ();
        double horizontalSpeed = Math.sqrt(dx * dx + dz * dz);
        boolean bl = stableOnLiquid = Math.abs(velocityY) < 0.05 && horizontalSpeed > 0.03;
        if (stableOnLiquid) {
            Block headBlock = to.clone().add(0.0, 1.0, 0.0).getBlock();
            if (this.isLiquid(headBlock)) {
                tracker.reset();
                return CheckResult.passed();
            }
            tracker.recordViolation();
            int violations = tracker.getViolationCount();
            if (violations < 3) {
                return CheckResult.passed();
            }
            double severity = Math.min(0.95, 0.75 + (double)violations * 0.05);
            EnhancementTracker.MovementEnhancements enhancementsForLog = EnhancementTracker.calculateMovementEnhancements(player);
            CheckResult prelimResult = CheckResult.failed(ViolationType.JESUS, severity, String.format("Stable on liquid: Y-velocity: %.3f, violations: %d | Enhancements: %s", velocityY, violations, enhancementsForLog.reason));
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.JESUS, prelimResult)) {
                tracker.decay();
                return CheckResult.passed();
            }
            return prelimResult;
        }
        tracker.decay();
        return CheckResult.passed();
    }

    private boolean isPlayerSubmergedInWater(Player player, Location loc) {
        double eyeHeight = player.getEyeHeight();
        Location eyeLoc = loc.clone().add(0.0, eyeHeight * 0.5, 0.0);
        Block eyeBlock = eyeLoc.getBlock();
        if (!this.isLiquid(eyeBlock)) {
            return false;
        }
        try {
            BlockData blockData = eyeBlock.getBlockData();
            if (blockData instanceof Levelled) {
                Levelled levelled = (Levelled)blockData;
                int level = levelled.getLevel();
                double waterHeight = (double)eyeLoc.getBlockY() + (1.0 - (double)level / 8.0);
                return eyeLoc.getY() < waterHeight;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return player.isInWater();
    }

    private boolean isLiquid(Block block) {
        Material type = block.getType();
        return type == Material.WATER || type == Material.LAVA || type.name().contains("WATER") || type.name().contains("LAVA");
    }

    private boolean isInFlowingWater(Location loc) {
        Block[] neighbors;
        Block center = loc.getBlock();
        if (this.isFlowingWaterBlock(center)) {
            return true;
        }
        for (Block neighbor : neighbors = new Block[]{loc.clone().add(1.0, 0.0, 0.0).getBlock(), loc.clone().add(-1.0, 0.0, 0.0).getBlock(), loc.clone().add(0.0, 0.0, 1.0).getBlock(), loc.clone().add(0.0, 0.0, -1.0).getBlock(), loc.clone().add(0.0, -1.0, 0.0).getBlock()}) {
            if (!this.isFlowingWaterBlock(neighbor)) continue;
            return true;
        }
        return false;
    }

    private boolean isFlowingWaterBlock(Block block) {
        if (block.getType() != Material.WATER) {
            return false;
        }
        try {
            BlockData blockData = block.getBlockData();
            if (blockData instanceof Levelled) {
                Levelled levelled = (Levelled)blockData;
                return levelled.getLevel() > 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void cleanup(UUID playerId) {
        this.trackers.remove(playerId);
    }

    private static class JesusTracker {
        private int violations = 0;
        private long lastViolation = 0L;
        private long lastReset = 0L;

        private JesusTracker() {
        }

        void recordViolation() {
            long now = System.currentTimeMillis();
            this.violations = now - this.lastViolation < 2000L ? ++this.violations : 1;
            this.lastViolation = now;
        }

        void decay() {
            long now = System.currentTimeMillis();
            if (now - this.lastViolation > 3000L) {
                this.violations = Math.max(0, this.violations - 1);
            }
        }

        void reset() {
            long now = System.currentTimeMillis();
            if (now - this.lastReset > 1000L) {
                this.violations = 0;
                this.lastReset = now;
            }
        }

        int getViolationCount() {
            return this.violations;
        }
    }
}

