/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.detection.movement;

import NC.noChance.core.ACConfig;
import NC.noChance.core.CheckResult;
import NC.noChance.core.EnhancementTracker;
import NC.noChance.core.LayerFiltering;
import NC.noChance.core.PlayerData;
import NC.noChance.core.ViolationType;
import NC.noChance.core.WaterHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.BoundingBox;

public class NoClipCheck {
    private final ACConfig config;
    private final Map<UUID, PlayerData> playerDataMap;
    private final LayerFiltering filtering;
    private final Map<UUID, ClipTracker> trackers;
    private static final double PLAYER_WIDTH = 0.6;
    private static final double PLAYER_HEIGHT = 1.8;
    private static final double HALF_WIDTH = 0.3;

    public NoClipCheck(ACConfig config, Map<UUID, PlayerData> playerDataMap, LayerFiltering filtering) {
        this.config = config;
        this.playerDataMap = playerDataMap;
        this.filtering = filtering;
        this.trackers = new HashMap<UUID, ClipTracker>();
    }

    public CheckResult check(Player player, Location from, Location to) {
        CheckResult vertResult;
        double overlapThreshold;
        if (!this.config.isCheckEnabled("noclip")) {
            return CheckResult.passed();
        }
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data == null) {
            return CheckResult.passed();
        }
        if (data.isInGracePeriod(this.config.getGracePeriod())) {
            return CheckResult.passed();
        }
        if (player.getGameMode() == GameMode.SPECTATOR) {
            return CheckResult.passed();
        }
        if (WaterHelper.isInWater(player)) {
            return CheckResult.passed();
        }
        EnhancementTracker.MovementEnhancements enhancements = EnhancementTracker.calculateMovementEnhancements(player);
        if (enhancements.hasLegitFlight) {
            return CheckResult.passed();
        }
        if (player.getVehicle() != null) {
            return CheckResult.passed();
        }
        if (!this.isChunkLoaded(to)) {
            return CheckResult.passed();
        }
        int ping = this.filtering.getPing(player);
        if (ping > 400) {
            return CheckResult.passed();
        }
        UUID uuid = player.getUniqueId();
        ClipTracker tracker = this.trackers.computeIfAbsent(uuid, k -> new ClipTracker());
        tracker.updatePing(ping);
        World world = player.getWorld();
        BoundingBox playerBox = this.getPlayerBoundingBox(to);
        int solidCount = 0;
        double totalOverlap = 0.0;
        int blocksChecked = 0;
        int minX = (int)Math.floor(playerBox.getMinX());
        int minY = (int)Math.floor(playerBox.getMinY());
        int minZ = (int)Math.floor(playerBox.getMinZ());
        int maxX = (int)Math.ceil(playerBox.getMaxX());
        int maxY = (int)Math.ceil(playerBox.getMaxY());
        int maxZ = (int)Math.ceil(playerBox.getMaxZ());
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BoundingBox blockBox;
                    Block block = world.getBlockAt(x, y, z);
                    ++blocksChecked;
                    if (WaterHelper.isWaterBlock(block) || !this.isSolidClipBlock(block) || (blockBox = block.getBoundingBox()).getMax().equals((Object)blockBox.getMin()) || !playerBox.overlaps(blockBox)) continue;
                    ++solidCount;
                    double overlap = this.calculateOverlapVolume(playerBox, blockBox);
                    totalOverlap += overlap;
                }
            }
        }
        tracker.decay();
        int threshold = ping > 200 ? 5 : 4;
        double d = overlapThreshold = ping > 200 ? 0.08 : 0.05;
        if (solidCount > threshold || totalOverlap > overlapThreshold) {
            int vlThreshold;
            tracker.addViolation(solidCount, totalOverlap);
            int n = vlThreshold = ping > 200 ? 3 : 2;
            if (tracker.getViolationCount() >= vlThreshold) {
                double severity = Math.min(1.0, Math.max((double)solidCount / 8.0, totalOverlap * 10.0));
                CheckResult prelimResult = CheckResult.failed(ViolationType.NOCLIP, severity, String.format("NoClip: %d solids | Overlap: %.3f | VL: %d", solidCount, totalOverlap, tracker.getViolationCount()));
                if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.NOCLIP, prelimResult)) {
                    return CheckResult.passed();
                }
                tracker.reset();
                return prelimResult;
            }
        }
        if ((vertResult = this.checkVerticalClip(player, from, to, tracker, world, ping)).isFailed()) {
            return vertResult;
        }
        return CheckResult.passed();
    }

    private CheckResult checkVerticalClip(Player player, Location from, Location to, ClipTracker tracker, World world, int ping) {
        int clipThreshold;
        double dy = to.getY() - from.getY();
        if (Math.abs(dy) < 0.5) {
            return CheckResult.passed();
        }
        if (dy > 0.0 && dy < 1.0 && player.isOnGround()) {
            return CheckResult.passed();
        }
        int steps = (int)Math.ceil(Math.abs(dy) / 0.4);
        steps = Math.min(steps, 8);
        int clipsFound = 0;
        for (int i = 1; i <= steps; ++i) {
            double ratio = (double)i / (double)steps;
            double checkY = from.getY() + dy * ratio;
            BoundingBox checkBox = new BoundingBox(to.getX() - 0.3, checkY, to.getZ() - 0.3, to.getX() + 0.3, checkY + 1.8, to.getZ() + 0.3);
            int minX = (int)Math.floor(checkBox.getMinX());
            int minY = (int)Math.floor(checkBox.getMinY());
            int minZ = (int)Math.floor(checkBox.getMinZ());
            int maxX = (int)Math.ceil(checkBox.getMaxX());
            int maxY = (int)Math.ceil(checkBox.getMaxY());
            int maxZ = (int)Math.ceil(checkBox.getMaxZ());
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        BoundingBox blockBox;
                        Block block = world.getBlockAt(x, y, z);
                        if (!this.isSolidClipBlock(block) || (blockBox = block.getBoundingBox()).getMax().equals((Object)blockBox.getMin()) || !checkBox.overlaps(blockBox)) continue;
                        ++clipsFound;
                    }
                }
            }
        }
        int n = clipThreshold = ping > 200 ? 4 : 3;
        if (clipsFound >= clipThreshold) {
            int vlThreshold;
            tracker.addVerticalViolation(clipsFound);
            int n2 = vlThreshold = ping > 200 ? 3 : 2;
            if (tracker.getVerticalViolationCount() >= vlThreshold) {
                double severity = Math.min(1.0, (double)clipsFound / 6.0);
                CheckResult prelimResult = CheckResult.failed(ViolationType.NOCLIP, severity, String.format("Vertical noclip: %d clips | VL: %d", clipsFound, tracker.getVerticalViolationCount()));
                if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.NOCLIP, prelimResult)) {
                    return CheckResult.passed();
                }
                tracker.reset();
                return prelimResult;
            }
        }
        return CheckResult.passed();
    }

    private BoundingBox getPlayerBoundingBox(Location loc) {
        return new BoundingBox(loc.getX() - 0.3, loc.getY(), loc.getZ() - 0.3, loc.getX() + 0.3, loc.getY() + 1.8, loc.getZ() + 0.3);
    }

    private double calculateOverlapVolume(BoundingBox a, BoundingBox b) {
        double overlapX = Math.max(0.0, Math.min(a.getMaxX(), b.getMaxX()) - Math.max(a.getMinX(), b.getMinX()));
        double overlapY = Math.max(0.0, Math.min(a.getMaxY(), b.getMaxY()) - Math.max(a.getMinY(), b.getMinY()));
        double overlapZ = Math.max(0.0, Math.min(a.getMaxZ(), b.getMaxZ()) - Math.max(a.getMinZ(), b.getMinZ()));
        return overlapX * overlapY * overlapZ;
    }

    private boolean isSolidClipBlock(Block block) {
        Material type = block.getType();
        if (!type.isSolid()) {
            return false;
        }
        String name = type.name();
        if (type == Material.LADDER) {
            return false;
        }
        if (type == Material.VINE) {
            return false;
        }
        if (type == Material.SCAFFOLDING) {
            return false;
        }
        if (type == Material.BELL) {
            return false;
        }
        if (type == Material.COBWEB) {
            return false;
        }
        if (type == Material.HONEY_BLOCK) {
            return false;
        }
        if (type == Material.SLIME_BLOCK) {
            return false;
        }
        if (type == Material.SOUL_SAND) {
            return false;
        }
        if (type == Material.SOUL_SOIL) {
            return false;
        }
        if (type == Material.POWDER_SNOW) {
            return false;
        }
        if (type == Material.SWEET_BERRY_BUSH) {
            return false;
        }
        if (name.contains("TRAPDOOR")) {
            return false;
        }
        if (name.contains("DOOR")) {
            return false;
        }
        if (name.contains("FENCE_GATE")) {
            return false;
        }
        if (name.contains("CARPET")) {
            return false;
        }
        if (name.contains("PRESSURE_PLATE")) {
            return false;
        }
        if (name.contains("SIGN")) {
            return false;
        }
        if (name.contains("BANNER")) {
            return false;
        }
        if (name.contains("LANTERN")) {
            return false;
        }
        if (name.contains("CORAL")) {
            return false;
        }
        if (name.contains("CANDLE")) {
            return false;
        }
        if (name.contains("BUTTON")) {
            return false;
        }
        if (name.contains("LEVER")) {
            return false;
        }
        if (name.contains("TRIPWIRE")) {
            return false;
        }
        if (name.contains("POT")) {
            return false;
        }
        if (name.contains("HEAD")) {
            return false;
        }
        if (name.contains("SKULL")) {
            return false;
        }
        if (name.contains("TORCH")) {
            return false;
        }
        if (name.contains("CHAIN")) {
            return false;
        }
        if (name.contains("END_ROD")) {
            return false;
        }
        if (name.contains("LIGHTNING_ROD")) {
            return false;
        }
        if (name.contains("AMETHYST")) {
            return false;
        }
        if (name.contains("RAIL")) {
            return false;
        }
        if (name.contains("REDSTONE")) {
            return false;
        }
        if (name.contains("REPEATER")) {
            return false;
        }
        return !name.contains("COMPARATOR");
    }

    private boolean isChunkLoaded(Location loc) {
        return loc.getWorld().isChunkLoaded(loc.getBlockX() >> 4, loc.getBlockZ() >> 4);
    }

    public void cleanup(UUID playerId) {
        this.trackers.remove(playerId);
    }

    private static class ClipTracker {
        private int violations = 0;
        private int vertViolations = 0;
        private long lastViolation = 0L;
        private int avgPing = 50;
        private double peakOverlap = 0.0;
        private int peakSolidCount = 0;

        private ClipTracker() {
        }

        void addViolation(int solidCount, double overlap) {
            ++this.violations;
            this.lastViolation = System.currentTimeMillis();
            if (overlap > this.peakOverlap) {
                this.peakOverlap = overlap;
            }
            if (solidCount > this.peakSolidCount) {
                this.peakSolidCount = solidCount;
            }
        }

        void addVerticalViolation(int clips) {
            ++this.vertViolations;
            this.lastViolation = System.currentTimeMillis();
        }

        void updatePing(int ping) {
            this.avgPing = (this.avgPing * 3 + ping) / 4;
        }

        void decay() {
            int decayTime;
            long now = System.currentTimeMillis();
            int n = decayTime = this.avgPing > 150 ? 2000 : 1500;
            if (now - this.lastViolation > (long)decayTime) {
                if (this.violations > 0) {
                    --this.violations;
                }
                if (this.vertViolations > 0) {
                    --this.vertViolations;
                }
                this.lastViolation = now;
            }
        }

        void reset() {
            this.violations = 0;
            this.vertViolations = 0;
            this.peakOverlap = 0.0;
            this.peakSolidCount = 0;
        }

        int getViolationCount() {
            return this.violations;
        }

        int getVerticalViolationCount() {
            return this.vertViolations;
        }
    }
}

