/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.detection.movement;

import NC.noChance.core.ACConfig;
import NC.noChance.core.CheckResult;
import NC.noChance.core.LayerFiltering;
import NC.noChance.core.PlayerData;
import NC.noChance.core.ViolationType;
import NC.noChance.core.WaterHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.BoundingBox;

public class PhaseCheck {
    private final ACConfig config;
    private final Map<UUID, PlayerData> playerDataMap;
    private final LayerFiltering filtering;
    private final Map<UUID, PhaseTracker> trackers;
    private static final double PLAYER_WIDTH = 0.6;
    private static final double PLAYER_HEIGHT = 1.8;
    private static final double HALF_WIDTH = 0.3;

    public PhaseCheck(ACConfig config, Map<UUID, PlayerData> playerDataMap, LayerFiltering filtering) {
        this.config = config;
        this.playerDataMap = playerDataMap;
        this.filtering = filtering;
        this.trackers = new HashMap<UUID, PhaseTracker>();
    }

    public CheckResult check(Player player, Location from, Location to) {
        if (!this.config.isCheckEnabled("phase")) {
            return CheckResult.passed();
        }
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data == null) {
            return CheckResult.passed();
        }
        if (data.isInGracePeriod(this.config.getGracePeriod())) {
            return CheckResult.passed();
        }
        if (player.getGameMode() == GameMode.SPECTATOR) {
            return CheckResult.passed();
        }
        if (player.isFlying() && player.getAllowFlight()) {
            return CheckResult.passed();
        }
        if (player.getVehicle() != null) {
            return CheckResult.passed();
        }
        if (WaterHelper.isInWater(player)) {
            return CheckResult.passed();
        }
        if (!this.isChunkLoaded(to)) {
            return CheckResult.passed();
        }
        int ping = this.filtering.getPing(player);
        if (ping > 350) {
            return CheckResult.passed();
        }
        UUID uuid = player.getUniqueId();
        PhaseTracker tracker = this.trackers.computeIfAbsent(uuid, k -> new PhaseTracker());
        tracker.updatePing(ping);
        boolean inSolidNow = this.isInsideSolidBlock(to, player.getWorld());
        boolean wasInSolid = this.isInsideSolidBlock(from, player.getWorld());
        if (inSolidNow && !wasInSolid) {
            int threshold;
            tracker.recordPhaseEntry(to);
            int n = threshold = ping > 200 ? 4 : 3;
            if (tracker.getEntryCount() >= threshold) {
                double severity = Math.min(1.0, (double)tracker.getEntryCount() / 5.0);
                CheckResult prelimResult = CheckResult.failed(ViolationType.PHASE, severity, String.format("Phase entry detected (%d violations)", tracker.getEntryCount()));
                if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.PHASE, prelimResult)) {
                    tracker.decay();
                    return CheckResult.passed();
                }
                tracker.reset();
                return prelimResult;
            }
        }
        if (inSolidNow) {
            int tickThreshold;
            tracker.addTickInSolid();
            int n = tickThreshold = ping > 200 ? 8 : 5;
            if (tracker.getTicksInSolid() >= tickThreshold) {
                double severity = Math.min(1.0, (double)tracker.getTicksInSolid() / 10.0);
                CheckResult prelimResult = CheckResult.failed(ViolationType.PHASE, severity, String.format("Extended phase duration (%d ticks inside solid)", tracker.getTicksInSolid()));
                if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.PHASE, prelimResult)) {
                    tracker.decay();
                    return CheckResult.passed();
                }
                tracker.reset();
                return prelimResult;
            }
        } else {
            tracker.resetTicksInSolid();
        }
        CheckResult pathResult = this.checkPhasePath(player, from, to, tracker, ping);
        if (pathResult.isFailed()) {
            return pathResult;
        }
        tracker.decay();
        return CheckResult.passed();
    }

    private CheckResult checkPhasePath(Player player, Location from, Location to, PhaseTracker tracker, int ping) {
        double dz;
        double dy;
        double dx = to.getX() - from.getX();
        double distance = Math.sqrt(dx * dx + (dy = to.getY() - from.getY()) * dy + (dz = to.getZ() - from.getZ()) * dz);
        if (distance < 0.1) {
            return CheckResult.passed();
        }
        int steps = (int)Math.ceil(distance / 0.25);
        steps = Math.min(steps, 16);
        World world = from.getWorld();
        int solidPenetrations = 0;
        double penetrationDepth = 0.0;
        for (int i = 1; i <= steps; ++i) {
            double checkZ;
            double checkY;
            double ratio = (double)i / (double)steps;
            double checkX = from.getX() + dx * ratio;
            if (!this.isPointInsideSolid(checkX, checkY = from.getY() + dy * ratio, checkZ = from.getZ() + dz * ratio, world)) continue;
            ++solidPenetrations;
            penetrationDepth = Math.max(penetrationDepth, ratio);
        }
        if (solidPenetrations >= 2) {
            int threshold;
            tracker.recordPathPhase();
            int n = threshold = ping > 200 ? 5 : 4;
            if (tracker.getPathCount() >= threshold) {
                double severity = Math.min(1.0, (double)(tracker.getPathCount() + solidPenetrations) / 8.0);
                CheckResult prelimResult = CheckResult.failed(ViolationType.PHASE, severity, String.format("Phase through blocks (%d solid hits, depth %.2f)", solidPenetrations, penetrationDepth));
                if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.PHASE, prelimResult)) {
                    tracker.decay();
                    return CheckResult.passed();
                }
                tracker.reset();
                return prelimResult;
            }
        }
        return CheckResult.passed();
    }

    private boolean isInsideSolidBlock(Location loc, World world) {
        double x = loc.getX();
        double y = loc.getY();
        double z = loc.getZ();
        BoundingBox playerBox = new BoundingBox(x - 0.3, y, z - 0.3, x + 0.3, y + 1.8, z + 0.3);
        int minX = (int)Math.floor(playerBox.getMinX());
        int minY = (int)Math.floor(playerBox.getMinY());
        int minZ = (int)Math.floor(playerBox.getMinZ());
        int maxX = (int)Math.ceil(playerBox.getMaxX());
        int maxY = (int)Math.ceil(playerBox.getMaxY());
        int maxZ = (int)Math.ceil(playerBox.getMaxZ());
        for (int bx = minX; bx <= maxX; ++bx) {
            for (int by = minY; by <= maxY; ++by) {
                for (int bz = minZ; bz <= maxZ; ++bz) {
                    BoundingBox blockBox;
                    Block block = world.getBlockAt(bx, by, bz);
                    if (!this.isSolidPhaseBlock(block) || (blockBox = block.getBoundingBox()).getMax().equals((Object)blockBox.getMin()) || !playerBox.overlaps(blockBox)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isPointInsideSolid(double x, double y, double z, World world) {
        BoundingBox playerBox = new BoundingBox(x - 0.3, y, z - 0.3, x + 0.3, y + 1.8, z + 0.3);
        int minX = (int)Math.floor(playerBox.getMinX());
        int minY = (int)Math.floor(playerBox.getMinY());
        int minZ = (int)Math.floor(playerBox.getMinZ());
        int maxX = (int)Math.ceil(playerBox.getMaxX());
        int maxY = (int)Math.ceil(playerBox.getMaxY());
        int maxZ = (int)Math.ceil(playerBox.getMaxZ());
        for (int bx = minX; bx <= maxX; ++bx) {
            for (int by = minY; by <= maxY; ++by) {
                for (int bz = minZ; bz <= maxZ; ++bz) {
                    BoundingBox blockBox;
                    Block block = world.getBlockAt(bx, by, bz);
                    if (!this.isSolidPhaseBlock(block) || (blockBox = block.getBoundingBox()).getMax().equals((Object)blockBox.getMin()) || !playerBox.overlaps(blockBox)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isSolidPhaseBlock(Block block) {
        Material type = block.getType();
        if (!type.isSolid()) {
            return false;
        }
        String name = type.name();
        if (type == Material.COBWEB) {
            return false;
        }
        if (type == Material.HONEY_BLOCK) {
            return false;
        }
        if (type == Material.SLIME_BLOCK) {
            return false;
        }
        if (type == Material.SOUL_SAND) {
            return false;
        }
        if (type == Material.SOUL_SOIL) {
            return false;
        }
        if (type == Material.POWDER_SNOW) {
            return false;
        }
        if (type == Material.SWEET_BERRY_BUSH) {
            return false;
        }
        if (type == Material.SCAFFOLDING) {
            return false;
        }
        if (type == Material.LADDER) {
            return false;
        }
        if (type == Material.VINE) {
            return false;
        }
        if (type == Material.BELL) {
            return false;
        }
        if (name.contains("DOOR")) {
            return false;
        }
        if (name.contains("GATE")) {
            return false;
        }
        if (name.contains("FENCE")) {
            return false;
        }
        if (name.contains("TRAPDOOR")) {
            return false;
        }
        if (name.contains("CARPET")) {
            return false;
        }
        if (name.contains("PRESSURE_PLATE")) {
            return false;
        }
        if (name.contains("SIGN")) {
            return false;
        }
        if (name.contains("BANNER")) {
            return false;
        }
        if (name.contains("LANTERN")) {
            return false;
        }
        if (name.contains("CORAL")) {
            return false;
        }
        if (name.contains("CANDLE")) {
            return false;
        }
        if (name.contains("BUTTON")) {
            return false;
        }
        if (name.contains("LEVER")) {
            return false;
        }
        if (name.contains("TRIPWIRE")) {
            return false;
        }
        if (name.contains("POT")) {
            return false;
        }
        if (name.contains("HEAD")) {
            return false;
        }
        if (name.contains("SKULL")) {
            return false;
        }
        if (name.contains("TORCH")) {
            return false;
        }
        if (name.contains("CHAIN")) {
            return false;
        }
        if (name.contains("END_ROD")) {
            return false;
        }
        if (name.contains("LIGHTNING_ROD")) {
            return false;
        }
        if (name.contains("AMETHYST_CLUSTER")) {
            return false;
        }
        if (name.contains("AMETHYST_BUD")) {
            return false;
        }
        if (name.contains("RAIL")) {
            return false;
        }
        if (name.contains("REDSTONE")) {
            return false;
        }
        if (name.contains("REPEATER")) {
            return false;
        }
        return !name.contains("COMPARATOR");
    }

    private boolean isChunkLoaded(Location loc) {
        return loc.getWorld().isChunkLoaded(loc.getBlockX() >> 4, loc.getBlockZ() >> 4);
    }

    public void cleanup(UUID uuid) {
        this.trackers.remove(uuid);
    }

    private static class PhaseTracker {
        private int entryCount = 0;
        private int pathCount = 0;
        private int ticksInSolid = 0;
        private long lastViolation = 0L;
        private int avgPing = 50;
        private Location lastPhaseLocation = null;

        private PhaseTracker() {
        }

        void recordPhaseEntry(Location loc) {
            double dist;
            if (this.lastPhaseLocation != null && (dist = loc.distance(this.lastPhaseLocation)) < 0.5) {
                return;
            }
            ++this.entryCount;
            this.lastViolation = System.currentTimeMillis();
            this.lastPhaseLocation = loc.clone();
        }

        void recordPathPhase() {
            ++this.pathCount;
            this.lastViolation = System.currentTimeMillis();
        }

        void addTickInSolid() {
            ++this.ticksInSolid;
        }

        void resetTicksInSolid() {
            this.ticksInSolid = 0;
        }

        void updatePing(int ping) {
            this.avgPing = (this.avgPing * 3 + ping) / 4;
        }

        void decay() {
            int decayTime;
            long now = System.currentTimeMillis();
            int n = decayTime = this.avgPing > 150 ? 1500 : 1000;
            if (now - this.lastViolation > (long)decayTime) {
                if (this.entryCount > 0) {
                    --this.entryCount;
                }
                if (this.pathCount > 0) {
                    --this.pathCount;
                }
                this.lastViolation = now;
            }
        }

        void reset() {
            this.entryCount = 0;
            this.pathCount = 0;
            this.ticksInSolid = 0;
            this.lastPhaseLocation = null;
        }

        int getEntryCount() {
            return this.entryCount;
        }

        int getPathCount() {
            return this.pathCount;
        }

        int getTicksInSolid() {
            return this.ticksInSolid;
        }
    }
}

