/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.detection.movement;

import NC.noChance.core.ACConfig;
import NC.noChance.core.CheckResult;
import NC.noChance.core.FalsePositiveFilter;
import NC.noChance.core.LayerFiltering;
import NC.noChance.core.MovementPredictor;
import NC.noChance.core.PlayerData;
import NC.noChance.core.ViolationType;
import NC.noChance.core.WaterHelper;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class SpeedCheck {
    private final ACConfig config;
    private final Map<UUID, PlayerData> playerDataMap;
    private final LayerFiltering filtering;
    private final WaterHelper waterPhysics;
    private final FalsePositiveFilter falsePositiveFilter;
    private final Map<UUID, Vector> lastVelocity;
    private final Map<UUID, MoveData> moveDataMap;

    public SpeedCheck(ACConfig config, Map<UUID, PlayerData> playerDataMap, LayerFiltering filtering) {
        this.config = config;
        this.playerDataMap = playerDataMap;
        this.filtering = filtering;
        this.waterPhysics = new WaterHelper();
        this.falsePositiveFilter = new FalsePositiveFilter();
        this.lastVelocity = new ConcurrentHashMap<UUID, Vector>();
        this.moveDataMap = new ConcurrentHashMap<UUID, MoveData>();
    }

    public CheckResult check(Player player, Location from, Location to) {
        if (!this.config.isCheckEnabled("speed")) {
            return CheckResult.passed();
        }
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data == null) {
            return CheckResult.passed();
        }
        if (data.isInGracePeriod(this.config.getGracePeriod())) {
            this.falsePositiveFilter.recordLegitAction(player, ViolationType.SPEED);
            return CheckResult.passed();
        }
        if (player.getAllowFlight() && player.isFlying()) {
            this.falsePositiveFilter.recordLegitAction(player, ViolationType.SPEED);
            return CheckResult.passed();
        }
        if (WaterHelper.isInWater(player)) {
            return this.checkWaterSpeed(player, from, to);
        }
        Entity vehicle = player.getVehicle();
        if (vehicle != null) {
            return this.checkVehicleSpeed(player, vehicle, from, to);
        }
        if (player.isGliding()) {
            return this.checkElytraSpeed(player, from, to);
        }
        if (player.isRiptiding()) {
            this.falsePositiveFilter.recordLegitAction(player, ViolationType.SPEED);
            return CheckResult.passed();
        }
        return this.checkGroundSpeed(player, from, to, data);
    }

    private CheckResult checkGroundSpeed(Player player, Location from, Location to, PlayerData data) {
        double dx = to.getX() - from.getX();
        double dy = to.getY() - from.getY();
        double dz = to.getZ() - from.getZ();
        double horizontalDist = Math.sqrt(dx * dx + dz * dz);
        double totalDist = Math.sqrt(dx * dx + dy * dy + dz * dz);
        this.falsePositiveFilter.recordMovement(player, totalDist);
        UUID playerId = player.getUniqueId();
        Vector currentVel = to.toVector().subtract(from.toVector());
        Vector lastVel = this.lastVelocity.getOrDefault(playerId, currentVel);
        MovementPredictor.PredictionResult prediction = MovementPredictor.predict(player, from, to, lastVel);
        this.lastVelocity.put(playerId, currentVel);
        if (prediction.valid && prediction.confidence > 0.92) {
            this.falsePositiveFilter.recordLegitAction(player, ViolationType.SPEED);
            return CheckResult.passed();
        }
        long now = System.currentTimeMillis();
        long timeDelta = now - data.getLastMoveTime();
        if (timeDelta < 20L) {
            return CheckResult.passed();
        }
        double tps = this.getTPS();
        double tpsMultiplier = 20.0 / Math.max(tps, 10.0);
        double timeInSeconds = Math.max((double)timeDelta / 1000.0, 0.05);
        double actualSpeed = horizontalDist / timeInSeconds;
        MoveData moveData = this.moveDataMap.computeIfAbsent(playerId, k -> new MoveData());
        moveData.addSpeed(actualSpeed, now);
        if (player.isOnGround()) {
            ++moveData.ticksOnGround;
            moveData.ticksInAir = 0;
        } else {
            ++moveData.ticksInAir;
            moveData.ticksOnGround = 0;
        }
        Block below = player.getLocation().clone().subtract(0.0, 0.5, 0.0).getBlock();
        Material belowType = below.getType();
        boolean onIce = this.isIceBlock(belowType);
        if (moveData.wasOnIce && !onIce && moveData.ticksOnGround < 5) {
            moveData.wasOnIce = false;
            return CheckResult.passed();
        }
        moveData.wasOnIce = onIce;
        if (!moveData.hasStableData()) {
            return CheckResult.passed();
        }
        double maxAllowedSpeed = this.calculateMaxGroundSpeed(player, dy, timeInSeconds, belowType);
        double lagComp = this.filtering.getLagCompensation(player);
        maxAllowedSpeed += lagComp;
        maxAllowedSpeed *= tpsMultiplier;
        if (this.isOnStairsOrSlabs(player)) {
            maxAllowedSpeed *= 1.25;
        }
        double avgSpeed = moveData.getAvgSpeed();
        double medianSpeed = moveData.getMedianSpeed();
        double speedToCheck = Math.min(actualSpeed, Math.max(avgSpeed, medianSpeed) * 1.12);
        moveData.decayViolations();
        if (speedToCheck > maxAllowedSpeed) {
            double maxExpectedAccel;
            double excess = speedToCheck - maxAllowedSpeed;
            double severityBase = excess / maxAllowedSpeed;
            double severity = Math.min(1.0, Math.pow(severityBase, 0.65));
            double avgAccel = moveData.getAvgAccel();
            double maxAccel = moveData.getMaxAccel();
            if (maxAccel > (maxExpectedAccel = maxAllowedSpeed * 0.6) * 2.5) {
                severity = Math.min(1.0, severity * 1.3);
            }
            moveData.addViolation();
            if (moveData.getViolations() < 2) {
                return CheckResult.passed();
            }
            CheckResult prelimResult = CheckResult.failed(ViolationType.SPEED, severity, String.format("Speed: %.2f/%.2f m/s | Avg: %.2f | Accel: %.2f | VL: %d", actualSpeed, maxAllowedSpeed, avgSpeed, avgAccel, moveData.getViolations()));
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.SPEED, prelimResult)) {
                return CheckResult.passed();
            }
            if (moveData.getViolations() >= 4) {
                moveData.resetViolations();
            }
            return prelimResult;
        }
        return CheckResult.passed();
    }

    private double calculateMaxGroundSpeed(Player player, double verticalMovement, double timeInSeconds, Material belowType) {
        PotionEffect slowness;
        PotionEffectType slownessType;
        boolean isFalling;
        double baseSpeed = 4.317;
        boolean isSprinting = player.isSprinting();
        boolean isJumping = verticalMovement > 0.08;
        boolean bl = isFalling = verticalMovement < -0.08;
        if (isSprinting && isJumping) {
            baseSpeed = 7.2;
        } else if (isSprinting) {
            baseSpeed = 5.7;
        } else if (isJumping) {
            baseSpeed = 5.0;
        }
        PotionEffect speedEffect = player.getPotionEffect(PotionEffectType.SPEED);
        if (speedEffect != null) {
            int amp = speedEffect.getAmplifier() + 1;
            baseSpeed *= 1.0 + (double)amp * 0.2;
        }
        if ((slownessType = PotionEffectType.getByName((String)"SLOWNESS")) == null) {
            slownessType = PotionEffectType.getByName((String)"SLOW");
        }
        if (slownessType != null && (slowness = player.getPotionEffect(slownessType)) != null) {
            int amp = slowness.getAmplifier() + 1;
            baseSpeed *= Math.max(0.08, 1.0 - (double)amp * 0.15);
        }
        if (this.isIceBlock(belowType)) {
            baseSpeed = belowType == Material.BLUE_ICE ? (isSprinting && isJumping ? 19.0 : baseSpeed * 3.2) : (isSprinting && isJumping ? 16.5 : baseSpeed * 2.6);
        } else if (belowType == Material.SOUL_SAND || belowType == Material.SOUL_SOIL) {
            int soulSpeed;
            boots = player.getInventory().getBoots();
            baseSpeed = boots != null ? ((soulSpeed = boots.getEnchantmentLevel(Enchantment.SOUL_SPEED)) > 0 ? (baseSpeed *= 1.35 + (double)soulSpeed * 0.12) : (baseSpeed *= 0.38)) : (baseSpeed *= 0.38);
        } else if (belowType == Material.HONEY_BLOCK) {
            baseSpeed *= 0.38;
        } else if (belowType == Material.COBWEB) {
            baseSpeed *= 0.22;
        } else if (belowType == Material.POWDER_SNOW) {
            boolean hasLeatherBoots;
            boots = player.getInventory().getBoots();
            boolean bl2 = hasLeatherBoots = boots != null && boots.getType() == Material.LEATHER_BOOTS;
            if (!hasLeatherBoots) {
                baseSpeed *= 0.55;
            }
        } else if (belowType == Material.SLIME_BLOCK && isJumping) {
            baseSpeed *= 1.8;
        }
        Block atBlock = player.getLocation().getBlock();
        Material atType = atBlock.getType();
        if (atType == Material.COBWEB) {
            baseSpeed *= 0.22;
        } else if (atType == Material.SWEET_BERRY_BUSH) {
            baseSpeed *= 0.45;
        } else if (atType == Material.POWDER_SNOW) {
            baseSpeed *= 0.55;
        }
        if (player.getWalkSpeed() != 0.2f) {
            baseSpeed *= (double)(player.getWalkSpeed() / 0.2f);
        }
        return baseSpeed * 1.38;
    }

    private boolean isIceBlock(Material type) {
        return type == Material.ICE || type == Material.PACKED_ICE || type == Material.BLUE_ICE || type == Material.FROSTED_ICE;
    }

    private boolean isOnStairsOrSlabs(Player player) {
        Location loc = player.getLocation();
        Block below = loc.clone().subtract(0.0, 0.5, 0.0).getBlock();
        Block at = loc.getBlock();
        String belowName = below.getType().name();
        String atName = at.getType().name();
        return belowName.contains("STAIRS") || belowName.contains("SLAB") || atName.contains("STAIRS") || atName.contains("SLAB");
    }

    private double getTPS() {
        try {
            Object server = Bukkit.getServer().getClass().getMethod("getServer", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
            double[] recentTps = (double[])server.getClass().getField("recentTps").get(server);
            return Math.min(20.0, recentTps[0]);
        }
        catch (Exception e) {
            return 20.0;
        }
    }

    private CheckResult checkWaterSpeed(Player player, Location from, Location to) {
        PotionEffect speedEffect;
        PotionEffect dolphinsGrace;
        int depthStrider;
        double dx = to.getX() - from.getX();
        double dy = to.getY() - from.getY();
        double dz = to.getZ() - from.getZ();
        double horizontalDist = Math.sqrt(dx * dx + dz * dz);
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data == null) {
            return CheckResult.passed();
        }
        long timeDelta = System.currentTimeMillis() - data.getLastMoveTime();
        if (timeDelta < 20L) {
            return CheckResult.passed();
        }
        double tps = this.getTPS();
        double tpsMultiplier = 20.0 / Math.max(tps, 10.0);
        double timeInSeconds = Math.max((double)timeDelta / 1000.0, 0.05);
        double actualSpeed = horizontalDist / timeInSeconds;
        double maxWaterSpeed = 1.5;
        ItemStack boots = player.getInventory().getBoots();
        if (boots != null && (depthStrider = boots.getEnchantmentLevel(Enchantment.DEPTH_STRIDER)) > 0) {
            maxWaterSpeed = 1.5 + (double)depthStrider * 1.0;
        }
        if ((dolphinsGrace = player.getPotionEffect(PotionEffectType.DOLPHINS_GRACE)) != null) {
            int depthStrider2;
            maxWaterSpeed = 10.0;
            if (boots != null && (depthStrider2 = boots.getEnchantmentLevel(Enchantment.DEPTH_STRIDER)) > 0) {
                maxWaterSpeed = 10.0 + (double)depthStrider2 * 9.0;
            }
        }
        if ((speedEffect = player.getPotionEffect(PotionEffectType.SPEED)) != null) {
            int amp = speedEffect.getAmplifier() + 1;
            maxWaterSpeed *= 1.0 + (double)amp * 0.15;
        }
        maxWaterSpeed *= 1.45 * tpsMultiplier;
        double lagComp = this.filtering.getLagCompensation(player);
        if (actualSpeed > (maxWaterSpeed += lagComp)) {
            double severity = Math.min(1.0, (actualSpeed - maxWaterSpeed) / maxWaterSpeed);
            CheckResult prelimResult = CheckResult.failed(ViolationType.SPEED, severity, String.format("Water: %.2f/%.2f m/s", actualSpeed, maxWaterSpeed));
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.SPEED, prelimResult)) {
                return CheckResult.passed();
            }
            return prelimResult;
        }
        this.falsePositiveFilter.recordLegitAction(player, ViolationType.SPEED);
        return CheckResult.passed();
    }

    private CheckResult checkVehicleSpeed(Player player, Entity vehicle, Location from, Location to) {
        Block below;
        Material belowType;
        double dx = to.getX() - from.getX();
        double dz = to.getZ() - from.getZ();
        double horizontalDist = Math.sqrt(dx * dx + dz * dz);
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data == null) {
            return CheckResult.passed();
        }
        long timeDelta = System.currentTimeMillis() - data.getLastMoveTime();
        if (timeDelta < 20L) {
            return CheckResult.passed();
        }
        double tps = this.getTPS();
        double tpsMultiplier = 20.0 / Math.max(tps, 10.0);
        double timeInSeconds = Math.max((double)timeDelta / 1000.0, 0.05);
        double actualSpeed = horizontalDist / timeInSeconds;
        double maxVehicleSpeed = 8.5;
        maxVehicleSpeed = vehicle instanceof Boat ? ((belowType = (below = vehicle.getLocation().clone().subtract(0.0, 0.5, 0.0).getBlock()).getType()) == Material.BLUE_ICE ? 75.0 : (this.isIceBlock(belowType) ? 42.0 : 8.5)) : (vehicle.getType().name().contains("HORSE") ? 15.0 : (vehicle.getType().name().contains("STRIDER") ? 8.5 : (vehicle.getType().name().contains("PIG") ? 7.5 : (vehicle.getType().name().contains("MINECART") ? 8.5 : (vehicle.getType().name().contains("CAMEL") ? 10.0 : 13.0)))));
        maxVehicleSpeed *= 1.35 * tpsMultiplier;
        double lagComp = this.filtering.getLagCompensation(player);
        maxVehicleSpeed += lagComp;
        if (actualSpeed > maxVehicleSpeed) {
            double severity = Math.min(1.0, (actualSpeed - maxVehicleSpeed) / maxVehicleSpeed);
            CheckResult prelimResult = CheckResult.failed(ViolationType.SPEED, severity, String.format("Vehicle: %.2f/%.2f m/s", actualSpeed, maxVehicleSpeed));
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.SPEED, prelimResult)) {
                return CheckResult.passed();
            }
            return prelimResult;
        }
        this.falsePositiveFilter.recordLegitAction(player, ViolationType.SPEED);
        return CheckResult.passed();
    }

    private CheckResult checkElytraSpeed(Player player, Location from, Location to) {
        double dx = to.getX() - from.getX();
        double dy = to.getY() - from.getY();
        double dz = to.getZ() - from.getZ();
        double totalDist = Math.sqrt(dx * dx + dy * dy + dz * dz);
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data == null) {
            return CheckResult.passed();
        }
        long timeDelta = System.currentTimeMillis() - data.getLastMoveTime();
        if (timeDelta < 20L) {
            return CheckResult.passed();
        }
        double tps = this.getTPS();
        double tpsMultiplier = 20.0 / Math.max(tps, 10.0);
        double timeInSeconds = Math.max((double)timeDelta / 1000.0, 0.05);
        double actualSpeed = totalDist / timeInSeconds;
        double maxElytraSpeed = 95.0;
        if (player.getInventory().contains(Material.FIREWORK_ROCKET)) {
            maxElytraSpeed = 150.0;
        }
        maxElytraSpeed *= 1.3 * tpsMultiplier;
        double lagComp = this.filtering.getLagCompensation(player);
        if (actualSpeed > (maxElytraSpeed += lagComp)) {
            double severity = Math.min(1.0, (actualSpeed - maxElytraSpeed) / maxElytraSpeed);
            CheckResult prelimResult = CheckResult.failed(ViolationType.SPEED, severity, String.format("Elytra: %.2f/%.2f m/s", actualSpeed, maxElytraSpeed));
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.SPEED, prelimResult)) {
                return CheckResult.passed();
            }
            return prelimResult;
        }
        this.falsePositiveFilter.recordLegitAction(player, ViolationType.SPEED);
        return CheckResult.passed();
    }

    public void cleanup(UUID playerId) {
        this.lastVelocity.remove(playerId);
        this.moveDataMap.remove(playerId);
        this.falsePositiveFilter.cleanup(playerId);
    }

    public void cleanupStale() {
        this.lastVelocity.clear();
        this.moveDataMap.clear();
    }

    private static class MoveData {
        private final double[] speeds = new double[12];
        private final double[] accelerations = new double[8];
        private final long[] timestamps = new long[12];
        private int speedIdx = 0;
        private int accelIdx = 0;
        private int count = 0;
        private int violations = 0;
        private long lastViolation = 0L;
        private double lastSpeed = 0.0;
        private boolean wasOnIce = false;
        private int ticksOnGround = 0;
        private int ticksInAir = 0;
        private double peakSpeed = 0.0;

        private MoveData() {
        }

        void addSpeed(double speed, long time) {
            double oldSpeed = this.speeds[this.speedIdx];
            this.speeds[this.speedIdx] = speed;
            this.timestamps[this.speedIdx] = time;
            this.speedIdx = (this.speedIdx + 1) % this.speeds.length;
            if (this.count < this.speeds.length) {
                ++this.count;
            }
            if (this.count > 1) {
                double accel;
                this.accelerations[this.accelIdx] = accel = Math.abs(speed - this.lastSpeed);
                this.accelIdx = (this.accelIdx + 1) % this.accelerations.length;
            }
            if (speed > this.peakSpeed) {
                this.peakSpeed = speed;
            }
            this.lastSpeed = speed;
        }

        double getAvgSpeed() {
            if (this.count == 0) {
                return 0.0;
            }
            double sum = 0.0;
            for (int i = 0; i < this.count; ++i) {
                sum += this.speeds[i];
            }
            return sum / (double)this.count;
        }

        double getMaxSpeed() {
            if (this.count == 0) {
                return 0.0;
            }
            double max = this.speeds[0];
            for (int i = 1; i < this.count; ++i) {
                if (!(this.speeds[i] > max)) continue;
                max = this.speeds[i];
            }
            return max;
        }

        double getMedianSpeed() {
            if (this.count == 0) {
                return 0.0;
            }
            double[] sorted = new double[this.count];
            System.arraycopy(this.speeds, 0, sorted, 0, this.count);
            Arrays.sort(sorted);
            return sorted[this.count / 2];
        }

        double getAvgAccel() {
            if (this.count < 2) {
                return 0.0;
            }
            int accelCount = Math.min(this.count - 1, this.accelerations.length);
            double sum = 0.0;
            for (int i = 0; i < accelCount; ++i) {
                sum += this.accelerations[i];
            }
            return sum / (double)accelCount;
        }

        double getMaxAccel() {
            if (this.count < 2) {
                return 0.0;
            }
            int accelCount = Math.min(this.count - 1, this.accelerations.length);
            double max = this.accelerations[0];
            for (int i = 1; i < accelCount; ++i) {
                if (!(this.accelerations[i] > max)) continue;
                max = this.accelerations[i];
            }
            return max;
        }

        boolean hasStableData() {
            return this.count >= 4;
        }

        void addViolation() {
            ++this.violations;
            this.lastViolation = System.currentTimeMillis();
        }

        void decayViolations() {
            if (System.currentTimeMillis() - this.lastViolation > 3000L && this.violations > 0) {
                --this.violations;
            }
        }

        int getViolations() {
            return this.violations;
        }

        void resetViolations() {
            this.violations = 0;
        }
    }
}

