/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.detection.movement;

import NC.noChance.core.ACConfig;
import NC.noChance.core.CheckResult;
import NC.noChance.core.LayerFiltering;
import NC.noChance.core.PlayerData;
import NC.noChance.core.ViolationType;
import NC.noChance.core.WaterHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

public class StepCheck {
    private final ACConfig config;
    private final Map<UUID, PlayerData> playerDataMap;
    private final LayerFiltering filtering;
    private final Map<UUID, StepTracker> trackers;

    public StepCheck(ACConfig config, Map<UUID, PlayerData> playerDataMap, LayerFiltering filtering) {
        this.config = config;
        this.playerDataMap = playerDataMap;
        this.filtering = filtering;
        this.trackers = new HashMap<UUID, StepTracker>();
    }

    public CheckResult check(Player player, Location from, Location to) {
        if (!this.config.isCheckEnabled("step")) {
            return CheckResult.passed();
        }
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data == null) {
            return CheckResult.passed();
        }
        if (data.isInGracePeriod(this.config.getGracePeriod())) {
            return CheckResult.passed();
        }
        UUID uuid = player.getUniqueId();
        StepTracker tracker = this.trackers.computeIfAbsent(uuid, k -> new StepTracker());
        double verticalDistance = to.getY() - from.getY();
        if (verticalDistance <= 0.0 || verticalDistance < 0.5) {
            return CheckResult.passed();
        }
        if (player.isFlying() || player.isGliding() || player.isRiptiding()) {
            return CheckResult.passed();
        }
        if (WaterHelper.isInWater(player) || player.isClimbing()) {
            return CheckResult.passed();
        }
        Block blockAt = player.getLocation().getBlock();
        if (blockAt.getType() == Material.LAVA || blockAt.getType().name().contains("LAVA")) {
            return CheckResult.passed();
        }
        Block blockBelow = from.clone().subtract(0.0, 1.0, 0.0).getBlock();
        if (blockBelow.getType() == Material.SLIME_BLOCK || blockBelow.getType() == Material.HONEY_BLOCK) {
            return CheckResult.passed();
        }
        double maxStep = 0.6;
        if (player.hasPotionEffect(PotionEffectType.JUMP_BOOST)) {
            int level = player.getPotionEffect(PotionEffectType.JUMP_BOOST).getAmplifier() + 1;
            maxStep += (double)level * 0.5;
        }
        if (player.hasPotionEffect(PotionEffectType.LEVITATION)) {
            return CheckResult.passed();
        }
        boolean hasStairOrSlab = false;
        for (int y = 0; y <= 2; ++y) {
            Block check = from.clone().add(0.0, (double)y, 0.0).getBlock();
            String type = check.getType().name();
            if (!type.contains("STAIRS") && !type.contains("SLAB")) continue;
            hasStairOrSlab = true;
            break;
        }
        if (hasStairOrSlab) {
            maxStep += 0.3;
        }
        if (verticalDistance > maxStep) {
            tracker.recordViolation(verticalDistance);
            if (tracker.getViolationCount() >= 3) {
                double severity = Math.min(1.0, (verticalDistance - maxStep) / maxStep);
                CheckResult prelimResult = CheckResult.failed(ViolationType.STEP, severity, String.format("Step: %.2f blocks (max: %.2f) - %d violations", verticalDistance, maxStep, tracker.getViolationCount()));
                if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.STEP, prelimResult)) {
                    tracker.decay();
                    return CheckResult.passed();
                }
                tracker.reset();
                return prelimResult;
            }
        }
        tracker.decay();
        return CheckResult.passed();
    }

    public void cleanup(UUID uuid) {
        this.trackers.remove(uuid);
    }

    private static class StepTracker {
        private int violations = 0;
        private long lastViolation = 0L;
        private double maxHeight = 0.0;

        private StepTracker() {
        }

        void recordViolation(double height) {
            ++this.violations;
            this.lastViolation = System.currentTimeMillis();
            this.maxHeight = Math.max(this.maxHeight, height);
        }

        void decay() {
            if (System.currentTimeMillis() - this.lastViolation > 1500L) {
                this.violations = Math.max(0, this.violations - 1);
            }
        }

        void reset() {
            this.violations = 0;
            this.maxHeight = 0.0;
        }

        int getViolationCount() {
            return this.violations;
        }
    }
}

