/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.detection.movement;

import NC.noChance.core.ACConfig;
import NC.noChance.core.CheckResult;
import NC.noChance.core.LayerFiltering;
import NC.noChance.core.PlayerData;
import NC.noChance.core.ViolationType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.entity.Strider;
import org.bukkit.potion.PotionEffectType;

public class StriderCheck {
    private final ACConfig config;
    private final Map<UUID, PlayerData> playerDataMap;
    private final LayerFiltering filtering;
    private final Map<UUID, LavaData> lavaDataMap;

    public StriderCheck(ACConfig config, Map<UUID, PlayerData> playerDataMap, LayerFiltering filtering) {
        this.config = config;
        this.playerDataMap = playerDataMap;
        this.filtering = filtering;
        this.lavaDataMap = new HashMap<UUID, LavaData>();
    }

    public CheckResult check(Player player, Location from, Location to) {
        List<Double> recentY;
        long upwardCount;
        boolean hasSolidBelow;
        boolean onLava;
        if (!this.config.isCheckEnabled("strider")) {
            return CheckResult.passed();
        }
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data == null) {
            return CheckResult.passed();
        }
        if (data.isInGracePeriod(this.config.getGracePeriod())) {
            return CheckResult.passed();
        }
        if (player.getVehicle() instanceof Strider) {
            return CheckResult.passed();
        }
        if (player.hasPotionEffect(PotionEffectType.FIRE_RESISTANCE)) {
            return CheckResult.passed();
        }
        if (player.isFlying() || player.isGliding()) {
            return CheckResult.passed();
        }
        Block atBlock = to.getBlock();
        Block belowBlock = to.clone().subtract(0.0, 0.5, 0.0).getBlock();
        boolean inLava = atBlock.getType() == Material.LAVA || atBlock.getType().name().contains("LAVA");
        boolean bl = onLava = belowBlock.getType() == Material.LAVA || belowBlock.getType().name().contains("LAVA");
        if (!inLava && !onLava) {
            return CheckResult.passed();
        }
        UUID uuid = player.getUniqueId();
        LavaData lavaData = this.lavaDataMap.computeIfAbsent(uuid, k -> new LavaData());
        double deltaY = to.getY() - from.getY();
        double horizontalSpeed = Math.sqrt(Math.pow(to.getX() - from.getX(), 2.0) + Math.pow(to.getZ() - from.getZ(), 2.0));
        lavaData.recordMovement(deltaY, horizontalSpeed);
        if (onLava && !inLava && !(hasSolidBelow = this.hasSolidUnderLava(to, 3)) && deltaY > -0.01 && horizontalSpeed > 0.1) {
            lavaData.incrementViolations();
            if (lavaData.getViolations() < 4) {
                return CheckResult.passed();
            }
            double severity = Math.min(0.92, 0.7 + (double)lavaData.getViolations() * 0.05);
            CheckResult prelimResult = CheckResult.failed(ViolationType.STRIDER, severity, String.format("Lava walk: deltaY=%.3f hSpeed=%.3f vl=%d", deltaY, horizontalSpeed, lavaData.getViolations()));
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.STRIDER, prelimResult)) {
                lavaData.decay();
                return CheckResult.passed();
            }
            return prelimResult;
        }
        if (inLava && deltaY > 0.3 && (upwardCount = (recentY = lavaData.getRecentYMovements(8)).stream().filter(y -> y > 0.2).count()) >= 4L) {
            lavaData.incrementViolations();
            if (lavaData.getViolations() < 3) {
                return CheckResult.passed();
            }
            CheckResult prelimResult = CheckResult.failed(ViolationType.STRIDER, 0.85, String.format("Lava fly: upwardMoves=%d deltaY=%.3f vl=%d", upwardCount, deltaY, lavaData.getViolations()));
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.STRIDER, prelimResult)) {
                lavaData.decay();
                return CheckResult.passed();
            }
            return prelimResult;
        }
        lavaData.decay();
        return CheckResult.passed();
    }

    private boolean hasSolidUnderLava(Location loc, int depth) {
        for (int y = 1; y <= depth; ++y) {
            Block block = loc.clone().subtract(0.0, (double)y, 0.0).getBlock();
            if (block.getType().isSolid()) {
                return true;
            }
            if (block.getType() != Material.LAVA && !block.getType().name().contains("LAVA")) break;
        }
        return false;
    }

    public void cleanup(UUID playerId) {
        this.lavaDataMap.remove(playerId);
    }

    public void cleanupStale() {
        long now = System.currentTimeMillis();
        this.lavaDataMap.entrySet().removeIf(entry -> {
            PlayerData data = this.playerDataMap.get(entry.getKey());
            return data == null || now - data.getLastMoveTime() > 300000L;
        });
    }

    private static class LavaData {
        private final Deque<Double> yMovements = new ArrayDeque<Double>(20);
        private int violations;
        private long lastViolation;

        private LavaData() {
        }

        void recordMovement(double deltaY, double hSpeed) {
            if (this.yMovements.size() >= 20) {
                this.yMovements.pollFirst();
            }
            this.yMovements.addLast(deltaY);
        }

        List<Double> getRecentYMovements(int count) {
            ArrayList<Double> result = new ArrayList<Double>();
            int idx = 0;
            int start = Math.max(0, this.yMovements.size() - count);
            for (Double y : this.yMovements) {
                if (idx >= start) {
                    result.add(y);
                }
                ++idx;
            }
            return result;
        }

        void incrementViolations() {
            long now = System.currentTimeMillis();
            if (now - this.lastViolation > 4000L) {
                this.violations = 0;
            }
            ++this.violations;
            this.lastViolation = now;
        }

        void decay() {
            if (System.currentTimeMillis() - this.lastViolation > 6000L) {
                this.violations = Math.max(0, this.violations - 1);
            }
        }

        int getViolations() {
            return this.violations;
        }
    }
}

