/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.detection.movement;

import NC.noChance.core.ACConfig;
import NC.noChance.core.CheckResult;
import NC.noChance.core.LayerFiltering;
import NC.noChance.core.PlayerData;
import NC.noChance.core.ViolationType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class TimerCheck {
    private final ACConfig config;
    private final Map<UUID, PlayerData> playerDataMap;
    private final LayerFiltering filtering;
    private final Map<UUID, TimerData> timerData;

    public TimerCheck(ACConfig config, Map<UUID, PlayerData> playerDataMap, LayerFiltering filtering) {
        this.config = config;
        this.playerDataMap = playerDataMap;
        this.filtering = filtering;
        this.timerData = new HashMap<UUID, TimerData>();
    }

    public CheckResult check(Player player) {
        if (!this.config.isCheckEnabled("timer")) {
            return CheckResult.passed();
        }
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data == null) {
            return CheckResult.passed();
        }
        if (data.isInGracePeriod(this.config.getGracePeriod())) {
            return CheckResult.passed();
        }
        Location lastLoc = data.getLastLocation();
        if (lastLoc == null) {
            return CheckResult.passed();
        }
        long lastMoveTime = data.getLastMoveTime();
        if (lastMoveTime == 0L) {
            return CheckResult.passed();
        }
        UUID uuid = player.getUniqueId();
        TimerData timer = this.timerData.computeIfAbsent(uuid, k -> new TimerData());
        long now = System.currentTimeMillis();
        long timeDelta = now - lastMoveTime;
        if (timeDelta > 1000L || timeDelta < 5L) {
            timer.reset();
            return CheckResult.passed();
        }
        Location currentLoc = player.getLocation();
        double distance = lastLoc.distance(currentLoc);
        if (distance < 0.01) {
            return CheckResult.passed();
        }
        double movementsPerSecond = 1000.0 / (double)timeDelta;
        timer.recordMovement(movementsPerSecond, distance, timeDelta);
        if (timer.getSampleCount() < 20) {
            return CheckResult.passed();
        }
        double avgMovementsPerSec = timer.getAverageMovementsPerSecond();
        double balance = timer.getBalance();
        if (avgMovementsPerSec > 25.0 && balance > 80.0) {
            double severity = Math.min(1.0, (avgMovementsPerSec - 20.0) / 15.0);
            CheckResult prelimResult = CheckResult.failed(ViolationType.TIMER, severity, String.format("Fast timer: %.1f moves/s (avg), Balance: +%.0f", avgMovementsPerSec, balance));
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.TIMER, prelimResult)) {
                timer.compensate();
                return CheckResult.passed();
            }
            return prelimResult;
        }
        return CheckResult.passed();
    }

    public void cleanup(UUID uuid) {
        this.timerData.remove(uuid);
    }

    private static class TimerData {
        private final List<Double> movementsPerSecond = new ArrayList<Double>();
        private final List<Long> deltas = new ArrayList<Long>();
        private double balance = 0.0;
        private static final double EXPECTED_MOVEMENTS_PER_SEC = 20.0;
        private static final int MAX_SAMPLES = 30;

        private TimerData() {
        }

        void recordMovement(double movementsPerSec, double distance, long timeDelta) {
            this.movementsPerSecond.add(movementsPerSec);
            this.deltas.add(timeDelta);
            if (this.movementsPerSecond.size() > 30) {
                this.movementsPerSecond.remove(0);
                this.deltas.remove(0);
            }
            double difference = movementsPerSec - 20.0;
            this.balance += difference;
            if (this.balance > 150.0) {
                this.balance = 150.0;
            }
            if (this.balance < -50.0) {
                this.balance = -50.0;
            }
        }

        double getAverageMovementsPerSecond() {
            if (this.movementsPerSecond.isEmpty()) {
                return 20.0;
            }
            return this.movementsPerSecond.stream().mapToDouble(Double::doubleValue).average().orElse(20.0);
        }

        double getBalance() {
            return this.balance;
        }

        int getSampleCount() {
            return this.movementsPerSecond.size();
        }

        void compensate() {
            this.balance *= 0.6;
        }

        void reset() {
            this.movementsPerSecond.clear();
            this.deltas.clear();
            this.balance = 0.0;
        }
    }
}

