/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.detection.player;

import NC.noChance.core.ACConfig;
import NC.noChance.core.CheckResult;
import NC.noChance.core.LayerFiltering;
import NC.noChance.core.PlayerData;
import NC.noChance.core.ViolationType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class InventoryCheck {
    private final ACConfig config;
    private final Map<UUID, PlayerData> playerDataMap;
    private final LayerFiltering filtering;
    private final Map<UUID, List<Long>> inventoryClicks;

    public InventoryCheck(ACConfig config, Map<UUID, PlayerData> playerDataMap, LayerFiltering filtering) {
        this.config = config;
        this.playerDataMap = playerDataMap;
        this.filtering = filtering;
        this.inventoryClicks = new HashMap<UUID, List<Long>>();
    }

    public CheckResult check(Player player, InventoryClickEvent event) {
        if (!this.config.isCheckEnabled("inventory")) {
            return CheckResult.passed();
        }
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data == null) {
            return CheckResult.passed();
        }
        if (data.isInGracePeriod(this.config.getGracePeriod())) {
            return CheckResult.passed();
        }
        UUID playerId = player.getUniqueId();
        long now = System.currentTimeMillis();
        List clicks = this.inventoryClicks.computeIfAbsent(playerId, k -> new ArrayList());
        clicks.add(now);
        clicks.removeIf(time -> now - time > 1000L);
        int maxClicksPerSecond = this.config.getInventoryMaxClicksPerSecond();
        if (clicks.size() > maxClicksPerSecond) {
            CheckResult prelimResult = CheckResult.failed(ViolationType.INVENTORY, Math.min(1.0, (double)clicks.size() / 20.0), String.format("Inventory clicks too fast: %d clicks/second", clicks.size()));
            if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.INVENTORY, prelimResult)) {
                return CheckResult.passed();
            }
            return prelimResult;
        }
        if (clicks.size() >= 5) {
            ArrayList<Long> intervals = new ArrayList<Long>();
            for (int i = 1; i < clicks.size(); ++i) {
                intervals.add((Long)clicks.get(i) - (Long)clicks.get(i - 1));
            }
            double mean = intervals.stream().mapToLong(Long::longValue).average().orElse(0.0);
            double variance = intervals.stream().mapToDouble(v -> Math.pow((double)v.longValue() - mean, 2.0)).average().orElse(0.0);
            double stdDev = Math.sqrt(variance);
            if (stdDev < 3.0 && mean < 50.0) {
                CheckResult prelimResult = CheckResult.failed(ViolationType.INVENTORY, Math.min(1.0, (5.0 - stdDev) / 5.0), String.format("Inventory click pattern too consistent: StdDev=%.2fms", stdDev));
                if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.INVENTORY, prelimResult)) {
                    return CheckResult.passed();
                }
                return prelimResult;
            }
        }
        return CheckResult.passed();
    }

    public void cleanup(UUID playerId) {
        this.inventoryClicks.remove(playerId);
    }
}

