/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.detection.player;

import NC.noChance.core.ACConfig;
import NC.noChance.core.CheckResult;
import NC.noChance.core.LayerFiltering;
import NC.noChance.core.PlayerData;
import NC.noChance.core.ViolationType;
import NC.noChance.core.WaterHelper;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class NoSlowCheck {
    private final ACConfig config;
    private final Map<UUID, PlayerData> playerDataMap;
    private final LayerFiltering filtering;
    private final Map<UUID, SlowData> dataMap;
    private static final double WEB_MAX_H = 0.105;
    private static final double WEB_MAX_V_UP = 0.08;
    private static final double WEB_MAX_FALL = 0.07;
    private static final double SOUL_MAX_H = 0.12;
    private static final double HONEY_MAX_H = 0.09;
    private static final double HONEY_MAX_SLIDE = 0.12;
    private static final double SNOW_MAX_H = 0.1;
    private static final double SNOW_MAX_SINK = 0.08;
    private static final double BERRY_MAX_H = 0.13;
    private static final double EAT_MULTI = 0.2;
    private static final double SHIELD_MULTI = 0.2;

    public NoSlowCheck(ACConfig config, Map<UUID, PlayerData> playerDataMap, LayerFiltering filtering) {
        this.config = config;
        this.playerDataMap = playerDataMap;
        this.filtering = filtering;
        this.dataMap = new ConcurrentHashMap<UUID, SlowData>();
    }

    public CheckResult check(Player player, Location from, Location to) {
        int ping;
        if (!this.config.isCheckEnabled("noslow")) {
            return CheckResult.passed();
        }
        PlayerData pData = this.playerDataMap.get(player.getUniqueId());
        if (pData == null) {
            return CheckResult.passed();
        }
        if (pData.isInGracePeriod(this.config.getGracePeriod())) {
            return CheckResult.passed();
        }
        if (player.isFlying() && player.getAllowFlight()) {
            return CheckResult.passed();
        }
        if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) {
            return CheckResult.passed();
        }
        if (WaterHelper.isInWater(player) || player.isGliding() || player.isRiptiding()) {
            return CheckResult.passed();
        }
        if (player.getVehicle() != null) {
            return CheckResult.passed();
        }
        UUID uuid = player.getUniqueId();
        SlowData sd = this.dataMap.computeIfAbsent(uuid, k -> new SlowData());
        sd.ping = ping = this.filtering.getPing(player);
        if (ping > 350) {
            return CheckResult.passed();
        }
        double dx = to.getX() - from.getX();
        double dy = to.getY() - from.getY();
        double dz = to.getZ() - from.getZ();
        double hDist = Math.sqrt(dx * dx + dz * dz);
        SlowCtx ctx = this.getContext(player, from, to);
        if (!ctx.slow) {
            sd.clear();
            return CheckResult.passed();
        }
        sd.tick();
        switch (ctx.type.ordinal()) {
            case 1: {
                return this.checkWeb(player, sd, hDist, dy, ping);
            }
            case 2: {
                return this.checkSoul(player, sd, hDist, dy, ping);
            }
            case 3: {
                return this.checkHoney(player, sd, hDist, dy, ping, ctx.onSide);
            }
            case 4: {
                return this.checkSnow(player, sd, hDist, dy, ping);
            }
            case 5: {
                return this.checkBerry(player, sd, hDist, ping);
            }
            case 6: 
            case 7: {
                return this.checkItem(player, sd, ctx, hDist, ping);
            }
        }
        return CheckResult.passed();
    }

    private CheckResult checkWeb(Player player, SlowData sd, double hDist, double vDist, int ping) {
        double ratio;
        boolean fastFall;
        double pingMult = ping > 150 ? 1.4 : (ping > 100 ? 1.2 : 1.0);
        double tpsMult = 20.0 / Math.max(this.getTPS(), 12.0);
        double maxH = 0.105 * pingMult * tpsMult;
        double maxVUp = 0.08 * pingMult * tpsMult;
        double maxFall = 0.07 * pingMult * tpsMult;
        sd.addMove(hDist, vDist);
        boolean hViolation = hDist > maxH;
        boolean vUpViolation = vDist > maxVUp;
        boolean bl = fastFall = vDist < -maxFall && Math.abs(vDist) > 0.12;
        if (!(hViolation || vUpViolation || fastFall)) {
            sd.decayVL();
            return CheckResult.passed();
        }
        if (hViolation) {
            ratio = hDist / maxH;
            ++sd.hVL;
            if (sd.hVL >= 2 || ratio > 2.0) {
                double sev = Math.min(1.0, 0.5 + (ratio - 1.0) * 0.4);
                return this.flagOrPass(player, sd, sev, String.format("[NoWeb] H:%.3f/%.3f r:%.1f", hDist, maxH, ratio));
            }
        }
        if (vUpViolation) {
            ratio = vDist / maxVUp;
            ++sd.vVL;
            if (sd.vVL >= 2 || ratio > 2.5) {
                double sev = Math.min(1.0, 0.5 + (ratio - 1.0) * 0.35);
                return this.flagOrPass(player, sd, sev, String.format("[NoWeb] V:%.3f/%.3f r:%.1f", vDist, maxVUp, ratio));
            }
        }
        if (fastFall) {
            ++sd.fallVL;
            if (sd.fallVL >= 3) {
                double sev = Math.min(1.0, 0.55 + Math.abs(vDist) * 0.8);
                return this.flagOrPass(player, sd, sev, String.format("[NoWeb] Fall:%.3f", vDist));
            }
        }
        return CheckResult.passed();
    }

    private CheckResult checkSoul(Player player, SlowData sd, double hDist, double vDist, int ping) {
        int threshold;
        PotionEffect speed;
        double pingMult = ping > 150 ? 1.35 : (ping > 100 ? 1.2 : 1.0);
        double tpsMult = 20.0 / Math.max(this.getTPS(), 12.0);
        double maxH = 0.12 * pingMult * tpsMult;
        if (player.isSprinting()) {
            maxH *= 1.15;
        }
        if ((speed = player.getPotionEffect(PotionEffectType.SPEED)) != null) {
            maxH *= 1.0 + (double)(speed.getAmplifier() + 1) * 0.15;
        }
        sd.addMove(hDist, vDist);
        if (hDist <= maxH) {
            sd.decayVL();
            return CheckResult.passed();
        }
        double ratio = hDist / maxH;
        if (ratio < 1.35) {
            return CheckResult.passed();
        }
        ++sd.hVL;
        int n = threshold = ping > 150 ? 3 : 2;
        if (sd.hVL >= threshold || ratio > 2.2) {
            double sev = Math.min(1.0, 0.5 + (ratio - 1.0) * 0.4);
            return this.flagOrPass(player, sd, sev, String.format("[NoSoul] H:%.3f/%.3f r:%.1f", hDist, maxH, ratio));
        }
        return CheckResult.passed();
    }

    private CheckResult checkHoney(Player player, SlowData sd, double hDist, double vDist, int ping, boolean onSide) {
        int threshold;
        double pingMult = ping > 150 ? 1.35 : (ping > 100 ? 1.2 : 1.0);
        double tpsMult = 20.0 / Math.max(this.getTPS(), 12.0);
        sd.addMove(hDist, vDist);
        if (onSide) {
            double maxSlide = 0.12 * pingMult * tpsMult;
            if (vDist < -maxSlide) {
                double ratio = Math.abs(vDist) / maxSlide;
                ++sd.fallVL;
                if (sd.fallVL >= 2 || ratio > 2.0) {
                    double sev = Math.min(1.0, 0.5 + (ratio - 1.0) * 0.35);
                    return this.flagOrPass(player, sd, sev, String.format("[NoHoney] Slide:%.3f/%.3f", vDist, -maxSlide));
                }
            } else {
                sd.decayVL();
            }
            return CheckResult.passed();
        }
        double maxH = 0.09 * pingMult * tpsMult;
        if (player.isSprinting()) {
            maxH *= 1.1;
        }
        if (hDist <= maxH) {
            sd.decayVL();
            return CheckResult.passed();
        }
        double ratio = hDist / maxH;
        if (ratio < 1.4) {
            return CheckResult.passed();
        }
        ++sd.hVL;
        int n = threshold = ping > 150 ? 3 : 2;
        if (sd.hVL >= threshold || ratio > 2.3) {
            double sev = Math.min(1.0, 0.5 + (ratio - 1.0) * 0.4);
            return this.flagOrPass(player, sd, sev, String.format("[NoHoney] H:%.3f/%.3f r:%.1f", hDist, maxH, ratio));
        }
        return CheckResult.passed();
    }

    private CheckResult checkSnow(Player player, SlowData sd, double hDist, double vDist, int ping) {
        double ratio;
        boolean noSink;
        double pingMult = ping > 150 ? 1.35 : (ping > 100 ? 1.2 : 1.0);
        double tpsMult = 20.0 / Math.max(this.getTPS(), 12.0);
        double maxH = 0.1 * pingMult * tpsMult;
        double maxSink = 0.08 * pingMult * tpsMult;
        sd.addMove(hDist, vDist);
        boolean hViolation = hDist > maxH;
        boolean bl = noSink = vDist > maxSink && sd.ticks > 5;
        if (!hViolation && !noSink) {
            sd.decayVL();
            return CheckResult.passed();
        }
        if (hViolation && (ratio = hDist / maxH) > 1.4) {
            int threshold;
            ++sd.hVL;
            int n = threshold = ping > 150 ? 3 : 2;
            if (sd.hVL >= threshold || ratio > 2.2) {
                double sev = Math.min(1.0, 0.5 + (ratio - 1.0) * 0.4);
                return this.flagOrPass(player, sd, sev, String.format("[NoSnow] H:%.3f/%.3f r:%.1f", hDist, maxH, ratio));
            }
        }
        if (noSink && sd.getAvgV() > maxSink) {
            ++sd.vVL;
            if (sd.vVL >= 4) {
                double sev = Math.min(1.0, 0.55 + sd.getAvgV() * 2.0);
                return this.flagOrPass(player, sd, sev, String.format("[NoSnow] NoSink V:%.3f", sd.getAvgV()));
            }
        }
        return CheckResult.passed();
    }

    private CheckResult checkBerry(Player player, SlowData sd, double hDist, int ping) {
        int threshold;
        double pingMult = ping > 150 ? 1.35 : (ping > 100 ? 1.2 : 1.0);
        double tpsMult = 20.0 / Math.max(this.getTPS(), 12.0);
        double maxH = 0.13 * pingMult * tpsMult;
        if (player.isSprinting()) {
            maxH *= 1.1;
        }
        sd.addMove(hDist, 0.0);
        if (hDist <= maxH) {
            sd.decayVL();
            return CheckResult.passed();
        }
        double ratio = hDist / maxH;
        if (ratio < 1.35) {
            return CheckResult.passed();
        }
        ++sd.hVL;
        int n = threshold = ping > 150 ? 3 : 2;
        if (sd.hVL >= threshold || ratio > 2.2) {
            double sev = Math.min(1.0, 0.5 + (ratio - 1.0) * 0.4);
            return this.flagOrPass(player, sd, sev, String.format("[NoBerry] H:%.3f/%.3f r:%.1f", hDist, maxH, ratio));
        }
        return CheckResult.passed();
    }

    private CheckResult checkItem(Player player, SlowData sd, SlowCtx ctx, double hDist, int ping) {
        int threshold;
        double base = 0.21585000000000001;
        base *= ctx.type == SlowType.EAT ? 0.2 : 0.2;
        PotionEffect speed = player.getPotionEffect(PotionEffectType.SPEED);
        if (speed != null) {
            base *= 1.0 + (double)(speed.getAmplifier() + 1) * 0.2;
        }
        double pingMult = ping > 150 ? 1.35 : (ping > 100 ? 1.2 : 1.0);
        double tpsMult = 20.0 / Math.max(this.getTPS(), 12.0);
        double maxH = base * pingMult * tpsMult * 1.2;
        sd.addMove(hDist, 0.0);
        if (hDist <= maxH) {
            sd.decayVL();
            return CheckResult.passed();
        }
        double ratio = hDist / maxH;
        if (ratio < 1.5) {
            return CheckResult.passed();
        }
        ++sd.hVL;
        int n = threshold = ping > 150 ? 3 : 2;
        if (sd.hVL >= threshold || ratio > 2.5) {
            double sev = Math.min(1.0, 0.5 + (ratio - 1.0) * 0.35);
            String tag = ctx.type == SlowType.EAT ? "NoEat" : "NoShield";
            return this.flagOrPass(player, sd, sev, String.format("[%s] H:%.3f/%.3f r:%.1f", tag, hDist, maxH, ratio));
        }
        return CheckResult.passed();
    }

    private CheckResult flagOrPass(Player player, SlowData sd, double severity, String details) {
        CheckResult res = CheckResult.failed(ViolationType.NOSLOW, severity, details + " vl:" + sd.hVL);
        if (!this.filtering.passesLayer2HeuristicFiltering(player, ViolationType.NOSLOW, res)) {
            sd.decayVL();
            return CheckResult.passed();
        }
        sd.resetVL();
        return res;
    }

    private SlowCtx getContext(Player player, Location from, Location to) {
        boolean using;
        ItemStack boots;
        SlowCtx ctx = new SlowCtx();
        Block feet = player.getLocation().getBlock();
        Block body = player.getLocation().clone().add(0.0, 1.0, 0.0).getBlock();
        Block below = player.getLocation().clone().subtract(0.0, 0.3, 0.0).getBlock();
        Block toFeet = to.getBlock();
        Block toBody = to.clone().add(0.0, 1.0, 0.0).getBlock();
        Block toBelow = to.clone().subtract(0.0, 0.3, 0.0).getBlock();
        if (feet.getType() == Material.COBWEB || body.getType() == Material.COBWEB || toFeet.getType() == Material.COBWEB || toBody.getType() == Material.COBWEB) {
            ctx.slow = true;
            ctx.type = SlowType.WEB;
            return ctx;
        }
        Material b = below.getType();
        Material tb = toBelow.getType();
        if (!(b != Material.SOUL_SAND && b != Material.SOUL_SOIL && tb != Material.SOUL_SAND && tb != Material.SOUL_SOIL || (boots = player.getInventory().getBoots()) != null && boots.getEnchantmentLevel(Enchantment.SOUL_SPEED) != 0)) {
            ctx.slow = true;
            ctx.type = SlowType.SOUL;
            return ctx;
        }
        if (this.isNearHoney(player, feet, body, below, toFeet, toBody, toBelow)) {
            ctx.slow = true;
            ctx.type = SlowType.HONEY;
            ctx.onSide = this.isOnHoneySide(player);
            return ctx;
        }
        if (!(feet.getType() != Material.POWDER_SNOW && toFeet.getType() != Material.POWDER_SNOW && body.getType() != Material.POWDER_SNOW && toBody.getType() != Material.POWDER_SNOW || (boots = player.getInventory().getBoots()) != null && boots.getType() == Material.LEATHER_BOOTS)) {
            ctx.slow = true;
            ctx.type = SlowType.SNOW;
            return ctx;
        }
        if (feet.getType() == Material.SWEET_BERRY_BUSH || toFeet.getType() == Material.SWEET_BERRY_BUSH || body.getType() == Material.SWEET_BERRY_BUSH || toBody.getType() == Material.SWEET_BERRY_BUSH) {
            ctx.slow = true;
            ctx.type = SlowType.BERRY;
            return ctx;
        }
        ItemStack main = player.getInventory().getItemInMainHand();
        ItemStack off = player.getInventory().getItemInOffHand();
        boolean bl = using = player.isBlocking() || player.isHandRaised();
        if (using) {
            if (this.isShield(main) || this.isShield(off)) {
                ctx.slow = true;
                ctx.type = SlowType.SHIELD;
                return ctx;
            }
            if (this.isUsable(main) || this.isUsable(off)) {
                ctx.slow = true;
                ctx.type = SlowType.EAT;
                return ctx;
            }
        }
        return ctx;
    }

    private boolean isNearHoney(Player player, Block feet, Block body, Block below, Block toFeet, Block toBody, Block toBelow) {
        Block sideUp;
        Block side;
        if (below.getType() == Material.HONEY_BLOCK || toBelow.getType() == Material.HONEY_BLOCK) {
            return true;
        }
        if (feet.getType() == Material.HONEY_BLOCK || toFeet.getType() == Material.HONEY_BLOCK) {
            return true;
        }
        Location loc = player.getLocation();
        double px = loc.getX();
        double pz = loc.getZ();
        int bx = loc.getBlockX();
        int by = loc.getBlockY();
        int bz = loc.getBlockZ();
        double fx = px - (double)bx;
        double fz = pz - (double)bz;
        if (fx < 0.3) {
            side = loc.getWorld().getBlockAt(bx - 1, by, bz);
            sideUp = loc.getWorld().getBlockAt(bx - 1, by + 1, bz);
            if (side.getType() == Material.HONEY_BLOCK || sideUp.getType() == Material.HONEY_BLOCK) {
                return true;
            }
        }
        if (fx > 0.7) {
            side = loc.getWorld().getBlockAt(bx + 1, by, bz);
            sideUp = loc.getWorld().getBlockAt(bx + 1, by + 1, bz);
            if (side.getType() == Material.HONEY_BLOCK || sideUp.getType() == Material.HONEY_BLOCK) {
                return true;
            }
        }
        if (fz < 0.3) {
            side = loc.getWorld().getBlockAt(bx, by, bz - 1);
            sideUp = loc.getWorld().getBlockAt(bx, by + 1, bz - 1);
            if (side.getType() == Material.HONEY_BLOCK || sideUp.getType() == Material.HONEY_BLOCK) {
                return true;
            }
        }
        if (fz > 0.7) {
            side = loc.getWorld().getBlockAt(bx, by, bz + 1);
            sideUp = loc.getWorld().getBlockAt(bx, by + 1, bz + 1);
            if (side.getType() == Material.HONEY_BLOCK || sideUp.getType() == Material.HONEY_BLOCK) {
                return true;
            }
        }
        return false;
    }

    private boolean isOnHoneySide(Player player) {
        Location loc = player.getLocation();
        Block below = loc.clone().subtract(0.0, 0.1, 0.0).getBlock();
        if (below.getType() == Material.HONEY_BLOCK) {
            return false;
        }
        double px = loc.getX();
        double pz = loc.getZ();
        int bx = loc.getBlockX();
        int by = loc.getBlockY();
        int bz = loc.getBlockZ();
        double fx = px - (double)bx;
        double fz = pz - (double)bz;
        return fx < 0.3 || fx > 0.7 || fz < 0.3 || fz > 0.7;
    }

    private boolean isShield(ItemStack i) {
        return i != null && i.getType() == Material.SHIELD;
    }

    private boolean isUsable(ItemStack i) {
        if (i == null || i.getType() == Material.AIR) {
            return false;
        }
        Material t = i.getType();
        return t.isEdible() || t == Material.POTION || t == Material.MILK_BUCKET || t == Material.HONEY_BOTTLE || t == Material.BOW || t == Material.CROSSBOW || t == Material.TRIDENT || t == Material.SPYGLASS || t.name().contains("GOAT_HORN");
    }

    private double getTPS() {
        try {
            Object srv = Bukkit.getServer().getClass().getMethod("getServer", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
            double[] tps = (double[])srv.getClass().getField("recentTps").get(srv);
            return Math.min(20.0, tps[0]);
        }
        catch (Exception e) {
            return 20.0;
        }
    }

    public void cleanup(UUID id) {
        this.dataMap.remove(id);
    }

    public void cleanupStale() {
        this.dataMap.clear();
    }

    private static class SlowData {
        int hVL = 0;
        int vVL = 0;
        int fallVL = 0;
        long lastVL = 0L;
        int ping = 50;
        int ticks = 0;
        double[] hHist = new double[8];
        double[] vHist = new double[8];
        int idx = 0;
        int count = 0;

        private SlowData() {
        }

        void addMove(double h, double v) {
            this.hHist[this.idx] = h;
            this.vHist[this.idx] = v;
            this.idx = (this.idx + 1) % this.hHist.length;
            if (this.count < this.hHist.length) {
                ++this.count;
            }
        }

        double getAvgH() {
            if (this.count == 0) {
                return 0.0;
            }
            double sum = 0.0;
            for (int i = 0; i < this.count; ++i) {
                sum += this.hHist[i];
            }
            return sum / (double)this.count;
        }

        double getAvgV() {
            if (this.count == 0) {
                return 0.0;
            }
            double sum = 0.0;
            for (int i = 0; i < this.count; ++i) {
                sum += this.vHist[i];
            }
            return sum / (double)this.count;
        }

        void tick() {
            ++this.ticks;
        }

        void decayVL() {
            long now = System.currentTimeMillis();
            if (now - this.lastVL > 1500L) {
                if (this.hVL > 0) {
                    --this.hVL;
                }
                if (this.vVL > 0) {
                    --this.vVL;
                }
                if (this.fallVL > 0) {
                    --this.fallVL;
                }
                this.lastVL = now;
            }
        }

        void resetVL() {
            this.hVL = 0;
            this.vVL = 0;
            this.fallVL = 0;
        }

        void clear() {
            this.ticks = 0;
            this.idx = 0;
            this.count = 0;
            this.hVL = 0;
            this.vVL = 0;
            this.fallVL = 0;
            Arrays.fill(this.hHist, 0.0);
            Arrays.fill(this.vHist, 0.0);
        }
    }

    private static class SlowCtx {
        boolean slow = false;
        boolean onSide = false;
        SlowType type = SlowType.NONE;

        private SlowCtx() {
        }
    }

    private static enum SlowType {
        NONE,
        WEB,
        SOUL,
        HONEY,
        SNOW,
        BERRY,
        SHIELD,
        EAT;

    }
}

